/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs;

import com.mapr.fs.MapRHTable;
import com.mapr.fs.StaleFileException;
import com.mapr.fs.jni.MapRResult;
import com.mapr.fs.jni.MapRScan;
import java.io.Closeable;
import java.io.IOException;

public class MapRResultScanner
implements Closeable {
    private MapRScan scan_;
    protected MapRHTable htable_;
    private long scannerId_;
    private boolean scanStarted_;

    public MapRResultScanner(MapRScan scan, MapRHTable htable, long id) {
        this.scan_ = scan;
        this.htable_ = htable;
        this.scanStarted_ = false;
        if (id == 0L) {
            try {
                this.scannerId_ = this.htable_.getScanner(this.scan_);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.scannerId_ = id;
        }
    }

    public MapRResultScanner(MapRScan scan, MapRHTable htable) {
        this(scan, htable, 0L);
    }

    public MapRResult nextRow() throws IOException {
        return this.nextRows(1)[0];
    }

    public MapRResult[] nextRows(int nbRows) throws IOException {
        if (this.scannerId_ == 0L) {
            throw new IOException("Invalid or freed scanner object");
        }
        MapRResult[] res = new MapRResult[nbRows];
        for (int i = 0; i < nbRows; ++i) {
            res[i] = new MapRResult();
        }
        this.nextRows(nbRows, res);
        return res;
    }

    protected void nextRows(int nbRows, MapRResult[] res) throws IOException {
        while (true) {
            try {
                this.htable_.scanNext(this.scannerId_, nbRows, res);
                this.scanStarted_ = true;
            }
            catch (StaleFileException e) {
                if (!e.isNoRetry() && !this.scanStarted_) {
                    this.scanStarted_ = true;
                    this.scannerId_ = this.htable_.getScanner(this.scan_);
                    continue;
                }
                throw e;
            }
            break;
        }
    }

    public void releaseTempMemory() throws IOException {
    }

    @Override
    public void close() {
        if (this.scannerId_ == 0L) {
            return;
        }
        this.htable_.removeScanner(this);
        try {
            this.htable_.getInode().closeScanner(this.scannerId_);
            this.scannerId_ = 0L;
            this.htable_.tryClose(true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

