/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs;

import com.google.protobuf.ByteString;
import com.mapr.fs.MapRDbResultScanner;
import com.mapr.fs.MapRFileSystem;
import com.mapr.fs.MapRHTable;
import com.mapr.fs.jni.MapRConstants;
import com.mapr.fs.jni.MapRGet;
import com.mapr.fs.jni.MapRKeyValue;
import com.mapr.fs.jni.MapRPut;
import com.mapr.fs.jni.MapRResult;
import com.mapr.fs.jni.MapRRowConstraint;
import com.mapr.fs.jni.MapRScan;
import com.mapr.fs.proto.Dbfilters;
import com.mapr.fs.tables.TableProperties;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;

public class MapRDbUtils {
    private final int SIZEOF_LONG = 8;
    private static final int kKeyOnlyFilter = -1104448491;
    private MapRFileSystem maprfs_;
    private MapRHTable maprHTable_;
    private byte[] tableUuid_;
    private String defaultColumnFamily_;
    private String defaultQualifier_;
    private long rowTimeStamp_;

    public MapRDbUtils() {
    }

    public MapRDbUtils(MapRFileSystem maprfs) {
        this.maprfs_ = maprfs;
    }

    public static boolean isDbCreated(String path) {
        try {
            Path tPath = new Path(path);
            MapRHTable tmpHTable = new MapRHTable();
            tmpHTable.init(new Configuration(), tPath);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public void Init(String tablePath, String defaultColumnFamily, String defaultQualifier) throws IOException {
        if (tablePath == null || tablePath.isEmpty()) {
            throw new IOException("Invalid tablePath");
        }
        if (defaultColumnFamily == null || defaultColumnFamily.isEmpty()) {
            throw new IOException("Invalid defaultColumnFamily");
        }
        if (defaultQualifier == null || defaultQualifier.isEmpty()) {
            throw new IOException("Invalid defaultQualifier");
        }
        this.defaultColumnFamily_ = new String(defaultColumnFamily);
        this.defaultQualifier_ = new String(defaultQualifier);
        this.rowTimeStamp_ = Long.MAX_VALUE;
        Path tPath = new Path(tablePath);
        this.maprHTable_ = new MapRHTable(this.maprfs_);
        this.maprHTable_.init(new Configuration(), tPath);
        TableProperties tableProp = this.maprHTable_.getMapRFS().getTableProperties(tPath);
        this.tableUuid_ = tableProp.getUuid();
    }

    public void Put(byte[] key, byte[] value) throws IOException {
        if (key == null) {
            throw new IOException("Invalid key");
        }
        if (value == null) {
            throw new IOException("Invalid value");
        }
        HashMap<String, byte[]> valueMap = new HashMap<String, byte[]>();
        valueMap.put(this.defaultQualifier_, value);
        this.Put(key, valueMap);
    }

    public void Put(byte[] key, Map<String, byte[]> valueMap) throws IOException {
        if (key == null) {
            throw new IOException("Invalid key");
        }
        if (valueMap == null || valueMap.size() == 0) {
            throw new IOException("Invalid valueMap");
        }
        MapRPut[] mrput = new MapRPut[valueMap.size()];
        int i = 0;
        for (Map.Entry<String, byte[]> entry : valueMap.entrySet()) {
            mrput[i] = new MapRPut();
            mrput[i].numFamilies = 1;
            mrput[i].numCells = 1;
            mrput[i].type = 0;
            mrput[i].rowTimeStamp = this.rowTimeStamp_;
            mrput[i].key = key;
            mrput[i].rowTotalBytes += (long)(mrput[i].key.length + 8);
            mrput[i].families = new int[mrput[i].numFamilies];
            mrput[i].keyvals = new MapRKeyValue[mrput[i].numCells];
            mrput[i].cellsPerFamily = new int[mrput[i].numFamilies];
            mrput[i].families[0] = this.maprHTable_.getFamilyId(this.defaultColumnFamily_);
            mrput[i].cellsPerFamily[0] = mrput[i].numCells;
            String qualifier = entry.getKey();
            byte[] value = entry.getValue();
            byte[] buffer = new byte[qualifier.length() + value.length];
            System.arraycopy(qualifier.getBytes(), 0, buffer, 0, qualifier.length());
            System.arraycopy(value, 0, buffer, qualifier.length(), value.length);
            mrput[i].keyvals[0] = new MapRKeyValue(buffer, 0, qualifier.length(), qualifier.length(), value.length, this.rowTimeStamp_, true, true);
            mrput[i].rowTotalBytes += (long)(qualifier.length() + value.length + 8);
            ++i;
        }
        this.maprHTable_.syncPut(mrput);
    }

    public void batchPut(Map<byte[], byte[]> keyValueMap) throws IOException {
        if (keyValueMap == null || keyValueMap.isEmpty()) {
            throw new IOException("Invalid keyValueMap");
        }
        ArrayList<MapRPut> mrputList = new ArrayList<MapRPut>();
        for (Map.Entry<byte[], byte[]> entry : keyValueMap.entrySet()) {
            byte[] key = entry.getKey();
            byte[] value = entry.getValue();
            MapRPut mrput = new MapRPut();
            mrput.numFamilies = 1;
            mrput.numCells = 1;
            mrput.type = 0;
            mrput.rowTimeStamp = this.rowTimeStamp_;
            mrput.key = key;
            mrput.rowTotalBytes += (long)(mrput.key.length + 8);
            mrput.families = new int[mrput.numFamilies];
            mrput.keyvals = new MapRKeyValue[mrput.numCells];
            mrput.cellsPerFamily = new int[mrput.numFamilies];
            mrput.families[0] = this.maprHTable_.getFamilyId(this.defaultColumnFamily_);
            mrput.cellsPerFamily[0] = mrput.numCells;
            String qualifier = this.defaultQualifier_;
            byte[] qualifierBytes = qualifier.getBytes();
            byte[] buffer = new byte[qualifierBytes.length + value.length];
            System.arraycopy(qualifierBytes, 0, buffer, 0, qualifierBytes.length);
            System.arraycopy(value, 0, buffer, qualifierBytes.length, value.length);
            mrput.keyvals[0] = new MapRKeyValue(buffer, 0, qualifierBytes.length, qualifierBytes.length, value.length, this.rowTimeStamp_, true, true);
            mrput.rowTotalBytes += (long)(qualifierBytes.length + value.length + 8);
            mrputList.add(mrput);
        }
        MapRPut[] mrputArray = (MapRPut[])mrputList.toArray(MapRPut[]::new);
        this.maprHTable_.syncPut(mrputArray);
    }

    public void Put(byte[] key, Map<String, byte[]> insValueMap, List<String> delColumns) throws IOException {
        if (insValueMap != null && insValueMap.size() > 0) {
            this.Put(key, insValueMap);
        }
        if (delColumns != null && delColumns.size() > 0) {
            for (String col : delColumns) {
                this.Delete(key, col);
            }
        }
    }

    public void Delete(byte[] key, String colName) throws IOException {
        if (key == null || colName == null || colName.isEmpty()) {
            throw new IOException("Invalid key");
        }
        MapRPut mrput = new MapRPut();
        mrput.numFamilies = 1;
        mrput.numCells = 1;
        mrput.type = 0;
        mrput.rowTimeStamp = this.rowTimeStamp_;
        mrput.key = key;
        mrput.rowTotalBytes += (long)(mrput.key.length + 8);
        mrput.families = new int[mrput.numFamilies];
        mrput.keyvals = new MapRKeyValue[mrput.numCells];
        mrput.cellsPerFamily = new int[mrput.numFamilies];
        mrput.families[0] = this.maprHTable_.getFamilyId(this.defaultColumnFamily_);
        mrput.cellsPerFamily[0] = mrput.numCells;
        byte[] buffer = new byte[colName.length()];
        System.arraycopy(colName.getBytes(), 0, buffer, 0, colName.length());
        mrput.keyvals[0] = new MapRKeyValue(buffer, 0, colName.length(), colName.length(), 0, this.rowTimeStamp_, true, true, true);
        mrput.rowTotalBytes += (long)(colName.length() + 8);
        this.maprHTable_.syncPut(mrput);
    }

    public void Delete(byte[] key) throws IOException {
        if (key == null) {
            throw new IOException("Invalid key");
        }
        MapRPut mrput = new MapRPut();
        mrput.numFamilies = 0;
        mrput.numCells = 0;
        mrput.type = (byte)17;
        mrput.rowTimeStamp = this.rowTimeStamp_;
        mrput.key = key;
        mrput.rowTotalBytes += (long)(mrput.key.length + 8);
        this.maprHTable_.delete(mrput);
    }

    public byte[] Get(byte[] key) throws IOException {
        MapRResult mresult;
        if (key == null) {
            throw new IOException("Invalid key");
        }
        MapRGet mrget = new MapRGet();
        mrget.result = new MapRResult();
        mrget.key = key;
        mrget.rowConstraint = this.getDefaultRowConstraint();
        mrget.setEncodedResult(false);
        this.maprHTable_.get(mrget, true);
        if (mrget.getArena() != 0L) {
            this.maprHTable_.freeArena(mrget.getArena());
        }
        if ((mresult = mrget.getResult()) == null || mresult.isEmpty()) {
            return null;
        }
        byte[] row = mresult.bufBytes;
        int valOffset = mresult.valueOffsets[0];
        int valLength = mresult.valueLengths[0];
        byte[] value = Arrays.copyOfRange(row, valOffset, valOffset + valLength);
        return value;
    }

    public Map<String, byte[]> MultiColumnGet(byte[] key) throws IOException {
        MapRResult mresult;
        if (key == null) {
            throw new IOException("Invalid key");
        }
        MapRGet mrget = new MapRGet();
        mrget.result = new MapRResult();
        mrget.key = key;
        mrget.rowConstraint = this.getDefaultRowConstraint(false);
        mrget.setEncodedResult(false);
        this.maprHTable_.get(mrget, true);
        if (mrget.getArena() != 0L) {
            this.maprHTable_.freeArena(mrget.getArena());
        }
        if ((mresult = mrget.getResult()) == null || mresult.isEmpty()) {
            return null;
        }
        HashMap<String, byte[]> valueMap = new HashMap<String, byte[]>();
        byte[] row = mresult.bufBytes;
        int[] columnOffsets = mresult.getColumnOffsets();
        int[] columnLengths = mresult.getColumnLengths();
        int[] valueOffsets = mresult.getValueOffsets();
        int[] valueLengths = mresult.getValueLengths();
        for (int i = 0; i < columnOffsets.length; ++i) {
            byte[] column = Arrays.copyOfRange(row, columnOffsets[i], columnOffsets[i] + columnLengths[i]);
            byte[] value = Arrays.copyOfRange(row, valueOffsets[i], valueOffsets[i] + valueLengths[i]);
            valueMap.put(new String(column), value);
            String string = new String(column);
        }
        return valueMap;
    }

    public boolean Exist(byte[] key) throws IOException {
        MapRResult mresult;
        if (key == null) {
            throw new IOException("Invalid key");
        }
        MapRGet mrget = new MapRGet();
        mrget.result = new MapRResult();
        mrget.key = key;
        mrget.rowConstraint = this.getDefaultRowConstraint();
        mrget.setEncodedResult(false);
        this.maprHTable_.get(mrget, true);
        if (mrget.getArena() != 0L) {
            this.maprHTable_.freeArena(mrget.getArena());
        }
        return (mresult = mrget.getResult()) != null && !mresult.isEmpty();
    }

    public MapRDbResultScanner getKeysScanner(byte[] startKey, byte[] endKey, boolean defaultColumn) throws IOException {
        return this.getScanner(startKey, endKey, defaultColumn, true);
    }

    public MapRDbResultScanner getKeysScanner(byte[] startKey, byte[] endKey) throws IOException {
        return this.getScanner(startKey, endKey, true, true);
    }

    public MapRDbResultScanner getScanner(byte[] startKey, byte[] endKey) throws IOException {
        return this.getScanner(startKey, endKey, true, false);
    }

    public MapRDbResultScanner getScanner(byte[] startKey, byte[] endKey, boolean defaultColumn) throws IOException {
        return this.getScanner(startKey, endKey, defaultColumn, false);
    }

    public MapRDbResultScanner getScanner(byte[] startKey, byte[] endKey, boolean defaultColumn, boolean onlyKeys) throws IOException {
        MapRScan maprscan = new MapRScan();
        maprscan.batch = 1;
        maprscan.caching = Integer.MAX_VALUE;
        maprscan.startRow = startKey != null ? startKey : MapRConstants.EMPTY_START_ROW;
        maprscan.stopRow = endKey != null ? endKey : MapRConstants.EMPTY_END_ROW;
        maprscan.rowConstraint = this.getDefaultRowConstraint(defaultColumn);
        maprscan.setFlushOnRead(true);
        if (onlyKeys) {
            ByteString state = Dbfilters.KeyOnlyFilterProto.newBuilder().setLenAsVal(true).build().toByteString();
            Dbfilters.FilterMsg filterMsg = Dbfilters.FilterMsg.newBuilder().setId(String.format("%08x", -1104448491)).setSerializedState(state).build();
            maprscan.setFilter(filterMsg.toByteArray());
        }
        long scannerId = this.maprHTable_.getScanner(maprscan);
        MapRDbResultScanner scanner = new MapRDbResultScanner(maprscan, this.maprHTable_, scannerId);
        return scanner;
    }

    private MapRRowConstraint getDefaultRowConstraint() throws IOException {
        return this.getDefaultRowConstraint(true);
    }

    private MapRRowConstraint getDefaultRowConstraint(boolean defaultColumn) throws IOException {
        MapRRowConstraint rc = new MapRRowConstraint();
        rc.maxVersions = 1;
        if (defaultColumn) {
            rc.numFamilies = 1;
            rc.numColumns = 1;
            rc.families = new int[rc.numFamilies];
            rc.families[0] = this.maprHTable_.getFamilyId(this.defaultColumnFamily_);
            rc.columns = new byte[rc.numColumns][];
            rc.columns[0] = this.defaultQualifier_.getBytes();
            rc.columnsPerFamily = new int[rc.numFamilies];
            rc.columnsPerFamily[0] = 1;
        } else {
            rc.numFamilies = 0;
            rc.numColumns = 0;
            rc.families = null;
            rc.columnsPerFamily = null;
            rc.columns = null;
        }
        rc.minStamp = 0L;
        rc.maxStamp = Long.MAX_VALUE;
        return rc;
    }

    public static String printBytes(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        sb.append("[ ");
        for (byte b : bytes) {
            sb.append(String.format("0x%02X ", b));
        }
        sb.append("]");
        return sb.toString();
    }

    public synchronized void close() {
        if (this.maprHTable_ != null) {
            try {
                this.maprHTable_.close();
                this.maprHTable_ = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

