/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs;

import com.mapr.fs.ClusterConf;
import com.mapr.fs.MapRFileSystem;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;

public class MapRCluster {
    public static final Log LOG = LogFactory.getLog(MapRCluster.class);

    public static InetSocketAddress[] getJobTrackerAddrs(String clusterName, String[] cldbLocations) throws IOException {
        MapRFileSystem mfs = null;
        try {
            mfs = new MapRFileSystem(clusterName, cldbLocations);
            InetSocketAddress[] inetSocketAddressArray = mfs.getJobTrackerAddrs(null);
            return inetSocketAddressArray;
        }
        catch (Exception e) {
            throw new IOException(e.getLocalizedMessage());
        }
        finally {
            if (mfs != null) {
                mfs.close();
            }
            mfs = null;
        }
    }

    public static InetSocketAddress[] getJobTrackerAddrs(String clusterName) throws IOException {
        MapRFileSystem mfs = null;
        Configuration conf = new Configuration();
        conf.set("fs.default.name", "maprfs:///mapr/" + clusterName);
        conf.set("mapred.job.tracker", "maprfs:///");
        try {
            URI uri = new URI("maprfs:///mapr/" + clusterName);
            mfs = new MapRFileSystem();
            mfs.initialize(uri, conf);
            InetSocketAddress[] inetSocketAddressArray = mfs.getJobTrackerAddrs(conf);
            return inetSocketAddressArray;
        }
        catch (Exception e) {
            throw new IOException(e.getLocalizedMessage());
        }
        finally {
            if (mfs != null) {
                mfs.close();
            }
            mfs = null;
        }
    }

    public List<ClusterConf.ClusterEntry> getClusterList() {
        return new ArrayList<ClusterConf.ClusterEntry>(MapRFileSystem.getClusterConf().getClusterList());
    }
}

