/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.org.apache.hadoop.metrics.util;

import com.mapr.org.apache.hadoop.classification.InterfaceAudience;
import java.lang.management.ManagementFactory;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

@InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce"})
public class MBeanUtil {
    public static ObjectName registerMBean(String serviceName, String nameName, Object theMbean) {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        ObjectName name = MBeanUtil.getMBeanName(serviceName, nameName);
        try {
            mbs.registerMBean(theMbean, name);
            return name;
        }
        catch (InstanceAlreadyExistsException instanceAlreadyExistsException) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static void unregisterMBean(ObjectName mbeanName) {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        if (mbeanName == null) {
            return;
        }
        try {
            mbs.unregisterMBean(mbeanName);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static ObjectName getMBeanName(String serviceName, String nameName) {
        ObjectName name = null;
        try {
            name = new ObjectName("hadoop:service=" + serviceName + ",name=" + nameName);
        }
        catch (MalformedObjectNameException e) {
            e.printStackTrace();
        }
        return name;
    }
}

