/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs;

import com.mapr.fs.Inode;
import com.mapr.fs.LoggerProxy;
import com.mapr.fs.MapRClientImpl;
import com.mapr.fs.MapRFileSystem;
import com.mapr.fs.jni.InodeAttributes;
import com.mapr.fs.jni.MapRUserInfo;
import com.mapr.fs.jni.Page;
import com.mapr.fs.jni.SFid;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.ByteBufferReadable;
import org.apache.hadoop.fs.CanSetDropBehind;
import org.apache.hadoop.fs.CanSetReadahead;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.PathId;

public class MapRFsInStream
extends FSInputStream
implements ByteBufferReadable,
CanSetReadahead,
CanSetDropBehind {
    public static final Log LOG = LogFactory.getLog(MapRFsInStream.class);
    private static final AtomicLong currentOpenStreams = new AtomicLong(0L);
    static final int DEFAULT_MAX_OPEN_STREAMS = 200;
    static final int MAX_OPEN_STREAMS;
    int READ_SIZE = 65536;
    int raThreadsPerStream = MapRClientImpl.javaRAThreadsPerStream();
    FileSystem.Statistics stats_;
    Inode inode_;
    SFid sfid_;
    Page curPage_;
    long curPos_;
    long prevPageOff_;
    int raHits_;
    int raReverse_;
    long raPos_;
    boolean raEnabled_ = false;
    RAList raList_ = null;
    long raCurrentReadStartPos_;
    int raCurrentReadLength_;
    int maxStreams_;
    boolean dropBehindSet_;
    private final boolean raAvailable_ = throttleCheck_ ? currentOpenStreams.incrementAndGet() < (long)MAX_OPEN_STREAMS : (MapRFileSystem.getRAThreads() != 0 ? currentOpenStreams.incrementAndGet() <= (long)(MapRFileSystem.getRAThreads() / this.raThreadsPerStream) : true);
    static final boolean throttleCheck_;

    protected MapRFsInStream(long clntPtr, long filePtr, String filename, FileSystem.Statistics stats, InodeAttributes attr, MapRUserInfo userInfo) throws IOException {
        this.inode_ = new Inode(clntPtr, filePtr, filename, this, attr, LoggerProxy.InodeLogger, userInfo);
        this.sfid_ = new SFid();
        this.curPage_ = null;
        this.curPos_ = 0L;
        this.prevPageOff_ = -1L;
        this.raPos_ = 0L;
        this.raHits_ = 3;
        this.raReverse_ = 0;
        this.stats_ = stats;
        this.raCurrentReadStartPos_ = 0L;
        this.raCurrentReadLength_ = 0;
        this.dropBehindSet_ = false;
    }

    public MapRFsInStream(long clntPtr, long filePtr, String filename, FileSystem.Statistics stats, MapRUserInfo userInfo) throws IOException {
        this(clntPtr, filePtr, filename, stats, null, userInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFidStr() {
        MapRFsInStream mapRFsInStream = this;
        synchronized (mapRFsInStream) {
            if (this.inode_ == null) {
                return null;
            }
            return this.inode_.getFidStr();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] getFidServers() {
        MapRFsInStream mapRFsInStream = this;
        synchronized (mapRFsInStream) {
            if (this.inode_ == null) {
                return null;
            }
            return this.inode_.getFidServers();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getChunkSize() {
        MapRFsInStream mapRFsInStream = this;
        synchronized (mapRFsInStream) {
            if (this.inode_ == null) {
                return -1L;
            }
            return this.inode_.getChunkSize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openAndRead(PathId pfid, String file, int length) throws IOException {
        MapRFsInStream mapRFsInStream = this;
        synchronized (mapRFsInStream) {
            if (this.inode_ == null) {
                throw new IOException("File already closed");
            }
            this.curPage_ = this.inode_.getDataIntoCache(0L, length, length - 1, this.sfid_, pfid, file);
        }
    }

    void saveReadRequestParamsForRA(long pos, int len) {
        this.raCurrentReadStartPos_ = pos;
        this.raCurrentReadLength_ = len;
    }

    public int getCacheSize(InodeAttributes iattr) {
        int RA_SIZE = this.raThreadsPerStream * this.READ_SIZE;
        RAThread[] raThread = new RAThread[this.raThreadsPerStream];
        if (MapRClientImpl.readBuffering()) {
            if (iattr.filesize > 0x800000L && this.raAvailable_) {
                this.raEnabled_ = true;
                this.raList_ = new RAList();
                for (int i = 0; i < raThread.length; ++i) {
                    raThread[i] = new RAThread();
                    Thread t = new Thread(null, raThread[i], "MapR RA");
                    t.setDaemon(true);
                    t.start();
                }
                return RA_SIZE * (this.raThreadsPerStream * this.raThreadsPerStream + 1) / 8192;
            }
            this.raEnabled_ = false;
            this.READ_SIZE = 524288;
            this.raThreadsPerStream = 1;
            RA_SIZE = this.raThreadsPerStream * this.READ_SIZE;
            return RA_SIZE / 8192 + 1;
        }
        this.raEnabled_ = false;
        this.READ_SIZE = 65536;
        this.raThreadsPerStream = 1;
        RA_SIZE = this.raThreadsPerStream * this.READ_SIZE;
        return 2 * (this.READ_SIZE / 8192) + 1;
    }

    void pr(String s) {
        LOG.error((Object)(this.inode_ + s));
    }

    void dropCurrentPage() {
        if (this.curPage_ != null) {
            Page p = this.curPage_;
            this.curPage_ = null;
            if (this.dropBehindSet_) {
                this.inode_.discardPage(p);
            } else {
                this.inode_.returnPageToCache(p);
            }
        }
    }

    void dropAndRefillCurrentPage(long intendReadTillOffset) throws IOException {
        this.dropCurrentPage();
        this.updateReadAhead(intendReadTillOffset);
        this.curPage_ = this.inode_.getDataIntoCache(this.curPos_, 1, intendReadTillOffset, this.sfid_, null, null);
    }

    boolean outsideCurrentPage() {
        long pageOff = this.curPage_.pageId << 13;
        return this.curPos_ < pageOff || this.curPos_ >= pageOff + 8192L;
    }

    public long getPos() {
        return this.curPos_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getFileLength() {
        MapRFsInStream mapRFsInStream = this;
        synchronized (mapRFsInStream) {
            if (this.inode_ == null) {
                return -1L;
            }
            return this.inode_.eof();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int available() throws IOException {
        MapRFsInStream mapRFsInStream = this;
        synchronized (mapRFsInStream) {
            if (this.inode_ == null) {
                throw new IOException("File already closed");
            }
            long available = this.inode_.eof() - this.curPos_;
            int n = available > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)available;
            return n;
        }
    }

    public boolean seekToNewSource(long pos) {
        return false;
    }

    private synchronized int readIntoDirectByteBuffer(ByteBuffer buffer) throws IOException {
        if (this.inode_ == null) {
            throw new IOException("File already closed");
        }
        int start = -1;
        int lenInPage = -1;
        int bytesRead = 0;
        int length = buffer.remaining();
        if (length == 0) {
            return 0;
        }
        if (this.curPos_ + (long)length > this.inode_.eof()) {
            length = (int)(this.inode_.eof() - this.curPos_);
        }
        if (length <= 0) {
            this.curPos_ = this.inode_.eof();
            return -1;
        }
        long intendReadTillOffset = this.curPos_ + (long)length;
        this.saveReadRequestParamsForRA(this.curPos_, length);
        while (length > 0) {
            if (this.curPage_ == null || this.outsideCurrentPage()) {
                this.dropAndRefillCurrentPage(intendReadTillOffset);
            }
            if (this.curPage_ == null || this.curPos_ == this.inode_.eof()) break;
            Page p = this.curPage_;
            start = (int)(this.curPos_ % 8192L);
            lenInPage = p.validLen - start;
            if (lenInPage > length) {
                lenInPage = length;
            }
            if (lenInPage <= 0) break;
            p.bbuf.position(start);
            int origLimit = p.bbuf.limit();
            p.bbuf.limit(start + lenInPage);
            buffer.put(p.bbuf);
            p.bbuf.limit(origLimit);
            this.curPos_ += (long)lenInPage;
            length -= lenInPage;
            bytesRead += lenInPage;
        }
        if (bytesRead <= 0) {
            return -1;
        }
        if (this.stats_ != null) {
            this.stats_.incrementBytesRead((long)bytesRead);
            this.stats_.incrementReadOps(1);
        }
        return bytesRead;
    }

    public synchronized int read(byte[] buffer, int bufOffset, int length) throws IOException {
        if (this.inode_ == null) {
            throw new IOException("File already closed");
        }
        int start = -1;
        int lenInPage = -1;
        int bytesRead = 0;
        if (bufOffset < 0) {
            throw new IndexOutOfBoundsException("BufferOffSet index " + bufOffset + " is out of bounds!");
        }
        if (length < 0 || length > buffer.length - bufOffset) {
            throw new IndexOutOfBoundsException("Length " + length + " is out of bounds!");
        }
        if (length == 0) {
            return 0;
        }
        if (this.curPos_ + (long)length > this.inode_.eof()) {
            length = (int)(this.inode_.eof() - this.curPos_);
        }
        if (length <= 0) {
            this.curPos_ = this.inode_.eof();
            return -1;
        }
        long intendReadTillOffset = this.curPos_ + (long)length;
        this.saveReadRequestParamsForRA(this.curPos_, length);
        while (length > 0) {
            if (this.curPage_ == null || this.outsideCurrentPage()) {
                this.dropAndRefillCurrentPage(intendReadTillOffset);
            }
            if (this.curPage_ == null || this.curPos_ == this.inode_.eof()) break;
            Page p = this.curPage_;
            start = (int)(this.curPos_ % 8192L);
            lenInPage = p.validLen - start;
            if (lenInPage > length) {
                lenInPage = length;
            }
            if (lenInPage <= 0) break;
            p.bbuf.position(start);
            p.bbuf.get(buffer, bufOffset, lenInPage);
            this.curPos_ += (long)lenInPage;
            length -= lenInPage;
            bytesRead += lenInPage;
            bufOffset += lenInPage;
        }
        if (bytesRead <= 0) {
            return -1;
        }
        if (this.stats_ != null) {
            this.stats_.incrementBytesRead((long)bytesRead);
            this.stats_.incrementReadOps(1);
        }
        return bytesRead;
    }

    public synchronized int read(ByteBuffer buf) throws IOException {
        int bytesRead = 0;
        if (buf.isDirect()) {
            bytesRead = this.readIntoDirectByteBuffer(buf);
        } else {
            bytesRead = this.read(buf.array(), buf.position(), buf.remaining());
            if (bytesRead > 0) {
                buf.position(buf.position() + bytesRead);
            }
        }
        return bytesRead;
    }

    public synchronized int read() throws IOException {
        if (this.inode_ == null) {
            throw new IOException("File already closed");
        }
        if (this.curPage_ == null || this.outsideCurrentPage()) {
            this.dropAndRefillCurrentPage(0L);
        }
        if (this.curPage_ == null || this.curPos_ >= this.inode_.eof()) {
            this.curPos_ = this.inode_.eof();
            this.dropCurrentPage();
            return -1;
        }
        int posInBuf = (int)(this.curPos_ % 8192L);
        ++this.curPos_;
        if (this.stats_ != null) {
            this.stats_.incrementBytesRead(1L);
            this.stats_.incrementReadOps(1);
        }
        return this.curPage_.bbuf.get(posInBuf) & 0xFF;
    }

    public synchronized void seek(long pos) throws IOException {
        if (this.inode_ == null) {
            throw new IOException("File already closed");
        }
        if (pos > this.inode_.eof()) {
            throw new EOFException("Seeking beyond EOF, file: " + this.inode_.filename() + ", file length: " + this.inode_.eof() + ", seeking to: " + pos);
        }
        if (pos < 0L) {
            throw new IOException("Seeking before beginning, file: " + this.inode_.filename() + ", seeking to: " + pos);
        }
        if (pos == this.curPos_) {
            return;
        }
        if (pos < this.curPos_) {
            ++this.raReverse_;
            if (this.raReverse_ > 1) {
                this.raPos_ = 0L;
                this.prevPageOff_ = -2L;
                this.raHits_ = 0;
            }
        } else {
            this.raReverse_ = 0;
        }
        this.curPos_ = pos;
        if (this.curPage_ != null && this.outsideCurrentPage()) {
            this.dropCurrentPage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(long startPos, byte[] buffer, int bufOffset, int length) throws IOException {
        Page p;
        int i;
        Inode inode;
        MapRFsInStream mapRFsInStream = this;
        synchronized (mapRFsInStream) {
            inode = this.inode_;
        }
        if (inode == null) {
            throw new IOException("File already closed");
        }
        if (startPos >= inode.eof()) {
            return -1;
        }
        if (startPos + (long)length > inode.eof()) {
            length = (int)(inode.eof() - startPos);
        }
        long saveStartPos = startPos;
        long firstPageId = startPos >> 13;
        int numPages = (int)((startPos + (long)length - 1L >> 13) - firstPageId + 1L);
        long intendReadTillOffset = (firstPageId + (long)numPages << 13) - 1L;
        Page[] pages = new Page[numPages];
        int lenLeft = length;
        for (i = 0; i < numPages; ++i) {
            p = new Page(null, false, 8192, false);
            p.pageId = firstPageId + (long)i;
            pages[i] = p;
            p.validStart = (int)(startPos & 0x1FFFL);
            p.validLen = 8192 - p.validStart;
            if (p.validLen > lenLeft) {
                p.validLen = lenLeft;
            }
            lenLeft -= p.validLen;
            startPos += (long)p.validLen;
        }
        try {
            int ret = inode.readPages(pages, intendReadTillOffset);
            if (length > ret) {
                length = ret;
            }
            if (length > 0) {
                int lenInPage;
                startPos = saveStartPos;
                if (length > 0 && this.stats_ != null) {
                    this.stats_.incrementBytesRead((long)length);
                }
                i = 0;
                for (int lenRead = length; lenRead > 0; lenRead -= lenInPage) {
                    int start = (int)(startPos % 8192L);
                    lenInPage = 8192 - start;
                    if (lenInPage > lenRead) {
                        lenInPage = lenRead;
                    }
                    p = pages[i++];
                    p.bbuf.position(start);
                    p.bbuf.get(buffer, bufOffset, lenInPage);
                    startPos += (long)lenInPage;
                    bufOffset += lenInPage;
                }
            }
        }
        finally {
            for (i = 0; i < numPages; ++i) {
                pages[i].releaseStorage();
                pages[i] = null;
            }
        }
        if (length < 0) {
            throw new IOException("error during read");
        }
        if (this.stats_ != null) {
            this.stats_.incrementReadOps(1);
        }
        return length;
    }

    public void readFully(long pos, byte[] buffer) throws IOException {
        this.readFully(pos, buffer, 0, buffer.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readFully(long pos, byte[] buffer, int bufOffset, int length) throws IOException {
        MapRFsInStream mapRFsInStream = this;
        synchronized (mapRFsInStream) {
            if (this.inode_ == null) {
                throw new IOException("File already closed");
            }
        }
        if (this.getFileLength() - pos < (long)length) {
            throw new EOFException("Not enough data to fill buffer");
        }
        this.read(pos, buffer, bufOffset, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void adviseFile(FSDataInputStream.FadviseType type, long offset, long count) throws IOException {
        MapRFsInStream mapRFsInStream = this;
        synchronized (mapRFsInStream) {
            if (this.inode_ != null) {
                switch (type) {
                    case FILE_DONTNEED: {
                        this.inode_.adviseFile(0, offset, count);
                    }
                }
            }
        }
    }

    public synchronized void close() throws IOException {
        if (this.inode_ != null) {
            this.dropCurrentPage();
            if (this.raEnabled_) {
                this.inode_.removeFromInStreams();
                this.raList_.waitTillRunnersDie(this.inode_.filename());
                this.raList_ = null;
            }
            this.inode_.close(true);
            LOG.debug((Object)("InStream closed: " + this.inode_.filename()));
            this.inode_ = null;
        }
        if (throttleCheck_ || MapRFileSystem.getRAThreads() != 0) {
            currentOpenStreams.decrementAndGet();
        }
    }

    void updateReadAhead(long intendReadTillOffset) throws IOException {
        if (!MapRClientImpl.readBuffering()) {
            int len = this.raCurrentReadLength_;
            if (len > 8192) {
                long pos;
                if (len > 2 * this.READ_SIZE) {
                    len = 2 * this.READ_SIZE;
                }
                if ((pos = this.raCurrentReadStartPos_) % 8192L != 0L) {
                    pos -= pos % 8192L;
                    if ((len += 8191) > 2 * this.READ_SIZE) {
                        len = 2 * this.READ_SIZE;
                    }
                }
                if (pos + (long)len > this.inode_.eof() && (len = (int)(this.inode_.eof() - pos)) <= 0) {
                    return;
                }
                this.raCurrentReadLength_ -= len;
                Page p = this.inode_.getDataIntoCache(pos, len, intendReadTillOffset, this.sfid_, null, null);
                if (p != null) {
                    this.inode_.returnPageToCache(p);
                }
            }
            return;
        }
        if (this.curPos_ >> 13 == 1L + this.prevPageOff_) {
            ++this.raHits_;
        }
        this.prevPageOff_ = this.curPos_ >> 13;
        if (this.raHits_ < 3) {
            return;
        }
        if (this.curPos_ % (long)this.READ_SIZE != 0L) {
            return;
        }
        int RA_SIZE = this.raThreadsPerStream * this.READ_SIZE;
        if (this.raEnabled_) {
            int sz;
            long chunksz;
            boolean didRA = false;
            long raDistance = this.raPos_ - this.curPos_;
            if (this.raHits_ > 10 && raDistance > (long)(this.raThreadsPerStream * RA_SIZE)) {
                this.raPos_ = this.curPos_;
            }
            if ((chunksz = this.inode_.attrs().chunksize) > 0L && this.curPos_ % chunksz == 0L) {
                this.raPos_ = this.curPos_;
            } else if (this.raPos_ <= this.curPos_ && (chunksz > 0L && (this.curPos_ & chunksz - 1L) >= (long)(this.raThreadsPerStream * RA_SIZE) || chunksz == 0L && this.curPos_ >= (long)(this.raThreadsPerStream * RA_SIZE))) {
                int i = 0;
                for (i = 0; i < this.raThreadsPerStream; ++i) {
                    Page[] pagesToFill;
                    long curChunk;
                    this.raPos_ = this.curPos_ + (long)(RA_SIZE * (i + 1));
                    if (this.raPos_ >= this.inode_.eof()) continue;
                    int sz2 = RA_SIZE;
                    if (this.raPos_ + (long)sz2 > this.inode_.eof()) {
                        sz2 = (int)(this.inode_.eof() - this.raPos_);
                    }
                    long l = curChunk = chunksz != 0L ? this.curPos_ / chunksz : 0L;
                    if (sz2 <= 0 || chunksz != 0L && (curChunk != this.raPos_ / chunksz || curChunk != (this.raPos_ + (long)sz2) / chunksz) || (pagesToFill = this.inode_.allocateReadaheadPages(this.raPos_, sz2)) == null) continue;
                    didRA = true;
                    RAWorker ra = new RAWorker(this, pagesToFill, intendReadTillOffset);
                    this.raList_.enq(ra);
                }
            }
            int n = sz = didRA ? RA_SIZE : this.READ_SIZE;
            if (this.curPos_ + (long)sz > this.inode_.eof() && (sz = (int)(this.inode_.eof() - this.curPos_)) <= 0) {
                return;
            }
            Page p = this.inode_.getDataIntoCache(this.curPos_, sz, intendReadTillOffset, this.sfid_, null, null);
            if (p != null) {
                this.inode_.returnPageToCache(p);
            }
        } else {
            if (this.curPos_ % (long)RA_SIZE != 0L) {
                return;
            }
            long pos = this.curPos_;
            for (int i = 0; i < this.raThreadsPerStream; ++i) {
                int sz = this.READ_SIZE;
                if (pos + (long)sz > this.inode_.eof() && (sz = (int)(this.inode_.eof() - pos)) <= 0) {
                    return;
                }
                Page p = this.inode_.getDataIntoCache(pos, sz, intendReadTillOffset, this.sfid_, null, null);
                if (p != null) {
                    this.inode_.returnPageToCache(p);
                }
                pos += (long)sz;
            }
        }
    }

    public void setReadahead(Long readAhead) {
    }

    public void setDropBehind(Boolean dropBehind) {
        this.dropBehindSet_ = dropBehind;
    }

    static {
        int maxStreams = 200;
        try {
            String vals = System.getProperty("MAPR_MAX_RA_STREAMS");
            if (vals != null) {
                maxStreams = Integer.parseInt(vals);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        MAX_OPEN_STREAMS = maxStreams;
        throttleCheck_ = System.getProperty("MAPR_IMPALA_RA_THROTTLE") != null;
    }

    static class RAList {
        RAWorker head = null;
        RAWorker tail = null;
        boolean exiting = false;
        int thread_exits = 0;

        RAList() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void enq(RAWorker rawork) {
            RAList rAList = this;
            synchronized (rAList) {
                if (this.tail != null) {
                    this.tail.next = rawork;
                } else {
                    this.head = rawork;
                }
                this.tail = rawork;
                rawork.next = null;
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        RAWorker deq() {
            RAWorker raw = null;
            try {
                RAList rAList = this;
                synchronized (rAList) {
                    while (this.head == null) {
                        if (this.exiting) {
                            return null;
                        }
                        this.wait();
                    }
                    raw = this.head;
                    this.head = this.head.next;
                    if (this.head == null) {
                        this.tail = null;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return raw;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void waitTillRunnersDie(String filename) {
            RAList rAList = this;
            synchronized (rAList) {
                boolean allExited = false;
                while (!allExited) {
                    try {
                        this.exiting = true;
                        this.notifyAll();
                        while (this.thread_exits < MapRClientImpl.javaRAThreadsPerStream()) {
                            this.wait();
                        }
                        allExited = true;
                    }
                    catch (InterruptedException e) {
                        LOG.error((Object)("Reading " + filename + ", interrupted while waiting for RA to finish"));
                    }
                    catch (Exception exception) {}
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void incrementExits() {
            RAList rAList = this;
            synchronized (rAList) {
                ++this.thread_exits;
                this.notify();
            }
        }

        boolean exiting() {
            return this.exiting;
        }
    }

    class RAThread
    implements Runnable {
        SFid sfid_ = new SFid();

        RAThread() {
        }

        @Override
        public void run() {
            while (true) {
                RAWorker raw;
                if ((raw = MapRFsInStream.this.raList_.deq()) != null) {
                    raw.run(this.sfid_);
                    continue;
                }
                if (MapRFsInStream.this.raList_.exiting()) break;
            }
            MapRFsInStream.this.raList_.incrementExits();
        }
    }

    static class RAWorker {
        MapRFsInStream istr;
        Page[] pagesToFill;
        long intendReadTillOffset;
        public RAWorker next;

        RAWorker(MapRFsInStream istr, Page[] pages, long readTillOffset) {
            this.istr = istr;
            this.pagesToFill = pages;
            this.intendReadTillOffset = readTillOffset;
        }

        RAWorker(MapRFsInStream istr) {
            this.istr = istr;
            this.pagesToFill = null;
            this.intendReadTillOffset = 0L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void run(SFid sfid) {
            try {
                if (this.pagesToFill == null) {
                    MapRFsInStream mapRFsInStream = this.istr;
                    synchronized (mapRFsInStream) {
                        ((Object)((Object)this.istr)).notify();
                    }
                    return;
                }
                this.istr.inode_.fillPages(this.pagesToFill, sfid, null, null, this.intendReadTillOffset);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

