/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs.tables;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class CFPermissions {
    final String cfname;
    final Map<String, String> cfPermissions = new HashMap<String, String>();
    final Map<String, Map<String, String>> colsPermissions = new HashMap<String, Map<String, String>>();

    public CFPermissions(String cfname) {
        this.cfname = cfname;
    }

    public String getFamily() {
        return this.cfname;
    }

    public Map<String, String> getCfPermissions() {
        return this.cfPermissions;
    }

    public boolean hasCFPerm(String permission) {
        return this.cfPermissions.containsKey(permission);
    }

    public void addCFPermission(String permission, String expression) {
        this.cfPermissions.put(permission, expression);
    }

    public boolean hasColPerm(String qualifier, String permission) {
        return this.colsPermissions.containsKey(qualifier) && this.colsPermissions.get(qualifier).containsKey(permission);
    }

    public void addColPermission(String qualifier, String permission, String expression) {
        Map<String, String> colPermissions = this.colsPermissions.get(qualifier);
        if (colPermissions == null) {
            colPermissions = new HashMap<String, String>();
            this.colsPermissions.put(qualifier, colPermissions);
        }
        colPermissions.put(permission, expression);
    }

    public Map<String, String> getColPermission(String qualifier) {
        return this.colsPermissions.get(qualifier);
    }

    public Set<String> getColumnNames() {
        return this.colsPermissions.keySet();
    }
}

