/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs;

import com.mapr.fs.Inode;
import com.mapr.fs.LoggerProxy;
import com.mapr.fs.jni.MapRUserInfo;
import com.mapr.fs.jni.Page;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FileSystem;

public class MapRFsOutStream
extends OutputStream {
    public static final Log LOG = LogFactory.getLog(MapRFsOutStream.class);
    private int written_;
    private long curPos_;
    private Page curPage_;
    Inode inode_;
    private FileSystem.Statistics stats_;

    void pr(String s) {
        LOG.error((Object)(Thread.currentThread().getId() + " : " + this.inode_.filename() + s));
    }

    MapRFsOutStream(long clntPtr, long filePtr, String filename, FileSystem.Statistics stats, MapRUserInfo userInfo) throws IOException {
        this.inode_ = new Inode(clntPtr, filePtr, filename, this, LoggerProxy.InodeLogger, userInfo);
        this.written_ = 0;
        this.curPos_ = 0L;
        this.curPage_ = null;
        this.stats_ = stats;
    }

    private void checkClosed() throws IOException {
        if (this.inode_ == null) {
            throw new IOException("stream closed");
        }
    }

    public String getFidStr() throws IOException {
        this.checkClosed();
        return this.inode_.getFidStr();
    }

    public long[] getFidServers() throws IOException {
        this.checkClosed();
        return this.inode_.getFidServers();
    }

    public long getChunkSize() throws IOException {
        this.checkClosed();
        return this.inode_.getChunkSize();
    }

    public synchronized int size() {
        if (this.written_ < 0) {
            this.written_ = Integer.MAX_VALUE;
        }
        return this.written_;
    }

    void dropCurrentPage() throws IOException {
        if (this.curPage_ != null) {
            Page p = this.curPage_;
            this.curPage_ = null;
            this.inode_.releaseDirty(p);
        }
    }

    @Override
    public synchronized void write(byte[] buffer, int bufOffset, int length) throws IOException {
        this.checkClosed();
        while (length > 0) {
            if (this.curPage_ == null || this.outsideCurrentPage()) {
                this.dropCurrentPage();
                this.curPage_ = this.inode_.allocatePage(this.curPos_);
            }
            Page p = this.curPage_;
            int posInPage = (int)(this.curPos_ % 8192L);
            int lenInPage = 8192 - posInPage;
            if (lenInPage > length) {
                lenInPage = length;
            }
            if (p.validLen > 0 && (posInPage > p.validStart + p.validLen || posInPage < p.validStart)) {
                this.dropCurrentPage();
                p = this.curPage_ = this.inode_.allocatePage(this.curPos_);
            }
            try {
                p.bbuf.position(posInPage);
                p.bbuf.put(buffer, bufOffset, lenInPage);
            }
            catch (Exception e) {
                LOG.error((Object)("*********** Exception: posInPage: " + posInPage + ", curpos " + this.curPos_ + ", lenInPage " + lenInPage + ", length " + length + ", pagedId " + p.pageId + ", validStart " + p.validStart + ", validLen " + p.validLen + ", bufOffset " + bufOffset + ", written_ " + this.written_ + ", buf.size " + buffer.length + "\nStack: "));
                e.printStackTrace();
                throw new IOException(e);
            }
            if (p.validLen == 0) {
                p.validStart = posInPage;
                p.validLen = lenInPage;
            } else if (posInPage <= p.validStart + p.validLen && posInPage >= p.validStart) {
                int newEnd = posInPage + lenInPage;
                int validEnd = p.validStart + p.validLen;
                if (newEnd > validEnd) {
                    p.validLen = newEnd - p.validStart;
                }
            } else {
                this.pr("Failed to handle non-contiguous write");
                break;
            }
            this.curPos_ += (long)lenInPage;
            length -= lenInPage;
            bufOffset += lenInPage;
            this.written_ += lenInPage;
            if (this.stats_ == null) continue;
            this.stats_.incrementBytesWritten((long)lenInPage);
            this.stats_.incrementWriteOps(1);
        }
    }

    @Override
    public synchronized void write(int v) throws IOException {
        this.checkClosed();
        if (this.curPage_ == null || this.outsideCurrentPage()) {
            this.dropCurrentPage();
            this.curPage_ = this.inode_.allocatePage(this.curPos_);
        }
        Page p = this.curPage_;
        int posInBuf = (int)(this.curPos_ % 8192L);
        if (p.validLen > 0 && (posInBuf > p.validStart + p.validLen || posInBuf < p.validStart)) {
            this.dropCurrentPage();
            p = this.curPage_ = this.inode_.allocatePage(this.curPos_);
        }
        p.bbuf.put(posInBuf, (byte)(v &= 0xFF));
        ++this.curPos_;
        if (p.validLen == 0) {
            p.validStart = posInBuf;
            p.validLen = 1;
        } else if (posInBuf <= p.validStart + p.validLen && posInBuf >= p.validStart) {
            int newEnd = posInBuf + 1;
            int validEnd = p.validStart + p.validLen;
            if (newEnd > validEnd) {
                p.validLen = newEnd - p.validStart;
            }
        } else {
            this.pr("Failed to handle non-contiguous write");
            return;
        }
        ++this.written_;
        if (this.stats_ != null) {
            this.stats_.incrementBytesWritten(1L);
            this.stats_.incrementWriteOps(1);
        }
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.inode_ != null) {
            this.dropCurrentPage();
            this.inode_.close(true);
            this.inode_ = null;
        }
    }

    @Override
    public void flush() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sync() throws IOException {
        Inode ino = null;
        long pos = 0L;
        MapRFsOutStream mapRFsOutStream = this;
        synchronized (mapRFsOutStream) {
            if (this.inode_ != null) {
                this.dropCurrentPage();
                ino = this.inode_;
                pos = this.getPos();
            }
        }
        if (ino != null) {
            ino.syncUpto(pos);
        }
    }

    boolean outsideCurrentPage() {
        long pageOff = this.curPage_.pageId << 13;
        return this.curPos_ < pageOff || this.curPos_ >= pageOff + 8192L;
    }

    public long getPos() {
        return this.curPos_;
    }

    public synchronized void seek(long pos) throws IOException {
        if (pos < 0L) {
            throw new IOException("Seeking before beginning, file: " + this.inode_.filename() + ", seeking to: " + pos);
        }
        if (this.curPage_ == null) {
            this.curPos_ = pos;
            return;
        }
        if (this.outsideCurrentPage()) {
            this.dropCurrentPage();
        }
        this.curPos_ = pos;
    }

    synchronized void seekToEof() throws IOException {
        this.seek(this.inode_.eof());
    }
}

