/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs;

import com.mapr.fs.proto.Common;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import org.apache.hadoop.io.WritableUtils;

public final class FidInfo {
    public int cid;
    public int cinum;
    public int uniq;
    public long[] ips = DEFAULT_IPS;
    public static final long[] DEFAULT_IPS = new long[0];
    String fidStr;

    public FidInfo() {
        this.uniq = -1;
        this.cinum = -1;
        this.cid = -1;
    }

    public FidInfo(Common.FidMsg fid) {
        this.cid = fid.getCid();
        this.cinum = fid.getCinum();
        this.uniq = fid.getUniq();
    }

    public FidInfo(int cid, int cinum, int uniq, long[] ips) {
        this.cid = cid;
        this.cinum = cinum;
        this.uniq = uniq;
        this.ips = (long[])ips.clone();
    }

    public void writeFields(DataOutput out) throws IOException {
        WritableUtils.writeVInt((DataOutput)out, (int)this.cid);
        WritableUtils.writeVInt((DataOutput)out, (int)this.cinum);
        WritableUtils.writeVInt((DataOutput)out, (int)this.uniq);
        WritableUtils.writeVInt((DataOutput)out, (int)this.ips.length);
        for (long l : this.ips) {
            WritableUtils.writeVLong((DataOutput)out, (long)l);
        }
    }

    public void readFields(DataInput in) throws IOException {
        this.cid = WritableUtils.readVInt((DataInput)in);
        this.cinum = WritableUtils.readVInt((DataInput)in);
        this.uniq = WritableUtils.readVInt((DataInput)in);
        this.ips = new long[WritableUtils.readVInt((DataInput)in)];
        for (int i = 0; i < this.ips.length; ++i) {
            this.ips[i] = WritableUtils.readVLong((DataInput)in);
        }
    }

    public boolean equals(Object other) {
        if (!(other instanceof FidInfo)) {
            return false;
        }
        FidInfo otherFileId = (FidInfo)other;
        return otherFileId.cid == this.cid && otherFileId.cinum == this.cinum && otherFileId.uniq == this.uniq && Arrays.equals(otherFileId.ips, this.ips);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.cid;
        result = 31 * result + this.cinum;
        result = 31 * result + this.uniq;
        for (long ip : this.ips) {
            result = 31 * result + Long.hashCode(ip);
        }
        return result;
    }

    public String toString() {
        return this.getClass() + "[ fid: " + this.cid + "." + this.cinum + "." + this.uniq + ", ipaddrs: " + Arrays.toString(this.ips) + " ]";
    }

    public String getFidStr() {
        if (this.fidStr == null) {
            this.fidStr = this.cid + "." + this.cinum + "." + this.uniq;
        }
        return this.fidStr;
    }

    public Common.FidMsg getFidMsg() {
        return Common.FidMsg.newBuilder().setCid(this.cid).setCinum(this.cinum).setUniq(this.uniq).build();
    }
}

