/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.mapr.fs.RetryException;
import com.mapr.fs.ServiceWatcher;
import com.mapr.fs.beans.QueryServiceParam;
import com.mapr.org.apache.hadoop.hbase.util.Bytes;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.ACL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryServiceWatcher
extends ServiceWatcher {
    private static Logger logger = LoggerFactory.getLogger(QueryServiceWatcher.class);
    private static final String QUERY_SERVICE_BASE_PATH = "/queryservice";
    private static final String QUERY_SERVICE_CONNECTION_PATH = "/queryservice/connection";
    private static final String QUERY_SERVICE_ENABLED_PATH = "/queryservice/enabled";
    private QueryServiceParam queryServiceParam = null;
    private static final List<ACL> NODE_ACLS = new ImmutableList.Builder().addAll((Iterable)ZooDefs.Ids.CREATOR_ALL_ACL).addAll((Iterable)ZooDefs.Ids.READ_ACL_UNSAFE).build();

    public QueryServiceWatcher(String zkConnectString, String clusterName) {
        super(zkConnectString, clusterName);
    }

    public void clearQueryServiceParam() throws KeeperException, IOException, InterruptedException {
        this.recursiveDelete(QUERY_SERVICE_BASE_PATH);
    }

    public void setQueryServiceParam(QueryServiceParam qsp) throws KeeperException, IOException, InterruptedException {
        this.recursiveDelete(QUERY_SERVICE_BASE_PATH);
        this.createNode(QUERY_SERVICE_BASE_PATH, null);
        this.createNode(QUERY_SERVICE_CONNECTION_PATH, null);
        for (Map.Entry<String, String> param : qsp.getConnectionParams().entrySet()) {
            String key = param.getKey();
            this.createNode("/queryservice/connection/" + key, Bytes.toBytes((String)param.getValue()));
        }
        this.createNode(QUERY_SERVICE_ENABLED_PATH, Bytes.toBytes((String)String.valueOf(qsp.isEnabled())));
    }

    private String createNode(String path, byte[] data) throws RetryException, IOException, InterruptedException, KeeperException {
        return this.create(path, data, NODE_ACLS, CreateMode.PERSISTENT);
    }

    private void recursiveDelete(String nodePath) throws RetryException, IOException, InterruptedException, KeeperException {
        try {
            List<String> children = this.getChildren(nodePath);
            for (String child : children) {
                this.recursiveDelete(nodePath + "/" + child);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        try {
            this.delete(nodePath);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    public QueryServiceParam getQueryServiceParam() throws KeeperException, IOException, InterruptedException {
        int attempts = 0;
        while (true) {
            try {
                HashMap params = Maps.newHashMap();
                List<String> children = this.getChildren(QUERY_SERVICE_CONNECTION_PATH);
                for (String key : children) {
                    params.put(key, Bytes.toString((byte[])this.getData("/queryservice/connection/" + key)));
                }
                String enabledStr = Bytes.toString((byte[])this.getData(QUERY_SERVICE_ENABLED_PATH));
                this.queryServiceParam = new QueryServiceParam(Boolean.valueOf(enabledStr), this.getZKString(), params);
                return this.queryServiceParam;
            }
            catch (RetryException params) {
                logger.info("Retrying to connect ZooKeeper Attempt# {}. Current ZooKeeper Server: {}", (Object)attempts, (Object)this.getZKString());
                long sleepMs = ++attempts * 2 > 30 ? 30000L : (long)(attempts * 2 * 1000);
                Thread.sleep(sleepMs);
                continue;
            }
            break;
        }
    }
}

