/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs;

import com.mapr.baseutils.utils.AceHelper;
import com.mapr.fs.proto.Common;
import java.io.IOException;

public class MapRFileAce {
    private AccessType atype;
    private String bExpr;

    public MapRFileAce(AccessType type) {
        this.atype = type;
        this.bExpr = null;
    }

    public void setBooleanExpression(String bExprIn) throws IOException {
        AceHelper.toPostfix((String)bExprIn);
        this.bExpr = new String(bExprIn);
    }

    public static boolean IsBooleanExpressionValid(String bExprIn) {
        try {
            AceHelper.toPostfix((String)bExprIn);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public AccessType getAccessType() {
        return this.atype;
    }

    public String getBooleanExpression() {
        return this.bExpr;
    }

    public static enum AccessType {
        READFILE(Common.FSAccessType.AceRead),
        WRITEFILE(Common.FSAccessType.AceWrite),
        EXECUTEFILE(Common.FSAccessType.AceExecute),
        READDIR(Common.FSAccessType.AceReadDir),
        ADDCHILD(Common.FSAccessType.AceAddChild),
        DELETECHILD(Common.FSAccessType.AceDeleteChild),
        LOOKUPDIR(Common.FSAccessType.AceLookupDir);

        private final Common.FSAccessType aType;

        private AccessType(Common.FSAccessType aType) {
            this.aType = aType;
        }

        public Common.FSAccessType getValue() {
            return this.aType;
        }
    }
}

