/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs;

import com.google.protobuf.ByteString;
import com.mapr.fs.Inode;
import com.mapr.fs.MapRFileSystem;
import com.mapr.fs.MapRResultScanner;
import com.mapr.fs.MapRTabletScanner;
import com.mapr.fs.ShimLoader;
import com.mapr.fs.StaleFileException;
import com.mapr.fs.jni.IOExceptionWithErrorCode;
import com.mapr.fs.jni.MapRConstants;
import com.mapr.fs.jni.MapRGet;
import com.mapr.fs.jni.MapRIncrement;
import com.mapr.fs.jni.MapRJSONPut;
import com.mapr.fs.jni.MapRPut;
import com.mapr.fs.jni.MapRResult;
import com.mapr.fs.jni.MapRRowConstraint;
import com.mapr.fs.jni.MapRScan;
import com.mapr.fs.jni.MapRUpdateAndGet;
import com.mapr.fs.proto.Dbfilters;
import com.mapr.fs.proto.Dbserver;
import com.mapr.fs.tables.TableProperties;
import com.mapr.org.apache.hadoop.hbase.util.Bytes;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;

public class MapRHTable
implements Closeable,
MapRConstants {
    private static final Log LOG = LogFactory.getLog(MapRHTable.class);
    private static final TableProperties EMPTY_INDEX_TABLE_PROPERTIES = new TableProperties(Dbserver.TableAttr.newBuilder().setJson(true).build(), Dbserver.TableAces.newBuilder().build(), null, false);
    private MapRFileSystem maprfs_;
    private boolean closeMfs_;
    private Configuration conf_;
    private byte[] tableNameInBytes_;
    private Path tablePath_;
    private String clusterName_;
    private volatile Inode inode_;
    private boolean closed_ = false;
    private boolean closeCalled_ = false;
    private LinkedList<MapRResultScanner> allScanners_ = new LinkedList();
    private String indexFid = null;
    private volatile long schemaVersion_;
    private Dbserver.ColumnFamilyScanResponse cfSchema_;
    private Object cfSchemaLock_ = new Object();
    private Map<Integer, Dbserver.SchemaFamily> idToSchemaMap_ = new HashMap<Integer, Dbserver.SchemaFamily>();
    private Map<String, Dbserver.SchemaFamily> nameToSchemaMap_ = new HashMap<String, Dbserver.SchemaFamily>();
    int maxReopenAttempt_;
    int sleepMsOnReopenFailure_;
    boolean useUpdateAndGet_ = true;
    int numCheckAndPut_ = 0;

    public static boolean unsignedLessThan(long a, long b) {
        return MapRHTable.flip(a) < MapRHTable.flip(b);
    }

    public static long flip(long a) {
        return a ^ Long.MIN_VALUE;
    }

    public MapRHTable() {
        this.maprfs_ = null;
    }

    public MapRHTable(MapRFileSystem injectedMfs) {
        this.maprfs_ = injectedMfs;
    }

    public synchronized void init(Configuration conf, Path tablePath) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Init table " + tablePath));
        }
        this.preOpen(conf, tablePath);
        this.inode_ = this.maprfs_.openTable(tablePath, this);
        this.postOpen(this.maprfs_.getTableProperties(tablePath));
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Opened table " + tablePath + " clustername " + this.clusterName_ + "isJson " + this.isJson()));
        }
    }

    public synchronized void init(Configuration conf, Path priTablePath, String indexName, String indexFid) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Init index " + indexName + " of " + priTablePath));
        }
        this.indexFid = indexFid;
        this.preOpen(conf, priTablePath);
        this.inode_ = this.maprfs_.openTableWithFid(priTablePath, indexFid, this);
        this.postOpen(EMPTY_INDEX_TABLE_PROPERTIES);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Opened index " + indexName + " clustername " + this.clusterName_));
        }
    }

    private void preOpen(Configuration conf, Path tablePath) throws IOException {
        this.tablePath_ = tablePath;
        this.tableNameInBytes_ = Bytes.toBytes((String)tablePath.getName());
        this.conf_ = conf;
        this.maxReopenAttempt_ = conf.getInt("fs.mapr.table.max.reopen.attempt", 2);
        this.sleepMsOnReopenFailure_ = conf.getInt("fs.mapr.table.reopen.failure.sleep", 1000);
        if (this.maprfs_ == null) {
            this.closeMfs_ = true;
            this.maprfs_ = new MapRFileSystem();
            this.maprfs_.initialize(tablePath.toUri(), conf);
        } else {
            this.closeMfs_ = false;
        }
        this.closed_ = false;
        this.closeCalled_ = false;
        this.clusterName_ = this.maprfs_.getClusterName(tablePath.toUri());
    }

    private void postOpen(TableProperties props) throws IOException {
        this.refreshSchema();
        this.inode_.setTableProperties(props);
    }

    public void put(MapRPut mput) throws IOException {
        this.put(new MapRPut[]{mput});
    }

    public void put(MapRPut[] mputs) throws IOException {
        while (true) {
            try {
                this.inode_.put(mputs);
            }
            catch (StaleFileException e) {
                this.reopenTable(e);
                continue;
            }
            break;
        }
    }

    public void syncPut(MapRPut mput) throws IOException {
        this.syncPut(mput, true);
    }

    public void syncPut(MapRPut[] mputs) throws IOException {
        this.syncPut(mputs, true);
    }

    public void syncPut(MapRPut mput, boolean shouldBlock) throws IOException {
        this.syncPut(new MapRPut[]{mput}, shouldBlock);
    }

    public void syncPut(MapRPut[] mputs, boolean shouldBlock) throws IOException {
        while (true) {
            try {
                this.inode_.syncPut(mputs, shouldBlock, false);
            }
            catch (StaleFileException e) {
                this.reopenTable(e);
                continue;
            }
            break;
        }
    }

    public void syncPut(MapRPut[] mputs, boolean shouldBlock, boolean rowMut) throws IOException {
        while (true) {
            try {
                this.inode_.syncPut(mputs, shouldBlock, rowMut);
            }
            catch (StaleFileException e) {
                this.reopenTable(e);
                continue;
            }
            break;
        }
    }

    public long getBulkLoader(byte[] tableUuid) throws IOException {
        while (true) {
            try {
                return this.inode_.getBulkLoader(tableUuid);
            }
            catch (StaleFileException e) {
                this.reopenTable(e);
                continue;
            }
            break;
        }
    }

    public void bulkLoaderClose(long bulkLoaderId) throws IOException {
        while (true) {
            try {
                this.inode_.bulkLoaderClose(bulkLoaderId);
            }
            catch (StaleFileException e) {
                this.reopenTable(e);
                continue;
            }
            break;
        }
    }

    public void bulkLoaderAppend(long bulkLoaderId, MapRPut mput) throws IOException {
        this.bulkLoaderAppend(bulkLoaderId, new MapRPut[]{mput});
    }

    public void bulkLoaderAppend(long bulkLoaderId, MapRPut[] mput) throws IOException {
        while (true) {
            try {
                this.inode_.bulkLoaderAppend(bulkLoaderId, mput);
            }
            catch (StaleFileException e) {
                this.reopenTable(e);
                continue;
            }
            break;
        }
    }

    public void bulkLoaderAppendEncoded(long bulkLoaderId, MapRJSONPut mput) throws IOException {
        while (true) {
            try {
                this.inode_.bulkLoaderAppendEncoded(bulkLoaderId, new MapRJSONPut[]{mput});
            }
            catch (StaleFileException e) {
                this.reopenTable(e);
                continue;
            }
            break;
        }
    }

    public void bulkLoaderAppendEncoded(long bulkLoaderId, MapRJSONPut[] mput) throws IOException {
        while (true) {
            try {
                this.inode_.bulkLoaderAppendEncoded(bulkLoaderId, mput);
            }
            catch (StaleFileException e) {
                this.reopenTable(e);
                continue;
            }
            break;
        }
    }

    public byte[] getName() {
        return this.tableNameInBytes_;
    }

    public Path getTablePath() {
        return this.tablePath_;
    }

    private void closeMFS(MapRFileSystem mfs) throws IOException {
        if (this.closeMfs_) {
            mfs.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        MapRFileSystem mfsObj = null;
        MapRHTable mapRHTable = this;
        synchronized (mapRHTable) {
            if (!this.closeCalled_) {
                this.closeCalled_ = true;
                this.tryClose(true, false);
                if (this.closed_) {
                    mfsObj = this.maprfs_;
                    this.maprfs_ = null;
                }
            }
        }
        if (mfsObj != null) {
            this.closeMFS(mfsObj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeNoFlush() throws IOException {
        MapRFileSystem mfsObj = null;
        MapRHTable mapRHTable = this;
        synchronized (mapRHTable) {
            if (!this.closeCalled_) {
                this.closeCalled_ = true;
                this.tryClose(false, false);
                if (this.closed_) {
                    mfsObj = this.maprfs_;
                    this.maprfs_ = null;
                }
            }
        }
        if (mfsObj != null) {
            this.closeMFS(mfsObj);
        }
    }

    public void tryClose(boolean doFlush) throws IOException {
        this.tryClose(doFlush, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tryClose(boolean doFlush, boolean closeMFS) throws IOException {
        MapRFileSystem mfsObj = null;
        MapRHTable mapRHTable = this;
        synchronized (mapRHTable) {
            if (this.closeCalled_ && this.allScanners_.isEmpty() && !this.closed_) {
                this.allScanners_.clear();
                this.idToSchemaMap_.clear();
                this.nameToSchemaMap_.clear();
                this.schemaVersion_ = 0L;
                this.inode_.removeFromTables();
                this.inode_.close(doFlush);
                if (closeMFS) {
                    mfsObj = this.maprfs_;
                    this.maprfs_ = null;
                }
                this.closed_ = true;
                LOG.debug((Object)("Closing the table " + this.tablePath_));
            }
        }
        if (mfsObj != null) {
            this.closeMFS(mfsObj);
        }
    }

    public long lastUpdateTime() {
        return this.inode_.lastUpdateTime();
    }

    public void flushCommits() throws IOException {
        while (true) {
            try {
                this.inode_.flushPuts();
            }
            catch (StaleFileException e) {
                this.reopenTable(e);
                continue;
            }
            break;
        }
    }

    public void getJson(MapRGet mget) throws IOException {
        MapRGet[] mgets = new MapRGet[]{mget};
        this.getJson(mgets);
    }

    public void getJson(MapRGet[] mgets) throws IOException {
        while (true) {
            try {
                this.inode_.get(mgets, true);
            }
            catch (StaleFileException e) {
                this.reopenTable(e);
                continue;
            }
            break;
        }
    }

    public void getMultiTabletJson(MapRGet[] mgets) throws IOException {
        while (true) {
            try {
                this.inode_.multiTabletGet(mgets, true);
            }
            catch (StaleFileException e) {
                this.reopenTable(e);
                continue;
            }
            break;
        }
    }

    public MapRResult get(MapRGet mget) throws IOException {
        return this.get(mget, true);
    }

    public MapRResult[] get(MapRGet[] mgets) throws IOException {
        return this.get(mgets, true);
    }

    public MapRResult get(MapRGet mget, boolean shouldFlush) throws IOException {
        MapRGet[] mgets = new MapRGet[]{mget};
        while (true) {
            try {
                this.inode_.get(mgets, shouldFlush);
                return mgets[0].getResult();
            }
            catch (StaleFileException e) {
                this.reopenTable(e);
                continue;
            }
            break;
        }
    }

    public MapRResult[] get(MapRGet[] mgets, boolean shouldFlush) throws IOException {
        while (true) {
            try {
                this.inode_.get(mgets, shouldFlush);
            }
            catch (StaleFileException e) {
                this.reopenTable(e);
                continue;
            }
            break;
        }
        MapRResult[] results = new MapRResult[mgets.length];
        int i = 0;
        for (MapRGet mget : mgets) {
            results[i++] = mget.getResult();
        }
        return results;
    }

    public void freeArena(long arenaAddr) {
        this.inode_.freeArena(arenaAddr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addScanner(MapRResultScanner scanner) {
        LinkedList<MapRResultScanner> linkedList = this.allScanners_;
        synchronized (linkedList) {
            this.allScanners_.addLast(scanner);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeScanner(MapRResultScanner scanner) {
        LinkedList<MapRResultScanner> linkedList = this.allScanners_;
        synchronized (linkedList) {
            this.allScanners_.remove(scanner);
        }
    }

    public void increment(MapRIncrement incr) throws IOException {
        this.increment(incr, true);
    }

    public void increment(MapRIncrement incr, boolean shouldFlush) throws IOException {
        while (true) {
            try {
                this.inode_.increment(incr, shouldFlush);
            }
            catch (StaleFileException e) {
                this.reopenTable(e);
                continue;
            }
            break;
        }
    }

    public boolean checkAndPut(byte[] row, boolean useCf, int familyId, byte[] qualifier, byte[] value, MapRPut mput) throws IOException {
        return this.checkAndPut(row, useCf, familyId, qualifier, value, mput, true);
    }

    public boolean checkAndPut(byte[] row, boolean useCf, int familyId, byte[] qualifier, byte[] value, MapRPut mput, boolean shouldFlush) throws IOException {
        while (true) {
            try {
                return this.asyncToCheckAndMutate(row, useCf, familyId, qualifier, value, mput, shouldFlush);
            }
            catch (StaleFileException e) {
                this.reopenTable(e);
                continue;
            }
            break;
        }
    }

    public void delete(MapRPut mput) throws IOException {
        while (true) {
            try {
                this.inode_.delete(new MapRPut[]{mput});
            }
            catch (StaleFileException e) {
                this.reopenTable(e);
                continue;
            }
            break;
        }
    }

    public void delete(MapRPut[] mputs) throws IOException {
        while (true) {
            try {
                this.inode_.delete(mputs);
            }
            catch (StaleFileException e) {
                this.reopenTable(e);
                continue;
            }
            break;
        }
    }

    public void asyncDelete(MapRPut mput) throws IOException {
        while (true) {
            try {
                this.inode_.asyncDelete(new MapRPut[]{mput});
            }
            catch (StaleFileException e) {
                this.reopenTable(e);
                continue;
            }
            break;
        }
    }

    public void asyncDelete(MapRPut[] mputs) throws IOException {
        while (true) {
            try {
                this.inode_.asyncDelete(mputs);
            }
            catch (StaleFileException e) {
                this.reopenTable(e);
                continue;
            }
            break;
        }
    }

    public boolean checkAndDelete(byte[] row, boolean useCf, int familyId, byte[] qualifier, byte[] value, MapRPut mput) throws IOException {
        return this.checkAndDelete(row, useCf, familyId, qualifier, value, mput, true);
    }

    public boolean checkAndDelete(byte[] row, boolean useCf, int familyId, byte[] qualifier, byte[] value, MapRPut mput, boolean shouldFlush) throws IOException {
        return this.asyncToCheckAndMutate(row, useCf, familyId, qualifier, value, mput, shouldFlush);
    }

    public boolean checkUseUpdateAndGet() {
        if (this.useUpdateAndGet_) {
            return true;
        }
        ++this.numCheckAndPut_;
        if (this.numCheckAndPut_ > 8192) {
            this.useUpdateAndGet_ = true;
            this.numCheckAndPut_ = 0;
        }
        return this.useUpdateAndGet_;
    }

    public boolean checkAndMutate(byte[] row, boolean useCf, boolean checkForNonExist, MapRRowConstraint checkConstraint, Dbfilters.FilterMsg filterMsg, MapRPut[] mputs, boolean shouldFlush) throws IOException {
        while (this.checkUseUpdateAndGet()) {
            try {
                return this.inode_.checkAndMutate(row, useCf, checkForNonExist, checkConstraint, filterMsg, mputs, shouldFlush);
            }
            catch (StaleFileException e) {
                this.reopenTable(e);
                continue;
            }
            catch (IOExceptionWithErrorCode e) {
                if (e.getErrorCode() == 38) {
                    this.useUpdateAndGet_ = false;
                    continue;
                }
                throw new IOException(e);
            }
            break;
        }
        return this.checkAndMutateToCheckAndPut(row, useCf, checkForNonExist, checkConstraint, filterMsg, mputs, shouldFlush);
    }

    public boolean checkAndMutateToCheckAndPut(byte[] row, boolean useCf, boolean checkForNonExist, MapRRowConstraint checkConstraint, Dbfilters.FilterMsg filterMsg, MapRPut[] mputs, boolean shouldFlush) throws IOException {
        if (mputs.length > 1) {
            throw new IllegalArgumentException("Num of put/deletes in checkandmutate should be 1, however it is " + mputs.length + "), cannot turn it into checkandput call");
        }
        if (checkConstraint.numFamilies != 1) {
            throw new IllegalArgumentException("Num of families in checkConstraint should be 1, however it is " + checkConstraint.numFamilies);
        }
        int familyId = checkConstraint.families[0];
        if (checkConstraint.numColumns != 1) {
            throw new IllegalArgumentException("Num of columns in checkConstraint should be 1, however it is " + checkConstraint.numColumns);
        }
        byte[] qualifier = checkConstraint.columns[0];
        ByteString stateFilterMsg = filterMsg.getSerializedState();
        Dbfilters.SingleColumnValueFilterProto scvfProt = Dbfilters.SingleColumnValueFilterProto.parseFrom((ByteString)stateFilterMsg);
        Dbfilters.FilterComparatorProto filterComparatorProt = scvfProt.getFilterComparator();
        Dbfilters.CompareOpProto compareOpProt = filterComparatorProt.getCompareOp();
        if (compareOpProt != Dbfilters.CompareOpProto.EQUAL) {
            throw new IOException("CompareOp(" + compareOpProt + ") is not EQUAL(" + Dbfilters.CompareOpProto.EQUAL + "), cannot turn it into checkandput call");
        }
        Dbfilters.ComparatorProto comparatorProt = filterComparatorProt.getComparator();
        ByteString stateComparator = comparatorProt.getSerializedComparator();
        Dbfilters.BinaryComparatorProto binaryComparator = Dbfilters.BinaryComparatorProto.parseFrom((ByteString)stateComparator);
        ByteString value = binaryComparator.getComparable();
        while (true) {
            try {
                return this.inode_.checkAndPut(row, useCf, familyId, qualifier, value.toByteArray(), mputs[0], shouldFlush);
            }
            catch (StaleFileException e) {
                this.reopenTable(e);
                continue;
            }
            break;
        }
    }

    public boolean asyncToCheckAndMutate(byte[] row, boolean useCf, int familyId, byte[] qualifier, byte[] value, MapRPut mput, boolean shouldFlush) throws IOException {
        if (qualifier == null) {
            throw new IllegalArgumentException("Missing qualifier");
        }
        if (qualifier.length == 0) {
            throw new IllegalArgumentException("Empty qualifier");
        }
        MapRPut[] mputs = new MapRPut[]{mput};
        MapRRowConstraint checkConstraint = new MapRRowConstraint();
        checkConstraint.numFamilies = 1;
        checkConstraint.families = new int[checkConstraint.numFamilies];
        checkConstraint.columnsPerFamily = new int[checkConstraint.numFamilies];
        checkConstraint.families[0] = familyId;
        checkConstraint.numColumns = 1;
        checkConstraint.columns = new byte[checkConstraint.numColumns][];
        checkConstraint.columns[0] = qualifier;
        checkConstraint.columnsPerFamily[0] = 1;
        checkConstraint.minStamp = -9223372036854775807L;
        checkConstraint.maxStamp = Long.MAX_VALUE;
        checkConstraint.maxVersions = 1;
        Dbfilters.FilterMsg filterMsg = null;
        boolean checkForNonExist = true;
        if (value.length > 0) {
            checkForNonExist = false;
            String nameComparator = String.format("%08x", 99850341);
            ByteString stateComparator = Dbfilters.BinaryComparatorProto.newBuilder().setComparable(ByteString.copyFrom((byte[])value)).build().toByteString();
            Dbfilters.ComparatorProto comparatorProt = Dbfilters.ComparatorProto.newBuilder().setName(nameComparator).setSerializedComparator(stateComparator).build();
            Dbfilters.FilterComparatorProto filterComparatorProt = Dbfilters.FilterComparatorProto.newBuilder().setCompareOp(Dbfilters.CompareOpProto.EQUAL).setComparator(comparatorProt).build();
            ByteString stateFilterMsg = Dbfilters.SingleColumnValueFilterProto.newBuilder().setColumnFamily(ByteString.copyFrom((byte[])this.getFamilyName(familyId).getBytes())).setColumnQualifier(ByteString.copyFrom((byte[])qualifier)).setFilterComparator(filterComparatorProt).setFilterIfMissing(false).setLatestVersionOnly(false).build().toByteString();
            String idFilter = String.format("%08x", 1032050493);
            filterMsg = Dbfilters.FilterMsg.newBuilder().setId(idFilter).setSerializedState(stateFilterMsg).build();
        }
        return this.checkAndMutate(row, useCf, checkForNonExist, checkConstraint, filterMsg, mputs, shouldFlush);
    }

    public void append(MapRPut mput, boolean needResult) throws IOException {
        this.append(mput, needResult, true);
    }

    public void append(MapRPut mput) throws IOException {
        this.append(mput, true, true);
    }

    public void append(MapRPut mput, boolean needResult, boolean shouldFlush) throws IOException {
        while (true) {
            try {
                this.inode_.append(mput, needResult, shouldFlush);
            }
            catch (StaleFileException e) {
                this.reopenTable(e);
                continue;
            }
            break;
        }
    }

    private synchronized void reopenTable(StaleFileException originalException) throws IOException {
        Inode currInode = this.inode_;
        if (currInode.isStale()) {
            if (this.maxReopenAttempt_ == 0) {
                throw originalException.noRetry();
            }
            HashSet<String> families = new HashSet<String>(this.nameToSchemaMap_.keySet());
            int i = 0;
            while (true) {
                try {
                    this.inode_ = this.indexFid == null ? this.maprfs_.openTable(this.tablePath_, this) : this.maprfs_.openTableWithFid(this.tablePath_, this.indexFid, this);
                    if (this.inode_.attrs().eq(currInode.attrs())) {
                        LOG.warn((Object)("Attept to reopen table returned the same inode: " + this.inode_.attrs()));
                        currInode.close(true);
                        if (this.indexFid == null) {
                            this.inode_.setTableProperties(this.maprfs_.getTableProperties(this.tablePath_));
                        } else {
                            this.inode_.setTableProperties(new TableProperties(Dbserver.TableAttr.newBuilder().setJson(true).build(), Dbserver.TableAces.newBuilder().build(), null, false));
                        }
                        throw originalException.noRetry();
                    }
                    block5: for (String family : families) {
                        int j = 0;
                        while (true) {
                            try {
                                this.inode_.getFamilyId(family);
                                continue block5;
                            }
                            catch (IOException e) {
                                this.handleReopenException(j, originalException.noRetry());
                                ++j;
                                continue;
                            }
                            break;
                        }
                    }
                    this.refreshSchema();
                    if (this.indexFid == null) {
                        this.inode_.setTableProperties(this.maprfs_.getTableProperties(this.tablePath_));
                    } else {
                        this.inode_.setTableProperties(new TableProperties(Dbserver.TableAttr.newBuilder().setJson(true).build(), Dbserver.TableAces.newBuilder().build(), null, false));
                    }
                    currInode.close(true);
                    return;
                }
                catch (IOException e) {
                    if (e == originalException) {
                        throw originalException.noRetry();
                    }
                    this.handleReopenException(i, originalException);
                    ++i;
                    continue;
                }
                break;
            }
        }
    }

    private void handleReopenException(int retryAttempt, StaleFileException e) throws IOException {
        if (retryAttempt < this.maxReopenAttempt_) {
            try {
                Thread.sleep(this.sleepMsOnReopenFailure_);
            }
            catch (InterruptedException e1) {
                throw new IOException("Interrupted while sleeping", e1);
            }
        } else {
            throw e.noRetry();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void refreshSchema() throws IOException {
        Dbserver.ColumnFamilyScanResponse scanResp;
        byte[] newSchema = this.inode_.getSchema(this.schemaVersion_);
        if (newSchema != null && MapRHTable.unsignedLessThan(this.schemaVersion_, (scanResp = Dbserver.ColumnFamilyScanResponse.parseFrom((byte[])newSchema)).getVersion())) {
            Object object = this.cfSchemaLock_;
            synchronized (object) {
                if (MapRHTable.unsignedLessThan(this.schemaVersion_, scanResp.getVersion())) {
                    this.idToSchemaMap_.clear();
                    this.nameToSchemaMap_.clear();
                    this.cfSchema_ = scanResp;
                    int families = scanResp.getCfAttrListCount();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Updating schema #families " + families));
                    }
                    for (int i = 0; i < families; ++i) {
                        Dbserver.SchemaFamily sf = this.cfSchema_.getCfAttrList(i).getSchFamily();
                        this.idToSchemaMap_.put(sf.getId(), sf);
                        this.nameToSchemaMap_.put(sf.getName(), sf);
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug((Object)("Caching family name=" + sf.getName() + ", id=" + sf.getId()));
                    }
                    this.schemaVersion_ = scanResp.getVersion();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFamilyName(int id) throws IOException {
        Dbserver.SchemaFamily sf;
        Object object = this.cfSchemaLock_;
        synchronized (object) {
            sf = this.idToSchemaMap_.get(id);
        }
        if (sf != null) {
            return sf.getName();
        }
        String fname = null;
        while (true) {
            try {
                fname = this.inode_.getFamilyName(id);
                this.refreshSchema();
                return fname;
            }
            catch (StaleFileException e) {
                this.reopenTable(e);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFamilyId(String name) throws IOException {
        Dbserver.SchemaFamily sf;
        Object object = this.cfSchemaLock_;
        synchronized (object) {
            sf = this.nameToSchemaMap_.get(name);
        }
        if (sf != null) {
            return sf.getId();
        }
        int id = 0;
        while (true) {
            try {
                id = this.inode_.getFamilyId(name);
                this.refreshSchema();
                return id;
            }
            catch (StaleFileException e) {
                this.reopenTable(e);
                continue;
            }
            break;
        }
    }

    public long getAverageRowSize() throws IOException {
        Dbserver.TableBasicStats basicStats = this.maprfs_.getTableStats(this.tablePath_, this.indexFid);
        long numRows = basicStats.getNumRows();
        long size = basicStats.getSize();
        long averageRowSize = numRows != 0L ? size / numRows : 0L;
        return averageRowSize;
    }

    public Dbserver.TableBasicStats getScanRangeStats(byte[] stKey, byte[] endKey) throws IOException {
        return this.maprfs_.getScanRangeStats(this.tablePath_, this.indexFid, stKey, endKey);
    }

    public MapRTabletScanner getTabletScanner(byte[] row) throws IOException {
        return this.maprfs_.getTabletScanner(this.tablePath_, this.indexFid, row);
    }

    public MapRTabletScanner getTabletScanner() throws IOException {
        return this.getTabletScanner(false, false);
    }

    public MapRTabletScanner getTabletScanner(boolean needSpaceUsage, boolean prefetchTabletMap) throws IOException {
        return this.maprfs_.getTabletScanner(this.tablePath_, this.indexFid, needSpaceUsage, prefetchTabletMap);
    }

    public MapRTabletScanner getTabletScanner(byte[] startKey, byte[] endKey, boolean spaceUsage, boolean prefetchTabletMap) throws IOException {
        return this.maprfs_.getTabletScanner(this.tablePath_, this.indexFid, startKey, endKey, spaceUsage, prefetchTabletMap);
    }

    public String getServerForCid(int cid) throws IOException {
        return this.maprfs_.getServerForCid(cid, this.clusterName_);
    }

    public void asyncFlush() throws IOException {
        while (true) {
            try {
                this.inode_.flushPuts();
            }
            catch (StaleFileException e) {
                this.reopenTable(e);
                continue;
            }
            break;
        }
    }

    public long getScanner(MapRScan scan) throws IOException {
        while (true) {
            try {
                return this.inode_.getScanner(scan);
            }
            catch (StaleFileException e) {
                this.reopenTable(e);
                continue;
            }
            break;
        }
    }

    public void scanNext(long scannerId, int nbRows, MapRResult[] res) throws IOException {
        try {
            this.inode_.scanNext(scannerId, nbRows, res);
        }
        catch (StaleFileException e) {
            this.reopenTable(e);
            throw e;
        }
    }

    public void closeScanner(long scannerId) throws IOException {
        while (true) {
            try {
                this.inode_.closeScanner(scannerId);
            }
            catch (StaleFileException e) {
                this.reopenTable(e);
                continue;
            }
            break;
        }
    }

    public MapRFileSystem getMapRFS() {
        return this.maprfs_;
    }

    public Inode getInode() {
        return this.inode_;
    }

    public Configuration getConf() {
        return this.conf_;
    }

    public boolean isJson() throws IOException {
        return this.getInode().isJson();
    }

    public void checkAndReplaceOrDelete(ByteBuffer key, ByteBuffer[] serRecords, int[] recordFamilyIds, byte[] serReadConstraint, ByteBuffer condition, boolean shouldFlush, boolean isDelete, MapRUpdateAndGet muag) throws IOException {
        while (true) {
            try {
                this.inode_.checkAndReplaceOrDelete(key, serRecords, recordFamilyIds, serReadConstraint, condition, shouldFlush, isDelete, muag);
            }
            catch (StaleFileException e) {
                this.reopenTable(e);
                continue;
            }
            break;
        }
    }

    public void checkAndMutate(ByteBuffer key, ByteBuffer[] serRecordMutations, int[] mutationsFamilyIds, byte[] serReadConstraint, ByteBuffer serCondition, boolean shouldFlush, MapRUpdateAndGet muag) throws IOException {
        while (true) {
            try {
                this.inode_.checkAndMutate(key, serRecordMutations, mutationsFamilyIds, serReadConstraint, serCondition, shouldFlush, muag);
            }
            catch (StaleFileException e) {
                this.reopenTable(e);
                continue;
            }
            break;
        }
    }

    public void updateRecord(ByteBuffer key, ByteBuffer[] serRecordMutations, int[] mutationsFamilyIds, byte[] serReadConstraint, boolean shouldFlush, MapRUpdateAndGet muag) throws IOException {
        while (true) {
            try {
                this.inode_.updateRecord(key, serRecordMutations, mutationsFamilyIds, serReadConstraint, shouldFlush, muag);
            }
            catch (StaleFileException e) {
                this.reopenTable(e);
                continue;
            }
            break;
        }
    }

    public Integer getSecurityPolicyID(String policyName) throws IOException {
        return this.maprfs_.getSecurityPolicyId(policyName);
    }

    public String getSecurityPolicyName(Integer policyID) throws IOException {
        return this.maprfs_.getSecurityPolicyName(policyID);
    }

    static {
        ShimLoader.load();
    }
}

