/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.org.apache.hadoop.metrics.util;

import com.mapr.org.apache.hadoop.classification.InterfaceAudience;
import com.mapr.org.apache.hadoop.metrics.MetricsRecord;
import com.mapr.org.apache.hadoop.metrics.util.MetricsBase;
import com.mapr.org.apache.hadoop.metrics.util.MetricsRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce"})
public class MetricsTimeVaryingInt
extends MetricsBase {
    private static final Logger LOG = LoggerFactory.getLogger(MetricsTimeVaryingInt.class);
    private int currentValue = 0;
    private int previousIntervalValue = 0;

    public MetricsTimeVaryingInt(String nam, MetricsRegistry registry, String description) {
        super(nam, description);
        registry.add(nam, this);
    }

    public MetricsTimeVaryingInt(String nam, MetricsRegistry registry) {
        this(nam, registry, "NoDescription");
    }

    public synchronized void inc(int incr) {
        this.currentValue += incr;
    }

    public synchronized void inc() {
        ++this.currentValue;
    }

    private synchronized void intervalHeartBeat() {
        this.previousIntervalValue = this.currentValue;
        this.currentValue = 0;
    }

    @Override
    public synchronized void pushMetric(MetricsRecord mr) {
        this.intervalHeartBeat();
        try {
            mr.incrMetric(this.getName(), this.getPreviousIntervalValue());
        }
        catch (Exception e) {
            LOG.info("pushMetric failed for " + this.getName() + "\n", (Throwable)e);
        }
    }

    public synchronized int getPreviousIntervalValue() {
        return this.previousIntervalValue;
    }

    public synchronized int getCurrentIntervalValue() {
        return this.currentValue;
    }
}

