/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs.tables;

import com.mapr.fs.MapRDbKeyValue;
import com.mapr.fs.MapRDbResultScanner;
import com.mapr.fs.MapRDbUtils;
import com.mapr.fs.MapRFileStatus;
import com.mapr.fs.MapRFileSystem;
import com.mapr.fs.tables.MetadataEntry;
import com.mapr.org.apache.hadoop.hbase.util.Bytes;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.AccessControlException;

public class MapRDBMetadataMgr
implements Closeable {
    private static final Log LOG = LogFactory.getLog(MapRDBMetadataMgr.class);
    private static final boolean noMetadata = Boolean.valueOf(System.getProperty("hpe.ez.db.no.metadata", "false")) != false || Boolean.valueOf(System.getenv("HPE_EZ_DB_NO_METADATA")) != false;
    private static final List<Pattern> DF_DB_TABLE_FILTER_PATTERNS = List.of(Pattern.compile("^/var/mapr$"), Pattern.compile("^/var/objstore$"), Pattern.compile("/var/mapr/.*"), Pattern.compile("/var/objstore/.*"));
    public static final String DB_META_TABLE = "/var/mapr/df.db/table-list";
    public static final String DB_META_TABLE_CLUSTER = "/mapr/%s/var/mapr/df.db/table-list";
    public static final String DEFAULT_CF = "DefaultCf";
    public static final String COMMITTED_COL = "committed";
    public static final String FID_COL = "fid";
    private static final byte[] TRUE_VALUE = Bytes.toBytes((String)"true");
    private static final byte[] FALSE_VALUE = Bytes.toBytes((String)"false");
    private boolean initialized = false;
    private MapRDbUtils metadataDb = null;
    private final MapRFileSystem mfs;
    private final List<Pattern> skipRegexList;

    public MapRDBMetadataMgr(MapRFileSystem mfs) {
        this(mfs, DB_META_TABLE, DF_DB_TABLE_FILTER_PATTERNS);
    }

    public MapRDBMetadataMgr(MapRFileSystem mfs, String clusterName) {
        this(mfs, String.format(DB_META_TABLE_CLUSTER, clusterName), DF_DB_TABLE_FILTER_PATTERNS);
    }

    public MapRDBMetadataMgr(MapRFileSystem mfs, Collection<String> skipRegexList) {
        this(mfs, DB_META_TABLE, skipRegexList.stream().map(regex -> Pattern.compile(regex)).collect(Collectors.toList()));
    }

    private MapRDBMetadataMgr(MapRFileSystem mfs, String metaTable, List<Pattern> skipRegexList) {
        this.mfs = mfs;
        this.skipRegexList = skipRegexList;
        try {
            if (noMetadata) {
                LOG.warn((Object)"DB Metadata is disabled!");
            } else {
                this.metadataDb = new MapRDbUtils(mfs);
                this.metadataDb.Init(metaTable, DEFAULT_CF, COMMITTED_COL);
                this.initialized = true;
            }
        }
        catch (IOException e) {
            this.initialized = false;
            this.metadataDb = null;
            LOG.error((Object)"Unable to initialize DB Binary metadata table. Metadata entries won't be updated.", (Throwable)e);
        }
    }

    @Override
    public synchronized void close() {
        if (this.metadataDb != null) {
            this.metadataDb.close();
            this.initialized = false;
            this.metadataDb = null;
        }
    }

    public void prepareCreate(String tablePathStr) {
        if (this.initialized) {
            try {
                byte[] key = Bytes.toBytes((String)this.mfs.getNameStr(tablePathStr));
                this.metadataDb.Delete(key);
                this.metadataDb.Put(key, FALSE_VALUE);
            }
            catch (IOException e) {
                LOG.error((Object)("Failed to add entry for '" + tablePathStr + "' in metadata table."), (Throwable)e);
            }
        } else if (!noMetadata) {
            LOG.warn((Object)("MapRDBMetadataMgr isn't initialized, entry for '" + tablePathStr + "' won't be added."));
        }
    }

    public boolean commitCreate(String tablePathStr) {
        if (this.initialized) {
            try {
                Path tablePath = new Path(tablePathStr);
                MapRFileStatus fStatus = this.mfs.getMapRFileStatus(tablePath);
                if (fStatus.isTable()) {
                    byte[] key = Bytes.toBytes((String)this.mfs.getNameStr(tablePathStr));
                    HashMap<String, byte[]> valueMap = new HashMap<String, byte[]>();
                    valueMap.put(COMMITTED_COL, TRUE_VALUE);
                    valueMap.put(FID_COL, Bytes.toBytes((String)fStatus.getFidStr()));
                    this.metadataDb.Put(key, valueMap);
                    return true;
                }
                LOG.error((Object)("'" + tablePathStr + "' is not a table. Entry won't be added to the metadata table."));
            }
            catch (FileNotFoundException e) {
                LOG.warn((Object)("Table '" + tablePathStr + "' does not exist on the filesystem. Won't be added to the metadata table."));
            }
            catch (IOException e) {
                LOG.error((Object)("Failed to commit entry for '" + tablePathStr + "' in metadata table."), (Throwable)e);
            }
        } else if (!noMetadata) {
            LOG.warn((Object)("MapRDBMetadataMgr isn't initialized, entry for '" + tablePathStr + "' won't be committed."));
        }
        return false;
    }

    public void deleteEntry(String tablePathStr) {
        if (this.initialized) {
            try {
                this.metadataDb.Delete(Bytes.toBytes((String)this.mfs.getNameStr(tablePathStr)));
            }
            catch (IOException e) {
                LOG.error((Object)("Failed to remove entry for '" + tablePathStr + "' from metadata table."), (Throwable)e);
            }
        } else if (!noMetadata) {
            LOG.warn((Object)("MapRDBMetadataMgr isn't initialized, entry for '" + tablePathStr + "' won't be removed."));
        }
    }

    public void deleteEntries(List<String> entriesToDelete) throws IOException {
        if (this.initialized) {
            for (String tablePath : entriesToDelete) {
                this.metadataDb.Delete(Bytes.toBytes((String)tablePath));
            }
        } else if (!noMetadata) {
            throw new IOException("MapRDBMetadataMgr isn't initialized.");
        }
    }

    public Iterable<MetadataEntry> getMetaDataEntries() throws IOException {
        if (this.initialized) {
            MapRDbResultScanner dbScanner = this.metadataDb.getScanner(null, null, false);
            MetadataIterator iterator = new MetadataIterator(dbScanner);
            return () -> iterator;
        }
        if (noMetadata) {
            return () -> Collections.emptyIterator();
        }
        throw new IOException("MapRDBMetadataMgr isn't initialized.");
    }

    private void removeEntries(Path rootPath, Set<String> skipDirs) throws IOException {
        if (this.initialized) {
            Object strRootPath = rootPath.toUri().getPath();
            if (!((String)strRootPath).endsWith("/")) {
                strRootPath = (String)strRootPath + "/";
            }
            byte[] startRow = Bytes.toBytes((String)strRootPath);
            byte[] endRow = new byte[startRow.length];
            System.arraycopy(startRow, 0, endRow, 0, startRow.length);
            int n = endRow.length - 1;
            endRow[n] = (byte)(endRow[n] + 1);
            MapRDbResultScanner dbScanner = this.metadataDb.getKeysScanner(startRow, endRow);
            MapRDbKeyValue result = null;
            boolean noSkip = skipDirs.isEmpty();
            while ((result = dbScanner.next()) != null) {
                byte[] tableKey = result.getKey();
                if (!noSkip && !this.isAccesible(tableKey, skipDirs)) continue;
                this.metadataDb.Delete(tableKey);
            }
        }
    }

    private boolean isAccesible(byte[] tableP, Set<String> skipDirs) {
        String tablePath = new String(tableP);
        return skipDirs.stream().noneMatch(tablePath::startsWith);
    }

    public int update(Path rootPath) throws IOException {
        if (this.initialized) {
            ArrayList<MapRFileStatus> binaryTables = new ArrayList<MapRFileStatus>();
            LinkedList<MapRFileStatus> allFiles = new LinkedList<MapRFileStatus>();
            HashSet<String> skipDirs = new HashSet<String>();
            MapRFileStatus rootFStatus = this.mfs.getMapRFileStatus(rootPath);
            if (!rootFStatus.isDir() && !rootFStatus.isTable()) {
                throw new IOException("The specified path '" + rootPath + "' is neither a directory nor a table.");
            }
            allFiles.add(rootFStatus);
            while (!allFiles.isEmpty()) {
                MapRFileStatus file = (MapRFileStatus)((Object)allFiles.remove());
                Path filePath = file.getPath();
                String strFilePath = filePath.toUri().getPath();
                if (this.skipRegexList.stream().anyMatch(regex -> regex.matcher(strFilePath).matches())) continue;
                if (file.isDir()) {
                    try {
                        MapRFileStatus[] files = this.mfs.listMapRStatus(filePath, false, false);
                        allFiles.addAll(List.of(files));
                    }
                    catch (AccessControlException e) {
                        LOG.warn((Object)("Current user doesn't have access to directory " + filePath));
                        skipDirs.add(filePath.toUri().getPath() + "/");
                    }
                    continue;
                }
                if (!file.isTable() || this.mfs.isJsonTable(filePath)) continue;
                binaryTables.add(file);
            }
            this.removeEntries(rootPath, skipDirs);
            for (MapRFileStatus binaryTable : binaryTables) {
                String tablePathStr = binaryTable.getPath().toUri().getPath();
                byte[] key = Bytes.toBytes((String)tablePathStr);
                HashMap<String, byte[]> valueMap = new HashMap<String, byte[]>();
                valueMap.put(COMMITTED_COL, TRUE_VALUE);
                valueMap.put(FID_COL, Bytes.toBytes((String)binaryTable.getFidStr()));
                this.metadataDb.Put(key, valueMap);
            }
            return binaryTables.size();
        }
        if (!noMetadata) {
            throw new IOException("MapRDBMetadataMgr isn't initialized, the metadata table will not be updated.");
        }
        return 0;
    }

    public class MetadataIterator
    implements Iterator<MetadataEntry> {
        private final MapRDbResultScanner dbScanner;
        private MapRDbKeyValue result = null;
        private String tablePath;

        public MetadataIterator(MapRDbResultScanner dbScanner) {
            this.dbScanner = dbScanner;
        }

        @Override
        public boolean hasNext() {
            if (this.result == null) {
                try {
                    while ((this.result = this.dbScanner.next(false)) != null) {
                        this.tablePath = Bytes.toString((byte[])this.result.getKey());
                        boolean skipTable = MapRDBMetadataMgr.this.skipRegexList.stream().anyMatch(regex -> regex.matcher(this.tablePath).matches());
                        if (skipTable) continue;
                    }
                    return this.result != null;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            return true;
        }

        @Override
        public MetadataEntry next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            MetadataEntry entry = new MetadataEntry(this.tablePath);
            Map<String, byte[]> valueMap = this.result.getValueMap();
            byte[] fidValue = valueMap.get(MapRDBMetadataMgr.FID_COL);
            entry.fid_ = fidValue != null ? Bytes.toString((byte[])fidValue) : null;
            byte[] committedValue = valueMap.get(MapRDBMetadataMgr.COMMITTED_COL);
            entry.isCommitted_ = committedValue != null ? Boolean.valueOf(Bytes.toString((byte[])committedValue)) : false;
            this.result = null;
            return entry;
        }
    }
}

