/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.google.protobuf.ByteString;
import com.mapr.fs.FileAceMoreInfo;
import com.mapr.fs.Inode;
import com.mapr.fs.JobTrackerWatcher;
import com.mapr.fs.LoggerProxy;
import com.mapr.fs.MapRBlockLocation;
import com.mapr.fs.MapRFileStatus;
import com.mapr.fs.MapRFsInStream;
import com.mapr.fs.MapRFsOutStream;
import com.mapr.fs.MapRHTable;
import com.mapr.fs.QueryServiceWatcher;
import com.mapr.fs.beans.QueryServiceParam;
import com.mapr.fs.jni.Errno;
import com.mapr.fs.jni.GatewaySource;
import com.mapr.fs.jni.IOExceptionWithErrorCode;
import com.mapr.fs.jni.IPPort;
import com.mapr.fs.jni.InodeAttributes;
import com.mapr.fs.jni.JNIFileTierStatus;
import com.mapr.fs.jni.JNIFsStatus;
import com.mapr.fs.jni.MapRClient;
import com.mapr.fs.jni.MapRClientInitParams;
import com.mapr.fs.jni.MapRConstants;
import com.mapr.fs.jni.MapRDataMask;
import com.mapr.fs.jni.MapRFileCount;
import com.mapr.fs.jni.MapRSecurityPolicy;
import com.mapr.fs.jni.MapRUserInfo;
import com.mapr.fs.maprbuildversion.MapRBuildVersion;
import com.mapr.fs.proto.Common;
import com.mapr.fs.proto.Dbserver;
import com.mapr.fs.proto.Fileserver;
import com.mapr.fs.tables.TableProperties;
import com.mapr.fs.util.Fids;
import com.mapr.login.MapRLoginException;
import com.mapr.login.client.MapRLoginHttpsClient;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathId;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.util.Progressable;
import org.apache.zookeeper.KeeperException;

public class MapRClientImpl
extends MapRClient
implements MapRConstants {
    public static final Log LOG = LogFactory.getLog(MapRClient.class);
    private static boolean readBuffering_ = true;
    private static int javaRAThreadsPerStream_ = 2;
    private static int slowOpsThreshold = 0;
    private long clntPtr;
    private String clusterName;
    private JobTrackerWatcher jtwatcher;
    private QueryServiceWatcher doNotUseDirectlyQSWatcher;
    private LoadingCache<Integer, String> cachedZKString = CacheBuilder.newBuilder().maximumSize(1L).expireAfterAccess(10L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<Integer, String>(){

        public String load(Integer key) throws Exception {
            return MapRClient.getZkConnectString((long)MapRClientImpl.this.clntPtr, (boolean)true);
        }
    });

    public MapRClientImpl(String clusterName, long[] ips, long[] numIpsPerCldb, String auth, boolean disableNameCache, MapRClientInitParams clientInitParams) throws IOException {
        MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
        try {
            try {
                MapRLoginHttpsClient loginclient = new MapRLoginHttpsClient();
                loginclient.authenticateIfNeeded(clusterName);
            }
            catch (MapRLoginException e) {
                throw new IOException("failure to authenticate to cluster " + clusterName, e);
            }
            boolean bailOutOnLibMismatch = false;
            if (clientInitParams != null) {
                bailOutOnLibMismatch = clientInitParams.bailOutOnLibMismatch;
            }
            this.clntPtr = this.OpenClient2(clusterName, ips, numIpsPerCldb, auth, disableNameCache, clientInitParams, MapRBuildVersion.getMapRBuildVersion(), MapRBuildVersion.getMapRBuildVersionId(), bailOutOnLibMismatch, err);
            if (this.clntPtr == 0L) {
                throw new IOException("Could not create FileClient err: " + err.error);
            }
        }
        catch (UnknownHostException e) {
            System.out.println("Exception occured " + e);
        }
        this.clusterName = clusterName;
        this.jtwatcher = null;
        this.refreshZkConnectString();
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public void close() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"MapRClient closing");
        }
        long ptr = this.clntPtr;
        this.clntPtr = 0L;
        this.CloseClient(ptr);
    }

    public int GetUserInfo(MapRUserInfo userInfo) {
        return this.GetUserInfo(this.clntPtr, userInfo);
    }

    public static void setReadBuffering(boolean v) {
        readBuffering_ = v;
    }

    public static boolean readBuffering() {
        return readBuffering_;
    }

    public static void setJavaRAThreadsPerStream(int v) {
        javaRAThreadsPerStream_ = v;
    }

    public static int javaRAThreadsPerStream() {
        return javaRAThreadsPerStream_;
    }

    public static void setSlowOpsThreshold(int v) {
        slowOpsThreshold = v;
    }

    public static int getSlowOpsThreshold() {
        return slowOpsThreshold;
    }

    private static final boolean ShouldFail(MapRFileStatus status, int error) {
        return status == null || error == 136;
    }

    private static final boolean ShouldFail(int error) {
        return error == 136;
    }

    public void forceLocalResolution() {
        this.forceLocalResolution(this.clntPtr);
    }

    public int FsActionToAccessBits(FsAction mode, boolean isDirectory) {
        int accessBits = 0;
        if (mode == FsAction.ALL || mode == FsAction.READ || mode == FsAction.READ_WRITE || mode == FsAction.READ_EXECUTE) {
            accessBits |= Fileserver.AccessBits.AccessRead.getNumber();
        }
        if (mode == FsAction.ALL || mode == FsAction.WRITE || mode == FsAction.READ_WRITE || mode == FsAction.WRITE_EXECUTE) {
            accessBits |= Fileserver.AccessBits.AccessModify.getNumber();
        }
        if (mode == FsAction.ALL || mode == FsAction.EXECUTE || mode == FsAction.WRITE_EXECUTE || mode == FsAction.READ_EXECUTE) {
            accessBits = isDirectory ? (accessBits |= Fileserver.AccessBits.AccessLookup.getNumber()) : (accessBits |= Fileserver.AccessBits.AccessExecute.getNumber());
        }
        return accessBits;
    }

    public int getUserPermission(String path, FsAction mode, MapRConstants.ErrorValue err, MapRUserInfo userInfo) throws IOException {
        int accessBitsOut;
        MapRFileStatus status = MapRFileStatus.getStatus(this.getattr(this.clntPtr, path, false, null, err, userInfo));
        if (err.error < 0) {
            err.error = -err.error;
        }
        if (status == null || err.error == 136) {
            return 0;
        }
        int accessBitsIn = this.FsActionToAccessBits(mode, status.isDirectory());
        return accessBitsIn != (accessBitsOut = this.getuserpermission(this.clntPtr, path, accessBitsIn, err, userInfo)) ? 0 : accessBitsOut;
    }

    public MapRFsOutStream create(String name, int mask, int mode, boolean createIfNonExistant, boolean append, boolean overwrite, short replication, long chunkSize, Progressable progress, MapRConstants.ErrorValue err, boolean createParent, MapRUserInfo userInfo, FileSystem.Statistics stats) throws IOException {
        long filePtr;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Create: " + name + " mode = " + mode + " replication = " + replication + " chunkSize = " + (Serializable)((mask & 0x80) != 0 ? Long.valueOf(chunkSize) : "default") + " overwrite = " + overwrite));
        }
        if ((filePtr = this.create(this.clntPtr, name, mask, mode, createIfNonExistant, append, overwrite, replication, chunkSize, createParent, err, userInfo)) == 0L) {
            if (err.error < 0) {
                err.error = -err.error;
            }
            if (err.error == 136) {
                return null;
            }
            if (err.error == 13) {
                throw new AccessControlException("User " + userInfo.userName + "(user id " + userInfo.GetUserID() + ") does not have access to " + name);
            }
            if (err.error == 2) {
                throw new FileNotFoundException("Create failed for file: " + name + ", error: " + Errno.toString((int)err.error) + "(" + err.error + ")");
            }
            throw new IOException("Create failed for file: " + name + ", error: " + Errno.toString((int)err.error) + " (" + err.error + ")");
        }
        return new MapRFsOutStream(this.clntPtr, filePtr, name, stats, userInfo);
    }

    public boolean truncate(String name, long newlength, MapRConstants.ErrorValue err, MapRUserInfo userInfo) throws IOException {
        int error;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Truncate file " + name + " to length " + newlength));
        }
        if ((error = this.truncate(this.clntPtr, name, newlength, err, userInfo)) != 0) {
            if (err.error < 0) {
                err.error = -err.error;
            }
            if (err.error == 136) {
                return false;
            }
            if (err.error == 13) {
                throw new AccessControlException("User " + userInfo.userName + "(user id " + userInfo.GetUserID() + ") does not have access to " + name);
            }
            if (err.error == 2) {
                throw new FileNotFoundException("Truncate failed for file: " + name + ", error: " + Errno.toString((int)err.error) + "(" + err.error + ")");
            }
            throw new IOException("Truncate failed for file: " + name + ", error: " + Errno.toString((int)err.error) + " (" + err.error + ")");
        }
        return true;
    }

    public IPPort[] getGatewayIps(String file, String dstCluster, boolean skipCache, GatewaySource source, MapRConstants.ErrorValue err, MapRUserInfo userInfo) {
        return MapRClientImpl.getGatewayIps((long)this.clntPtr, (String)file, (String)dstCluster, (boolean)skipCache, (GatewaySource)source, (MapRConstants.ErrorValue)err, (MapRUserInfo)userInfo);
    }

    public MapRFsInStream open(String name, MapRConstants.ErrorValue err, MapRUserInfo userInfo, FileSystem.Statistics stats) throws IOException {
        InodeAttributes attr;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Open: path = " + name));
        }
        if ((attr = this.open(this.clntPtr, name, 0, err, userInfo)) == null || attr.filePtr == 0L) {
            if (err.error < 0) {
                err.error = -err.error;
            }
            if (err.error == 13) {
                throw new AccessControlException("Open failed for file: " + name + ", error: " + Errno.toString((int)err.error) + " (" + err.error + ")");
            }
            if (err.error == 136) {
                return null;
            }
            if (err.error == 2) {
                throw new FileNotFoundException(name);
            }
            if (err.error == 13) {
                throw new AccessControlException("User " + userInfo.userName + "(user id " + userInfo.GetUserID() + ") does not have access to " + name);
            }
            throw new IOException("Open failed for file: " + name + ", error: " + Errno.toString((int)err.error) + " (" + err.error + ")");
        }
        return new MapRFsInStream(this.clntPtr, attr.filePtr, name, stats, attr, userInfo);
    }

    public MapRFsInStream openFid2(PathId pfid, String file, int length, MapRUserInfo userInfo, FileSystem.Statistics stats) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("openFid2: fid = " + pfid + ", file = " + (file != null ? file : "") + ", length = " + length));
        }
        MapRFsInStream is = new MapRFsInStream(this.clntPtr, 0L, null, stats, userInfo);
        is.openAndRead(pfid, file, length);
        return is;
    }

    public MapRFsInStream openFid(String fid, long[] ips, long chunkSize, long fileSize, MapRUserInfo userInfo, FileSystem.Statistics stats) throws IOException, IOExceptionWithErrorCode {
        MapRConstants.ErrorValue err;
        InodeAttributes attr;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("openFid: fid = " + fid + ", chunkSize = " + chunkSize + ", fileSize = " + fileSize));
        }
        if ((attr = this.openFidWithParams(this.clntPtr, fid, ips, chunkSize, fileSize, err = new MapRConstants.ErrorValue(), userInfo)) == null || attr.filePtr == 0L) {
            throw new IOExceptionWithErrorCode("openFid failed for fid: " + fid + ", error: " + Errno.toString((int)err.error) + " (" + err.error + ")", err.error);
        }
        return new MapRFsInStream(this.clntPtr, attr.filePtr, null, stats, attr, userInfo);
    }

    public MapRFsInStream openFid(String pfid, String file, long[] ips, MapRUserInfo userInfo, FileSystem.Statistics stats) throws IOException, IOExceptionWithErrorCode {
        MapRConstants.ErrorValue err;
        InodeAttributes attr;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("openFid: pfid = " + pfid + ", file = " + file));
        }
        if ((attr = this.openFid(this.clntPtr, pfid, file, ips, err = new MapRConstants.ErrorValue(), userInfo)) == null || attr.filePtr == 0L) {
            Object errMsg = err.error != 0 ? ", error: " + Errno.toString((int)err.error) + " (" + err.error + ")" : "";
            throw new IOExceptionWithErrorCode("openFid failed for pfid: " + pfid + ", file: " + file + (String)errMsg, err.error);
        }
        return new MapRFsInStream(this.clntPtr, attr.filePtr, null, stats, attr, userInfo);
    }

    public MapRFsOutStream createFid(String pfid, String file, int mask, int mode, long chunkSize, MapRUserInfo userInfo, FileSystem.Statistics stats) throws IOException {
        MapRConstants.ErrorValue err;
        long filePtr;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("createFid: pfid = " + pfid + ", file = " + file));
        }
        if ((filePtr = this.createFid(this.clntPtr, pfid, file, mask, mode, chunkSize, err = new MapRConstants.ErrorValue(), userInfo)) == 0L) {
            throw new IOExceptionWithErrorCode("createFid failed for pfid: " + pfid + ", file: " + file + ", error: " + Errno.toString((int)err.error) + " (" + err.error + ")", err.error);
        }
        return new MapRFsOutStream(this.clntPtr, filePtr, null, stats, userInfo);
    }

    public MapRFsOutStream createFid(String pfid, String file, int mask, int mode, long chunkSize, boolean overwrite, MapRUserInfo userInfo, FileSystem.Statistics stats) throws IOException {
        MapRConstants.ErrorValue err;
        long filePtr;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("createFid: pfid = " + pfid + ", file = " + file));
        }
        if ((filePtr = this.createFid2(this.clntPtr, pfid, file, mask, mode, chunkSize, overwrite, err = new MapRConstants.ErrorValue(), userInfo)) == 0L) {
            throw new IOExceptionWithErrorCode("createFid failed for pfid: " + pfid + ", file: " + file + ", error: " + Errno.toString((int)err.error) + " (" + err.error + ")", err.error);
        }
        return new MapRFsOutStream(this.clntPtr, filePtr, null, stats, userInfo);
    }

    public int deleteFid(String pfid, String dir, MapRUserInfo userInfo) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("deleteFid: pfid = " + pfid + ", dir = " + (dir != null ? dir : "")));
        }
        MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
        return this.removeFid(this.clntPtr, pfid, dir, err, userInfo);
    }

    public String mkdirsFid(String pfid, String dir, int mask, int mode, boolean compress, long chunkSize, MapRUserInfo userInfo) throws IOException {
        MapRConstants.ErrorValue err;
        String fidStr;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("mkdirsFid: pfid = " + pfid + ", dir = " + dir));
        }
        if ((fidStr = this.mkdirsFid(this.clntPtr, pfid, dir, mask, mode, compress, chunkSize, err = new MapRConstants.ErrorValue(), userInfo)) == null) {
            throw new IOException("mkdirsFid failed, Error: " + Errno.toString((int)err.error));
        }
        return fidStr;
    }

    public MapRFsOutStream append(String name, MapRConstants.ErrorValue err, MapRUserInfo userInfo, FileSystem.Statistics stats) throws IOException {
        InodeAttributes attr;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Append: path = " + name));
        }
        if ((attr = this.open(this.clntPtr, name, 1, err, userInfo)) == null || attr.filePtr == 0L) {
            if (err.error < 0) {
                err.error = -err.error;
            }
            if (err.error == 13) {
                throw new AccessControlException("Append failed for file: " + name + ", error: " + Errno.toString((int)err.error) + " (" + err.error + ")");
            }
            if (err.error == 136) {
                return null;
            }
            if (err.error == 13) {
                throw new AccessControlException("User " + userInfo.userName + "(user id " + userInfo.GetUserID() + ")  does not have access to " + name);
            }
            throw new IOException("Append failed for file: " + name + ", error: " + Errno.toString((int)err.error) + " (" + err.error + ")");
        }
        MapRFsOutStream os = new MapRFsOutStream(this.clntPtr, attr.filePtr, name, stats, userInfo);
        os.seekToEof();
        return os;
    }

    public int delete(String name, boolean recursive, boolean batched, MapRConstants.ErrorValue err, MapRUserInfo userInfo) {
        return this.remove(this.clntPtr, name, recursive, batched, err, userInfo);
    }

    public MapRFileStatus getFileStatus(String name, boolean needSlashMapr, String scheme, String authority, MapRConstants.ErrorValue err, MapRUserInfo userInfo) {
        return MapRFileStatus.getStatus(this.getattr(this.clntPtr, name, needSlashMapr, authority, err, userInfo), scheme);
    }

    public MapRFileStatus[] listStatus(String name, boolean showVols, boolean needSlashMapr, boolean showHidden, String scheme, String authority, MapRConstants.ErrorValue err, MapRUserInfo userInfo) {
        return MapRFileStatus.getStatus(this.readdirplus(this.clntPtr, name, showVols, needSlashMapr, showHidden, authority, err, userInfo), scheme);
    }

    public MapRFileStatus[] listStatusLite(String name, int cid, int cinum, int uniq, int count, long cookie, boolean showHidden, String scheme, String authority, MapRConstants.ErrorValue err, MapRUserInfo userInfo) {
        return MapRFileStatus.getStatus(this.readdirlite(this.clntPtr, name, cid, cinum, uniq, count, cookie, showHidden, authority, err, userInfo), scheme);
    }

    public int listDirLite(String name, String scheme, String authority, MapRConstants.ErrorValue err, MapRUserInfo userInfo) {
        return this.listdirlite(this.clntPtr, name, authority, err, userInfo);
    }

    public int rename(String src, String dest, MapRConstants.ErrorValue err, MapRUserInfo userInfo) {
        return this.rename(this.clntPtr, src, dest, err, userInfo);
    }

    public int mkdirs(String name, int mask, int mode, boolean compress, long chunkSize, MapRConstants.ErrorValue err, boolean needFid, boolean createParent, MapRUserInfo userInfo) {
        return this.mkdirs(this.clntPtr, name, mask, mode, compress, chunkSize, err, needFid, createParent, userInfo);
    }

    public MapRBlockLocation[] getBlockLocations(String name, long start, long len, boolean usePrimaryFid, boolean needDiskBlocks, boolean fullBlockInfo, MapRConstants.ErrorValue err) {
        return MapRBlockLocation.getLocation(this.getBlockInfo(this.clntPtr, name, start, len, usePrimaryFid, needDiskBlocks, fullBlockInfo, err));
    }

    public MapRFileCount getFileCount(String name, MapRConstants.ErrorValue err, MapRUserInfo userInfo) {
        return this.fileCount(this.clntPtr, name, err, userInfo);
    }

    public JNIFileTierStatus tierOp(int op, String name, boolean verbose, boolean blocking, long shaHigh, long shaLow, long uniq, MapRConstants.ErrorValue errorVal, MapRUserInfo userInfo) {
        return this.tierOp(this.clntPtr, op, name, verbose, blocking, shaHigh, shaLow, uniq, errorVal, userInfo);
    }

    public int setattr(String name, int bitmask, String user, String group, long mtime, long atime, int mode, short repl, boolean canCompress, String compressionName, long chunkSize, boolean wireSecurityEnabled, boolean diskFlushEnabled, MapRConstants.ErrorValue err, MapRUserInfo userInfo) {
        return this.setattr(this.clntPtr, name, bitmask, user, group, mtime, atime, mode, repl, canCompress, compressionName, chunkSize, wireSecurityEnabled, false, false, err, userInfo);
    }

    public int setOwner(String name, String user, String group, MapRConstants.ErrorValue err, MapRUserInfo userInfo) {
        int b = 0;
        if (user != null) {
            b |= 1;
        }
        if (group != null) {
            b |= 2;
        }
        return this.setattr(this.clntPtr, name, b, user, group, 0L, 0L, -1, (short)0, true, null, -1L, false, false, false, err, userInfo);
    }

    public int setOwnerFid(String name, String user, String group, MapRConstants.ErrorValue err, MapRUserInfo userInfo) {
        int b = 0;
        if (user != null) {
            b |= 1;
        }
        if (group != null) {
            b |= 2;
        }
        return this.setattr(this.clntPtr, name, b |= 0x400, user, group, 0L, 0L, -1, (short)0, true, null, -1L, false, false, false, err, userInfo);
    }

    public int setTimes(String name, long mtime, long atime, MapRConstants.ErrorValue err, MapRUserInfo userInfo) {
        int b = 0;
        if (mtime != -1L) {
            b |= 4;
        }
        if (atime != -1L) {
            b |= 8;
        }
        return this.setattr(this.clntPtr, name, b, null, null, mtime, atime, -1, (short)0, true, null, -1L, false, false, false, err, userInfo);
    }

    public int setPermission(String name, int mode, MapRConstants.ErrorValue err, MapRUserInfo userInfo) {
        return this.setattr(this.clntPtr, name, 16, null, null, 0L, 0L, mode, (short)0, true, null, -1L, false, false, false, err, userInfo);
    }

    public FsStatus getStatus() {
        JNIFsStatus fs = this.getStatus(this.clntPtr);
        return new FsStatus(fs.getCapacity(), fs.getUsed(), fs.getRemaining());
    }

    public int setReplication(String name, short repl, MapRConstants.ErrorValue err, MapRUserInfo userInfo) {
        return this.setattr(this.clntPtr, name, 32, null, null, 0L, 0L, -1, repl, true, null, -1L, false, false, false, err, userInfo);
    }

    public void createSymlink(String target, String link, boolean createParent, int mask, int mode, long chunkSize, MapRConstants.ErrorValue linkErr, MapRUserInfo userInfo) throws IOException {
        this.createSymlink(this.clntPtr, target, link, createParent, mask, mode, chunkSize, linkErr, userInfo);
    }

    public void createHardlink(String oldpath, String newpath, MapRConstants.ErrorValue linkErr, MapRUserInfo userInfo) throws IOException {
        this.createHardlink(this.clntPtr, oldpath, newpath, linkErr, userInfo);
    }

    public Path getLinkTarget(String f, MapRConstants.ErrorValue err) {
        String link = this.readlink(this.clntPtr, f, err);
        return new Path(link);
    }

    public int setCompression(String path, boolean val, String compName, MapRConstants.ErrorValue err, MapRUserInfo userInfo) {
        MapRFileStatus status = MapRFileStatus.getStatus(this.getattr(this.clntPtr, path, false, null, err, userInfo));
        if (MapRClientImpl.ShouldFail(status, err.error)) {
            return -1;
        }
        if (status.isDir() || status.isTable()) {
            int mask = 64;
            if (compName != null) {
                mask |= 0x200;
            }
            return this.setattr(this.clntPtr, path, mask, null, null, 0L, 0L, -1, (short)0, val, compName, -1L, false, false, false, err, userInfo);
        }
        return -1;
    }

    public MapRFileStatus getStat(String path, MapRConstants.ErrorValue err, MapRUserInfo userInfo) {
        MapRFileStatus status = MapRFileStatus.getStatus(this.getattr(this.clntPtr, path, false, null, err, userInfo));
        if (MapRClientImpl.ShouldFail(status, err.error)) {
            return null;
        }
        return status;
    }

    public int modifyAudit(String path, boolean val, MapRConstants.ErrorValue err, MapRUserInfo userInfo) {
        MapRFileStatus status = MapRFileStatus.getStatus(this.getattr(this.clntPtr, path, false, null, err, userInfo));
        int mask = 8192;
        return this.setattr(this.clntPtr, path, mask, null, null, 0L, 0L, -1, (short)0, false, null, -1L, false, val, false, err, userInfo);
    }

    public int setWireSecurity(String path, boolean val, MapRConstants.ErrorValue err, MapRUserInfo userInfo) {
        MapRFileStatus status = MapRFileStatus.getStatus(this.getattr(this.clntPtr, path, false, null, err, userInfo));
        if (MapRClientImpl.ShouldFail(status, err.error)) {
            return -1;
        }
        int mask = 4096;
        return this.setattr(this.clntPtr, path, mask, null, null, 0L, 0L, -1, (short)0, val, null, -1L, val, false, false, err, userInfo);
    }

    public int setDiskFlush(String path, boolean val, MapRConstants.ErrorValue err, MapRUserInfo userInfo) {
        MapRFileStatus status = MapRFileStatus.getStatus(this.getattr(this.clntPtr, path, false, null, err, userInfo));
        if (MapRClientImpl.ShouldFail(status, err.error)) {
            return -1;
        }
        int mask = 16384;
        return this.setattr(this.clntPtr, path, mask, null, null, 0L, 0L, -1, (short)0, val, null, -1L, false, false, val, err, userInfo);
    }

    public int setXAttr(String path, String name, byte[] value, MapRConstants.ErrorValue err, MapRUserInfo userInfo) {
        MapRFileStatus status = MapRFileStatus.getStatus(this.getattr(this.clntPtr, path, false, null, err, userInfo));
        if (err.error < 0) {
            err.error = -err.error;
        }
        if (status == null || err.error == 136) {
            return -1;
        }
        if (status.isTable()) {
            LOG.error((Object)"Extended attributes are not supported for tables");
            return 22;
        }
        return this.setxattr(this.clntPtr, path, name, value, err, userInfo);
    }

    public byte[] getXAttr(String path, String name, MapRConstants.ErrorValue err, MapRUserInfo userInfo) throws IOException {
        MapRFileStatus status = MapRFileStatus.getStatus(this.getattr(this.clntPtr, path, false, null, err, userInfo));
        if (err.error < 0) {
            err.error = -err.error;
        }
        if (status == null || err.error == 136) {
            return null;
        }
        if (status.isTable()) {
            String errStr = Errno.toString((int)22);
            throw new IOException(errStr);
        }
        byte[] reply = this.getxattr(this.clntPtr, path, name, err, userInfo);
        if (reply == null) {
            String errStr = Errno.toString((int)err.error);
            if (err.error == 2) {
                errStr = "No such attribute";
            }
            throw new IOExceptionWithErrorCode(errStr, err.error);
        }
        Fileserver.GetXAttrResponse getxResp = Fileserver.GetXAttrResponse.parseFrom((byte[])reply);
        return getxResp.getValue().toByteArray();
    }

    public List<String> listXAttrs(String path, MapRConstants.ErrorValue err, MapRUserInfo userInfo) throws IOException {
        MapRFileStatus status = MapRFileStatus.getStatus(this.getattr(this.clntPtr, path, false, null, err, userInfo));
        if (err.error < 0) {
            err.error = -err.error;
        }
        if (status == null || err.error == 136) {
            return null;
        }
        if (status.isTable()) {
            String errStr = Errno.toString((int)22);
            throw new IOException(errStr);
        }
        ArrayList<String> namesList = new ArrayList<String>();
        byte[] reply = this.listxattr(this.clntPtr, path, err, userInfo);
        if (reply == null) {
            if (err.error == 2) {
                err.error = 0;
                return namesList;
            }
            throw new IOException(Errno.toString((int)err.error));
        }
        Fileserver.ListXAttrResponse getxResp = Fileserver.ListXAttrResponse.parseFrom((byte[])reply);
        for (String name : getxResp.getNamesList()) {
            namesList.add(name);
        }
        return namesList;
    }

    public int removeXAttr(String path, String name, MapRConstants.ErrorValue err, MapRUserInfo userInfo) throws IOException {
        MapRFileStatus status = MapRFileStatus.getStatus(this.getattr(this.clntPtr, path, false, null, err, userInfo));
        if (err.error < 0) {
            err.error = -err.error;
        }
        if (status == null || err.error == 136) {
            return -1;
        }
        if (status.isTable()) {
            String errStr = Errno.toString((int)22);
            throw new IOException(errStr);
        }
        int error = this.removexattr(this.clntPtr, path, name, err, userInfo);
        if (error != 0) {
            String errStr = Errno.toString((int)err.error);
            if (err.error == 2) {
                errStr = "No such attribute";
            }
            throw new IOException(errStr);
        }
        return error;
    }

    public int getAces(String path, ArrayList<Common.FileACE> aces, FileAceMoreInfo aceMoreInfo, MapRConstants.ErrorValue err, MapRUserInfo userInfo) throws IOException {
        return this.getAces(path, aces, aceMoreInfo, err, userInfo, -1);
    }

    public int getAces(String path, ArrayList<Common.FileACE> aces, FileAceMoreInfo aceMoreInfo, MapRConstants.ErrorValue err, MapRUserInfo userInfo, int serveridx) throws IOException {
        MapRFileStatus status = MapRFileStatus.getStatus(this.getattr(this.clntPtr, path, false, null, err, userInfo));
        if (err.error < 0) {
            err.error = -err.error;
        }
        if (status == null || err.error == 136) {
            return -1;
        }
        if (status.isTable()) {
            return -1;
        }
        byte[] reply = this.getace(this.clntPtr, path, err, userInfo, serveridx);
        if (err.error != 0) {
            return -1;
        }
        Common.FileACEs faces = null;
        if (reply != null) {
            Fileserver.GetXAttrResponse getxResp = Fileserver.GetXAttrResponse.parseFrom((byte[])reply);
            faces = Common.FileACEs.parseFrom((ByteString)getxResp.getValue());
        }
        int dirAccessTypeStartVal = Common.FSAccessType.AceDirAccessTypeStart.getNumber();
        int dirAccessTypeEndVal = Common.FSAccessType.AceDirAccessTypeEnd.getNumber();
        int fileAccessTypeStartVal = Common.FSAccessType.FileAccessTypeStart.getNumber();
        int fileAccessTypeEndVal = Common.FSAccessType.FileAccessTypeEnd.getNumber();
        int j = 0;
        for (int i = fileAccessTypeStartVal; i <= dirAccessTypeEndVal; ++i) {
            if (faces != null && faces.getAcesCount() > 0 && j < faces.getAcesCount() && faces.getAces(j).getAccessType().getNumber() == i) {
                aces.add(faces.getAces(j));
                ++j;
            } else {
                aces.add(Common.FileACE.newBuilder().setAccessType(Common.FSAccessType.valueOf((int)i)).setBoolExp(ByteString.copyFromUtf8((String)"")).build());
            }
            if (i != fileAccessTypeEndVal) continue;
            if (!status.isDirectory()) break;
            i = dirAccessTypeStartVal - 1;
        }
        if (faces != null && faces.hasNoInherit() && faces.getNoInherit() && aceMoreInfo != null) {
            aceMoreInfo.setInherit(false);
        }
        return 0;
    }

    public int delAces(String path, MapRConstants.ErrorValue err, MapRUserInfo userInfo) throws IOException {
        MapRFileStatus status = MapRFileStatus.getStatus(this.getattr(this.clntPtr, path, false, null, err, userInfo));
        if (err.error < 0) {
            err.error = -err.error;
        }
        if (status == null || err.error == 136) {
            return -1;
        }
        if (status.isTable()) {
            return -1;
        }
        int error = this.delace(this.clntPtr, path, err, userInfo);
        if (error == 2) {
            error = 0;
        }
        return error;
    }

    public int setAces(String path, ArrayList<Common.FileACE> aces, boolean isSet, int noinherit, int preservemodebits, String hintAcePath, MapRConstants.ErrorValue err, MapRUserInfo userInfo) {
        MapRFileStatus status = MapRFileStatus.getStatus(this.getattr(this.clntPtr, path, false, null, err, userInfo));
        if (err.error < 0) {
            err.error = -err.error;
        }
        if (status == null || err.error == 136) {
            return -1;
        }
        if (status.isTable()) {
            return -1;
        }
        int dirAccessTypeStartVal = Common.FSAccessType.AceDirAccessTypeStart.getNumber();
        int dirAccessTypeEndVal = Common.FSAccessType.AceDirAccessTypeEnd.getNumber();
        Common.FileACEs.Builder faceBuilder = Common.FileACEs.newBuilder();
        for (Common.FileACE a : aces) {
            if (!status.isDirectory() && a.getAccessType().getNumber() >= dirAccessTypeStartVal && a.getAccessType().getNumber() <= dirAccessTypeEndVal) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("dir aces provided for non-dir file " + path + " accesstype " + a.getAccessType().getNumber()));
                continue;
            }
            faceBuilder.addAces(a);
        }
        if (noinherit != -1) {
            faceBuilder.setNoInherit(noinherit == 1);
        }
        if (preservemodebits != -1) {
            faceBuilder.setPreserveModeBits(preservemodebits == 1);
        }
        if (faceBuilder.getAcesCount() == 0 && !faceBuilder.hasNoInherit()) {
            LOG.debug((Object)("Path: " + path + ", nothing to be set for aces"));
            return 0;
        }
        return this.setace(this.clntPtr, path, faceBuilder.build().toByteArray(), isSet, hintAcePath, err, userInfo);
    }

    public int setChunkSize(String path, long val, MapRConstants.ErrorValue err, MapRUserInfo userInfo) {
        MapRFileStatus status = MapRFileStatus.getStatus(this.getattr(this.clntPtr, path, false, null, err, userInfo));
        if (MapRClientImpl.ShouldFail(status, err.error)) {
            return -1;
        }
        if (status.isDir()) {
            return this.setattr(this.clntPtr, path, 128, null, null, 0L, 0L, -1, (short)0, true, null, val, false, false, false, err, userInfo);
        }
        return -1;
    }

    public int mountVolume(String volName, String mountPath, String username, MapRUserInfo userInfo, int mode) {
        return this.mountVolume(this.clntPtr, volName, mountPath, username, userInfo, mode);
    }

    public int unmountVolume(String volName, String mountPath, String username, int pCid, int pCinum, int pUniq, MapRUserInfo userInfo) {
        return this.unmountVolume(this.clntPtr, volName, mountPath, username, pCid, pCinum, pUniq, userInfo);
    }

    public String getMountPath(String username, int pCid, int pCinum, int pUniq, MapRUserInfo userInfo, boolean useCache) {
        return this.getPathFromFid(this.clntPtr, username, pCid, pCinum, pUniq, userInfo, useCache);
    }

    public String getVolumeNameCached(int volId, MapRUserInfo userInfo) {
        return this.getVolNameCached(this.clntPtr, volId, userInfo);
    }

    public String getVolumeName(int volId, MapRUserInfo userInfo) {
        return this.getVolName(this.clntPtr, volId, userInfo);
    }

    public int createSnapshot(String volName, int volId, int rootCid, String snapshotName, boolean mirrorSnapshot, long expirationTime, String username, MapRUserInfo userInfo) {
        return this.createSnapshot(this.clntPtr, volName, volId, rootCid, snapshotName, mirrorSnapshot, expirationTime, username, userInfo);
    }

    public int createSnapshotLite(String volName, int volId, int rootCid, String snapshotName, boolean mirrorSnapshot, long expirationTime, String username, MapRUserInfo userInfo, long clusterOps) {
        return this.createSnapshotLite(this.clntPtr, volName, volId, rootCid, snapshotName, mirrorSnapshot, expirationTime, username, userInfo, clusterOps);
    }

    public int createVolLink(String volName, String volLink, boolean writeable, boolean hidden, MapRUserInfo userInfo) {
        return this.createVolLink(this.clntPtr, volName, volLink, writeable, hidden, userInfo);
    }

    public int deleteVolLink(String volLink, MapRUserInfo userInfo) {
        return this.deleteVolLink(this.clntPtr, volLink, userInfo);
    }

    public static int getModeBits(FsPermission permission, Configuration conf) {
        int mode = permission != null ? permission.toShort() : FsPermission.getDefault().toShort();
        short umask = FsPermission.getUMask((Configuration)conf).toShort();
        return mode &= ~umask;
    }

    public synchronized void clearQueryServiceParam() throws IOException, InterruptedException {
        try {
            this.queryServiceWatcher().clearQueryServiceParam();
        }
        catch (KeeperException e) {
            throw new IOException("Failed to clear QueryServiceParam for cluster " + this.getClusterName(), e);
        }
    }

    public synchronized void setQueryServiceParam(QueryServiceParam qsp) throws IOException, InterruptedException {
        Preconditions.checkNotNull((Object)qsp);
        try {
            this.queryServiceWatcher().setQueryServiceParam(qsp);
        }
        catch (KeeperException e) {
            throw new IOException("Failed to set QueryServiceParam for cluster " + this.getClusterName(), e);
        }
    }

    public synchronized QueryServiceParam getQueryServiceParam() throws IOException, InterruptedException {
        int attempts = 0;
        while (true) {
            try {
                return this.queryServiceWatcher().getQueryServiceParam();
            }
            catch (FileNotFoundException e) {
                return new QueryServiceParam(false, this.getZkConnectString(), null);
            }
            catch (KeeperException e) {
                this.resetQueryServiceWatcher();
                LOG.trace((Object)e.getMessage(), (Throwable)e);
                LOG.error((Object)("Retrying...Fetching new Zookeeper locations from CLDB.  Attempt #" + ++attempts));
                try {
                    if (attempts * 2 > 30) {
                        Thread.sleep(30000L);
                        continue;
                    }
                    Thread.sleep(attempts * 2 * 1000);
                }
                catch (InterruptedException interruptedException) {
                }
                continue;
            }
            break;
        }
    }

    public synchronized String getZkConnectString() {
        return (String)this.cachedZKString.getUnchecked((Object)0);
    }

    public synchronized InetSocketAddress[] getJobTrackerAddrs() throws IOException {
        String zkConnectString;
        int attempts = 0;
        InetSocketAddress[] jobTrackerAddrs = new InetSocketAddress[1];
        if (this.jtwatcher == null) {
            zkConnectString = this.getZkConnectString();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("zkConnectString: = " + zkConnectString));
            }
            if (zkConnectString != null && !zkConnectString.isEmpty()) {
                this.jtwatcher = new JobTrackerWatcher(zkConnectString);
                if (!this.jtwatcher.connect()) {
                    this.resetJobTrackerWatcher();
                    throw new IOException("Failed to connect to Zookeeper at " + zkConnectString + " for cluster " + this.getClusterName());
                }
            } else {
                throw new IOException("Failed to get Zookeeper information for cluster " + this.getClusterName());
            }
        }
        try {
            jobTrackerAddrs[0] = this.jtwatcher.findJobTrackerAddr();
        }
        catch (KeeperException ke) {
            if (ke instanceof KeeperException.SessionExpiredException || ke instanceof KeeperException.SessionMovedException || ke instanceof KeeperException.ConnectionLossException) {
                this.resetJobTrackerWatcher();
                ++attempts;
                try {
                    if (attempts * 2 > 30) {
                        Thread.sleep(30000L);
                    }
                    Thread.sleep(attempts * 2 * 1000);
                }
                catch (InterruptedException interruptedException) {}
            }
            throw new IOException("Failed to get Zookeeper information for cluster " + this.getClusterName());
        }
        if (jobTrackerAddrs[0] == null) {
            zkConnectString = this.jtwatcher.getZKString();
            this.resetJobTrackerWatcher();
            throw new IOException("Failed to get jobtracker location from Zookeeper at " + zkConnectString + " for cluster " + this.getClusterName());
        }
        return jobTrackerAddrs;
    }

    public byte[] scanKV(String name, byte[] start, byte[] end, int maxkeys, MapRConstants.ErrorValue err) {
        return this.scanKV(this.clntPtr, name, start, end, maxkeys, false, err);
    }

    public byte[] scanKV(String name, byte[] start, byte[] end, int maxkeys, boolean fromGfsck, MapRConstants.ErrorValue err) {
        return this.scanKV(this.clntPtr, name, start, end, maxkeys, fromGfsck, err);
    }

    public Fileserver.KvstoreLookupResponse lookupKV(String kvPath, Fileserver.KvStoreKey key, MapRConstants.ErrorValue err) throws IOException {
        byte[] reply = this.lookupkv(this.clntPtr, kvPath, key.toByteArray(), err);
        if (reply == null) {
            throw new IOException("Reply to lookup on file " + kvPath);
        }
        return Fileserver.KvstoreLookupResponse.parseFrom((byte[])reply);
    }

    public Fileserver.KvstoreScanResponse scanKVGivenFid(Common.FidMsg kvFid, Fileserver.KvStoreKey stKey, Fileserver.KvStoreKey enKey, MapRConstants.ErrorValue err) throws IOException {
        byte[] reply;
        byte[] end = null;
        if (end != null) {
            end = enKey.toByteArray();
        }
        if ((reply = this.scankvgivenfid(this.clntPtr, kvFid.toByteArray(), stKey.toByteArray(), end, err)) == null) {
            throw new IOException("Reply to scan of file is null.");
        }
        return Fileserver.KvstoreScanResponse.parseFrom((byte[])reply);
    }

    public Inode openTable(String name, MapRConstants.ErrorValue err, MapRHTable table, MapRUserInfo userInfo) throws IOException {
        long filePtr = this.opentable(this.clntPtr, name, err, userInfo);
        if (filePtr == 0L) {
            if (err.error < 0) {
                err.error = -err.error;
            }
            switch (err.error) {
                case 136: {
                    return null;
                }
                case 2: {
                    throw new FileNotFoundException(name);
                }
            }
            throw new IOException("Open failed for table: " + name + ", error: " + Errno.toString((int)err.error) + " (" + err.error + ")");
        }
        return new Inode(this.clntPtr, filePtr, name, table, LoggerProxy.InodeLogger, userInfo);
    }

    public Inode openTableWithFid(String fid, MapRConstants.ErrorValue err, MapRHTable table, MapRUserInfo userInfo) throws IOException {
        long filePtr = this.opentablewithfid(this.clntPtr, fid, err, userInfo);
        if (filePtr == 0L) {
            if (err.error < 0) {
                err.error = -err.error;
            }
            switch (err.error) {
                case 136: {
                    return null;
                }
                case 2: {
                    throw new FileNotFoundException(fid);
                }
            }
            throw new IOException("Open failed for table: " + fid + ", error: " + Errno.toString((int)err.error) + " (" + err.error + ")");
        }
        return new Inode(this.clntPtr, filePtr, fid, table, LoggerProxy.InodeLogger, userInfo);
    }

    public String createTable(String name, String user, Dbserver.TableAttr attr, Dbserver.TableAces aces, int mode, byte[][] splitKeys, boolean needServerInfo, int auditValue, MapRConstants.ErrorValue err, MapRUserInfo userInfo) throws IOException {
        return this.createtable(this.clntPtr, name, user, attr.toByteArray(), aces.toByteArray(), mode, splitKeys, needServerInfo, auditValue, err, userInfo);
    }

    public Dbserver.TableBasicStats getTableStats(String tablePath, String indexFid, MapRConstants.ErrorValue err, MapRUserInfo userInfo) throws IOException {
        byte[] reply = this.gettablestats(this.clntPtr, tablePath, indexFid, err, userInfo);
        Dbserver.TableBasicStats basicStats = null;
        if (reply != null) {
            basicStats = Dbserver.TableBasicStats.parseFrom((byte[])reply);
        }
        return basicStats;
    }

    public Dbserver.TableBasicStats getScanRangeStats(String tablePath, String indexFid, byte[] stKey, byte[] endKey, MapRConstants.ErrorValue err, MapRUserInfo userInfo) throws IOException {
        byte[] reply = this.getscanrangestats(this.clntPtr, tablePath, indexFid, stKey, endKey, err, userInfo);
        Dbserver.TableBasicStats scrStats = null;
        if (reply != null) {
            scrStats = Dbserver.TableBasicStats.parseFrom((byte[])reply);
        }
        return scrStats;
    }

    public Dbserver.TabletLookupResponse getTablets(String tablePath, byte[] stKey, byte[] endKey, boolean needSpaceUsage, boolean prefetchTabletMap, MapRConstants.ErrorValue err, MapRUserInfo userInfo) throws IOException {
        byte[] reply = this.gettablets(this.clntPtr, tablePath, stKey, endKey, needSpaceUsage, prefetchTabletMap, err, userInfo);
        if (reply == null) {
            throw new IOException("Reply to get tablets on table: " + tablePath + " is null.");
        }
        Dbserver.TabletLookupResponse lookupResp = Dbserver.TabletLookupResponse.parseFrom((byte[])reply);
        return lookupResp;
    }

    public String ToCommaSeparatedString(Collection<String> namesList) {
        StringBuilder sb = new StringBuilder();
        if (namesList.size() == 0) {
            sb.append(" ");
            return sb.toString();
        }
        for (String s : namesList) {
            sb.append(",");
            sb.append(s);
        }
        sb = sb.deleteCharAt(0);
        return sb.toString();
    }

    public List<Integer> getSecurityPolicyIds(List<String> policyNames, MapRConstants.ErrorValue err, MapRUserInfo userInfo) throws IOException {
        if (policyNames.size() == 0) {
            throw new IOException("No policy name is provided as input");
        }
        String names = this.ToCommaSeparatedString(policyNames);
        int[] policyIds = this.getsecuritypolicyids(this.clntPtr, names.toString(), err, userInfo);
        if (policyIds == null && err.error != 0) {
            if (err.error == 2) {
                throw new IOException("Security policy " + policyNames.get(0) + " does not exist");
            }
            throw new IOException("Failed to get policy ID for " + policyNames.get(0) + ": " + Errno.toString((int)err.error));
        }
        if (policyIds.length != policyNames.size()) {
            throw new IOException("Error " + Errno.toString((int)err.error) + " in fetching security policy id for name " + policyNames.get(policyIds.length));
        }
        ArrayList<Integer> outIds = new ArrayList<Integer>(policyIds.length);
        for (int id : policyIds) {
            outIds.add(id);
        }
        return outIds;
    }

    public List<String> getSecurityPolicyNames(List<Integer> policyIds, MapRConstants.ErrorValue err, MapRUserInfo userInfo) throws IOException {
        if (policyIds.size() == 0) {
            throw new IOException("No policy id is provided as input");
        }
        int[] policyIdsArr = new int[policyIds.size()];
        int i = 0;
        for (Integer id : policyIds) {
            policyIdsArr[i] = id;
            ++i;
        }
        String names = this.getsecuritypolicynames(this.clntPtr, policyIdsArr, err, userInfo);
        if (names == null) {
            throw new IOException("Error " + Errno.toString((int)err.error) + " in fetching security policy name for id " + policyIds.get(0));
        }
        ArrayList<String> policyNamesList = new ArrayList<String>(Arrays.asList(new String(names).split("\\s*,\\s*")));
        int namesLen = policyNamesList.size();
        if (namesLen != policyIds.size()) {
            throw new IOException("Error " + Errno.toString((int)err.error) + " in fetching security policy name for id " + policyIds.get(namesLen));
        }
        return policyNamesList;
    }

    public Integer getSecurityPolicyId(String policyName, MapRConstants.ErrorValue err, MapRUserInfo userInfo) throws IOException {
        ArrayList<String> policyNameList = new ArrayList<String>();
        policyNameList.add(policyName);
        List<Integer> policyIdList = this.getSecurityPolicyIds(policyNameList, err, userInfo);
        return policyIdList.get(0);
    }

    public String getSecurityPolicyName(Integer policyId, MapRConstants.ErrorValue err, MapRUserInfo userInfo) throws IOException {
        ArrayList<Integer> policyIdList = new ArrayList<Integer>();
        policyIdList.add(policyId);
        List<String> policyNameList = this.getSecurityPolicyNames(policyIdList, err, userInfo);
        return policyNameList.get(0);
    }

    public Map<String, Integer> getClusterSecurityPolicies(MapRUserInfo userInfo) throws IOException {
        MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
        MapRSecurityPolicy[] policies = this.getsecuritypolicyinfo(this.clntPtr, err, userInfo);
        if (err.error != 0) {
            throw new IOException("Failed to get cluster security policies: " + Errno.toString((int)err.error));
        }
        ImmutableMap.Builder allPolicies = ImmutableMap.builder();
        if (policies != null) {
            for (MapRSecurityPolicy policy : policies) {
                allPolicies.put((Object)policy.getPolicyName(), (Object)policy.getPolicyID());
            }
        }
        return allPolicies.build();
    }

    public int printsecuritypolicies(String path, boolean recursive, MapRUserInfo userInfo) throws IOException {
        int ret = this.printsecuritypolicies(this.clntPtr, path, recursive, userInfo);
        if (ret != 0) {
            throw new IOException("Error " + Errno.toString((int)ret) + " returned while getting security policies for path" + path);
        }
        return ret;
    }

    public int addsecuritypolicies(String path, List<String> policyNames, boolean recursive, MapRConstants.ErrorValue err, MapRUserInfo userInfo) throws IOException {
        if (policyNames.size() == 0) {
            throw new IOException("No policy name is provided as input");
        }
        String names = this.ToCommaSeparatedString(policyNames);
        int[] policyIds = this.getsecuritypolicyids(this.clntPtr, names.toString(), err, userInfo);
        if (policyIds == null && err.error != 0) {
            if (err.error == 2) {
                throw new IOException("Security policy " + policyNames.get(0) + " does not exist");
            }
            throw new IOException("Failed to get policy ID for " + policyNames.get(0) + ": " + Errno.toString((int)err.error));
        }
        if (policyIds.length != policyNames.size()) {
            throw new IOException("Error " + Errno.toString((int)err.error) + " in fetching security policy id for name " + policyNames.get(policyIds.length));
        }
        int ret = this.addsecuritypolicies(this.clntPtr, path, policyIds, recursive, userInfo);
        if (ret != 0) {
            throw new IOException("Error " + Errno.toString((int)ret) + " returned while adding security policies for path" + path);
        }
        return ret;
    }

    public int setsecuritypolicies(String path, List<String> policyNames, boolean recursive, MapRConstants.ErrorValue err, MapRUserInfo userInfo) throws IOException {
        if (policyNames.size() == 0) {
            int[] policyIds = new int[]{};
            return this.setsecuritypolicies(this.clntPtr, path, policyIds, recursive, userInfo);
        }
        String names = this.ToCommaSeparatedString(policyNames);
        int[] policyIds = this.getsecuritypolicyids(this.clntPtr, names.toString(), err, userInfo);
        if (policyIds == null && err.error != 0) {
            if (err.error == 2) {
                throw new IOException("Security policy " + policyNames.get(0) + " does not exist");
            }
            throw new IOException("Failed to get policy ID for " + policyNames.get(0) + ": " + Errno.toString((int)err.error));
        }
        if (policyIds.length != policyNames.size()) {
            throw new IOException("Error " + Errno.toString((int)err.error) + " in fetching security policy id for name " + policyNames.get(policyIds.length));
        }
        int ret = this.setsecuritypolicies(this.clntPtr, path, policyIds, recursive, userInfo);
        if (ret != 0) {
            throw new IOException("Error " + Errno.toString((int)ret) + " returned while setting security policy for path" + path);
        }
        return ret;
    }

    public int removesecuritypolicies(String path, List<String> policyNames, boolean recursive, MapRConstants.ErrorValue err, MapRUserInfo userInfo) throws IOException {
        if (policyNames.size() == 0) {
            throw new IOException("No policy name is provided as input");
        }
        String names = this.ToCommaSeparatedString(policyNames);
        int[] policyIds = this.getsecuritypolicyids(this.clntPtr, names.toString(), err, userInfo);
        if (policyIds == null && err.error != 0) {
            if (err.error == 2) {
                throw new IOException("Security policy " + policyNames.get(0) + " does not exist");
            }
            throw new IOException("Failed to get policy ID for " + policyNames.get(0) + ": " + Errno.toString((int)err.error));
        }
        if (policyIds.length != policyNames.size()) {
            throw new IOException("Error " + Errno.toString((int)err.error) + " in fetching security policy id for name " + policyNames.get(policyIds.length));
        }
        int ret = this.removesecuritypolicies(this.clntPtr, path, policyIds, recursive, userInfo);
        if (ret != 0) {
            throw new IOException("Error " + Errno.toString((int)ret) + " returned while removing security policies for path" + path);
        }
        return ret;
    }

    public List<Dbserver.DataMask> getAllDataMasks(MapRConstants.ErrorValue err, MapRUserInfo userInfo) throws IOException {
        MapRDataMask[] dms = this.getalldatamasks(this.clntPtr, err, userInfo);
        if (dms == null) {
            if (err.error == 2) {
                throw new IOException("No data masks can be found");
            }
            throw new IOException("Error " + Errno.toString((int)err.error) + " in fetching data mask");
        }
        ArrayList<Dbserver.DataMask> dmList = new ArrayList<Dbserver.DataMask>();
        for (MapRDataMask dm : dms) {
            dmList.add(Dbserver.DataMask.newBuilder().setId(dm.getId()).setName(dm.getName()).setDesc(dm.getDescr()).addAllApp(Arrays.asList(dm.getApp())).build());
        }
        return dmList;
    }

    public Dbserver.DataMask getDataMask(String dmName, MapRConstants.ErrorValue err, MapRUserInfo userInfo) throws IOException {
        MapRDataMask dm = this.getdatamask(this.clntPtr, dmName, err, userInfo);
        if (dm == null) {
            if (err.error == 2) {
                throw new IOException("Data mask lookup of " + dmName + " failed, no such data mask");
            }
            throw new IOException("Error " + Errno.toString((int)err.error) + " in fetching data mask with name " + dmName);
        }
        return Dbserver.DataMask.newBuilder().setId(dm.getId()).setName(dm.getName()).setDesc(dm.getDescr()).addAllApp(Arrays.asList(dm.getApp())).build();
    }

    public String getDataMaskNameFromId(int id, MapRConstants.ErrorValue err, MapRUserInfo userInfo) throws IOException {
        String dmName = this.getdatamasknamefromid(this.clntPtr, id, err, userInfo);
        if (dmName == null) {
            if (err.error == 2) {
                throw new IOException("Data mask lookup of ID " + id + " failed, no such data mask");
            }
            throw new IOException("Error " + Errno.toString((int)err.error) + " in fetching data mask with id " + id);
        }
        return dmName;
    }

    public Dbserver.TabletLookupResponse getTabletsWithFid(String fid, byte[] stKey, byte[] endKey, boolean needSpaceUsage, boolean prefetchTabletMap, MapRConstants.ErrorValue err, MapRUserInfo userInfo) throws IOException {
        byte[] reply = this.gettabletswithfid(this.clntPtr, fid, stKey, endKey, needSpaceUsage, prefetchTabletMap, err, userInfo);
        if (reply == null) {
            throw new IOException("Reply to get tablets on table: " + fid + " is null.");
        }
        Dbserver.TabletLookupResponse lookupResp = Dbserver.TabletLookupResponse.parseFrom((byte[])reply);
        return lookupResp;
    }

    public void createColumnFamily(String tablePath, String name, Dbserver.ColumnFamilyAttr schFamily, MapRConstants.ErrorValue err, MapRUserInfo userInfo) throws IOException {
        this.createcolumnfamily(this.clntPtr, tablePath, name, schFamily.toByteArray(), err, userInfo);
    }

    public void modifyColumnFamily(String tablePath, String name, Dbserver.ColumnFamilyAttr schFamily, Dbserver.SecurityPolicyOperation securityPolicyOp, MapRConstants.ErrorValue err, MapRUserInfo userInfo) throws IOException {
        this.modifycolumnfamily(this.clntPtr, tablePath, name, schFamily.toByteArray(), securityPolicyOp.getNumber(), err, userInfo);
    }

    public void deleteColumnFamily(String tablePath, String name, MapRConstants.ErrorValue err, MapRUserInfo userInfo) throws IOException {
        this.deletecolumnfamily(this.clntPtr, tablePath, name, err, userInfo);
    }

    public List<Dbserver.ColumnFamilyAttr> listColumnFamily(String tablePath, boolean wantAces, MapRConstants.ErrorValue err, MapRUserInfo userInfo) throws IOException {
        return this.listColumnFamily(tablePath, wantAces, false, err, userInfo);
    }

    public List<Dbserver.ColumnFamilyAttr> listColumnFamily(String tablePath, boolean wantAces, boolean useCached, MapRConstants.ErrorValue err, MapRUserInfo userInfo) throws IOException {
        byte[] reply = this.listcolumnfamily(this.clntPtr, tablePath, wantAces, useCached, err, userInfo);
        return reply == null ? null : Dbserver.ColumnFamilyScanResponse.parseFrom((byte[])reply).getCfAttrListList();
    }

    public void modifyTableAttr(String tablePath, Dbserver.TableAttr am, Dbserver.TableAces aces, boolean genUuid, Dbserver.SecurityPolicyOperation securityPolicyOp, MapRConstants.ErrorValue err, MapRUserInfo userInfo) throws IOException {
        this.modifytableattr(this.clntPtr, tablePath, am.toByteArray(), aces.toByteArray(), genUuid, securityPolicyOp.getNumber(), err, userInfo);
    }

    public Dbserver.OpenBasicAttrs getTableBasicAttrs(String tablePath, MapRConstants.ErrorValue err, MapRUserInfo userInfo) throws IOException {
        byte[] reply = this.gettablebasicattrs(this.clntPtr, tablePath, err, userInfo);
        Dbserver.OpenBasicAttrs basicAttrs = null;
        if (reply != null) {
            basicAttrs = Dbserver.OpenBasicAttrs.parseFrom((byte[])reply);
        }
        return basicAttrs;
    }

    public TableProperties getTableProperties(String tablePath, MapRConstants.ErrorValue err, MapRUserInfo userInfo) throws IOException {
        byte[] reply = this.listcolumnfamily(this.clntPtr, tablePath, true, true, err, userInfo);
        if (reply == null) {
            return null;
        }
        Dbserver.ColumnFamilyScanResponse cfResp = Dbserver.ColumnFamilyScanResponse.parseFrom((byte[])reply);
        if (cfResp.hasAttr()) {
            byte[] uuid = cfResp.hasUuid() ? cfResp.getUuid().toByteArray() : null;
            Common.FidMsg fid = cfResp.hasTableFid() ? cfResp.getTableFid() : null;
            return new TableProperties(cfResp.getAttr(), cfResp.getTableAces(), uuid, cfResp.getAudit(), fid);
        }
        reply = this.gettableattr(this.clntPtr, tablePath, err, userInfo);
        if (reply == null) {
            return null;
        }
        Dbserver.GetTableSchemaResponse schemaResp = Dbserver.GetTableSchemaResponse.parseFrom((byte[])reply);
        byte[] uuid = schemaResp.hasUuid() ? schemaResp.getUuid().toByteArray() : null;
        Common.FidMsg fid = schemaResp.hasTableFid() ? schemaResp.getTableFid() : null;
        return new TableProperties(schemaResp.getAttr(), schemaResp.getTableAces(), uuid, schemaResp.getAudit(), fid);
    }

    public void splitTableRegion(String fidstr, boolean ignoreRegionTooSmallError, MapRConstants.ErrorValue err) throws IOException {
        this.splittableregion(this.clntPtr, fidstr, ignoreRegionTooSmallError, err);
    }

    public void packTableRegion(String fidstr, int ctype, MapRConstants.ErrorValue err) throws IOException {
        this.packtableregion(this.clntPtr, fidstr, ctype, err);
    }

    public void mergeTableRegion(String fidstr, MapRConstants.ErrorValue err) throws IOException {
        this.mergetableregion(this.clntPtr, fidstr, err);
    }

    public Dbserver.TabletStatResponse getTabletStat(Common.FidMsg fid, MapRConstants.ErrorValue err) throws IOException {
        String fidStr = Fids.fidToString(fid);
        byte[] reply = this.tabletstat(this.clntPtr, fidStr, err);
        if (reply == null) {
            throw new IOException("Reply to get tablet stat for fid: " + fidStr + " is null.");
        }
        return Dbserver.TabletStatResponse.parseFrom((byte[])reply);
    }

    public Dbserver.TableReplicaListResponse listTableDownstreams(String tablePath, boolean wantStats, boolean skipFieldsReadPermCheck, boolean refreshNow, TableDownstreamType type, boolean getCompactInfo, MapRConstants.ErrorValue err, MapRUserInfo userInfo) throws IOException {
        byte[] reply = null;
        reply = this.listtablereplicas(this.clntPtr, tablePath, wantStats, skipFieldsReadPermCheck, refreshNow, type == TableDownstreamType.Indexes, getCompactInfo, err, userInfo);
        if (reply == null) {
            throw new IOException("Reply to list replicas on table: " + tablePath + " is null.");
        }
        return Dbserver.TableReplicaListResponse.parseFrom((byte[])reply);
    }

    public int addTableReplica(String tablePath, Dbserver.TableReplicaDesc replica, Dbserver.TableReplAutoSetupInfo ainfo, MapRConstants.ErrorValue err, MapRUserInfo userInfo) throws IOException {
        return this.addtablereplica(this.clntPtr, tablePath, replica.toByteArray(), ainfo == null ? null : ainfo.toByteArray(), err, userInfo);
    }

    public void editTableReplica(String tablePath, String clusterName, String replicaPath, String topicName, boolean allowAllCfs, Dbserver.TableReplicaDesc replica, MapRConstants.ErrorValue err, MapRUserInfo userInfo) throws IOException {
        this.edittablereplica(this.clntPtr, tablePath, clusterName, replicaPath, topicName == null ? "" : topicName, allowAllCfs, replica.toByteArray(), err, userInfo);
    }

    public void removeTableReplica(String tablePath, Dbserver.TableReplicaDesc replica, MapRConstants.ErrorValue err, MapRUserInfo userInfo) throws IOException {
        this.removetablereplica(this.clntPtr, tablePath, replica.toByteArray(), err, userInfo);
    }

    public void addTableUpstream(String tablePath, Dbserver.TableUpstreamDesc upstream, MapRConstants.ErrorValue err, MapRUserInfo userInfo) throws IOException {
        this.addtableupstream(this.clntPtr, tablePath, upstream.toByteArray(), err, userInfo);
    }

    public Dbserver.TableUpstreamListResponse listTableUpstreams(String tablePath, MapRConstants.ErrorValue err, MapRUserInfo userInfo) throws IOException {
        byte[] reply = this.listtableupstreams(this.clntPtr, tablePath, err, userInfo);
        if (reply == null) {
            throw new IOException("Reply to list Upstreams on table: " + tablePath + " is null.");
        }
        return Dbserver.TableUpstreamListResponse.parseFrom((byte[])reply);
    }

    public void removeTableUpstream(String tablePath, Dbserver.TableUpstreamDesc upstream, MapRConstants.ErrorValue err, MapRUserInfo userInfo) throws IOException {
        this.removetableupstream(this.clntPtr, tablePath, upstream.toByteArray(), err, userInfo);
    }

    public byte[] getContainerInfo(int[] cids, MapRConstants.ErrorValue err, MapRUserInfo userInfo) {
        return this.getContainerInfo(this.clntPtr, cids, err, userInfo);
    }

    public String getServerForCid(int cid, MapRConstants.ErrorValue err) throws IOException {
        return this.getServerForCid(this.clntPtr, cid, err);
    }

    private synchronized void refreshZkConnectString() {
        this.cachedZKString.refresh((Object)0);
    }

    private synchronized void resetJobTrackerWatcher() {
        this.refreshZkConnectString();
        if (this.jtwatcher != null) {
            this.jtwatcher.close();
            this.jtwatcher = null;
        }
    }

    private synchronized QueryServiceWatcher queryServiceWatcher() throws IOException {
        String zkConnectString = this.getZkConnectString();
        if (this.doNotUseDirectlyQSWatcher == null) {
            if (zkConnectString != null && !zkConnectString.isEmpty()) {
                this.doNotUseDirectlyQSWatcher = new QueryServiceWatcher(zkConnectString, this.clusterName);
                if (!this.doNotUseDirectlyQSWatcher.connect()) {
                    this.resetQueryServiceWatcher();
                    throw new IOException(String.format("Failed to connect to Zookeeper at `%s` for cluster `%s`", zkConnectString, this.getClusterName()));
                }
            } else {
                throw new IOException("Failed to get Zookeeper information for cluster " + this.getClusterName());
            }
        }
        return this.doNotUseDirectlyQSWatcher;
    }

    private synchronized void resetQueryServiceWatcher() {
        this.refreshZkConnectString();
        if (this.doNotUseDirectlyQSWatcher != null) {
            this.doNotUseDirectlyQSWatcher.close();
            this.doNotUseDirectlyQSWatcher = null;
        }
    }

    public byte[] creates3bucket(String parentName, String bktName, MapRConstants.ErrorValue err, MapRUserInfo userInfo, String domain, int aId, boolean worm, long ownwerUid) {
        return this.creates3bucket(this.clntPtr, parentName, bktName, err, userInfo, domain, aId, worm, ownwerUid);
    }

    public byte[] removeS3bucket(String bucketName, MapRConstants.ErrorValue err, MapRUserInfo userInfo, String domainName) {
        return this.removes3bucket(this.clntPtr, bucketName, err, userInfo, domainName);
    }

    public static enum TableDownstreamType {
        Replica,
        Indexes;

    }
}

