/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.org.apache.hadoop.metrics.spi;

import com.mapr.org.apache.hadoop.classification.InterfaceAudience;
import com.mapr.org.apache.hadoop.classification.InterfaceStability;
import com.mapr.org.apache.hadoop.metrics.MetricsException;
import com.mapr.org.apache.hadoop.metrics.MetricsRecord;
import com.mapr.org.apache.hadoop.metrics.spi.AbstractMetricsContext;
import com.mapr.org.apache.hadoop.metrics.spi.MetricValue;
import com.mapr.org.apache.hadoop.metrics.spi.OutputRecord;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class MetricsRecordImpl
implements MetricsRecord {
    private AbstractMetricsContext.TagMap tagTable = new AbstractMetricsContext.TagMap();
    private Map<String, MetricValue> metricTable = new LinkedHashMap<String, MetricValue>();
    private String recordName;
    private AbstractMetricsContext context;

    protected MetricsRecordImpl(String recordName, AbstractMetricsContext context) {
        this.recordName = recordName;
        this.context = context;
    }

    @Override
    public String getRecordName() {
        return this.recordName;
    }

    @Override
    public void setTag(String tagName, String tagValue) {
        if (tagValue == null) {
            tagValue = "";
        }
        this.tagTable.put(tagName, tagValue);
    }

    @Override
    public void setTag(String tagName, int tagValue) {
        this.tagTable.put(tagName, tagValue);
    }

    @Override
    public void setTag(String tagName, long tagValue) {
        this.tagTable.put(tagName, tagValue);
    }

    @Override
    public void setTag(String tagName, short tagValue) {
        this.tagTable.put(tagName, tagValue);
    }

    @Override
    public void setTag(String tagName, byte tagValue) {
        this.tagTable.put(tagName, tagValue);
    }

    @Override
    public void removeTag(String tagName) {
        this.tagTable.remove(tagName);
    }

    @Override
    public void setMetric(String metricName, int metricValue) {
        this.setAbsolute(metricName, metricValue);
    }

    @Override
    public void setMetric(String metricName, long metricValue) {
        this.setAbsolute(metricName, metricValue);
    }

    @Override
    public void setMetric(String metricName, short metricValue) {
        this.setAbsolute(metricName, metricValue);
    }

    @Override
    public void setMetric(String metricName, byte metricValue) {
        this.setAbsolute(metricName, metricValue);
    }

    @Override
    public void setMetric(String metricName, float metricValue) {
        this.setAbsolute(metricName, new Float(metricValue));
    }

    @Override
    public void incrMetric(String metricName, int metricValue) {
        this.setIncrement(metricName, metricValue);
    }

    @Override
    public void incrMetric(String metricName, long metricValue) {
        this.setIncrement(metricName, metricValue);
    }

    @Override
    public void incrMetric(String metricName, short metricValue) {
        this.setIncrement(metricName, metricValue);
    }

    @Override
    public void incrMetric(String metricName, byte metricValue) {
        this.setIncrement(metricName, metricValue);
    }

    @Override
    public void incrMetric(String metricName, float metricValue) {
        this.setIncrement(metricName, new Float(metricValue));
    }

    private void setAbsolute(String metricName, Number metricValue) {
        this.metricTable.put(metricName, new MetricValue(metricValue, false));
    }

    private void setIncrement(String metricName, Number metricValue) {
        this.metricTable.put(metricName, new MetricValue(metricValue, true));
    }

    @Override
    public void update() {
        this.context.update(this);
    }

    @Override
    public void remove() {
        this.context.remove(this);
    }

    AbstractMetricsContext.TagMap getTagTable() {
        return this.tagTable;
    }

    Map<String, MetricValue> getMetricTable() {
        return this.metricTable;
    }

    public Set<String> getTagNames() {
        return Collections.unmodifiableSet(this.tagTable.keySet());
    }

    public OutputRecord createOutputRecord() {
        HashSet<Map.Entry<String, MetricValue>> entrySet = new HashSet<Map.Entry<String, MetricValue>>(this.metricTable.entrySet());
        AbstractMetricsContext.TagMap copyTagMap = new AbstractMetricsContext.TagMap(this.tagTable);
        AbstractMetricsContext.MetricMap metricMap = new AbstractMetricsContext.MetricMap();
        for (Map.Entry entry : entrySet) {
            String metricName = (String)entry.getKey();
            MetricValue updateValue = (MetricValue)entry.getValue();
            Number updateNumber = updateValue.getNumber();
            Number currentNumber = (Number)metricMap.get(metricName);
            if (currentNumber == null || updateValue.isAbsolute()) {
                metricMap.put(metricName, updateNumber);
                continue;
            }
            Number newNumber = this.sum(updateNumber, currentNumber);
            metricMap.put(metricName, newNumber);
        }
        OutputRecord retRecord = new OutputRecord(copyTagMap, metricMap);
        return retRecord;
    }

    private Number sum(Number a, Number b) {
        if (a instanceof Integer) {
            return a.intValue() + b.intValue();
        }
        if (a instanceof Float) {
            return new Float(a.floatValue() + b.floatValue());
        }
        if (a instanceof Short) {
            return (short)(a.shortValue() + b.shortValue());
        }
        if (a instanceof Byte) {
            return (byte)(a.byteValue() + b.byteValue());
        }
        if (a instanceof Long) {
            return a.longValue() + b.longValue();
        }
        throw new MetricsException("Invalid number type");
    }
}

