/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.org.apache.hadoop.metrics;

import com.mapr.org.apache.hadoop.classification.InterfaceAudience;
import com.mapr.org.apache.hadoop.classification.InterfaceStability;
import com.mapr.org.apache.hadoop.metrics.MetricsContext;
import com.mapr.org.apache.hadoop.metrics.spi.NullContext;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

@InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce"})
@InterfaceStability.Evolving
public class ContextFactory {
    private static final String PROPERTIES_FILE = "/hadoop-metrics.properties";
    private static final String CONTEXT_CLASS_SUFFIX = ".class";
    private static final String DEFAULT_CONTEXT_CLASSNAME = "com.mapr.org.apache.hadoop.metrics.spi.NullContext";
    private static ContextFactory theFactory = null;
    private Map<String, Object> attributeMap = new HashMap<String, Object>();
    private Map<String, MetricsContext> contextMap = new HashMap<String, MetricsContext>();
    private static Map<String, MetricsContext> nullContextMap = new HashMap<String, MetricsContext>();

    protected ContextFactory() {
    }

    public Object getAttribute(String attributeName) {
        return this.attributeMap.get(attributeName);
    }

    public String[] getAttributeNames() {
        String[] result = new String[this.attributeMap.size()];
        int i = 0;
        Iterator<String> it = this.attributeMap.keySet().iterator();
        while (it.hasNext()) {
            result[i++] = it.next();
        }
        return result;
    }

    public void setAttribute(String attributeName, Object value) {
        this.attributeMap.put(attributeName, value);
    }

    public void removeAttribute(String attributeName) {
        this.attributeMap.remove(attributeName);
    }

    public synchronized MetricsContext getContext(String refName, String contextName) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        MetricsContext metricsContext = this.contextMap.get(refName);
        if (metricsContext == null) {
            String classNameAttribute = refName + CONTEXT_CLASS_SUFFIX;
            String className = (String)this.getAttribute(classNameAttribute);
            if (className == null) {
                className = DEFAULT_CONTEXT_CLASSNAME;
            }
            Class<?> contextClass = Class.forName(className);
            metricsContext = (MetricsContext)contextClass.newInstance();
            metricsContext.init(contextName, this);
            this.contextMap.put(contextName, metricsContext);
        }
        return metricsContext;
    }

    public synchronized MetricsContext getContext(String contextName) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        return this.getContext(contextName, contextName);
    }

    public synchronized Collection<MetricsContext> getAllContexts() {
        return new ArrayList<MetricsContext>(this.contextMap.values());
    }

    public static synchronized MetricsContext getNullContext(String contextName) {
        MetricsContext nullContext = nullContextMap.get(contextName);
        if (nullContext == null) {
            nullContext = new NullContext();
            nullContextMap.put(contextName, nullContext);
        }
        return nullContext;
    }

    public static synchronized ContextFactory getFactory() throws IOException {
        if (theFactory == null) {
            theFactory = new ContextFactory();
            theFactory.setAttributes();
        }
        return theFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setAttributes() throws IOException {
        InputStream is = this.getClass().getResourceAsStream(PROPERTIES_FILE);
        if (is != null) {
            try {
                Properties properties = new Properties();
                properties.load(is);
                for (String string : properties.keySet()) {
                    String propertyValue = properties.getProperty(string);
                    this.setAttribute(string, propertyValue);
                }
            }
            finally {
                is.close();
            }
        }
    }
}

