/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs;

import com.google.protobuf.ByteString;
import com.mapr.fs.jni.IndexSyncStateTracker;
import com.mapr.fs.jni.JNILoggerProxy;
import com.mapr.fs.proto.Dbserver;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class PutLogger {
    private JNILoggerProxy LOG;
    final int MAX_PUTS = 10;
    final int EXPECTED_PUTS_PER_RANGE = 2;
    public static final int MAX_RANGES_PER_CONTEXT = 10;
    long numPuts;
    long maxTs;
    TreeMap<ByteArrayWrapper, CommitRange> ranges;

    public PutLogger(JNILoggerProxy logger) {
        this.LOG = logger;
        this.ranges = new TreeMap();
        this.numPuts = 0L;
    }

    public void printRanges() {
        Iterator<Map.Entry<ByteArrayWrapper, CommitRange>> rangeItr = this.ranges.entrySet().iterator();
        System.out.println("Total ranges: " + this.ranges.size());
        while (rangeItr.hasNext()) {
            Map.Entry<ByteArrayWrapper, CommitRange> range = rangeItr.next();
            System.out.println("[" + new String(range.getValue().startKey.array()) + " - " + new String(range.getValue().endKey.array()) + ") : keys " + range.getValue().numPutsInRange);
        }
    }

    public TreeMap<ByteArrayWrapper, CommitRange> getRanges() {
        return this.ranges;
    }

    public void addNewPut(byte[] key) {
        this.addNewPut(new ByteArrayWrapper(key), 1);
    }

    public void addNewPut(ByteBuffer key) {
        this.addNewPut(new ByteArrayWrapper(key), 1);
    }

    private void addNewPut(ByteArrayWrapper key, int expectedPuts) {
        this.numPuts += (long)expectedPuts;
        Map.Entry<ByteArrayWrapper, CommitRange> floorEntry = this.ranges.floorEntry(key);
        CommitRange floorRange = null;
        if (floorEntry != null && (floorRange = floorEntry.getValue()).coversKey(key)) {
            floorRange.incrementPuts(1L);
            return;
        }
        if (this.ranges.size() < 10) {
            this.ranges.put(key, new CommitRange(key));
            return;
        }
        if (floorRange == null) {
            Map.Entry<ByteArrayWrapper, CommitRange> ceilingEntry = this.ranges.ceilingEntry(key);
            CommitRange range = ceilingEntry.getValue();
            this.ranges.remove(range.startKey);
            range.startKey = key;
            range.numPutsInRange += (long)expectedPuts;
            this.ranges.put(key, range);
            return;
        }
        floorRange.extend(key, 1);
    }

    public void addNewRange(ByteBuffer sKey, ByteBuffer eKey, int expectedPuts) {
        this.addNewRange(new ByteArrayWrapper(sKey), new ByteArrayWrapper(eKey), expectedPuts);
    }

    public void addNewRange(ByteArrayWrapper sKey, ByteArrayWrapper eKey, int expectedPuts) {
        Map.Entry<ByteArrayWrapper, CommitRange> floorSEntry = this.ranges.floorEntry(sKey);
        Map.Entry<ByteArrayWrapper, CommitRange> floorEEntry = this.ranges.floorEntry(eKey);
        while (floorSEntry == null && floorEEntry != null || floorSEntry != null && floorEEntry != null && floorSEntry.getKey().compareTo(floorEEntry.getKey()) != 0) {
            CommitRange range = floorEEntry.getValue();
            expectedPuts = (int)((long)expectedPuts + range.numPutsInRange);
            range.endKey = null;
            this.ranges.remove(range.startKey);
            floorEEntry = this.ranges.floorEntry(eKey);
        }
        if (floorSEntry == null) {
            if (this.ranges.size() < 10) {
                this.ranges.put(sKey, new CommitRange(sKey, eKey, expectedPuts));
            } else {
                this.addNewPut(sKey, expectedPuts);
            }
            return;
        }
        if (floorSEntry.getValue().coversKey(eKey)) {
            floorSEntry.getValue().incrementPuts(expectedPuts);
            return;
        }
        if (!floorSEntry.getValue().coversKey(sKey)) {
            if (this.ranges.size() < 10) {
                this.ranges.put(sKey, new CommitRange(sKey, eKey, expectedPuts));
                return;
            }
        } else {
            floorSEntry.getValue().extend(eKey, expectedPuts - 1);
            return;
        }
        floorSEntry.getValue().extend(eKey, expectedPuts);
    }

    public void mergeCommitContext(Dbserver.CommitContext ctx) {
        for (int i = 0; i < ctx.getCtxElemsCount(); ++i) {
            Dbserver.CommitContext.CommitContextElement elem = ctx.getCtxElems(i);
            if (elem.getEndkeyCount() == 0) {
                this.addNewPut(elem.getStartkey(0).toByteArray());
                ++this.numPuts;
                continue;
            }
            this.numPuts += 2L;
            this.addNewRange(new ByteArrayWrapper(elem.getStartkey(0).toByteArray()), new ByteArrayWrapper(elem.getEndkey(0).toByteArray()), 2);
        }
        if (ctx.getTimestamp() > this.maxTs) {
            this.maxTs = ctx.getTimestamp();
        }
    }

    public void setMaxTimestamp(long m) {
        if (m > this.maxTs) {
            this.maxTs = m;
        }
    }

    public long getMaxTimestamp() {
        return this.maxTs;
    }

    public int numRanges() {
        return this.ranges.size();
    }

    public Dbserver.CommitContext getCommitContext() {
        int numRanges = this.ranges.size();
        int numRangesPerMerge = numRanges / 10;
        if (numRangesPerMerge > 0 && numRanges / numRangesPerMerge > 10 && numRanges % 10 != 0) {
            ++numRangesPerMerge;
        }
        Dbserver.CommitContext.Builder ctxBuilder = Dbserver.CommitContext.newBuilder();
        Iterator<Map.Entry<ByteArrayWrapper, CommitRange>> entryItr = this.ranges.entrySet().iterator();
        int i = 0;
        int numRangeSlots = 10;
        while (entryItr.hasNext()) {
            Map.Entry<ByteArrayWrapper, CommitRange> entry = entryItr.next();
            ByteArrayWrapper key = entry.getKey();
            Dbserver.CommitContext.CommitContextElement.Builder ctxElemBuilder = Dbserver.CommitContext.CommitContextElement.newBuilder();
            ctxElemBuilder.addStartkey(ByteString.copyFrom((byte[])key.array()));
            CommitRange range = entry.getValue();
            if (numRanges - ++i >= numRangeSlots) {
                for (int j = 1; j < numRangesPerMerge && entryItr.hasNext(); ++j) {
                    entry = entryItr.next();
                    range = entry.getValue();
                    ++i;
                }
            }
            byte[] startKey = key.array();
            byte[] endKey = range.endKey.array();
            if (endKey.length != startKey.length + 1 || endKey[endKey.length - 1] != 0 || !Arrays.equals(startKey, Arrays.copyOfRange(endKey, 0, endKey.length - 1))) {
                ctxElemBuilder.addEndkey(ByteString.copyFrom((byte[])range.endKey.array()));
            }
            ctxBuilder.addCtxElems(ctxElemBuilder.build());
            --numRangeSlots;
        }
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug((Object)(">getCommitContext() num ranges " + i + " ts " + this.maxTs));
        }
        ctxBuilder.setTimestamp(this.maxTs);
        return ctxBuilder.build();
    }

    public boolean coversKey(ByteBuffer key) {
        ByteArrayWrapper kWrapper = new ByteArrayWrapper(key);
        Map.Entry<ByteArrayWrapper, CommitRange> floorEntry = this.ranges.floorEntry(kWrapper);
        return floorEntry.getValue().coversKey(kWrapper);
    }

    public IndexSyncStateTracker createIndexSyncStateTracker(long clusterP, long fileP) throws IOException {
        if (this.ranges.size() == 0) {
            return new IndexSyncStateTracker(this.LOG).setIndexesSynced();
        }
        int numRanges = this.ranges.size();
        byte[][] startKeys = new byte[numRanges][];
        byte[][] endKeys = new byte[numRanges][];
        Iterator<Map.Entry<ByteArrayWrapper, CommitRange>> entryItr = this.ranges.entrySet().iterator();
        int i = 0;
        while (entryItr.hasNext()) {
            CommitRange range = entryItr.next().getValue();
            startKeys[i] = range.startKey.array();
            endKeys[i] = range.endKey.array();
            ++i;
        }
        return new IndexSyncStateTracker(clusterP, fileP, (byte[][])startKeys, (byte[][])endKeys, this.maxTs, this.LOG);
    }

    public class CommitRange {
        public ByteArrayWrapper startKey;
        public ByteArrayWrapper endKey;
        public long numPutsInRange;

        CommitRange(ByteArrayWrapper sKey, ByteArrayWrapper eKey, long numPuts) {
            this.startKey = sKey;
            this.endKey = eKey;
            this.numPutsInRange = numPuts;
        }

        CommitRange(ByteArrayWrapper sKey) {
            this.startKey = sKey;
            this.endKey = new ByteArrayWrapper(Arrays.copyOf(sKey.array(), sKey.array().length + 1));
            this.numPutsInRange = 1L;
            PutLogger.this.maxTs = 0L;
        }

        public void incrementPuts(long num) {
            this.numPutsInRange += num;
        }

        public boolean coversKey(ByteArrayWrapper kWrapper) {
            int startKeyComp = this.startKey.compareTo(kWrapper);
            int endKeyComp = this.endKey.compareTo(kWrapper);
            return startKeyComp <= 0 && endKeyComp > 0;
        }

        public void extend(ByteArrayWrapper key, int numPuts) {
            this.endKey = new ByteArrayWrapper(Arrays.copyOf(key.array(), key.array().length + 1));
            this.numPutsInRange += (long)numPuts;
        }
    }

    public class ByteArrayWrapper
    implements Comparable {
        byte[] arr;

        public ByteArrayWrapper(ByteBuffer a) {
            this.arr = a.array();
        }

        public ByteArrayWrapper(byte[] a) {
            this.arr = a;
        }

        public byte[] array() {
            return this.arr;
        }

        public int hashCode() {
            return Arrays.hashCode(this.arr);
        }

        public int compareTo(Object other) {
            if (!(other instanceof ByteArrayWrapper)) {
                return 1;
            }
            ByteArrayWrapper b = (ByteArrayWrapper)other;
            int cmpLen = this.arr.length < b.arr.length ? this.arr.length : b.arr.length;
            for (int i = 0; i < cmpLen; ++i) {
                if (this.arr[i] == b.arr[i]) continue;
                return this.arr[i] - b.arr[i];
            }
            if (cmpLen < this.arr.length) {
                return 1;
            }
            if (cmpLen < b.arr.length) {
                return -1;
            }
            return 0;
        }
    }
}

