/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs;

import com.mapr.fs.proto.Common;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class MapRDbParser {
    public static byte[] getBytesFromInteger(int value) {
        return ByteBuffer.allocate(4).putInt(value).array();
    }

    public static int getIntegerFromBytes(byte[] bytes) {
        return ByteBuffer.wrap(bytes).getInt();
    }

    public static byte[] getBytesFromLong(long value) {
        return ByteBuffer.allocate(8).putLong(value).array();
    }

    public static long getLongFromBytes(byte[] bytes) {
        return ByteBuffer.wrap(bytes).getLong();
    }

    public static Common.FidMsg getFidFromBytes(byte[] bytes) {
        if (bytes.length < 16) {
            return null;
        }
        return Common.FidMsg.newBuilder().setCid(MapRDbParser.getIntegerFromBytes(Arrays.copyOfRange(bytes, 4, 8))).setCinum(MapRDbParser.getIntegerFromBytes(Arrays.copyOfRange(bytes, 8, 12))).setUniq(MapRDbParser.getIntegerFromBytes(Arrays.copyOfRange(bytes, 12, 16))).build();
    }

    public static boolean getBooleanFromByte(byte[] bytes) {
        return (bytes[0] & 0xFF) != 0;
    }
}

