/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs;

import com.google.common.base.Preconditions;
import com.mapr.fs.RetryException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceWatcher
implements Watcher {
    private static final Logger logger = LoggerFactory.getLogger(ServiceWatcher.class);
    private static final int ZK_CONNECTION_TIMEOUT_MS = 30000;
    private final String clusterName;
    private final String zkConnectString;
    private ZooKeeper zookeeper;
    private volatile boolean isConnected = false;
    private CountDownLatch lock = new CountDownLatch(1);

    public ServiceWatcher(String zkConnectString, String clusterName) {
        this.clusterName = clusterName;
        this.zkConnectString = (String)Preconditions.checkNotNull((Object)zkConnectString);
        this.isConnected = false;
    }

    public String getZKString() {
        return this.zkConnectString;
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    public synchronized boolean connect() {
        try {
            this.init_zookeeper();
            while (!this.lock.await(30000L, TimeUnit.MILLISECONDS)) {
                logger.error("Could not connect to ZK within: {}ms. Check if ZK connection defined correctly: {}. No data from ZK will be returned.", (Object)30000, (Object)this.zkConnectString);
            }
            logger.debug("Connected to ZK: {}", (Object)this.zkConnectString);
        }
        catch (IOException e) {
            logger.error("Could not create ZooKeeper instance.", (Throwable)e);
            return false;
        }
        catch (InterruptedException e) {
            logger.error("InterruptedException during wait for ZK to be connected");
            return false;
        }
        return true;
    }

    public synchronized boolean reconnect() {
        this.close();
        return this.connect();
    }

    public void close() {
        if (this.zookeeper == null) {
            return;
        }
        try {
            this.zookeeper.close();
        }
        catch (InterruptedException e) {
            logger.error("Unable to close ZooKeeper connection", (Throwable)e);
        }
        finally {
            this.zookeeper = null;
        }
    }

    public void process(WatchedEvent event) {
        String path = event.getPath();
        logger.trace("Process path: {}, Event state: {}, Event type: {}.", new Object[]{path, event.getState(), event.getType()});
        if (event.getState() == Watcher.Event.KeeperState.SyncConnected) {
            this.lock.countDown();
        }
    }

    protected byte[] getData(String nodePath) throws InterruptedException, KeeperException, RetryException, FileNotFoundException, IOException {
        return this.applyZooKeeperFunction(new KeeperFunction<String, byte[]>(){

            @Override
            public byte[] apply(String nodePath) throws InterruptedException, KeeperException {
                Stat stat = ServiceWatcher.this.zookeeper.exists(nodePath, false);
                return ServiceWatcher.this.zookeeper.getData(nodePath, false, stat);
            }
        }, nodePath);
    }

    protected Void delete(String path) throws InterruptedException, KeeperException, RetryException, FileNotFoundException, IOException {
        return this.applyZooKeeperFunction(new KeeperFunction<String, Void>(){

            @Override
            public Void apply(String path) throws InterruptedException, KeeperException {
                ServiceWatcher.this.zookeeper.delete(path, -1);
                return null;
            }
        }, path);
    }

    protected String create(String path, byte[] data, List<ACL> acl, CreateMode createMode) throws InterruptedException, KeeperException, RetryException, FileNotFoundException, IOException {
        return this.applyZooKeeperFunction(new KeeperFunction<Object[], String>(){

            @Override
            public String apply(Object[] args) throws InterruptedException, KeeperException {
                Preconditions.checkArgument((args.length == 4 ? 1 : 0) != 0);
                return ServiceWatcher.this.zookeeper.create((String)args[0], (byte[])args[1], (List)args[2], (CreateMode)args[3]);
            }
        }, new Object[]{path, data, acl, createMode});
    }

    protected List<String> getChildren(String nodePath) throws RetryException, FileNotFoundException, IOException, InterruptedException, KeeperException {
        return this.applyZooKeeperFunction(new KeeperFunction<String, List<String>>(){

            @Override
            public List<String> apply(String nodePath) throws InterruptedException, KeeperException {
                return ServiceWatcher.this.zookeeper.getChildren(nodePath, false);
            }
        }, nodePath);
    }

    private <T, R> R applyZooKeeperFunction(KeeperFunction<T, R> function, T args) throws InterruptedException, IOException, RetryException, FileNotFoundException, KeeperException {
        try {
            return function.apply(args);
        }
        catch (KeeperException.NoNodeException bailoutException) {
            throw (FileNotFoundException)new FileNotFoundException().initCause(bailoutException);
        }
        catch (KeeperException.OperationTimeoutException kto) {
            throw new RetryException(kto);
        }
        catch (KeeperException.ConnectionLossException | KeeperException.SessionExpiredException | KeeperException.SessionMovedException reconnectException) {
            throw reconnectException;
        }
        catch (KeeperException e) {
            String msg = String.format("While trying to apply Zookeeper operation, received %s. Can not reconnect to zookeeper service for %s. Bailing out.", e.getMessage(), this.getZKString());
            logger.error(msg);
            logger.debug(e.getMessage(), (Throwable)e);
            throw new IOException(msg, e);
        }
    }

    private void init_zookeeper() throws IOException {
        try {
            this.zookeeper = new ZooKeeper(this.zkConnectString, 30000, (Watcher)this, this.clusterName);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        if (this.zookeeper == null) {
            this.zookeeper = new ZooKeeper(this.zkConnectString, 30000, (Watcher)this);
        }
    }

    @FunctionalInterface
    private static interface KeeperFunction<T, R> {
        public R apply(T var1) throws InterruptedException, KeeperException;
    }
}

