/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs.hbase.test;

import com.mapr.fs.hbase.HTableDescriptorProxy;
import com.mapr.fs.hbase.tools.mapreduce.SegKeyRangeUtil;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.util.Bytes;

public class TestAtomicOps {
    public static boolean creatTable(String tableName, String[] familys, Configuration conf) throws Exception {
        HBaseAdmin admin = new HBaseAdmin(conf);
        if (admin.tableExists(tableName)) {
            System.out.println("table already exists!");
            return false;
        }
        HTableDescriptor tableDesc = new HTableDescriptor(tableName);
        for (int i = 0; i < familys.length; ++i) {
            HTableDescriptorProxy.addFamily((HTableDescriptor)tableDesc, (HColumnDescriptor)new HColumnDescriptor(familys[i]));
        }
        admin.createTable(tableDesc);
        System.out.println("create table " + tableName + " ok.");
        return true;
    }

    public static boolean tablesAreSame(HTable ht1, HTable ht2, Scan scan) throws Exception {
        ArrayList<Result> ht1rs = new ArrayList<Result>();
        ResultScanner rs1 = ht1.getScanner(scan);
        System.out.println("--------" + ht1.getName() + " Scan Results---------");
        for (Object result : rs1) {
            System.out.println(SegKeyRangeUtil.resultToString((Result)result));
            ht1rs.add((Result)result);
        }
        rs1.close();
        ArrayList<Result> ht2rs = new ArrayList<Result>();
        ResultScanner rs2 = ht2.getScanner(scan);
        System.out.println("--------" + ht2.getName() + " Scan Results---------");
        for (Result result : rs2) {
            System.out.println(SegKeyRangeUtil.resultToString((Result)result));
            ht2rs.add(result);
        }
        rs2.close();
        if (ht1rs.size() != ht2rs.size()) {
            System.out.println("Different: " + ht1.getName() + " has " + ht1rs.size() + " entries, but " + ht2.getName() + " has " + ht2rs.size() + " entries");
        }
        for (int i = 0; i < ht1rs.size(); ++i) {
            Result r1 = (Result)ht1rs.get(i);
            Result r2 = (Result)ht2rs.get(i);
            if (r1.size() != r2.size()) {
                System.out.println("Different: result " + i + " has different size");
                return false;
            }
            Cell[] cs1 = r1.rawCells();
            Cell[] cs2 = r2.rawCells();
            for (int j = 0; j < r1.size(); ++j) {
                if (!Bytes.equals((byte[])cs1[j].getRowArray(), (int)cs1[j].getRowOffset(), (int)cs1[j].getRowLength(), (byte[])cs2[j].getRowArray(), (int)cs2[j].getRowOffset(), (int)cs2[j].getRowLength())) {
                    System.out.println("Different: result " + i + " cell " + j + " has different row key " + Bytes.toStringBinary((byte[])cs1[j].getRowArray()) + ", and " + Bytes.toStringBinary((byte[])cs2[j].getRowArray()));
                    return false;
                }
                if (!Bytes.equals((byte[])cs1[j].getFamilyArray(), (int)cs1[j].getFamilyOffset(), (int)cs1[j].getFamilyLength(), (byte[])cs2[j].getFamilyArray(), (int)cs2[j].getFamilyOffset(), (int)cs2[j].getFamilyLength())) {
                    System.out.println("Different: result " + i + " cell " + j + " has different family " + Bytes.toStringBinary((byte[])cs1[j].getFamilyArray()) + ", and " + Bytes.toStringBinary((byte[])cs2[j].getFamilyArray()));
                    return false;
                }
                if (!Bytes.equals((byte[])cs1[j].getQualifierArray(), (int)cs1[j].getQualifierOffset(), (int)cs1[j].getQualifierLength(), (byte[])cs2[j].getQualifierArray(), (int)cs2[j].getQualifierOffset(), (int)cs2[j].getQualifierLength())) {
                    System.out.println("Different: result " + i + " cell " + j + " has different qualifier " + Bytes.toStringBinary((byte[])cs1[j].getQualifierArray()) + ", and " + Bytes.toStringBinary((byte[])cs2[j].getQualifierArray()));
                    return false;
                }
                if (cs1[j].getValueLength() != cs2[j].getValueLength()) {
                    System.out.println("Different: result " + i + " cell " + j + " has different value size " + cs1[j].getValueLength() + ", and " + cs2[j].getValueLength());
                    return false;
                }
                if (Bytes.equals((byte[])cs1[j].getValueArray(), (int)cs1[j].getValueOffset(), (int)cs1[j].getValueLength(), (byte[])cs2[j].getValueArray(), (int)cs2[j].getValueOffset(), (int)cs2[j].getValueLength())) continue;
                System.out.println("Different: result " + i + " cell " + j + " has different value " + Bytes.toStringBinary((byte[])cs1[j].getValueArray()) + ", and " + Bytes.toStringBinary((byte[])cs2[j].getValueArray()));
                return false;
            }
        }
        System.out.println("Same:" + ht1.getName() + " and " + ht2.getName());
        return true;
    }

    public static void assertOpsNotRun(boolean ret1, boolean ret2, boolean tsame, String opname) {
        if (!ret1 && !ret2 && tsame) {
            System.out.println("Test Pass: " + opname + " for mismatched value does not change value");
        } else if (ret1 || ret2) {
            System.out.println("Test Fail: " + opname + " for mismatched value should not run");
        } else {
            System.out.println("Test Fail: after run " + opname + ", tables are different.");
        }
        assert (!ret1 && !ret2 && tsame);
    }

    public static void assertOpsRun(boolean ret1, boolean ret2, boolean tsame, String opname) {
        if (ret1 && ret2 && tsame) {
            System.out.println("Test Pass: after run " + opname + ", tables are same.");
        } else if (!ret1 || !ret2) {
            System.out.println("Test Fail: " + opname + " for matched value should run");
        } else {
            System.out.println("Test Fail: after run " + opname + ", tables are different.");
        }
        assert (ret1 && ret2 && tsame);
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            System.out.println("Compare the CheckAndMutate result between two tables, used to test CheckAndMutate behavior for mapr and hbase tables. Usage:\n\t hbase com.mapr.fs.hbase.test.TestAtomicOps tableA tableB zkQuorumIP zkClientPort");
            return;
        }
        byte[] row0 = Bytes.toBytes((String)"surow0");
        byte[] row1 = Bytes.toBytes((String)"surow1");
        byte[] row2 = Bytes.toBytes((String)"surow2");
        byte[] row3 = Bytes.toBytes((String)"surow3");
        byte[] fam0 = Bytes.toBytes((String)"fam0");
        byte[] fam1 = Bytes.toBytes((String)"fam1");
        byte[] famx = Bytes.toBytes((String)"famx");
        byte[] qual0 = Bytes.toBytes((String)"col0");
        byte[] qual1 = Bytes.toBytes((String)"col1");
        byte[] qual2 = Bytes.toBytes((String)"col2");
        byte[] qualx = Bytes.toBytes((String)"colx");
        byte[] valempty = Bytes.toBytes((String)"");
        byte[] valnull = null;
        byte[] r0val00 = Bytes.toBytes((String)"surow0-val00");
        byte[] r0val01 = Bytes.toBytes((String)"surow0-val01");
        byte[] r0val02 = Bytes.toBytes((String)"surow0-val02");
        byte[] r0val10 = Bytes.toBytes((String)"surow0-val10");
        byte[] r0val11 = Bytes.toBytes((String)"surow0-val11");
        byte[] r0val12 = Bytes.toBytes((String)"surow0-val12");
        byte[] r1val00 = Bytes.toBytes((String)"surow1-val00");
        byte[] r1val01 = Bytes.toBytes((String)"surow1-val01");
        byte[] r1val02 = Bytes.toBytes((String)"surow1-val02");
        byte[] r1val10 = Bytes.toBytes((String)"surow1-val10");
        byte[] r1val11 = Bytes.toBytes((String)"surow1-val11");
        byte[] r1val12 = Bytes.toBytes((String)"surow1-val12");
        byte[] r3val00 = Bytes.toBytes((String)"surow3-val00");
        byte[] r3val01 = Bytes.toBytes((String)"surow3-val01");
        byte[] r3bigval = Bytes.toBytes((String)"surow4");
        byte[] r3smallval = Bytes.toBytes((String)"surow2");
        byte[] chgr0val00 = Bytes.toBytes((String)"chg-surow0-val00");
        byte[] chgr0val11 = Bytes.toBytes((String)"chg-surow0-val11-123456789");
        byte[] chgr0val02 = Bytes.toBytes((String)"chg-surow0-val02-123");
        byte[] chgr1val00 = Bytes.toBytes((String)"chg-surow1-val00-abcdefghijklmnopqrestuvwxyz");
        byte[] chgr1val01 = Bytes.toBytes((String)"chg-surow1-val01-1234567890-abcdefghijklmnopqrestuvwxyz");
        byte[] chgr1val112 = Bytes.toBytes((String)"chg-surow1-val12-nullvalueintablematchesnullvalueininput");
        byte[] chgr1val210 = Bytes.toBytes((String)"chg-surow2-val10-emotyvalueintablematchesemptyvalueininput, this will be added");
        byte[] chgr1val211 = Bytes.toBytes((String)"chg-surow2-val11-nullvalueintablematchesnullvalueininput, this will be added");
        byte[] chgr3val10 = Bytes.toBytes((String)"chg-surow3-val10-surow3-val00 is greater than surow2, this will be added");
        byte[] chgr3val11 = Bytes.toBytes((String)"chg-surow3-val10-surow3-val00 is not less surow2, this will not be added");
        String tableName1 = args[0];
        String tableName2 = args[1];
        String quorum = "localhost";
        if (args.length > 2) {
            quorum = args[2];
        }
        String port = "5181";
        if (args.length > 3) {
            port = args[3];
        }
        Configuration conf = new Configuration();
        conf.set("hbase.zookeeper.quorum", quorum);
        conf.set("hbase.zookeeper.property.clientPort", port);
        System.out.println("hbase.zookeeper.quorum = " + conf.get("hbase.zookeeper.quorum") + "\nhbase.zookeeper.property.clientPort = " + conf.get("hbase.zookeeper.property.clientPort"));
        String[] familys = new String[]{new String(fam0), new String(fam1)};
        boolean table1IsNew = TestAtomicOps.creatTable(tableName1, familys, conf);
        boolean table2IsNew = TestAtomicOps.creatTable(tableName2, familys, conf);
        HTable ht1 = new HTable(conf, tableName1);
        HTable ht2 = new HTable(conf, tableName2);
        Scan simplescan = new Scan();
        if (!table1IsNew) {
            ResultScanner rs1 = ht1.getScanner(simplescan);
            for (Result result : rs1) {
                ht1.delete(new Delete(result.getRow()));
            }
            rs1.close();
        }
        if (!table2IsNew) {
            ResultScanner rs2 = ht2.getScanner(simplescan);
            for (Result result : rs2) {
                ht2.delete(new Delete(result.getRow()));
            }
            rs2.close();
        }
        Put put0 = new Put(row0);
        put0.add(fam0, qual0, r0val00);
        put0.add(fam0, qual1, r0val01);
        put0.add(fam1, qual0, r0val10);
        put0.add(fam1, qual1, r0val11);
        Put put10 = new Put(row1);
        put10.add(fam0, qual0, r1val00);
        put10.add(fam0, qual1, r1val01);
        Put put2 = new Put(row2);
        put2.add(fam0, qual0, valempty);
        put2.add(fam0, qual1, valnull);
        Put put3 = new Put(row3);
        put3.add(fam0, qual0, r3val00);
        put3.add(fam0, qual1, r3val01);
        ht1.put(put0);
        ht1.put(put10);
        ht1.put(put2);
        ht1.put(put3);
        ht1.flushCommits();
        ht2.put(put0);
        ht2.put(put10);
        ht2.put(put2);
        ht2.put(put3);
        ht2.flushCommits();
        boolean tsame = TestAtomicOps.tablesAreSame(ht1, ht2, simplescan);
        System.out.println((tsame ? "Same:" : "Different:") + " after populated data to table " + tableName1 + " and " + tableName2);
        Put put110 = new Put(row1);
        Put put111 = new Put(row1);
        put110.add(fam1, qual0, r1val10);
        put111.add(fam1, qual1, r1val11);
        System.out.println("\n========Test1: mismatch case for checkandput========");
        boolean ret1 = ht1.checkAndPut(row1, fam0, qual0, r1val01, put110);
        boolean ret2 = ht2.checkAndPut(row1, fam0, qual0, r1val01, put110);
        System.out.println("After checkandput " + Bytes.toStringBinary((byte[])row1) + ", col:qual(" + Bytes.toStringBinary((byte[])fam0) + ":" + Bytes.toStringBinary((byte[])qual0) + "=" + Bytes.toStringBinary((byte[])r1val00) + ") mismatch value(" + Bytes.toStringBinary((byte[])r1val01) + "), should not apply put");
        tsame = TestAtomicOps.tablesAreSame(ht1, ht2, simplescan);
        TestAtomicOps.assertOpsNotRun(ret1, ret2, tsame, "CheckAndPut");
        System.out.println("\n========Test2: match case for checkandput========");
        ret1 = ht1.checkAndPut(row1, fam0, qual0, r1val00, put111);
        ret2 = ht2.checkAndPut(row1, fam0, qual0, r1val00, put111);
        System.out.println("After checkandput " + Bytes.toStringBinary((byte[])row1) + ", col:qual(" + Bytes.toStringBinary((byte[])fam0) + ":" + Bytes.toStringBinary((byte[])qual0) + "=" + Bytes.toStringBinary((byte[])r1val00) + ") match value(" + Bytes.toStringBinary((byte[])r1val00) + "), should apply put (" + Bytes.toStringBinary((byte[])r1val11) + ")");
        tsame = TestAtomicOps.tablesAreSame(ht1, ht2, simplescan);
        TestAtomicOps.assertOpsRun(ret1, ret2, tsame, "CheckAndPut");
        System.out.println("\n========Test3: mismatch case for checkanddelete========");
        Delete del100 = new Delete(row1);
        Delete del101 = new Delete(row1);
        del100.deleteColumn(fam0, qual0);
        del101.deleteColumn(fam0, qual1);
        ret1 = ht1.checkAndDelete(row1, fam0, qual0, r1val01, del100);
        ret2 = ht2.checkAndDelete(row1, fam0, qual0, r1val01, del100);
        System.out.println("After checkanddelete " + Bytes.toStringBinary((byte[])row1) + ", col:qual(" + Bytes.toStringBinary((byte[])fam0) + ":" + Bytes.toStringBinary((byte[])qual0) + "=" + Bytes.toStringBinary((byte[])r1val00) + ") mismatch value(" + Bytes.toStringBinary((byte[])r1val01) + "), should not apply delete fam0:col0");
        tsame = TestAtomicOps.tablesAreSame(ht1, ht2, simplescan);
        TestAtomicOps.assertOpsNotRun(ret1, ret2, tsame, "CheckAndDelete");
        System.out.println("\n========Test4: match case for checkanddelete========");
        ret1 = ht1.checkAndDelete(row1, fam1, qual1, r1val11, del100);
        ret2 = ht2.checkAndDelete(row1, fam1, qual1, r1val11, del100);
        System.out.println("After checkanddelete " + Bytes.toStringBinary((byte[])row1) + ", col:qual(" + Bytes.toStringBinary((byte[])fam1) + ":" + Bytes.toStringBinary((byte[])qual1) + "=" + Bytes.toStringBinary((byte[])r1val11) + ") match value(" + Bytes.toStringBinary((byte[])r1val11) + "), will delete fam0:col0");
        tsame = TestAtomicOps.tablesAreSame(ht1, ht2, simplescan);
        TestAtomicOps.assertOpsRun(ret1, ret2, tsame, "CheckAndDelete");
        RowMutations rm = new RowMutations(row0);
        Delete chgdel00 = new Delete(row0);
        chgdel00.deleteFamily(fam0);
        rm.add(chgdel00);
        Put chgput0 = new Put(row0);
        chgput0.add(fam0, qual0, chgr0val00);
        chgput0.add(fam1, qual1, chgr0val11);
        chgput0.add(fam0, qual2, chgr0val02);
        rm.add(chgput0);
        System.out.println("\n========Test5: mismatch case for checkandmutate========");
        ret1 = ht1.checkAndMutate(row0, fam1, qual1, CompareFilter.CompareOp.EQUAL, r0val00, rm);
        ret2 = ht2.checkAndMutate(row0, fam1, qual1, CompareFilter.CompareOp.EQUAL, r0val00, rm);
        System.out.println("checkandmutate for key(" + Bytes.toStringBinary((byte[])row0) + ") fam:col(" + Bytes.toStringBinary((byte[])fam1) + ":" + Bytes.toStringBinary((byte[])qual1) + ") val(" + Bytes.toStringBinary((byte[])r0val00) + ") mismatch should not apply mutate, result=(" + ret1 + "," + ret2 + ")");
        tsame = TestAtomicOps.tablesAreSame(ht1, ht2, simplescan);
        TestAtomicOps.assertOpsNotRun(ret1, ret2, tsame, "CheckAndMutate");
        System.out.println("\n========Test6: match case for checkandmutate========");
        ret1 = ht1.checkAndMutate(row0, fam1, qual1, CompareFilter.CompareOp.EQUAL, r0val11, rm);
        ret2 = ht2.checkAndMutate(row0, fam1, qual1, CompareFilter.CompareOp.EQUAL, r0val11, rm);
        System.out.println("checkandmutate for key(" + Bytes.toStringBinary((byte[])row0) + ") fam:col(" + Bytes.toStringBinary((byte[])fam1) + ":" + Bytes.toStringBinary((byte[])qual1) + ") matches val(" + Bytes.toStringBinary((byte[])r0val11) + "), should apply mutation, del(fam0), put (" + Bytes.toStringBinary((byte[])chgr0val00) + ", " + Bytes.toStringBinary((byte[])chgr0val11) + ", " + Bytes.toStringBinary((byte[])chgr0val02) + ") result=(" + ret1 + "," + ret2 + ")");
        tsame = TestAtomicOps.tablesAreSame(ht1, ht2, simplescan);
        TestAtomicOps.assertOpsRun(ret1, ret2, tsame, "CheckAndMutate");
        RowMutations rm310 = new RowMutations(row3);
        Put chgput310 = new Put(row3);
        chgput310.add(fam1, qual0, chgr3val10);
        rm310.add(chgput310);
        RowMutations rm311 = new RowMutations(row3);
        Put chgput311 = new Put(row3);
        chgput311.add(fam1, qual0, chgr3val11);
        rm311.add(chgput311);
        RowMutations rm301 = new RowMutations(row3);
        Delete chgdel301 = new Delete(row3);
        rm301.add(chgdel301);
        System.out.println("\n========Test7: checkandmutate with CompareOp GREATER ========");
        ret1 = ht1.checkAndMutate(row3, fam0, qual0, CompareFilter.CompareOp.GREATER, r3smallval, rm310);
        ret2 = ht2.checkAndMutate(row3, fam0, qual0, CompareFilter.CompareOp.GREATER, r3smallval, rm310);
        System.out.println("checkandmutate for key(" + Bytes.toStringBinary((byte[])row3) + ") fam:col(" + Bytes.toStringBinary((byte[])fam0) + ":" + Bytes.toStringBinary((byte[])qual0) + ") > val(" + Bytes.toStringBinary((byte[])r3smallval) + ") should apply change (" + Bytes.toStringBinary((byte[])chgr3val10) + ") result=(" + ret1 + "," + ret2 + ")");
        tsame = TestAtomicOps.tablesAreSame(ht1, ht2, simplescan);
        TestAtomicOps.assertOpsRun(ret1, ret2, tsame, "CheckAndMutate");
        System.out.println("\n========Test8: checkandmutate with CompareOp LESS ========");
        ret1 = ht1.checkAndMutate(row3, fam0, qual1, CompareFilter.CompareOp.LESS, r3smallval, rm311);
        ret2 = ht2.checkAndMutate(row3, fam0, qual1, CompareFilter.CompareOp.LESS, r3smallval, rm311);
        System.out.println("checkandmutate for key(" + Bytes.toStringBinary((byte[])row3) + ") fam:col(" + Bytes.toStringBinary((byte[])fam0) + ":" + Bytes.toStringBinary((byte[])qual1) + ") < val(" + Bytes.toStringBinary((byte[])r3smallval) + ") should not apply change (" + Bytes.toStringBinary((byte[])chgr3val11) + ") result=(" + ret1 + "," + ret2 + ")");
        tsame = TestAtomicOps.tablesAreSame(ht1, ht2, simplescan);
        TestAtomicOps.assertOpsNotRun(ret1, ret2, tsame, "CheckAndMutate");
        System.out.println("\n========Test9: checkandmutate with CompareOp NOOP ========");
        ret1 = ht1.checkAndMutate(row3, fam1, qual1, CompareFilter.CompareOp.NO_OP, r3bigval, rm301);
        ret2 = ht2.checkAndMutate(row3, fam1, qual1, CompareFilter.CompareOp.NO_OP, r3bigval, rm301);
        System.out.println("checkandmutate for key(" + Bytes.toStringBinary((byte[])row0) + ") fam:col(" + Bytes.toStringBinary((byte[])fam1) + ":" + Bytes.toStringBinary((byte[])qual1) + " NO_OP val(" + Bytes.toStringBinary((byte[])r3bigval) + ") should not apply delete surow3. result=(" + ret1 + "," + ret2 + ")");
        tsame = TestAtomicOps.tablesAreSame(ht1, ht2, simplescan);
        TestAtomicOps.assertOpsNotRun(ret1, ret2, tsame, "CheckAndMutate");
        RowMutations rm1 = new RowMutations(row1);
        Delete chgdel1 = new Delete(row1);
        rm1.add(chgdel1);
        Put chgput1 = new Put(row1);
        chgput1.add(fam0, qual0, chgr1val00);
        chgput1.add(fam0, qual1, chgr1val01);
        rm1.add(chgput1);
        System.out.println("\n========Test11: Empty qualifier for checkandmutate========");
        byte[] emptybytes = HConstants.EMPTY_BYTE_ARRAY;
        ret1 = ht1.checkAndMutate(row1, fam1, emptybytes, CompareFilter.CompareOp.EQUAL, r1val11, rm1);
        ret2 = ht2.checkAndMutate(row1, fam1, emptybytes, CompareFilter.CompareOp.EQUAL, r1val11, rm1);
        System.out.println("checkandmutate for key(" + Bytes.toStringBinary((byte[])row1) + ") fam:col(" + Bytes.toStringBinary((byte[])fam1) + ":" + Bytes.toStringBinary((byte[])emptybytes) + ") val(" + Bytes.toStringBinary((byte[])r1val11) + "), for empty qualifier should not apply mutate(delete surow1 and put " + Bytes.toStringBinary((byte[])chgr1val00) + " and " + Bytes.toStringBinary((byte[])chgr1val01) + "), result=(" + ret1 + "," + ret2 + ")");
        tsame = TestAtomicOps.tablesAreSame(ht1, ht2, simplescan);
        TestAtomicOps.assertOpsNotRun(ret1, ret2, tsame, "CheckAndMutate");
        System.out.println("\n========Test12: Empty family for checkandmutate========");
        ret1 = ht1.checkAndMutate(row1, emptybytes, qual1, CompareFilter.CompareOp.EQUAL, r1val11, rm1);
        ret2 = ht2.checkAndMutate(row1, emptybytes, qual1, CompareFilter.CompareOp.EQUAL, r1val11, rm1);
        System.out.println("checkandmutate for key(" + Bytes.toStringBinary((byte[])row1) + ") fam:col(" + Bytes.toStringBinary((byte[])emptybytes) + ":" + Bytes.toStringBinary((byte[])qual1) + ") val(" + Bytes.toStringBinary((byte[])r1val11) + "), for empty family should not apply mutate(delete surow1 and put " + Bytes.toStringBinary((byte[])chgr1val00) + " and " + Bytes.toStringBinary((byte[])chgr1val01) + "),  result=(" + ret1 + "," + ret2 + ")");
        tsame = TestAtomicOps.tablesAreSame(ht1, ht2, simplescan);
        TestAtomicOps.assertOpsNotRun(ret1, ret2, tsame, "CheckAndMutate");
        System.out.println("\n========Test13: checkandmutate with not-empty value in the table and empty value in input========");
        ret1 = ht1.checkAndMutate(row1, fam1, qual1, CompareFilter.CompareOp.EQUAL, emptybytes, rm1);
        ret2 = ht2.checkAndMutate(row1, fam1, qual1, CompareFilter.CompareOp.EQUAL, emptybytes, rm1);
        System.out.println("checkandmutate for key(" + Bytes.toStringBinary((byte[])row1) + ") fam:col(" + Bytes.toStringBinary((byte[])fam1) + ":" + Bytes.toStringBinary((byte[])qual1) + ") table has val, and input val is empty(" + Bytes.toStringBinary((byte[])emptybytes) + "), should not apply mutate(delete surow1 and put " + Bytes.toStringBinary((byte[])chgr1val00) + " and " + Bytes.toStringBinary((byte[])chgr1val01) + "), result=(" + ret1 + "," + ret2 + ")");
        tsame = TestAtomicOps.tablesAreSame(ht1, ht2, simplescan);
        TestAtomicOps.assertOpsNotRun(ret1, ret2, tsame, "CheckAndMutate");
        RowMutations rm2 = new RowMutations(row2);
        Delete chgdel201 = new Delete(row2);
        chgdel201.deleteColumn(fam0, qual1);
        rm2.add(chgdel201);
        System.out.println("\n========Test14: checkandmutate with empty value in the table and not empty value in input========");
        ret1 = ht1.checkAndMutate(row2, fam0, qual1, CompareFilter.CompareOp.EQUAL, r1val01, rm2);
        ret2 = ht2.checkAndMutate(row2, fam0, qual1, CompareFilter.CompareOp.EQUAL, r1val01, rm2);
        System.out.println("checkandmutate for key(" + Bytes.toStringBinary((byte[])row2) + ") fam:col(" + Bytes.toStringBinary((byte[])fam0) + ":" + Bytes.toStringBinary((byte[])qual1) + ") table has empty val, and input val is " + Bytes.toStringBinary((byte[])r1val01) + ", should not apply mutate delete surow2:fam0:qual1, result=(" + ret1 + "," + ret2 + ")");
        tsame = TestAtomicOps.tablesAreSame(ht1, ht2, simplescan);
        TestAtomicOps.assertOpsNotRun(ret1, ret2, tsame, "CheckAndMutate");
        System.out.println("\n========Test15: checkandmutate with empty value in the table and empty value in input========");
        ret1 = ht1.checkAndMutate(row2, fam0, qual1, CompareFilter.CompareOp.EQUAL, emptybytes, rm2);
        ret2 = ht2.checkAndMutate(row2, fam0, qual1, CompareFilter.CompareOp.EQUAL, emptybytes, rm2);
        System.out.println("checkandmutate for key(" + Bytes.toStringBinary((byte[])row2) + ") fam:col(" + Bytes.toStringBinary((byte[])fam0) + ":" + Bytes.toStringBinary((byte[])qual1) + ") val in table is empty, and input val is empty(" + Bytes.toStringBinary((byte[])emptybytes) + "), should apply mutate (del surow2:fam0:qual1), result=(" + ret1 + "," + ret2 + ")");
        tsame = TestAtomicOps.tablesAreSame(ht1, ht2, simplescan);
        TestAtomicOps.assertOpsRun(ret1, ret2, tsame, "CheckAndMutate");
        RowMutations rm112 = new RowMutations(row1);
        Put chgput112 = new Put(row1);
        chgput112.add(fam1, qual1, chgr1val112);
        rm112.add(chgput112);
        System.out.println("\n========Test16: checkandmutate with not-exist family ========");
        ret1 = ht1.checkAndMutate(row1, famx, qual1, CompareFilter.CompareOp.EQUAL, emptybytes, rm112);
        ret2 = ht2.checkAndMutate(row1, famx, qual1, CompareFilter.CompareOp.EQUAL, emptybytes, rm112);
        System.out.println("checkandmutate for key(" + Bytes.toStringBinary((byte[])row1) + ") fam:col(" + Bytes.toStringBinary((byte[])famx) + ":" + Bytes.toStringBinary((byte[])qual1) + ") input family does not exist, should not apply mutate put(" + Bytes.toStringBinary((byte[])chgr1val112) + "), result=(" + ret1 + "," + ret2 + ")");
        tsame = TestAtomicOps.tablesAreSame(ht1, ht2, simplescan);
        TestAtomicOps.assertOpsNotRun(ret1, ret2, tsame, "CheckAndMutate");
        System.out.println("\n========Test17: checkandmutate with not-exist qualifier ========");
        ret1 = ht1.checkAndMutate(row1, fam1, qualx, CompareFilter.CompareOp.EQUAL, emptybytes, rm112);
        ret2 = ht2.checkAndMutate(row1, fam1, qualx, CompareFilter.CompareOp.EQUAL, emptybytes, rm112);
        System.out.println("checkandmutate for key(" + Bytes.toStringBinary((byte[])row1) + ") fam:col(" + Bytes.toStringBinary((byte[])fam1) + ":" + Bytes.toStringBinary((byte[])qualx) + ") input qualifier does not exist, should not apply mutate put(" + Bytes.toStringBinary((byte[])chgr1val112) + "), result=(" + ret1 + "," + ret2 + ")");
        tsame = TestAtomicOps.tablesAreSame(ht1, ht2, simplescan);
        TestAtomicOps.assertOpsNotRun(ret1, ret2, tsame, "CheckAndMutate");
        System.out.println("\n========Test18: checkandmutate with empty mutation ========");
        RowMutations rm1empty = new RowMutations(row1);
        ret1 = ht1.checkAndMutate(row1, fam1, qual1, CompareFilter.CompareOp.EQUAL, r1val11, rm1empty);
        ret2 = ht2.checkAndMutate(row1, fam1, qual1, CompareFilter.CompareOp.EQUAL, r1val11, rm1empty);
        System.out.println("checkandmutate for key(" + Bytes.toStringBinary((byte[])row1) + ") fam:col(" + Bytes.toStringBinary((byte[])fam1) + ":" + Bytes.toStringBinary((byte[])qual1) + ") input val(" + Bytes.toStringBinary((byte[])r1val11) + "), mutation is empty, should not apply, result=(" + ret1 + "," + ret2 + ")");
        tsame = TestAtomicOps.tablesAreSame(ht1, ht2, simplescan);
        TestAtomicOps.assertOpsNotRun(ret1, ret2, tsame, "CheckAndMutate");
        ht1.close();
        ht2.close();
    }
}

