/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs.hbase.tools.mapreduce;

import com.mapr.fs.hbase.tools.mapreduce.NonSplitableFileInputFormat;
import com.mapr.fs.hbase.tools.mapreduce.SegKeyRangeUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Arrays;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.ResultSerialization;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class FormatResult
extends Configured
implements Tool {
    private static final Log LOG = LogFactory.getLog(FormatResult.class);
    static String input;
    static String output;
    static String MROutputFilePrefix;
    boolean runMR = false;

    public int runMapReduceJob() throws Exception {
        Configuration conf = this.getConf();
        Path inputPath = new Path(input);
        Path outputPath = new Path(output);
        conf.setStrings("io.serializations", new String[]{conf.get("io.serializations"), ResultSerialization.class.getName()});
        Job job = new Job(conf);
        job.setJarByClass(FormatResult.class);
        job.setJobName("Convert Sequence File and Output as Text");
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{inputPath});
        FileOutputFormat.setOutputPath((Job)job, (Path)outputPath);
        job.setInputFormatClass(NonSplitableFileInputFormat.class);
        job.setMapperClass(FormatConverterMapper.class);
        job.setOutputKeyClass(NullWritable.class);
        job.setOutputValueClass(Text.class);
        job.setNumReduceTasks(0);
        TableMapReduceUtil.addDependencyJars((Job)job);
        boolean success = job.waitForCompletion(true);
        FileSystem fs = FileSystem.get((Configuration)conf);
        if (fs.getFileStatus(inputPath).isDirectory()) {
            if (!FormatResult.renameDstDirAccordToSrcDir(conf, inputPath, outputPath)) {
                LOG.error((Object)("Failed to map input file to output files. The files in " + outputPath + " may not be in the same order as " + inputPath));
            }
        } else if (!FormatResult.renameDstDirAccordToSingleFile(conf, inputPath, outputPath)) {
            LOG.error((Object)("Failed to map input file to output files. The files in " + outputPath + " may not be in the same order as " + inputPath));
        }
        return success ? 0 : 1;
    }

    public int runNonMapReduceJob(boolean replaceDst) throws Exception {
        Path dstPath;
        Configuration conf = HBaseConfiguration.create();
        conf.set("fs.default.name", "maprfs:///");
        conf.set("fs.maprfs.impl", "com.mapr.fs.MapRFileSystem");
        conf.set("mapr.htable.impl", "com.mapr.fs.MapRHTable");
        conf.setStrings("io.serializations", new String[]{conf.get("io.serializations"), ResultSerialization.class.getName()});
        int ret = 0;
        FileSystem fs = FileSystem.get((Configuration)conf);
        Path srcPath = new Path(input);
        if (!fs.exists(srcPath)) {
            LOG.error((Object)("Source " + input + " doesn't exist."));
            return 1;
        }
        boolean isDir = false;
        if (fs.getFileStatus(srcPath).isDirectory()) {
            LOG.debug((Object)("Source " + srcPath + " is a directory."));
            isDir = true;
        }
        if (fs.exists(dstPath = new Path(output))) {
            if (!replaceDst) {
                LOG.error((Object)(dstPath + " already exists."));
                return 1;
            }
            LOG.warn((Object)(dstPath + " will be overwritten."));
            if (!fs.delete(dstPath, true)) {
                LOG.error((Object)("Fail to replace " + dstPath));
                return 1;
            }
        }
        if (isDir && !fs.mkdirs(dstPath)) {
            LOG.error((Object)("Fail to create " + dstPath));
            return 1;
        }
        int cnt = 0;
        Object[] contents = fs.listStatus(srcPath);
        Arrays.sort(contents);
        LOG.debug((Object)(srcPath + " contains " + contents.length + " files."));
        for (int i = 0; i < contents.length; ++i) {
            Path srcFilePath = contents[i].getPath();
            if (contents[i].isFile()) {
                Path dstFilePath = null;
                dstFilePath = isDir ? new Path(dstPath + "/" + srcFilePath.getName()) : dstPath;
                if (!FormatResult.sequenceToTextFile(conf, srcFilePath, dstFilePath)) {
                    LOG.error((Object)("Fail to translate " + srcFilePath.toString() + " to " + dstFilePath.toString()));
                    ret = 1;
                } else {
                    ++cnt;
                }
            }
            LOG.debug((Object)("current file " + srcFilePath));
        }
        if (cnt <= 0 && !fs.delete(dstPath, true)) {
            LOG.error((Object)("Fail to cleanup empty " + dstPath));
            return 1;
        }
        LOG.info((Object)("Total " + cnt + " text files created."));
        return ret;
    }

    private static boolean renameDstDirAccordToSingleFile(Configuration conf, Path srcFilePath, Path dstDir) throws IOException {
        FileSystem fs = FileSystem.get((Configuration)conf);
        if (fs.getFileStatus(srcFilePath).isDirectory()) {
            LOG.error((Object)(srcFilePath + " is a directory."));
            return false;
        }
        String srcFileName = srcFilePath.getName();
        int cnt = 0;
        Object[] contents = fs.listStatus(dstDir);
        Arrays.sort(contents);
        LOG.info((Object)(dstDir + " contains " + contents.length + " files."));
        for (int i = 0; i < contents.length; ++i) {
            Path dstFilePath = contents[i].getPath();
            if (contents[i].isFile() && contents[i].getPath().getName().startsWith(MROutputFilePrefix)) {
                if (cnt >= 1) {
                    LOG.error((Object)("There should be only one mapreduce output file in " + dstDir));
                    return false;
                }
                String newTextFileName = dstDir + "/" + srcFileName;
                if (!fs.rename(dstFilePath, new Path(newTextFileName))) {
                    LOG.error((Object)("Fail to rename " + dstFilePath + " to " + newTextFileName));
                    return false;
                }
                ++cnt;
            }
            LOG.debug((Object)("current file " + dstFilePath));
        }
        return true;
    }

    private static boolean renameDstDirAccordToSrcDir(Configuration conf, Path srcDir, Path dstDir) throws IOException {
        int i;
        boolean ret = true;
        FileSystem fs = FileSystem.get((Configuration)conf);
        if (!fs.getFileStatus(srcDir).isDirectory()) {
            LOG.error((Object)(srcDir + "is not a direcotry"));
            return false;
        }
        if (!fs.getFileStatus(dstDir).isDirectory()) {
            LOG.error((Object)(dstDir + "is not a direcotry"));
            return false;
        }
        TreeMap<String, String> keyToFileName = new TreeMap<String, String>();
        int cnt = 0;
        Object[] contents = fs.listStatus(srcDir);
        Arrays.sort(contents);
        LOG.info((Object)(srcDir + " contains " + contents.length + " files."));
        for (i = 0; i < contents.length; ++i) {
            Path srcFilePath = contents[i].getPath();
            if (contents[i].isFile()) {
                if (!FormatResult.addKeyFileNameMapping(conf, srcFilePath, keyToFileName)) {
                    LOG.error((Object)("Fail to get key-to-file mapping for " + srcFilePath.toString()));
                    ret = false;
                } else {
                    ++cnt;
                }
            }
            LOG.debug((Object)("current file " + srcFilePath));
        }
        LOG.info((Object)("Genereated keyMap from " + cnt + " files"));
        cnt = 0;
        contents = fs.listStatus(dstDir);
        Arrays.sort(contents);
        LOG.info((Object)(dstDir + " contains " + contents.length + " files."));
        for (i = 0; i < contents.length; ++i) {
            Path dstFilePath = contents[i].getPath();
            if (contents[i].isFile() && contents[i].getPath().getName().startsWith(MROutputFilePrefix)) {
                if (!FormatResult.renameDstFile(conf, dstDir, dstFilePath, keyToFileName)) {
                    LOG.error((Object)("Fail to rename " + dstFilePath));
                    ret = false;
                } else {
                    ++cnt;
                }
            }
            LOG.debug((Object)("current file " + dstFilePath));
        }
        LOG.info((Object)("Renamed " + cnt + " files"));
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean renameDstFile(Configuration conf, Path dstDir, Path dstTextFilePath, TreeMap<String, String> keyToFileName) throws IOException {
        boolean ret = true;
        FileSystem fs = FileSystem.get((Configuration)conf);
        try (InputStreamReader instream = null;){
            instream = new InputStreamReader((InputStream)fs.open(dstTextFilePath));
            BufferedReader br = new BufferedReader(instream);
            String line = br.readLine();
            String key = null;
            if (line == null) {
                LOG.error((Object)("Empty file " + dstTextFilePath));
                boolean fields = false;
                return fields;
            }
            String[] fields = line.split(" ", 2);
            key = fields[0];
            LOG.info((Object)(dstTextFilePath + " start with " + key));
            String srcFileName = keyToFileName.get(key);
            if (srcFileName == null) {
                LOG.error((Object)("Could not find source file for key " + key));
                boolean bl = false;
                return bl;
            }
            String newTextFileName = dstDir + "/" + srcFileName;
            if (!fs.rename(dstTextFilePath, new Path(newTextFileName))) {
                LOG.error((Object)("Fail to rename " + dstTextFilePath + " to " + newTextFileName));
                boolean bl = false;
                return bl;
            }
            LOG.info((Object)("Renamed " + dstTextFilePath + " to " + newTextFileName));
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean addKeyFileNameMapping(Configuration conf, Path seqFilePath, TreeMap<String, String> keyToFileName) throws IOException {
        SequenceFile.Reader reader;
        boolean ret;
        block5: {
            boolean bl;
            ret = true;
            reader = null;
            FileSystem fs = FileSystem.get((Configuration)conf);
            try {
                reader = new SequenceFile.Reader(fs, seqFilePath, conf);
                ImmutableBytesWritable key = new ImmutableBytesWritable();
                if (reader.next((Writable)key)) {
                    keyToFileName.put(Bytes.toStringBinary((byte[])key.get()), seqFilePath.getName());
                    LOG.info((Object)(Bytes.toStringBinary((byte[])key.get()) + "->" + seqFilePath.getName()));
                    break block5;
                }
                LOG.error((Object)("No Key found in file " + seqFilePath.getName()));
                bl = false;
            }
            catch (Exception e) {
                try {
                    ret = false;
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    IOUtils.closeStream(reader);
                    throw throwable;
                }
                IOUtils.closeStream((Closeable)reader);
            }
            IOUtils.closeStream((Closeable)reader);
            return bl;
        }
        IOUtils.closeStream((Closeable)reader);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean sequenceToTextFile(Configuration conf, Path seqFilePath, Path textFilePath) throws IOException {
        boolean ret = true;
        SequenceFile.Reader reader = null;
        BufferedWriter writer = null;
        FileSystem fs = FileSystem.get((Configuration)conf);
        try {
            reader = new SequenceFile.Reader(fs, seqFilePath, conf);
            Writable key = (Writable)ReflectionUtils.newInstance((Class)reader.getKeyClass(), (Configuration)conf);
            Result value = (Result)ReflectionUtils.newInstance((Class)reader.getValueClass(), (Configuration)conf);
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)fs.create(textFilePath, false)));
            while (reader.next(key)) {
                value = (Result)reader.getCurrentValue((Object)null);
                writer.write(SegKeyRangeUtil.resultToString(value) + "\n");
            }
            LOG.info((Object)("Translated sequence file " + seqFilePath + " to text file " + textFilePath));
        }
        catch (Exception e) {
            try {
                ret = false;
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                IOUtils.closeStream(reader);
                if (writer != null) {
                    writer.close();
                }
                throw throwable;
            }
            IOUtils.closeStream((Closeable)reader);
            if (writer != null) {
                writer.close();
            }
        }
        IOUtils.closeStream((Closeable)reader);
        if (writer != null) {
            writer.close();
        }
        return ret;
    }

    private static boolean checkFileExist(String fileName) throws IOException {
        Configuration conf = HBaseConfiguration.create();
        Path path = new Path(fileName);
        FileSystem fs = path.getFileSystem(conf);
        return fs.exists(path);
    }

    private boolean ParseArgs(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            String isMapreduce;
            if (args[i].equals("-h") || args[i].startsWith("--h")) {
                FormatResult.printUsage(null);
                return false;
            }
            if (args[i].equalsIgnoreCase("-input")) {
                input = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-output")) {
                output = args[++i];
                continue;
            }
            if (!args[i].equalsIgnoreCase("-mapreduce")) continue;
            if ((isMapreduce = args[++i]).equalsIgnoreCase("false")) {
                this.runMR = false;
                continue;
            }
            if (!isMapreduce.equalsIgnoreCase("true")) continue;
            this.runMR = true;
        }
        if (input == null || output == null) {
            FormatResult.printUsage("missing -input or -output.");
        }
        return true;
    }

    private static void printUsage(String errMsg) {
        if (errMsg != null) {
            System.err.println("ERROR: " + errMsg);
        }
        System.err.println("Usage: hbase com.mapr.fs.hbase.tools.mapreduce.FormatResult\n-input <input file>\n-output <output file>\n[-mapreduce <true|false> (default: false)]");
        System.exit(1);
    }

    public int run(String[] args) throws Exception {
        if (!this.ParseArgs(args)) {
            return 1;
        }
        if (!FormatResult.checkFileExist(input)) {
            FormatResult.printUsage("Input " + input + " doesn't exist.");
        }
        if (FormatResult.checkFileExist(output)) {
            FormatResult.printUsage("Output " + output + " already exists.");
        }
        int ret = this.runMR ? this.runMapReduceJob() : this.runNonMapReduceJob(false);
        return ret == 0 ? 0 : 1;
    }

    public static void main(String[] args) throws Exception {
        int exitCode = ToolRunner.run((Configuration)HBaseConfiguration.create(), (Tool)new FormatResult(), (String[])args);
        System.exit(exitCode);
    }

    static {
        MROutputFilePrefix = "part-";
    }

    public static class FormatConverterMapper
    extends Mapper<ImmutableBytesWritable, Result, NullWritable, Text> {
        public void map(ImmutableBytesWritable key, Result value, Mapper.Context context) throws IOException, InterruptedException {
            context.write((Object)NullWritable.get(), (Object)new Text(SegKeyRangeUtil.resultToString(value)));
        }
    }
}

