/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.kvstore;

import com.mapr.kvstore.Operation;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class KvStoreWriter {
    BlockingQueue<Operation> opQueue = new LinkedBlockingQueue<Operation>();
    KvStoreWriterThread kvstoreThread = new KvStoreWriterThread();
    public static final Log LOG = LogFactory.getLog(KvStoreWriter.class);

    public void addOp(Operation op) {
        block3: {
            if (op == null) {
                return;
            }
            try {
                this.opQueue.put(op);
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block3;
                LOG.error((Object)("KvStoreWriter: Failed to add op to kvstore writer" + e.getLocalizedMessage()));
            }
        }
    }

    class KvStoreWriterThread
    implements Runnable {
        Thread thread;

        KvStoreWriterThread() {
            block2: {
                try {
                    this.thread = new Thread((Runnable)this, "kvwriter");
                    this.thread.setPriority(1);
                    this.thread.setDaemon(true);
                    this.thread.start();
                }
                catch (Exception e) {
                    if (!LOG.isErrorEnabled()) break block2;
                    LOG.error((Object)("KvStoreWriter: Failed to create writer thread" + e.getLocalizedMessage()));
                }
            }
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        Operation op;
                        int status;
                        if ((status = (op = KvStoreWriter.this.opQueue.take()).apply()) == 0 || !LOG.isErrorEnabled()) {
                            continue;
                        }
                        LOG.error((Object)("KvStoreWriter: Failed to write to kvstore status: " + status));
                    }
                }
                catch (Exception e) {
                    if (!LOG.isErrorEnabled()) continue;
                    LOG.error((Object)("KvStoreWriter: Failed to write to kvstore" + e.getLocalizedMessage()));
                    continue;
                }
                break;
            }
        }
    }
}

