/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.kvstore;

import com.google.protobuf.ByteString;
import com.mapr.kvstore.HashedStringKvStore;
import com.mapr.kvstore.KvDatabaseFactory;
import com.mapr.kvstore.KvDatabaseOp;
import com.mapr.kvstore.KvTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HashedStringKvFactory
implements KvDatabaseFactory {
    private static final Logger LOG = LoggerFactory.getLogger(HashedStringKvFactory.class);
    KvDatabaseFactory dbFactory = null;

    public HashedStringKvFactory(KvDatabaseFactory dbFactory) {
        this.dbFactory = dbFactory;
    }

    public KvTable<String> create() {
        KvTable<ByteString> dbKv = this.dbFactory.create();
        dbKv.setVarKeyType(ByteString.class.getName());
        return new HashedStringKvStore(dbKv);
    }

    @Override
    public <T> void createAndOpenTable(String tableName, KvTable<T> table, int keyType, boolean create) throws Exception {
        KvTable<ByteString> dbKv = ((HashedStringKvStore)table).getInnerTable();
        this.dbFactory.createAndOpenTable(tableName, dbKv, keyType, create);
    }

    @Override
    public <T> int openTableNoRetry(String tableName, KvTable<T> table, int keyType) throws Exception {
        KvTable<ByteString> dbKv = ((HashedStringKvStore)table).getInnerTable();
        return this.dbFactory.openTableNoRetry(tableName, dbKv, keyType);
    }

    @Override
    public KvDatabaseOp getOperator() {
        return this.dbFactory.getOperator();
    }

    @Override
    public <T> void createAndOpenTableBasedOnRole(String tableName, KvTable<T> table, int keyType, boolean create) throws Exception {
        KvTable<ByteString> dbKv = ((HashedStringKvStore)table).getInnerTable();
        this.dbFactory.createAndOpenTableBasedOnRole(tableName, dbKv, keyType, create);
    }
}

