/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.kvstore;

import com.google.protobuf.MessageLite;
import com.mapr.fs.Rpc;
import com.mapr.fs.proto.Common;
import com.mapr.fs.proto.Fileserver;
import com.mapr.fs.proto.Security;
import com.mapr.kvstore.KvClientInterface;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class KvStoreClient
implements KvClientInterface {
    private long clntPtr;
    private int rootCid;
    private int numRpcThreads;
    private Security.CredentialsMsg creds;
    private int DEFAULT_ROOT_DIR_CINUM = 16;
    private int DEFAULT_ROOT_DIR_UNIQ = 2;
    BindingIdxTracker bindingIdxTracker = null;
    private List<Long> bindings = null;
    public long binding;
    public static final Log LOG = LogFactory.getLog(KvStoreClient.class);

    private final native long OpenClientWithCid(String var1, int var2, byte[] var3, int var4, int var5, String var6);

    private final native void CloseClient(long var1);

    private final native int create(long var1, String var3, int var4, int var5);

    private final native int createdirs(long var1, String var3, int var4);

    private final native void setNoDelete(long var1, int var3, boolean var4);

    private final native byte[] lookup(long var1, String var3);

    private final native int gettype(long var1, byte[] var3);

    private final native int getfiletype(long var1, byte[] var3);

    private final native int remove(long var1, String var3);

    private final native int rename(long var1, String var3, String var4);

    public static final native void setLogLevel(String var0);

    public long getBinding() {
        return this.bindings.get(0);
    }

    public long getBinding(BindingType bType) {
        return this.bindingIdxTracker.getBinding(bType);
    }

    public KvStoreClient(String clusterName, int rootCid, String fsHost, int fsPort, boolean doNotTimeout, Security.CredentialsMsg creds) throws IOException {
        this(clusterName, rootCid, fsHost, fsPort, doNotTimeout, creds, 1, 0, null);
    }

    public KvStoreClient(String clusterName, int rootCid, String fsHost, int fsPort, boolean doNotTimeout, Security.CredentialsMsg creds, int numRpcThreads, int cldbPort, String coreSiteXmlPath) throws IOException {
        ArrayList<Integer> kvPorts = new ArrayList<Integer>();
        kvPorts.add(fsPort);
        this.initializeKvClient(clusterName, rootCid, fsHost, kvPorts, doNotTimeout, creds, numRpcThreads, cldbPort, coreSiteXmlPath);
    }

    public KvStoreClient(String clusterName, int rootCid, String fsHost, List<Integer> kvPorts, boolean doNotTimeout, Security.CredentialsMsg creds, int numRpcThreads, int cldbPort, String coreSiteXmlPath) throws IOException {
        this.initializeKvClient(clusterName, rootCid, fsHost, kvPorts, doNotTimeout, creds, numRpcThreads, cldbPort, coreSiteXmlPath);
    }

    private Common.Server newServer(int ip, List<Integer> kvPorts, String fsHost) {
        Common.IPAddress ipB = Common.IPAddress.newBuilder().setHost(ip).setPort(kvPorts.get(0).intValue()).setHostname(fsHost).build();
        Common.Server.Builder sb = Common.Server.newBuilder().addIps(ipB);
        for (int i = 1; i < kvPorts.size(); ++i) {
            sb.addSecondaryPorts(kvPorts.get(i).intValue());
        }
        return sb.build();
    }

    private int getIpFromHostname(String fsHost) throws Exception {
        InetAddress in = InetAddress.getByName(fsHost);
        byte[] ipBytes = in.getAddress();
        long ip = 0L;
        ip |= (long)(ipBytes[0] & 0xFF);
        ip <<= 8;
        ip |= (long)(ipBytes[1] & 0xFF);
        ip <<= 8;
        ip |= (long)(ipBytes[2] & 0xFF);
        ip <<= 8;
        return (int)(ip |= (long)(ipBytes[3] & 0xFF));
    }

    private void initializeKvClient(String clusterName, int rootCid, String fsHost, List<Integer> kvPorts, boolean doNotTimeout, Security.CredentialsMsg creds, int numRpcThreads, int cldbPort, String coreSiteXmlPath) throws IOException {
        LOG.info((Object)("Creating KvStoreClient communicating on RPC Server Idx: " + numRpcThreads + " with KvPorts: " + Arrays.toString(kvPorts.toArray())));
        this.numRpcThreads = numRpcThreads;
        this.bindingIdxTracker = new BindingIdxTracker();
        this.bindings = new ArrayList<Long>();
        this.rootCid = rootCid;
        this.creds = creds;
        try {
            int ip = this.getIpFromHostname(fsHost);
            Common.Server localMfs = this.newServer(ip, kvPorts, fsHost);
            this.clntPtr = this.OpenClientWithCid(clusterName, rootCid, localMfs.toByteArray(), cldbPort, numRpcThreads, coreSiteXmlPath);
            if (this.clntPtr == 0L) {
                throw new IOException("Could not initialize KvStoreClient");
            }
            int rpcServerIdx = 0;
            for (int i = 0; i < kvPorts.size(); ++i) {
                int fsPort = kvPorts.get(i);
                rpcServerIdx = (rpcServerIdx + 1) % numRpcThreads;
                long tmpBinding = Rpc.createBindingOnServerFor((int)ip, (int)fsPort, (String)clusterName, (int)Security.ServerKeyType.ServerKey.getNumber(), (int)rpcServerIdx);
                if (doNotTimeout) {
                    Rpc.doNotTimeout((long)tmpBinding);
                }
                Rpc.setAllowImpersonation((long)tmpBinding);
                this.bindings.add(tmpBinding);
                LOG.info((Object)("Successfully created KvStoreClient binding on rpcServerIdx: " + rpcServerIdx + " toPort: " + fsPort + " binding: " + String.format("0x%08X", tmpBinding) + " clntPtr: " + String.format("0x%08X", this.clntPtr)));
            }
            this.binding = this.bindings.get(0);
        }
        catch (Exception e) {
            LOG.error((Object)("Exception RpcInit: " + e));
            e.printStackTrace();
        }
    }

    public void setNoDelete(int cid, boolean setNoDelete) {
        this.setNoDelete(this.clntPtr, cid, setNoDelete);
    }

    @Override
    public int probe() {
        Common.FidMsg fid = Common.FidMsg.newBuilder().setCid(this.rootCid).setCinum(this.DEFAULT_ROOT_DIR_CINUM).setUniq(this.DEFAULT_ROOT_DIR_UNIQ).build();
        Fileserver.GetattrRequest req = Fileserver.GetattrRequest.newBuilder().setNode(fid).setCreds(this.creds).build();
        byte[] reply = null;
        try {
            reply = Rpc.sendRequest((long)this.binding, (int)Common.MapRProgramId.FileServerProgramId.getNumber(), (int)Fileserver.FSProg.GetattrProc.getNumber(), (MessageLite)req);
            if (reply == null) {
                LOG.error((Object)"KvStore probe : RPC response null");
                return 10009;
            }
            Fileserver.GetattrResponse resp = Fileserver.GetattrResponse.parseFrom((byte[])reply);
            return resp.getStatus();
        }
        catch (Exception e) {
            LOG.error((Object)("KvStore probe : Exception " + e));
            return 10003;
        }
    }

    @Override
    public void close() {
        this.CloseClient(this.clntPtr);
        this.clntPtr = 0L;
    }

    @Override
    public int create(String name, int mode, int keytype) {
        return this.create(this.clntPtr, name, mode, keytype);
    }

    @Override
    public int createdirs(String name, int mode) {
        return this.createdirs(this.clntPtr, name, mode);
    }

    @Override
    public Common.FidMsg lookup(String name) {
        byte[] bytes = this.lookup(this.clntPtr, name);
        if (bytes == null) {
            return null;
        }
        try {
            Common.FidMsg fid = Common.FidMsg.parseFrom((byte[])bytes);
            return fid;
        }
        catch (Exception e) {
            LOG.error((Object)("Exception: During file " + name + " lookup" + e));
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Common.FSKeyType gettype(Common.FidMsg fid) {
        int ret = this.gettype(this.clntPtr, fid.toByteArray());
        return Common.FSKeyType.valueOf((int)ret);
    }

    @Override
    public Common.FileType getfiletype(Common.FidMsg fid) {
        int ret = this.getfiletype(this.clntPtr, fid.toByteArray());
        return Common.FileType.valueOf((int)ret);
    }

    @Override
    public int remove(String name) {
        return this.remove(this.clntPtr, name);
    }

    @Override
    public int rename(String oldname, String newname) {
        return this.rename(this.clntPtr, oldname, newname);
    }

    private class BindingIdxTracker {
        int curDefaultBindingIdx = 0;
        int curScannerBindingIdx = 0;
        int curKvMultiOpBindingIdx = 0;

        synchronized long getBinding(BindingType btype) {
            int idx = 0;
            int maxCount = KvStoreClient.this.bindings.size();
            switch (btype) {
                case DefaultBinding: {
                    idx = this.curDefaultBindingIdx;
                    this.curDefaultBindingIdx = (this.curDefaultBindingIdx + 1) % maxCount;
                    break;
                }
                case ScannerBinding: {
                    idx = this.curScannerBindingIdx;
                    this.curScannerBindingIdx = (this.curScannerBindingIdx + 1) % maxCount;
                    break;
                }
                case KvMultiOpBinding: {
                    idx = this.curKvMultiOpBindingIdx;
                    this.curKvMultiOpBindingIdx = (this.curKvMultiOpBindingIdx + 1) % maxCount;
                    break;
                }
                case Max: {
                    idx = 0;
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("For Binding type: " + btype + " using binding at idx: " + idx + " binding: " + KvStoreClient.this.bindings.get(idx)));
            }
            return KvStoreClient.this.bindings.get(idx);
        }
    }

    public static enum BindingType {
        DefaultBinding,
        ScannerBinding,
        KvMultiOpBinding,
        Max;

    }
}

