/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.ycsb.db;

import com.mapr.db.Admin;
import com.mapr.db.FamilyDescriptor;
import com.mapr.db.TableDescriptor;
import com.mapr.db.exceptions.DBException;
import com.mapr.db.exceptions.TableExistsException;
import com.mapr.db.impl.MapRDBImpl;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.ExecutionException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.util.GenericOptionsParser;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapRDBAdminClient
extends Configured
implements Tool {
    private static final Logger _logger = LoggerFactory.getLogger(MapRDBAdminClient.class);
    private static final String PARAM_NAME_NUM_REGIONS = "num_regions";
    private static final String PARAM_NAME_FAMILY = "family";
    private static final String PARAM_NAME_TYPE = "type";
    private static final String PARAM_NAME_KEY_PREFIX = "key_prefix";
    private static final String PARAM_NAME_MULTICF = "multicf";
    private static final int PARAM_NAME_NUM_REGIONS_DEFAULT = 100;
    private static final String PARAM_NAME_FAMILY_DEFAULT = "default";
    private static final String PARAM_NAME_TYPE_DEFAULT = "json";
    private static final String PARAM_NAME_KEY_PREFIX_DEFAULT = "user";
    private static final boolean PARAM_NAME_MULTICF_DEFAULT = false;
    protected int num_splits_;
    protected String tablename_;
    protected String family_;
    protected String type_;
    protected String key_prefix_;
    protected boolean multicf_;
    protected Operation operation_;

    public int run(String[] args) throws Exception {
        String[] otherArgs = new GenericOptionsParser(this.getConf(), args).getRemainingArgs();
        if (otherArgs == null || otherArgs.length != 2) {
            this.usage();
            return 1;
        }
        this.tablename_ = otherArgs[1];
        this.operation_ = Operation.valueOf(otherArgs[0].toUpperCase());
        this.family_ = this.getConf().get(PARAM_NAME_FAMILY, PARAM_NAME_FAMILY_DEFAULT);
        this.type_ = this.getConf().get(PARAM_NAME_TYPE, PARAM_NAME_TYPE_DEFAULT).toUpperCase();
        this.key_prefix_ = this.getConf().get(PARAM_NAME_KEY_PREFIX, PARAM_NAME_KEY_PREFIX_DEFAULT);
        this.num_splits_ = this.getConf().getInt(PARAM_NAME_NUM_REGIONS, 100) - 1;
        this.multicf_ = this.getConf().getBoolean(PARAM_NAME_MULTICF, false);
        return this.run0();
    }

    protected int run0() throws IOException {
        switch (this.operation_) {
            case CREATE: {
                return this.createTable();
            }
        }
        return 1;
    }

    private int createTable() throws IOException {
        if (MapRDBImpl.tableExists((String)this.tablename_)) {
            _logger.error("Table: {} already exists.", (Object)this.tablename_);
            return 1;
        }
        _logger.info("Creating table: {} with column family: {} and total {} regions.", new Object[]{this.tablename_, this.family_, this.num_splits_ + 1});
        try {
            Admin admin = MapRDBImpl.newAdmin((Configuration)this.getConf());
            TableDescriptor tableDescriptor = MapRDBImpl.newTableDescriptor().setPath(this.tablename_);
            FamilyDescriptor familyDesc = MapRDBImpl.newDefaultFamilyDescriptor().setCompression(FamilyDescriptor.Compression.None);
            tableDescriptor.addFamily(familyDesc);
            if (this.multicf_) {
                FamilyDescriptor familyDesc2 = MapRDBImpl.newFamilyDescriptor((String)"cfother", (String)"field0").setCompression(FamilyDescriptor.Compression.None).setInMemory(true);
                tableDescriptor.addFamily(familyDesc2);
            }
            admin.createTable(tableDescriptor, this.getSplits());
            _logger.info("Table: {} created successfully", (Object)this.tablename_);
        }
        catch (TableExistsException e) {
            _logger.error("Error creating table: " + this.tablename_ + ".\n" + e.getMessage());
            throw e;
        }
        catch (DBException e) {
            _logger.error("Error creating table: " + this.tablename_ + ".\n" + e.getMessage());
            throw e;
        }
        return 0;
    }

    protected void usage() {
        System.out.println("MapRDBAdminClient 1.0\nUsage:\n");
        System.out.println(((Object)((Object)this)).getClass().getName() + " [-Doption=value]... <operation> <table_path>");
    }

    protected String[] getSplits() {
        long start = 1000000L;
        long end = 9999999L;
        long delta = (end - start) / (long)this.num_splits_;
        ArrayList<CallSite> splitKeys = new ArrayList<CallSite>();
        long split = start;
        for (int i = 0; i < this.num_splits_; ++i) {
            splitKeys.add((CallSite)((Object)(this.key_prefix_ + (split += delta))));
        }
        Collections.sort(splitKeys);
        _logger.info("Split keys: {}", splitKeys);
        String[] splits = new String[this.num_splits_];
        int i = 0;
        for (String string : splitKeys) {
            splits[i++] = string;
        }
        return splits;
    }

    public static void main(String[] args) throws InterruptedException, ExecutionException, Exception {
        _logger.info("Starting MapRDBAdminClient");
        int ret = ToolRunner.run((Tool)new MapRDBAdminClient(), (String[])args);
        System.exit(ret);
    }

    public static enum Operation {
        CREATE,
        DROP,
        ENABLE,
        DISABLE;

    }
}

