/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.ycsb.workload;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.google.common.collect.Maps;
import com.mapr.ycsb.Command;
import com.mapr.ycsb.workload.Insert;
import com.mapr.ycsb.workload.Load;
import com.mapr.ycsb.workload.Mix;
import com.mapr.ycsb.workload.Read;
import com.mapr.ycsb.workload.Scan;
import java.util.HashMap;
import java.util.Map;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
public abstract class Workload {
    private boolean enabled = true;
    private String id;
    public Map<String, String> props;
    private static Class<?>[] SUB_CLASSES = new Class[]{Load.class, Read.class, Insert.class, Mix.class, Scan.class};
    @JsonProperty(value="run_before")
    private Command[] runBefore;
    @JsonProperty(value="run_after")
    private Command[] runAfter;
    @JsonProperty(value="wait_before")
    private int waitBefore = 0;
    @JsonProperty(value="wait_after")
    private int waitAfter = 0;

    public static synchronized Class<?>[] getSubTypes() {
        return SUB_CLASSES;
    }

    void merge(Map<String, String> props) {
        HashMap newProps = Maps.newHashMap(props);
        for (Map.Entry<String, String> prop : this.props.entrySet()) {
            newProps.put(prop.getKey(), prop.getValue());
        }
        this.props = newProps;
    }

    public StringBuilder getParams() {
        StringBuilder params = new StringBuilder();
        for (Map.Entry<String, String> param : this.props.entrySet()) {
            params.append(" -p ").append(param.getKey()).append('=').append(param.getValue());
        }
        return params;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getId() {
        return this.id;
    }

    public void override(Map<String, String> props) {
        for (Map.Entry<String, String> prop : props.entrySet()) {
            this.props.put(prop.getKey(), prop.getValue());
        }
    }

    public Command[] getRunBefore() {
        return this.runBefore;
    }

    public Command[] getRunAfter() {
        return this.runAfter;
    }

    public int getWaitBefore() {
        return this.waitBefore;
    }

    public int getWaitAfter() {
        return this.waitAfter;
    }
}

