/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.ycsb;

import com.mapr.ycsb.config.Config;
import java.io.File;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.util.GenericOptionsParser;
import org.apache.hadoop.util.Tool;
import org.slf4j.Logger;

public abstract class App
extends Configured
implements Tool {
    private File configFile;
    protected Config config;
    private String sessionName;

    public int run(String[] args) throws Exception {
        String[] otherArgs = new GenericOptionsParser(this.getConf(), args).getRemainingArgs();
        if (otherArgs == null || otherArgs.length < 1 || otherArgs.length > 2) {
            this.usage();
            return 1;
        }
        this.configFile = new File(otherArgs[0]);
        this.config = Config.load(this.configFile);
        String java_bin = this.config.getJavaInfo().getBin();
        if (java_bin == null) {
            this.getLogger().error("The setting 'java' is required but missing in the config file.");
            return 1;
        }
        this.sessionName = otherArgs.length > 1 ? otherArgs[1] : String.valueOf(System.currentTimeMillis());
        return this.run0();
    }

    protected File getConfigFile() {
        return this.configFile;
    }

    protected Config getConfig() {
        return this.config;
    }

    protected abstract int run0() throws Exception;

    protected abstract Logger getLogger();

    protected void usage() {
        System.out.println("YCSB" + ((Object)((Object)this)).getClass().getSimpleName() + " 1.0\nUsage:\n");
        System.out.println(((Object)((Object)this)).getClass().getName() + " [-Doption=value]... <path_to_conf_file> [<session_name>]");
    }

    public String getSessionName() {
        return this.sessionName;
    }
}

