/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.ycsb.db;

import com.yahoo.ycsb.ByteArrayByteIterator;
import com.yahoo.ycsb.ByteIterator;
import com.yahoo.ycsb.DB;
import com.yahoo.ycsb.DBException;
import com.yahoo.ycsb.measurements.Measurements;
import java.io.IOException;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.Vector;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.ParseFilter;
import org.apache.hadoop.hbase.util.Bytes;

public class HBaseClient
extends DB {
    private static final Configuration config = HBaseConfiguration.create();
    private final Map<String, HTable> hTableMap = new HashMap<String, HTable>();
    public boolean _debug = false;
    public boolean _writeToWal = true;
    public int _batchSize = 1;
    public String _columnFamily = "";
    public byte[] _columnFamilyBytes;
    private Filter _filter = null;
    public static final int Ok = 0;
    public static final int ServerError = -1;
    public static final int HttpError = -2;
    public static final int NoMatchingRecord = -3;
    public static final Object tableLock = new Object();

    public void init() throws DBException {
        this._debug = this.getPropertyBool("debug", false);
        this._writeToWal = this.getPropertyBool("hbase.writeToWal", true);
        this._batchSize = this.getPropertyInt("batchsize", 1);
        this._columnFamily = this.getProperty("columnfamily");
        if (this._columnFamily == null) {
            System.err.println("Error, must specify a columnfamily for HBase table");
            throw new DBException("No columnfamily specified");
        }
        this._columnFamilyBytes = Bytes.toBytes((String)this._columnFamily);
        String hbaseFilter = this.getProperty("hbasefilter");
        if (hbaseFilter != null) {
            try {
                this._filter = new ParseFilter().parseFilterString(hbaseFilter);
                if (this._debug) {
                    System.out.println("Using HBase filter: " + this._filter);
                }
            }
            catch (Exception e) {
                System.err.println("An HBase filter was specified but could not be parsed.");
                throw new DBException((Throwable)e);
            }
        }
    }

    public void cleanup() throws DBException {
        Measurements _measurements = Measurements.getMeasurements();
        try {
            long st = System.nanoTime();
            for (HTable table : this.hTableMap.values()) {
                table.close();
            }
            long en = System.nanoTime();
            _measurements.measure("UPDATE", (int)((en - st) / 1000L));
        }
        catch (IOException e) {
            throw new DBException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HTable getHTable(String table) {
        Object object = tableLock;
        synchronized (object) {
            HTable hTable = this.hTableMap.get(table);
            if (hTable == null) {
                try {
                    hTable = new HTable(config, table);
                    boolean autoFlush = this.getPropertyBool("hbase.autoFlush", false);
                    boolean clearBufferOnFail = this.getPropertyBool("hbase.clearBufferOnFail", false);
                    hTable.setAutoFlush(autoFlush, clearBufferOnFail);
                    long writeBufferSize = this.getPropertyLong("hbase.writeBufferSize", 0xC00000L);
                    hTable.setWriteBufferSize(writeBufferSize);
                }
                catch (IOException e) {
                    System.err.println("Error accessing HBase table: " + e);
                    return null;
                }
                this.hTableMap.put(table, hTable);
            }
            return hTable;
        }
    }

    public int read(String table, String key, Set<String> fields, HashMap<String, ByteIterator> result) {
        HTable hTable = this.getHTable(table);
        if (hTable == null) {
            return -1;
        }
        Result r = null;
        try {
            if (this._debug) {
                System.out.println("Doing read from HBase columnfamily " + this._columnFamily);
                System.out.println("Doing read for key: " + key);
                System.out.println("Batch Size :" + this._batchSize);
            }
            String longValue = key.replaceAll("[^0-9]", "");
            long keynum = Long.parseLong(longValue);
            ArrayList<Get> gets = new ArrayList<Get>(this._batchSize);
            for (int i = 0; i < this._batchSize; ++i) {
                Get g = new Get(Bytes.toBytes((String)("user" + keynum + i)));
                if (fields == null) {
                    g.addFamily(this._columnFamilyBytes);
                } else {
                    for (String field : fields) {
                        g.addColumn(this._columnFamilyBytes, Bytes.toBytes((String)field));
                    }
                }
                if (this._filter != null) {
                    g.setFilter(this._filter);
                }
                if (this._batchSize <= 1) {
                    r = hTable.get(g);
                }
                gets.add(g);
            }
            if (this._batchSize > 1) {
                Result[] rarray = hTable.get(gets);
                r = rarray[0];
            }
        }
        catch (IOException e) {
            System.err.println("Error doing get: " + e);
            return -1;
        }
        catch (ConcurrentModificationException e) {
            return -1;
        }
        if (!r.isEmpty()) {
            for (Cell kv : r.rawCells()) {
                String column = Bytes.toString((byte[])CellUtil.cloneQualifier((Cell)kv));
                byte[] value = CellUtil.cloneValue((Cell)kv);
                result.put(column, (ByteIterator)new ByteArrayByteIterator(value));
                if (!this._debug) continue;
                System.out.println("Result for field: " + column + " is: " + Bytes.toString((byte[])value));
            }
            return 0;
        }
        if (this._debug) {
            System.out.println("No record found for key: " + key);
        }
        return -3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int scan(String table, String startkey, int recordcount, Set<String> fields, Vector<HashMap<String, ByteIterator>> result) {
        HTable hTable = this.getHTable(table);
        if (hTable == null) {
            return -1;
        }
        Scan s = new Scan(Bytes.toBytes((String)startkey));
        if (this._debug) {
            System.out.println("Scanning for " + recordcount + " records, starting at '" + startkey + "'.");
        }
        s.setCaching(recordcount);
        if (fields == null) {
            s.addFamily(this._columnFamilyBytes);
        } else {
            for (String field : fields) {
                s.addColumn(this._columnFamilyBytes, Bytes.toBytes((String)field));
            }
        }
        if (this._filter != null) {
            s.setFilter(this._filter);
        }
        try (ResultScanner scanner = null;){
            scanner = hTable.getScanner(s);
            int numResults = 0;
            Result rr = scanner.next();
            while (rr != null) {
                String key = Bytes.toString((byte[])rr.getRow());
                if (this._debug) {
                    System.out.println("Got scan result for key: " + key);
                }
                HashMap<String, ByteArrayByteIterator> rowResult = new HashMap<String, ByteArrayByteIterator>();
                for (Cell kv : rr.rawCells()) {
                    String column = Bytes.toString((byte[])CellUtil.cloneQualifier((Cell)kv));
                    byte[] value = CellUtil.cloneValue((Cell)kv);
                    rowResult.put(column, new ByteArrayByteIterator(value));
                }
                result.add(rowResult);
                if (++numResults >= recordcount) {
                    break;
                }
                rr = scanner.next();
            }
        }
        return 0;
    }

    public int update(String table, String key, HashMap<String, ByteIterator> values) {
        HTable hTable = this.getHTable(table);
        if (hTable == null) {
            return -1;
        }
        if (this._debug) {
            System.out.println("Setting up put for key: " + key);
        }
        Put p = new Put(Bytes.toBytes((String)key));
        p.setDurability(this._writeToWal ? Durability.USE_DEFAULT : Durability.SKIP_WAL);
        for (Map.Entry<String, ByteIterator> entry : values.entrySet()) {
            if (this._debug) {
                System.out.println("Adding field/value " + entry.getKey() + "/" + entry.getValue() + " to put request");
            }
            p.add(this._columnFamilyBytes, Bytes.toBytes((String)entry.getKey()), entry.getValue().toArray());
        }
        try {
            hTable.put(p);
        }
        catch (IOException e) {
            if (this._debug) {
                System.err.println("Error doing put: " + e);
            }
            return -1;
        }
        catch (ConcurrentModificationException e) {
            return -1;
        }
        return 0;
    }

    public int insert(String table, String key, HashMap<String, ByteIterator> values) {
        return this.update(table, key, values);
    }

    public int delete(String table, String key) {
        HTable hTable = this.getHTable(table);
        if (hTable == null) {
            return -1;
        }
        if (this._debug) {
            System.out.println("Doing delete for key: " + key);
        }
        Delete d = new Delete(Bytes.toBytes((String)key));
        try {
            hTable.delete(d);
        }
        catch (IOException e) {
            if (this._debug) {
                System.err.println("Error doing delete: " + e);
            }
            return -1;
        }
        return 0;
    }

    public static void main(String[] args) {
        if (args.length != 3) {
            System.out.println("Please specify a threadcount, columnfamily and operation count");
            System.exit(0);
        }
        int keyspace = 10000;
        int threadcount = Integer.parseInt(args[0]);
        final String columnfamily = args[1];
        final int opcount = Integer.parseInt(args[2]) / threadcount;
        Vector<1> allthreads = new Vector<1>();
        for (int i = 0; i < threadcount; ++i) {
            Thread t = new Thread(){

                @Override
                public void run() {
                    try {
                        Random random = new Random();
                        HBaseClient client = new HBaseClient();
                        Properties props = new Properties();
                        props.setProperty("columnfamily", columnfamily);
                        props.setProperty("debug", "true");
                        client.setProperties(props);
                        client.init();
                        long accum = 0L;
                        for (int i = 0; i < opcount; ++i) {
                            int keynum = random.nextInt(10000);
                            String key = "user" + keynum;
                            long st = System.currentTimeMillis();
                            HashSet<String> scanFields = new HashSet<String>();
                            scanFields.add("field1");
                            scanFields.add("field3");
                            Vector<HashMap<String, ByteIterator>> scanResults = new Vector<HashMap<String, ByteIterator>>();
                            int rescode = client.scan("table1", "user2", 20, null, scanResults);
                            long en = System.currentTimeMillis();
                            accum += en - st;
                            if (rescode != 0) {
                                System.out.println("Error " + rescode + " for " + key);
                            }
                            if (i % 1 != 0) continue;
                            System.out.println(i + " operations, average latency: " + (double)accum / (double)i);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            };
            allthreads.add(t);
        }
        long st = System.currentTimeMillis();
        for (Thread thread : allthreads) {
            thread.start();
        }
        for (Thread thread : allthreads) {
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {}
        }
        long en = System.currentTimeMillis();
        System.out.println("Throughput: " + 1000.0 * ((double)(opcount * threadcount) / (double)(en - st)) + " ops/sec");
    }
}

