/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.Lists;
import com.mapr.db.TabletInfo;
import com.mapr.db.exceptions.DBException;
import com.mapr.db.exceptions.ExceptionHandler;
import com.mapr.db.exceptions.TableNotFoundException;
import com.mapr.db.impl.BaseJsonTable;
import com.mapr.db.impl.CommitContextHelper;
import com.mapr.db.impl.ConditionDescriptor;
import com.mapr.db.impl.ConditionImpl;
import com.mapr.db.impl.ConditionNode;
import com.mapr.db.impl.Constants;
import com.mapr.db.impl.DBDocumentStream;
import com.mapr.db.impl.EncodedBufFamIdInfo;
import com.mapr.db.impl.IdCodec;
import com.mapr.db.impl.MapRDBTableImplHelper;
import com.mapr.db.rowcol.DBDocumentImpl;
import com.mapr.db.rowcol.DBValueBuilderImpl;
import com.mapr.db.rowcol.MutationImpl;
import com.mapr.db.rowcol.RowcolCodec;
import com.mapr.db.rowcol.SerializedFamilyInfo;
import com.mapr.db.util.ByteBufs;
import com.mapr.fs.ErrnoException;
import com.mapr.fs.MapRHTable;
import com.mapr.fs.MapRResultScanner;
import com.mapr.fs.MapRTabletScanner;
import com.mapr.fs.jni.IndexSyncStateTracker;
import com.mapr.fs.jni.MapRPut;
import com.mapr.fs.jni.MapRScan;
import com.mapr.fs.jni.MapRUpdateAndGet;
import com.mapr.fs.proto.Dbserver;
import com.mapr.org.apache.hadoop.hbase.util.Bytes;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.json.JSONException;
import org.json.JSONStringer;
import org.ojai.Document;
import org.ojai.DocumentStream;
import org.ojai.FieldPath;
import org.ojai.Value;
import org.ojai.annotation.API;
import org.ojai.json.JsonOptions;
import org.ojai.store.DocumentMutation;
import org.ojai.store.OpListener;
import org.ojai.store.QueryCondition;
import org.ojai.store.QueryResult;
import org.ojai.store.exceptions.DocumentExistsException;
import org.ojai.store.exceptions.DocumentNotFoundException;
import org.ojai.store.exceptions.FailedOp;
import org.ojai.store.exceptions.IllegalMutationException;
import org.ojai.store.exceptions.MultiOpException;
import org.ojai.store.exceptions.StoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API.Internal
public class MapRDBTableImpl
extends BaseJsonTable {
    private static Logger logger = LoggerFactory.getLogger(MapRDBTableImpl.class);
    ExecutorService executor = Executors.newFixedThreadPool(8);
    @VisibleForTesting
    public int testMulitOpExIdx = 0;

    public MapRDBTableImpl(Configuration config, Path tablePath) throws DBException, TableNotFoundException {
        super(config, new MapRHTable());
        try {
            this.maprTable.init(config, tablePath);
            if (!this.maprTable.getMapRFS().exists(tablePath)) {
                throw new TableNotFoundException(tablePath);
            }
            this.closed = false;
            this.initCommon(null);
        }
        catch (IOException e) {
            throw ExceptionHandler.handle(e, "<init>()");
        }
    }

    @Override
    public void findById(OpListener listener, String id) {
        this._findById(listener, IdCodec.encode(id), (QueryCondition)null, (String[])null);
    }

    @Override
    public void findById(OpListener listener, ByteBuffer id) {
        this._findById(listener, IdCodec.encode(id), (QueryCondition)null, (String[])null);
    }

    public void findById(OpListener listener, Value id) {
        this._findById(listener, IdCodec.encode(id), (QueryCondition)null, (String[])null);
    }

    @Override
    public void findById(OpListener listener, String id, FieldPath ... fields) {
        this.findById(listener, id, this.getStringPaths(fields));
    }

    @Override
    public void findById(OpListener listener, String id, String ... paths) {
        this._findById(listener, IdCodec.encode(id), null, paths);
    }

    @Override
    public void findById(OpListener listener, ByteBuffer id, FieldPath ... fields) {
        this.findById(listener, id, this.getStringPaths(fields));
    }

    @Override
    public void findById(OpListener listener, ByteBuffer id, String ... paths) {
        this._findById(listener, IdCodec.encode(id), null, paths);
    }

    public void findById(OpListener listener, Value id, String ... paths) {
        this._findById(listener, IdCodec.encode(id), null, paths);
    }

    public void findById(OpListener listener, Value id, FieldPath ... fields) {
        this.findById(listener, id, this.getStringPaths(fields));
    }

    @Override
    public void findById(OpListener listener, String id, QueryCondition c) {
        this._findById(listener, IdCodec.encode(id), c, new String[0]);
    }

    @Override
    public void findById(OpListener listener, ByteBuffer id, QueryCondition c) {
        this._findById(listener, IdCodec.encode(id), c, new String[0]);
    }

    public void findById(OpListener listener, Value id, QueryCondition c) {
        this._findById(listener, IdCodec.encode(id), c, new String[0]);
    }

    @Override
    public void findById(OpListener listener, String id, QueryCondition c, FieldPath ... fields) {
        this.findById(listener, id, c, this.getStringPaths(fields));
    }

    @Override
    public void findById(OpListener listener, String id, QueryCondition c, String ... paths) {
        this._findById(listener, IdCodec.encode(id), c, paths);
    }

    @Override
    public void findById(OpListener listener, ByteBuffer id, QueryCondition c, FieldPath ... fields) {
        this.findById(listener, id, c, this.getStringPaths(fields));
    }

    @Override
    public void findById(OpListener listener, ByteBuffer id, QueryCondition c, String ... paths) {
        this._findById(listener, IdCodec.encode(id), c, paths);
    }

    public void findById(OpListener listener, Value id, QueryCondition c, FieldPath ... fields) {
        this.findById(listener, id, c, this.getStringPaths(fields));
    }

    public void findById(OpListener listener, Value id, QueryCondition c, String ... paths) {
        this._findById(listener, IdCodec.encode(id), c, paths);
    }

    private void _findById(OpListener listener, ByteBuffer id, QueryCondition c, String ... paths) {
        this.executor.execute(new AsyncReader(listener, id, c, paths));
    }

    @Override
    protected QueryResult _doScan(QueryCondition c, String ... paths) throws DBException {
        MapRDBTableImplHelper.CondAndProjPaths bothpaths = new MapRDBTableImplHelper.CondAndProjPaths();
        MapRDBTableImplHelper.setPaths(c, paths, bothpaths);
        MapRScan maprscan = MapRDBTableImplHelper.toMapRScan((BaseJsonTable)this, c, bothpaths.allPaths);
        try {
            long id = this.maprTable.getInode().getScanner(maprscan);
            MapRResultScanner scanner = new MapRResultScanner(maprscan, this.maprTable, id);
            this.maprTable.addScanner(scanner);
            if (paths != null) {
                return new DBDocumentStream(scanner, this.isExcludeId(), this, bothpaths.condPaths, paths);
            }
            return new DBDocumentStream(scanner, this.isExcludeId(), this);
        }
        catch (IOException e) {
            throw ExceptionHandler.handle(e, "scan()");
        }
    }

    @Override
    public void insertOrReplace(Document r) throws DBException {
        Preconditions.checkNotNull((Object)r, (Object)"Document being inserted cannot be null");
        DBDocumentImpl mdbRec = RowcolCodec.getDBDocument(r);
        Value id = mdbRec.getId();
        Preconditions.checkArgument((id != null ? 1 : 0) != 0, (Object)"Document needs to have '_id' in the map as a key.");
        this.insertOrReplace(id, r);
    }

    @Override
    public void insertOrReplace(String id, Document r) throws DBException {
        this._insertOrReplace(IdCodec.encode(id), r);
    }

    @Override
    public void insertOrReplace(ByteBuffer id, Document r) throws DBException {
        this._insertOrReplace(IdCodec.encode(id), r);
    }

    public void insertOrReplace(Value id, Document r) throws DBException {
        this._insertOrReplace(IdCodec.encode(id), r);
    }

    private void checkDuplicateIds(ByteBuffer id, Document r) {
        Value recIdVal = r.getId();
        ByteBuffer encodedRecId = null;
        if (recIdVal != null && !(encodedRecId = IdCodec.encode(recIdVal)).equals(id)) {
            Object errorMsg = null;
            errorMsg = recIdVal.getType() == Value.Type.STRING ? "Document needs to have '_id' value same as passed id of " + IdCodec.decodeString(id) + " while Document has " + recIdVal.getString() : "Document needs to have '_id' value same as the passed in id ";
            throw new IllegalArgumentException((String)errorMsg);
        }
    }

    private void _insertOrReplace(ByteBuffer inId, Document doc) throws DBException {
        Preconditions.checkNotNull((Object)doc, (Object)"Document being inserted cannot be null");
        this.checkClosed();
        ByteBuffer id = ByteBufs.ensurePreferred(inId);
        this.checkDuplicateIds(id, doc);
        SerializedFamilyInfo[] info = RowcolCodec.encode(doc, (Map<FieldPath, Integer>)this.idPathMap, false, this.isPreserveTS());
        assert (info.length == this.sortedById().size());
        EncodedBufFamIdInfo ebf = MapRDBTableImplHelper.getEncBufsAndFamilyIds(info);
        MapRPut mput = MapRDBTableImplHelper.toMapRPut(id, ebf.familyIds, ebf.encBuffers, (byte)0);
        try {
            if (this.isBufferWrite()) {
                this.maprTable.put(mput);
            } else {
                this.maprTable.syncPut(mput, true);
            }
        }
        catch (IOException e) {
            throw ExceptionHandler.handle(e, "insertOrReplace()");
        }
    }

    private ByteBuffer getKeyFieldsValue(Document r, String fieldAsKey) throws DBException {
        if (r == null) {
            throw new IllegalArgumentException("Document cannot be null");
        }
        if (fieldAsKey == null) {
            throw new IllegalArgumentException("Requested key cannot be null.");
        }
        Value value = r.getValue(fieldAsKey);
        if (value == null) {
            throw new IllegalArgumentException("Requested key's value cannot be null in the record.");
        }
        return IdCodec.encode(value);
    }

    @Override
    public void insertOrReplace(Document r, FieldPath fieldAsKey) throws DBException {
        this.insertOrReplace(r, fieldAsKey.asPathString());
    }

    @Override
    public void insertOrReplace(Document r, String fieldAsKey) throws DBException {
        ByteBuffer id = this.getKeyFieldsValue(r, fieldAsKey);
        this._insertOrReplace(id, r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<FailedOp> processBatch(List<Document> batch, BaseJsonTable.BatchingType type, String fieldAsKey) {
        AsyncBatchInfo abi = new AsyncBatchInfo(batch.size(), type, fieldAsKey);
        for (int i = 0; i < batch.size(); ++i) {
            this.executor.execute(new AsyncBatchElement(batch.get(i), abi, i));
        }
        try {
            AsyncBatchInfo asyncBatchInfo = abi;
            synchronized (asyncBatchInfo) {
                while (abi.numCompl < abi.numObj) {
                    abi.wait();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        batch.clear();
        return abi.failedDocuments;
    }

    @Override
    public void insertOrReplace(DocumentStream rs) throws MultiOpException {
        String fak = null;
        this.insertOrReplace(rs, fak);
    }

    @Override
    public void insertOrReplace(DocumentStream rs, FieldPath fieldAsKey) throws MultiOpException {
        this.insertOrReplace(rs, fieldAsKey.asPathString());
    }

    @Override
    public void insertOrReplace(DocumentStream rs, String fieldAsKey) throws MultiOpException {
        Iterator itrs = rs.iterator();
        List<Object> failedDocuments = null;
        ArrayList<Document> batchedDocumentList = new ArrayList<Document>();
        boolean hitWriteError = false;
        while (itrs.hasNext()) {
            Document readDocument = (Document)itrs.next();
            if (readDocument == null) {
                failedDocuments = new ArrayList<FailedOp>();
                failedDocuments.add(new FailedOp(readDocument, (Exception)new IllegalArgumentException()));
                if (rs instanceof DBDocumentStream) {
                    ((DBDocumentStream)rs).makeIteratorNotOpen();
                }
                throw new MultiOpException(failedDocuments);
            }
            batchedDocumentList.add(readDocument);
            if (batchedDocumentList.size() == 8) {
                failedDocuments = this.processBatch(batchedDocumentList, BaseJsonTable.BatchingType.INSERTORREPLACE, fieldAsKey);
            }
            if (failedDocuments == null || failedDocuments.size() == 0) continue;
            hitWriteError = true;
            break;
        }
        if (!hitWriteError && batchedDocumentList.size() != 0) {
            failedDocuments = this.processBatch(batchedDocumentList, BaseJsonTable.BatchingType.INSERTORREPLACE, fieldAsKey);
        }
        if (failedDocuments != null && failedDocuments.size() != 0) {
            if (rs instanceof DBDocumentStream) {
                ((DBDocumentStream)rs).makeIteratorNotOpen();
            }
            throw new MultiOpException(failedDocuments);
        }
    }

    @Override
    public void update(String id, DocumentMutation m) throws DBException {
        this._update(IdCodec.encode(id), m);
    }

    @Override
    public void update(ByteBuffer id, DocumentMutation m) throws DBException {
        this._update(IdCodec.encode(id), m);
    }

    public void update(Value id, DocumentMutation m) throws DBException {
        this._update(IdCodec.encode(id), m);
    }

    private void _update(ByteBuffer inId, DocumentMutation m) throws DBException {
        this.checkClosed();
        ByteBuffer id = ByteBufs.ensurePreferred(inId);
        MutationImpl rmi = (MutationImpl)m;
        SerializedFamilyInfo[] info = rmi.rowcolSerialize((Map<FieldPath, Integer>)this.idPathMap);
        boolean isRMW = rmi.needsReadOnServer();
        if (isRMW) {
            MapRUpdateAndGet muag = new MapRUpdateAndGet();
            assert (info.length == this.idPathMap.size());
            EncodedBufFamIdInfo ebf = MapRDBTableImplHelper.getEncBufsAndFamilyIds(info);
            Map<Integer, List<String>> fieldsMap = rmi.getFieldsNeedRead((Map<FieldPath, Integer>)this.idPathMap);
            byte[] serRowConstraint = MapRDBTableImplHelper.fieldPathsToSerRowConstraint(fieldsMap);
            assert (serRowConstraint != null);
            try {
                this.maprTable.updateRecord(id, ebf.encBuffers, ebf.familyIds, serRowConstraint, this.isBufferWrite(), muag);
            }
            catch (IOException e) {
                throw this.handleMutationException(e, "update()");
            }
        } else {
            MapRDBTableImplHelper.insertOrReplace(this, id, info);
        }
    }

    private StoreException handleMutationException(IOException e, String operation) {
        if (e instanceof ErrnoException && ((ErrnoException)e).getErrno() == 22) {
            return new IllegalMutationException("Invalid mutation: one or more mutation operation could not be applied.", (Throwable)e);
        }
        return ExceptionHandler.handle(e, operation);
    }

    @Override
    public void delete(String id) throws DBException {
        this._delete(IdCodec.encode(id));
    }

    @Override
    public void delete(ByteBuffer id) throws DBException {
        this._delete(IdCodec.encode(id));
    }

    public void delete(Value id) throws DBException {
        this._delete(IdCodec.encode(id));
    }

    @Override
    public void delete(Document r) throws DBException {
        Preconditions.checkArgument((r != null ? 1 : 0) != 0, (Object)"Document being deleted cannot be null");
        DBDocumentImpl mdbRec = RowcolCodec.getDBDocument(r);
        Value id = mdbRec.getId();
        Preconditions.checkArgument((id != null ? 1 : 0) != 0, (Object)"Document needs to have '_id' in the map as a key.");
        this.delete(id);
    }

    @Override
    public void delete(Document r, FieldPath fieldAsKey) throws DBException {
        this.delete(r, fieldAsKey.asPathString());
    }

    @Override
    public void delete(Document r, String fieldAsKey) throws DBException {
        this._delete(this.getKeyFieldsValue(r, fieldAsKey));
    }

    private void _delete(ByteBuffer inId) throws DBException {
        this.checkClosed();
        int[] famIds = new int[this.sortedById().size()];
        int i = 0;
        for (Map.Entry<FieldPath, Integer> entry : this.sortedById()) {
            famIds[i] = entry.getValue();
            ++i;
        }
        ByteBuffer id = ByteBufs.ensurePreferred(inId);
        MapRPut mput = MapRDBTableImplHelper.toMapRPut(id, famIds, null, (byte)17);
        try {
            if (this.isBufferWrite()) {
                this.maprTable.put(mput);
            } else {
                this.maprTable.syncPut(mput, true);
            }
        }
        catch (IOException e) {
            throw ExceptionHandler.handle(e, "delete()");
        }
    }

    @Override
    public void delete(DocumentStream rs, FieldPath fieldAsKey) throws MultiOpException {
        this.delete(rs, fieldAsKey.asPathString());
    }

    @Override
    public void delete(DocumentStream rs) throws MultiOpException {
        String fak = null;
        this.delete(rs, fak);
    }

    @Override
    public void delete(DocumentStream rs, String fieldAsKey) throws MultiOpException {
        Iterator itrs = rs.iterator();
        List<Object> failedDocuments = new ArrayList<FailedOp>();
        ArrayList<Document> batchedDocumentList = new ArrayList<Document>();
        boolean hitDeleteError = false;
        while (itrs.hasNext()) {
            Document readDocument = (Document)itrs.next();
            if (readDocument == null) {
                failedDocuments = new ArrayList();
                failedDocuments.add(new FailedOp(readDocument, (Exception)new IllegalArgumentException()));
                if (rs instanceof DBDocumentStream) {
                    ((DBDocumentStream)rs).makeIteratorNotOpen();
                }
                throw new MultiOpException(failedDocuments);
            }
            batchedDocumentList.add(readDocument);
            if (batchedDocumentList.size() == 8) {
                failedDocuments = this.processBatch(batchedDocumentList, BaseJsonTable.BatchingType.DELETE, fieldAsKey);
            }
            if (failedDocuments == null || failedDocuments.size() == 0) continue;
            hitDeleteError = true;
            break;
        }
        if (!hitDeleteError && batchedDocumentList.size() != 0) {
            failedDocuments = this.processBatch(batchedDocumentList, BaseJsonTable.BatchingType.DELETE, fieldAsKey);
        }
        if (failedDocuments != null && failedDocuments.size() != 0) {
            if (rs instanceof DBDocumentStream) {
                ((DBDocumentStream)rs).makeIteratorNotOpen();
            }
            throw new MultiOpException(failedDocuments);
        }
    }

    @Override
    public void increment(String id, String field, long inc) throws DBException {
        this._update(IdCodec.encode(id), new MutationImpl().increment(field, inc));
    }

    @Override
    public void increment(ByteBuffer id, String field, long inc) throws DBException {
        this._update(IdCodec.encode(id), new MutationImpl().increment(field, inc));
    }

    public void increment(Value id, String field, long inc) throws DBException {
        this._update(IdCodec.encode(id), new MutationImpl().increment(field, inc));
    }

    @Override
    public void increment(String id, String field, float inc) throws DBException {
        this._update(IdCodec.encode(id), new MutationImpl().increment(field, inc));
    }

    @Override
    public void increment(ByteBuffer id, String field, float inc) throws DBException {
        this._update(IdCodec.encode(id), new MutationImpl().increment(field, inc));
    }

    public void increment(Value id, String field, float inc) throws DBException {
        this._update(IdCodec.encode(id), new MutationImpl().increment(field, inc));
    }

    @Override
    public void increment(String id, String field, double inc) throws DBException {
        this._update(IdCodec.encode(id), new MutationImpl().increment(field, inc));
    }

    @Override
    public void increment(ByteBuffer id, String field, double inc) throws DBException {
        this._update(IdCodec.encode(id), new MutationImpl().increment(field, inc));
    }

    public void increment(Value id, String field, double inc) throws DBException {
        this._update(IdCodec.encode(id), new MutationImpl().increment(field, inc));
    }

    @Override
    public void increment(String id, String field, BigDecimal inc) throws DBException {
        this._update(IdCodec.encode(id), new MutationImpl().increment(field, inc));
    }

    @Override
    public void increment(ByteBuffer id, String field, BigDecimal inc) throws DBException {
        this._update(IdCodec.encode(id), new MutationImpl().increment(field, inc));
    }

    public void increment(Value id, String field, BigDecimal inc) throws DBException {
        this._update(IdCodec.encode(id), new MutationImpl().increment(field, inc));
    }

    @Override
    public void increment(String id, String field, byte inc) throws DBException {
        this._update(IdCodec.encode(id), new MutationImpl().increment(field, inc));
    }

    @Override
    public void increment(ByteBuffer id, String field, byte inc) throws DBException {
        this._update(IdCodec.encode(id), new MutationImpl().increment(field, inc));
    }

    public void increment(Value id, String field, byte inc) throws DBException {
        this._update(IdCodec.encode(id), new MutationImpl().increment(field, inc));
    }

    @Override
    public void increment(String id, String field, short inc) throws DBException {
        this._update(IdCodec.encode(id), new MutationImpl().increment(field, inc));
    }

    @Override
    public void increment(ByteBuffer id, String field, short inc) throws DBException {
        this._update(IdCodec.encode(id), new MutationImpl().increment(field, inc));
    }

    public void increment(Value id, String field, short inc) throws DBException {
        this._update(IdCodec.encode(id), new MutationImpl().increment(field, inc));
    }

    @Override
    public void increment(String id, String field, int inc) throws DBException {
        this._update(IdCodec.encode(id), new MutationImpl().increment(field, inc));
    }

    @Override
    public void increment(ByteBuffer id, String field, int inc) throws DBException {
        this._update(IdCodec.encode(id), new MutationImpl().increment(field, inc));
    }

    public void increment(Value id, String field, int inc) throws DBException {
        this._update(IdCodec.encode(id), new MutationImpl().increment(field, inc));
    }

    @Override
    public void insert(String id, Document r) throws DBException {
        this._insert(IdCodec.encode(id), r);
    }

    @Override
    public void insert(ByteBuffer id, Document r) throws DBException {
        this._insert(IdCodec.encode(id), r);
    }

    public void insert(Value id, Document r) throws DBException {
        this._insert(IdCodec.encode(id), r);
    }

    @Override
    public void insert(Document r) throws DBException {
        Document mdbRec = r instanceof DBDocumentImpl ? r : (Document)DBValueBuilderImpl.KeyValueBuilder.initFrom(r);
        Value id = mdbRec.getId();
        if (id == null) {
            throw new IllegalArgumentException("Document needs to have '_id' in the map as a key.");
        }
        this.insert(id, r);
    }

    private void _insert(ByteBuffer inId, Document r) throws DBException {
        this.checkClosed();
        ByteBuffer id = ByteBufs.ensurePreferred(inId);
        if (!this._checkAndReplace(id, Constants.ROW_NOT_EXISTS_CONDITION, r)) {
            throw new DocumentExistsException("A row with key \"" + Bytes.toStringBinary((ByteBuffer)id) + "\" already exist in the table");
        }
    }

    @Override
    public void insert(Document r, FieldPath fieldAsKey) throws DBException {
        this.insert(r, fieldAsKey.asPathString());
    }

    @Override
    public void insert(Document r, String fieldAsKey) throws DBException {
        this._insert(this.getKeyFieldsValue(r, fieldAsKey), r);
    }

    @Override
    public void insert(DocumentStream rs, FieldPath fieldAsKey) throws MultiOpException {
        this.insert(rs, fieldAsKey.asPathString());
    }

    @Override
    public void insert(DocumentStream rs) throws MultiOpException {
        this.insert(rs, (String)null);
    }

    @Override
    public void insert(DocumentStream rs, String fieldAsKey) throws MultiOpException {
        Iterator itrs = rs.iterator();
        List<Object> failedDocuments = null;
        ArrayList<Document> batchedDocumentList = new ArrayList<Document>();
        boolean hitError = false;
        while (itrs.hasNext()) {
            Document readDocument = (Document)itrs.next();
            if (readDocument == null) {
                failedDocuments = new ArrayList<FailedOp>();
                failedDocuments.add(new FailedOp(readDocument, (Exception)new IllegalArgumentException()));
                if (rs instanceof DBDocumentStream) {
                    ((DBDocumentStream)rs).makeIteratorNotOpen();
                }
                throw new MultiOpException(failedDocuments);
            }
            batchedDocumentList.add(readDocument);
            if (batchedDocumentList.size() == 8) {
                failedDocuments = this.processBatch(batchedDocumentList, BaseJsonTable.BatchingType.INSERT, fieldAsKey);
            }
            if (failedDocuments == null || failedDocuments.size() == 0) continue;
            hitError = true;
            break;
        }
        if (!hitError && batchedDocumentList.size() != 0) {
            failedDocuments = this.processBatch(batchedDocumentList, BaseJsonTable.BatchingType.INSERT, fieldAsKey);
        }
        if (failedDocuments != null && failedDocuments.size() != 0) {
            if (rs instanceof DBDocumentStream) {
                ((DBDocumentStream)rs).makeIteratorNotOpen();
            }
            throw new MultiOpException(failedDocuments);
        }
    }

    @Override
    public void replace(String id, Document r) throws DBException {
        this._replace(IdCodec.encode(id), r);
    }

    @Override
    public void replace(ByteBuffer id, Document r) throws DBException {
        this._replace(IdCodec.encode(id), r);
    }

    public void replace(Value id, Document r) throws DBException {
        this._replace(IdCodec.encode(id), r);
    }

    @Override
    public void replace(Document r) throws DBException {
        Document mdbRec = r instanceof Document ? r : (Document)DBValueBuilderImpl.KeyValueBuilder.initFrom(r);
        Value id = mdbRec.getId();
        if (id == null) {
            throw new IllegalArgumentException("Document needs to have '_id' in the map as a key.");
        }
        this.replace(id, r);
    }

    private void _replace(ByteBuffer inId, Document r) throws DBException {
        this.checkClosed();
        ByteBuffer id = ByteBufs.ensurePreferred(inId);
        if (!this._checkAndReplace(id, Constants.ROW_EXISTS_CONDITION, r)) {
            throw new DocumentNotFoundException("A row with key \"" + Bytes.toStringBinary((ByteBuffer)id) + "\" does not exist in the table");
        }
    }

    @Override
    public void replace(Document r, FieldPath fieldAsKey) throws DBException {
        this.replace(r, fieldAsKey.asPathString());
    }

    @Override
    public void replace(Document r, String fieldAsKey) throws DBException {
        ByteBuffer id = this.getKeyFieldsValue(r, fieldAsKey);
        this._replace(id, r);
    }

    @Override
    public void replace(DocumentStream rs, FieldPath fieldAsKey) throws MultiOpException {
        this.replace(rs, fieldAsKey.asPathString());
    }

    @Override
    public void replace(DocumentStream rs) throws MultiOpException {
        String fak = null;
        this.replace(rs, fak);
    }

    @Override
    public void replace(DocumentStream rs, String fieldAsKey) throws MultiOpException {
        Iterator itrs = rs.iterator();
        List<Object> failedDocuments = null;
        ArrayList<Document> batchedDocumentList = new ArrayList<Document>();
        boolean hitError = false;
        while (itrs.hasNext()) {
            Document readDocument = (Document)itrs.next();
            if (readDocument == null) {
                failedDocuments = new ArrayList<FailedOp>();
                failedDocuments.add(new FailedOp(readDocument, (Exception)new IllegalArgumentException()));
                if (rs instanceof DBDocumentStream) {
                    ((DBDocumentStream)rs).makeIteratorNotOpen();
                }
                throw new MultiOpException(failedDocuments);
            }
            batchedDocumentList.add(readDocument);
            if (batchedDocumentList.size() == 8) {
                failedDocuments = this.processBatch(batchedDocumentList, BaseJsonTable.BatchingType.REPLACE, fieldAsKey);
            }
            if (failedDocuments == null || failedDocuments.size() == 0) continue;
            hitError = true;
            break;
        }
        if (!hitError && batchedDocumentList.size() != 0) {
            failedDocuments = this.processBatch(batchedDocumentList, BaseJsonTable.BatchingType.REPLACE, fieldAsKey);
        }
        if (failedDocuments != null && failedDocuments.size() != 0) {
            if (rs instanceof DBDocumentStream) {
                ((DBDocumentStream)rs).makeIteratorNotOpen();
            }
            throw new MultiOpException(failedDocuments);
        }
    }

    @Override
    public boolean checkAndMutate(String id, QueryCondition condition, DocumentMutation m) throws DBException {
        return this._checkAndMutate(IdCodec.encode(id), condition, m);
    }

    @Override
    public boolean checkAndMutate(ByteBuffer id, QueryCondition condition, DocumentMutation m) throws DBException {
        return this._checkAndMutate(IdCodec.encode(id), condition, m);
    }

    public boolean checkAndMutate(Value id, QueryCondition condition, DocumentMutation m) throws DBException {
        return this._checkAndMutate(IdCodec.encode(id), condition, m);
    }

    private boolean _checkAndMutate(ByteBuffer inId, QueryCondition condition, DocumentMutation m) throws DBException {
        if (m == null) {
            throw new NullPointerException("DocumentMutation cannot be null");
        }
        if (condition == null || condition.isEmpty()) {
            throw new IllegalArgumentException("QueryCondition cannot be null or empty");
        }
        this.checkClosed();
        ConditionDescriptor condDesc = ((ConditionImpl)condition).getDescriptor((BiMap<FieldPath, Integer>)this.idPathMap, null);
        ByteBuffer serCond = ByteBufs.ensurePreferred(condDesc.getSerialized());
        MutationImpl rmi = (MutationImpl)m;
        SerializedFamilyInfo[] info = rmi.rowcolSerialize((Map<FieldPath, Integer>)this.idPathMap);
        assert (info.length == this.idPathMap.size());
        MapRUpdateAndGet muag = new MapRUpdateAndGet();
        EncodedBufFamIdInfo ebf = MapRDBTableImplHelper.getEncBufsAndFamilyIds(info);
        byte[] serRowConstraint = MapRDBTableImplHelper.fieldPathsToSerRowConstraint(MapRDBTableImplHelper.mergeFieldPathList(rmi.getFieldsNeedRead((Map<FieldPath, Integer>)this.idPathMap), MapRDBTableImplHelper.condFieldPathMapToCondFieldPathStrMap(condDesc.getFamilyFieldPathsMap())));
        ByteBuffer id = ByteBufs.ensurePreferred(inId);
        try {
            this.maprTable.checkAndMutate(id, ebf.encBuffers, ebf.familyIds, serRowConstraint, serCond, this.isBufferWrite(), muag);
        }
        catch (IOException e) {
            throw this.handleMutationException(e, "checkAndMutate()");
        }
        return muag.conditionSuccess;
    }

    @Override
    public boolean checkAndDelete(String id, QueryCondition condition) throws DBException {
        return this._checkAndDelete(IdCodec.encode(id), condition);
    }

    @Override
    public boolean checkAndDelete(ByteBuffer id, QueryCondition condition) throws DBException {
        return this._checkAndDelete(IdCodec.encode(id), condition);
    }

    public boolean checkAndDelete(Value id, QueryCondition condition) throws DBException {
        return this._checkAndDelete(IdCodec.encode(id), condition);
    }

    private boolean _checkAndDelete(ByteBuffer inId, QueryCondition condition) throws DBException {
        if (condition == null || condition.isEmpty()) {
            throw new IllegalArgumentException("QueryCondition cannot be null or empty");
        }
        this.checkClosed();
        ByteBuffer id = ByteBufs.ensurePreferred(inId);
        ConditionDescriptor condDesc = ((ConditionImpl)condition).getDescriptor((BiMap<FieldPath, Integer>)this.idPathMap, null);
        ByteBuffer serCond = ByteBufs.ensurePreferred(condDesc.getSerialized());
        int[] famIds = new int[this.idPathMap().size()];
        int i = 0;
        for (Map.Entry entry : this.idPathMap().entrySet()) {
            famIds[i++] = (Integer)entry.getValue();
        }
        MapRUpdateAndGet muag = new MapRUpdateAndGet();
        byte[] serRowConstraint = MapRDBTableImplHelper.fieldPathsToSerRowConstraint(MapRDBTableImplHelper.condFieldPathMapToCondFieldPathStrMap(condDesc.getFamilyFieldPathsMap()));
        try {
            this.maprTable.checkAndReplaceOrDelete(id, null, famIds, serRowConstraint, serCond, this.isBufferWrite(), true, muag);
        }
        catch (IOException e) {
            throw ExceptionHandler.handle(e, "checkAndDelete");
        }
        return muag.conditionSuccess;
    }

    @Override
    public boolean checkAndReplace(String id, QueryCondition condition, Document r) throws DBException {
        return this._checkAndReplace(IdCodec.encode(id), condition, r);
    }

    @Override
    public boolean checkAndReplace(ByteBuffer id, QueryCondition condition, Document r) throws DBException {
        return this._checkAndReplace(IdCodec.encode(id), condition, r);
    }

    public boolean checkAndReplace(Value id, QueryCondition condition, Document r) throws DBException {
        return this._checkAndReplace(IdCodec.encode(id), condition, r);
    }

    private boolean _checkAndReplace(ByteBuffer inId, QueryCondition condition, Document r) throws DBException {
        this.checkClosed();
        Preconditions.checkNotNull((Object)r, (Object)"Document being inserted cannot be null");
        Preconditions.checkArgument((condition != null && !condition.isEmpty() ? 1 : 0) != 0, (Object)"QueryCondition cannot be null or empty");
        ByteBuffer id = ByteBufs.ensurePreferred(inId);
        ConditionDescriptor condDesc = ((ConditionImpl)condition).getDescriptor((BiMap<FieldPath, Integer>)this.idPathMap, null);
        ByteBuffer serCond = ByteBufs.ensurePreferred(condDesc.getSerialized());
        SerializedFamilyInfo[] info = RowcolCodec.encode(r, (Map<FieldPath, Integer>)this.idPathMap);
        assert (info.length == this.idPathMap.size());
        EncodedBufFamIdInfo ebf = MapRDBTableImplHelper.getEncBufsAndFamilyIds(info);
        MapRUpdateAndGet muag = new MapRUpdateAndGet();
        byte[] serRowConstraint = MapRDBTableImplHelper.fieldPathsToSerRowConstraint(MapRDBTableImplHelper.condFieldPathMapToCondFieldPathStrMap(condDesc.getFamilyFieldPathsMap()));
        try {
            this.maprTable.checkAndReplaceOrDelete(id, ebf.encBuffers, ebf.familyIds, serRowConstraint, serCond, this.isBufferWrite(), false, muag);
        }
        catch (IOException e) {
            throw ExceptionHandler.handle(e, "checkAndDelete");
        }
        return muag.conditionSuccess;
    }

    @Override
    public synchronized void _doClose() throws DBException {
        if (!this.closed) {
            this.executor.shutdownNow();
        }
    }

    @Override
    public List<ConditionNode.RowkeyRange> getRowkeyRanges(QueryCondition condition) {
        ConditionImpl cond = (ConditionImpl)condition;
        return cond.getRowkeyRanges();
    }

    protected TabletInfo[] _getTabletInfos(QueryCondition condition) throws IOException {
        return this._getTabletInfos(condition, false, false);
    }

    @Override
    protected TabletInfo[] _getTabletInfos(QueryCondition condition, boolean needSpaceUsage, boolean prefetchTabletMap) throws IOException {
        List nextTabletSet;
        if (condition == null) {
            return this.getTabletInfos(needSpaceUsage, prefetchTabletMap);
        }
        ConditionImpl cond = (ConditionImpl)condition;
        List<ConditionNode.RowkeyRange> rowkeys = cond.getRowkeyRanges();
        boolean noKeyRange = false;
        byte[] startRow = null;
        byte[] endRow = null;
        if (rowkeys == null) {
            noKeyRange = true;
        } else {
            startRow = rowkeys.get(0).getStartRow();
            endRow = rowkeys.get(0).getStopRow();
            if (startRow == null && endRow == null || startRow.length == 0 && endRow.length == 0) {
                noKeyRange = true;
            }
        }
        if (noKeyRange) {
            return this.getTabletInfos(needSpaceUsage, prefetchTabletMap);
        }
        ArrayList tabletInfos = Lists.newArrayList();
        MapRTabletScanner scanner = this.maprTable.getTabletScanner(needSpaceUsage, prefetchTabletMap);
        boolean doneScanningTablets = false;
        while ((nextTabletSet = scanner.nextSet()) != null) {
            for (Dbserver.TabletDesc tablet : nextTabletSet) {
                byte[] srow = tablet.getStartKey().toByteArray();
                byte[] erow = tablet.getEndKey().toByteArray();
                if (srow == null || erow == null) {
                    throw new DBException("Missing start and/or endkey in tablet");
                }
                int leftRangeComp = startRow != null && startRow.length != 0 ? (erow.length == 0 ? -1 : Bytes.compareTo((byte[])startRow, (byte[])erow)) : -1;
                int rightRangeComp = endRow != null && endRow.length != 0 ? (srow.length == 0 ? 1 : Bytes.compareTo((byte[])endRow, (byte[])srow)) : 1;
                if (leftRangeComp < 0 && rightRangeComp < 0) {
                    doneScanningTablets = true;
                    break;
                }
                if (startRow == endRow) {
                    if (leftRangeComp >= 0 || rightRangeComp < 0) continue;
                    tabletInfos.add(this.toTabletInfo(tablet, rowkeys.get(0), needSpaceUsage));
                    continue;
                }
                if (leftRangeComp >= 0 || rightRangeComp <= 0) continue;
                tabletInfos.add(this.toTabletInfo(tablet, rowkeys.get(0), needSpaceUsage));
            }
            if (!doneScanningTablets) continue;
            break;
        }
        return tabletInfos.toArray(new TabletInfo[tabletInfos.size()]);
    }

    public Logger getLogger() {
        return logger;
    }

    public boolean isReadOnly() {
        return false;
    }

    @Override
    public BaseJsonTable.TableType getTableType() {
        return BaseJsonTable.TableType.TABLE_PRIMARY;
    }

    @Override
    public void beginTrackingWrites() throws IllegalStateException {
        try {
            this.maprTable.getInode().beginCommitContext();
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    @Override
    public void beginTrackingWrites(String previousContext) throws IllegalArgumentException, IllegalStateException {
        Dbserver.CommitContext ctx = null;
        try {
            ctx = CommitContextHelper.DecodeCommitContext(previousContext);
        }
        catch (DBException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        try {
            this.maprTable.getInode().beginCommitContext(ctx);
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    @Override
    public void clearTrackedWrites() throws DBException {
        try {
            this.maprTable.getInode().clearCommitContext();
        }
        catch (Exception e) {
            throw new DBException(e.getMessage());
        }
    }

    @Override
    public String endTrackingWrites() throws DBException {
        try {
            Dbserver.CommitContext ctx = this.maprTable.getInode().commitAndGetContext();
            return CommitContextHelper.EncodeCommitContext(ctx);
        }
        catch (Exception e) {
            throw new DBException(e.getMessage());
        }
    }

    public IndexSyncStateTracker createIndexSyncStateTracker() throws DBException {
        try {
            return this.maprTable.getInode().createIndexSyncStateTracker();
        }
        catch (Exception e) {
            throw new DBException(e.getMessage());
        }
    }

    public IndexSyncStateTracker createIndexSyncStateTracker(Dbserver.CommitContext ctx) throws DBException {
        try {
            return this.maprTable.getInode().createIndexSyncStateTracker(ctx);
        }
        catch (Exception e) {
            throw new DBException(e.getMessage());
        }
    }

    @Override
    public boolean isIndex() {
        return false;
    }

    public String asJsonString() {
        if (this.jsonString == null) {
            try {
                JSONStringer writer = new JSONStringer().object().key("tablePath").value((Object)this.maprTable.getTablePath()).endObject();
                this.jsonString = writer.toString();
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return this.jsonString;
    }

    public String asJsonString(JsonOptions arg0) {
        return this.asJsonString();
    }

    @Override
    protected ConditionImpl _cloneCondition(QueryCondition c) {
        return ((ConditionImpl)c).cloneUnbuilt().build();
    }

    @Override
    protected ConditionImpl _cloneConditionOptimized(QueryCondition c) {
        return ((ConditionImpl)c).cloneUnbuilt().build(ConditionNode.OptimizationMode.OptimizeFull);
    }

    class AsyncReader
    implements Runnable {
        OpListener cbListener;
        ByteBuffer encodedId;
        QueryCondition c;
        String[] paths;

        AsyncReader(OpListener list, ByteBuffer inId, QueryCondition inCond, String ... inPaths) {
            this.cbListener = list;
            this.encodedId = inId;
            this.c = inCond;
            this.paths = inPaths;
        }

        @Override
        public void run() {
            try {
                this.cbListener.onSuccess(MapRDBTableImpl.this._findById(this.encodedId, this.c, this.paths));
            }
            catch (Exception e) {
                this.cbListener.onFailure(e);
            }
        }
    }

    private class AsyncBatchInfo {
        List<FailedOp> failedDocuments;
        volatile int numObj;
        volatile int numCompl;
        BaseJsonTable.BatchingType type;
        String fieldAsKey;

        AsyncBatchInfo(int num, BaseJsonTable.BatchingType opType, String fieldforKey) {
            this.numObj = num;
            this.numCompl = 0;
            this.type = opType;
            this.failedDocuments = null;
            this.fieldAsKey = fieldforKey;
        }

        public synchronized void addToFailList(Document rec, Exception e) {
            if (this.failedDocuments == null) {
                this.failedDocuments = new ArrayList<FailedOp>();
            }
            this.failedDocuments.add(new FailedOp(rec, e));
        }

        public synchronized void incrementCompl() {
            ++this.numCompl;
            if (this.numCompl == this.numObj) {
                this.notify();
            }
        }
    }

    class AsyncBatchElement
    implements Runnable {
        Document rec;
        int recIdx;
        AsyncBatchInfo info;

        AsyncBatchElement(Document inRec, AsyncBatchInfo abi, int myIdx) {
            this.rec = inRec;
            this.info = abi;
            this.recIdx = myIdx;
        }

        @Override
        public void run() {
            try {
                if (MapRDBTableImpl.this.testMulitOpExIdx != 0 && this.recIdx == MapRDBTableImpl.this.testMulitOpExIdx) {
                    throw new DBException("Simulated insert error for " + this.recIdx);
                }
                ByteBuffer useKey = null;
                if (this.info.fieldAsKey != null) {
                    useKey = MapRDBTableImpl.this.getKeyFieldsValue(this.rec, this.info.fieldAsKey);
                }
                switch (this.info.type) {
                    case INSERTORREPLACE: {
                        if (useKey == null) {
                            MapRDBTableImpl.this.insertOrReplace(this.rec);
                            break;
                        }
                        MapRDBTableImpl.this._insertOrReplace(useKey, this.rec);
                        break;
                    }
                    case INSERT: {
                        if (useKey == null) {
                            MapRDBTableImpl.this.insert(this.rec);
                            break;
                        }
                        MapRDBTableImpl.this._insert(useKey, this.rec);
                        break;
                    }
                    case REPLACE: {
                        if (useKey == null) {
                            MapRDBTableImpl.this.replace(this.rec);
                            break;
                        }
                        MapRDBTableImpl.this._replace(useKey, this.rec);
                        break;
                    }
                    case DELETE: {
                        if (useKey == null) {
                            MapRDBTableImpl.this.delete(this.rec);
                            break;
                        }
                        MapRDBTableImpl.this._delete(useKey);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unsupported batching type " + this.info.type);
                    }
                }
            }
            catch (Exception e) {
                this.info.addToFailList(this.rec, e);
            }
            catch (OutOfMemoryError oom) {
                this.info.addToFailList(this.rec, (Exception)((Object)new DBException("Out of memory", oom)));
            }
            this.info.incrementCompl();
        }
    }
}

