/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.indexrowkeyfmt;

import com.mapr.db.indexrowkeyfmt.Error;
import com.mapr.db.indexrowkeyfmt.OArray;
import com.mapr.db.indexrowkeyfmt.OMap;
import com.mapr.utils.ByteReader;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import org.apache.commons.lang3.mutable.MutableInt;
import org.ojai.DocumentBuilder;
import org.ojai.types.ODate;
import org.ojai.types.OTime;
import org.ojai.types.OTimestamp;

public abstract class IndexRowKeyComponent {
    public static final byte NONE = 0;
    public static final byte STRING = 1;
    public static final byte MISSING = 2;
    public static final byte BOOLEAN = 3;
    public static final byte BYTE_ARRAY = 4;
    public static final byte BYTE = 5;
    public static final byte SHORT = 6;
    public static final byte INT = 7;
    public static final byte LONG = 8;
    public static final byte FLOAT = 9;
    public static final byte DOUBLE = 10;
    public static final byte NUMERIC = 11;
    public static final byte TIME = 12;
    public static final byte TIMESTAMP = 13;
    public static final byte DATE = 14;
    public static final byte _NULL = 15;
    public static final byte ERROR = 16;
    public static final byte ARRAY = 17;
    public static final byte MAP = 18;
    private static final int BYTE_SIZE = 8;
    private static final byte CONTINUATION_MARKER = -128;
    public static final byte ORIG_TYPE_ENCODING_SIZE = 1;
    private static final byte[] leftoverMask = new byte[]{0, 1, 3, 7, 15, 31, 63, 127, -1};
    protected static final double BYTE_ARRAY_ENCODING_SIZE_RATIO = 1.1428571428571428;
    protected static final double BYTE_ARRAY_DECODING_SIZE_RATIO = 0.875;
    protected static final byte MARKER_SIZE = 1;
    protected byte type_;
    protected boolean descendingOrder_;
    protected int offset_;
    protected Byte separator_;
    protected boolean isDecoded_;

    public IndexRowKeyComponent(byte type, boolean descendingOrder) {
        this.type_ = type;
        this.descendingOrder_ = descendingOrder;
        this.offset_ = 0;
        this.separator_ = null;
        this.isDecoded_ = false;
    }

    public byte getType() {
        return this.type_;
    }

    public void setOrigType(byte type) {
    }

    public byte getOrigType() {
        return this.type_;
    }

    public int encodeOrigType(ByteBuffer buf) {
        buf.put(this.getOrigType());
        return 1;
    }

    public int getOrigTypeEncodingSize() {
        return 1;
    }

    public void setOffset(int offset) {
        this.offset_ = offset;
    }

    public int getOffset() {
        return this.offset_;
    }

    public void setIsDecoded() {
        this.isDecoded_ = true;
    }

    public boolean isDecoded() {
        return this.isDecoded_;
    }

    public Byte getSeparator() {
        return this.separator_;
    }

    public int getEncodingSize() {
        return 1;
    }

    public int getFullEncodingSize() {
        return this.getEncodingSize() + (this.getSeparator() != null ? 1 : 0);
    }

    public int getNextComponentOffset() {
        return this.getOffset() + this.getFullEncodingSize();
    }

    public abstract byte getMarker(boolean var1);

    public abstract int encode(ByteBuffer var1);

    public int decode(ByteReader buf, int offset, int bufSize, MutableInt origTypeOffset, DocumentBuilder docBld, String key) {
        int decodedSize = -1;
        switch (this.getType()) {
            case 0: {
                return decodedSize;
            }
            case 1: {
                decodedSize = this.decode(buf, offset, bufSize, origTypeOffset);
                try {
                    docBld.put(key, this.getString());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return decodedSize;
            }
            case 2: {
                return decodedSize;
            }
            case 3: {
                decodedSize = this.decode(buf, offset, bufSize, origTypeOffset);
                docBld.put(key, this.getBoolean());
                return decodedSize;
            }
            case 4: {
                decodedSize = this.decode(buf, offset, bufSize, origTypeOffset);
                docBld.put(key, ByteBuffer.wrap(this.getByteArray()));
                return decodedSize;
            }
            case 11: {
                decodedSize = this.decode(buf, offset, bufSize, origTypeOffset);
                switch (this.getOrigType()) {
                    case 5: {
                        docBld.put(key, this.getByte());
                        return decodedSize;
                    }
                    case 6: {
                        docBld.put(key, this.getShort());
                        return decodedSize;
                    }
                    case 7: {
                        docBld.put(key, this.getInt());
                        return decodedSize;
                    }
                    case 8: {
                        docBld.put(key, this.getLong());
                        return decodedSize;
                    }
                    case 9: {
                        docBld.put(key, this.getFloat());
                        return decodedSize;
                    }
                    case 10: {
                        docBld.put(key, this.getDouble());
                        return decodedSize;
                    }
                }
                return decodedSize;
            }
            case 12: {
                decodedSize = this.decode(buf, offset, bufSize, origTypeOffset);
                docBld.put(key, this.getTime());
                return decodedSize;
            }
            case 13: {
                decodedSize = this.decode(buf, offset, bufSize, origTypeOffset);
                docBld.put(key, this.getTimestamp());
                return decodedSize;
            }
            case 14: {
                decodedSize = this.decode(buf, offset, bufSize, origTypeOffset);
                docBld.put(key, this.getDate());
                return decodedSize;
            }
            case 15: {
                decodedSize = this.decode(buf, offset, bufSize, origTypeOffset);
                docBld.putNull(key);
                return decodedSize;
            }
            case 16: {
                return decodedSize;
            }
            case 17: {
                docBld.putNewArray(key);
                decodedSize = this.decodeChildren(buf, offset, bufSize, origTypeOffset, docBld);
                docBld.endArray();
                return decodedSize;
            }
            case 18: {
                docBld.putNewMap(key);
                decodedSize = this.decodeChildren(buf, offset, bufSize, origTypeOffset, docBld);
                docBld.endMap();
                return decodedSize;
            }
        }
        return decodedSize;
    }

    public int decode(ByteReader buf, int offset, int bufSize, MutableInt origTypeOffset, DocumentBuilder docBld) {
        int decodedSize = -1;
        switch (this.getType()) {
            case 0: {
                return decodedSize;
            }
            case 1: {
                decodedSize = this.decode(buf, offset, bufSize, origTypeOffset);
                try {
                    docBld.add(this.getString());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return decodedSize;
            }
            case 2: {
                return decodedSize;
            }
            case 3: {
                decodedSize = this.decode(buf, offset, bufSize, origTypeOffset);
                docBld.add(this.getBoolean());
                return decodedSize;
            }
            case 4: {
                decodedSize = this.decode(buf, offset, bufSize, origTypeOffset);
                docBld.add(ByteBuffer.wrap(this.getByteArray()));
                return decodedSize;
            }
            case 11: {
                decodedSize = this.decode(buf, offset, bufSize, origTypeOffset);
                switch (this.getOrigType()) {
                    case 5: {
                        docBld.add(this.getByte());
                        return decodedSize;
                    }
                    case 6: {
                        docBld.add(this.getShort());
                        return decodedSize;
                    }
                    case 7: {
                        docBld.add(this.getInt());
                        return decodedSize;
                    }
                    case 8: {
                        docBld.add(this.getLong());
                        return decodedSize;
                    }
                    case 9: {
                        docBld.add(this.getFloat());
                        return decodedSize;
                    }
                    case 10: {
                        docBld.add(this.getDouble());
                        return decodedSize;
                    }
                }
                return decodedSize;
            }
            case 12: {
                decodedSize = this.decode(buf, offset, bufSize, origTypeOffset);
                docBld.add(this.getTime());
                return decodedSize;
            }
            case 13: {
                decodedSize = this.decode(buf, offset, bufSize, origTypeOffset);
                docBld.add(this.getTimestamp());
                return decodedSize;
            }
            case 14: {
                decodedSize = this.decode(buf, offset, bufSize, origTypeOffset);
                docBld.add(this.getDate());
                return decodedSize;
            }
            case 15: {
                decodedSize = this.decode(buf, offset, bufSize, origTypeOffset);
                docBld.addNull();
                return decodedSize;
            }
            case 16: {
                return decodedSize;
            }
            case 17: {
                docBld.addNewArray();
                decodedSize = this.decodeChildren(buf, offset, bufSize, origTypeOffset, docBld);
                docBld.endArray();
                return decodedSize;
            }
            case 18: {
                docBld.addNewMap();
                decodedSize = this.decodeChildren(buf, offset, bufSize, origTypeOffset, docBld);
                docBld.endMap();
                return decodedSize;
            }
        }
        return decodedSize;
    }

    public abstract int decode(ByteReader var1, int var2, int var3, MutableInt var4);

    public int decodeChildren(ByteReader buf, int offset, int bufSize, MutableInt origTypeOffset, DocumentBuilder docBld) {
        return -1;
    }

    public int calculateEncodingSize(ByteReader buf, int offset) {
        return 1;
    }

    public int getEncodingSizeEstimate() {
        return 1;
    }

    public String getString() throws UnsupportedEncodingException {
        throw new IllegalArgumentException("getString() called for type " + this.getType());
    }

    public boolean getBoolean() {
        throw new IllegalArgumentException("getBoolean() called for type " + this.getType());
    }

    public byte[] getByteArray() {
        throw new IllegalArgumentException("getByteArray() called for type " + this.getType());
    }

    public byte getByte() {
        throw new IllegalArgumentException("getByte() called for type " + this.getType());
    }

    public short getShort() {
        throw new IllegalArgumentException("getShort() called for type " + this.getType());
    }

    public void setInt(int value) {
        throw new IllegalArgumentException("setInt() called for type " + this.getType());
    }

    public int getInt() {
        throw new IllegalArgumentException("getInt() called for type " + this.getType());
    }

    public void setLong(long value) {
        throw new IllegalArgumentException("setLong() called for type " + this.getType());
    }

    public long getLong() {
        throw new IllegalArgumentException("getLong() called for type " + this.getType());
    }

    public float getFloat() {
        throw new IllegalArgumentException("getFloat() called for type " + this.getType());
    }

    public double getDouble() {
        throw new IllegalArgumentException("getDouble() called for type " + this.getType());
    }

    public OTime getTime() {
        throw new IllegalArgumentException("getTime() called for type " + this.getType());
    }

    public OTimestamp getTimestamp() {
        throw new IllegalArgumentException("getTimestamp() called for type " + this.getType());
    }

    public ODate getDate() {
        throw new IllegalArgumentException("getDate() called for type " + this.getType());
    }

    public Error getError() {
        throw new IllegalArgumentException("getError() called for type " + this.getType());
    }

    public String getErrorMessage() {
        throw new IllegalArgumentException("getErrorMessage() called for type " + this.getType());
    }

    public OArray getArray() {
        throw new IllegalArgumentException("getArray() called for type " + this.getType());
    }

    public OMap getMap() {
        throw new IllegalArgumentException("getMap() called for type " + this.getType());
    }

    protected int findIdx(ByteReader buf, int offset, byte b) {
        int length = buf.length();
        for (int i = offset; i < length; ++i) {
            if (buf.getByte(i) != b) continue;
            return i - offset;
        }
        return -1;
    }

    int encodeByteArray(byte[] inBuf, int inBufSize, ByteBuffer outBuf) {
        int startingPosition = outBuf.position();
        int leftoverSize = 8;
        boolean encodingHasPaddingBits = inBufSize % 7 != 0;
        int i = 0;
        while (i < inBufSize) {
            byte b;
            assert (leftoverSize <= 8);
            switch (leftoverSize) {
                case 8: {
                    b = (byte)(0xFFFFFF80 | (inBuf[i] & leftoverMask[leftoverSize] & 0xFF) >> 1);
                    leftoverSize = 1;
                    break;
                }
                case 7: {
                    b = (byte)(0xFFFFFF80 | inBuf[i++] & leftoverMask[leftoverSize]);
                    leftoverSize = (byte)(leftoverSize + 1);
                    break;
                }
                default: {
                    b = (byte)(0xFFFFFF80 | (inBuf[i++] & leftoverMask[leftoverSize]) << 7 - leftoverSize);
                    if (i >= inBufSize) break;
                    leftoverSize = (byte)(leftoverSize + 1);
                    b = (byte)(b | (inBuf[i] & 0xFF) >> leftoverSize);
                }
            }
            outBuf.put(b);
        }
        return outBuf.position() - startingPosition;
    }

    int decodeByteArray(ByteReader inBuf, int offset, int encSize, ByteBuffer outBuf) {
        int DATA_MASK = 127;
        int offsetLimit = offset + encSize;
        int startingOffset = offset;
        int leftoverSize = 7;
        while (offset < offsetLimit && (inBuf.getByte(offset) & 0xFFFFFF80) != 0) {
            assert (leftoverSize < 8);
            byte b = (byte)(inBuf.getByte(offset++) << 8 - leftoverSize);
            if (offset >= offsetLimit || (inBuf.getByte(offset) & 0xFFFFFF80) == 0) break;
            leftoverSize = (byte)(leftoverSize - 1);
            b = (byte)(b | (inBuf.getByte(offset) & 0x7F & 0xFF) >> leftoverSize);
            if (leftoverSize == 0) {
                ++offset;
                leftoverSize = 7;
            }
            outBuf.put(b);
        }
        assert ((inBuf.getByte(offset) & 0xFFFFFF80) == 0);
        return offset - startingOffset;
    }

    int encodeByteArrayOnesComplement(byte[] inBuf, int inBufSize, ByteBuffer outBuf) {
        int startingPosition = outBuf.position();
        int leftoverSize = 8;
        int i = 0;
        while (i < inBufSize) {
            byte b;
            assert (leftoverSize <= 8);
            switch (leftoverSize) {
                case 8: {
                    b = (byte)(0xFFFFFF80 | (inBuf[i] & leftoverMask[leftoverSize] & 0xFF) >> 1);
                    leftoverSize = 1;
                    break;
                }
                case 7: {
                    b = (byte)(0xFFFFFF80 | inBuf[i++] & leftoverMask[leftoverSize]);
                    leftoverSize = (byte)(leftoverSize + 1);
                    break;
                }
                default: {
                    b = (byte)(0xFFFFFF80 | (inBuf[i++] & leftoverMask[leftoverSize]) << 7 - leftoverSize);
                    if (i >= inBufSize) break;
                    leftoverSize = (byte)(leftoverSize + 1);
                    b = (byte)(b | (inBuf[i] & 0xFF) >> leftoverSize);
                }
            }
            outBuf.put(~b);
        }
        return outBuf.position() - startingPosition;
    }

    int decodeByteArrayOnesComplement(ByteReader inBuf, int offset, int encSize, ByteBuffer outBuf) {
        int DATA_MASK = 127;
        int offsetLimit = offset + encSize;
        int startingOffset = offset;
        int leftoverSize = 7;
        while (offset < offsetLimit && ((byte)(~inBuf.getByte(offset)) & 0xFFFFFF80) != 0) {
            assert (leftoverSize < 8);
            byte b = (byte)(~inBuf.getByte(offset++) << 8 - leftoverSize);
            if (offset >= offsetLimit || ((byte)(~inBuf.getByte(offset)) & 0xFFFFFF80) == 0) break;
            leftoverSize = (byte)(leftoverSize - 1);
            b = (byte)(b | ((byte)(~inBuf.getByte(offset)) & 0x7F & 0xFF) >> leftoverSize);
            if (leftoverSize == 0) {
                ++offset;
                leftoverSize = 7;
            }
            outBuf.put(b);
        }
        assert (((byte)(~inBuf.getByte(offset)) & 0xFFFFFF80) == 0);
        return offset - startingOffset;
    }
}

