/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.util;

import com.mapr.db.util.IndexKeyComponentValueExtractor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.ojai.Document;

public final class IndexKeyCompValueCombinationsGenerator {
    private IndexKeyComponentValueExtractor ikcve_;
    private int arrayIndex_;
    private int combinationSize_;

    public IndexKeyCompValueCombinationsGenerator(List<String> indexFieldPaths, List<String> includedFieldPaths) {
        this.ikcve_ = new IndexKeyComponentValueExtractor(indexFieldPaths, includedFieldPaths);
        this.arrayIndex_ = this.ikcve_.getArrayIndex();
        this.combinationSize_ = indexFieldPaths.size() + includedFieldPaths.size();
    }

    public IndexKeyComponentValueCombinations getIndexKeyComponentValueCombinations(Document doc) {
        return new IndexKeyComponentValueCombinations(this.ikcve_, this.arrayIndex_, this.combinationSize_, doc);
    }

    public Object[] getIndexFieldsPreprocessedForConditionGeneration() {
        return this.ikcve_.getIndexFieldsPreprocessedForConditionGeneration();
    }

    public final class IndexKeyComponentValueCombinations
    implements Iterable<Object[]> {
        private IndexKeyComponentValueExtractor ikcve_;
        private int arrayIndex_;
        private int combinationSize_;
        private Document doc_;

        public IndexKeyComponentValueCombinations(IndexKeyComponentValueExtractor ikcve, int arrayIndex, int combinationSize, Document doc) {
            this.ikcve_ = ikcve;
            this.arrayIndex_ = arrayIndex;
            this.combinationSize_ = combinationSize;
            this.doc_ = doc;
        }

        @Override
        public Iterator<Object[]> iterator() {
            return new IndexKeyComponentValueCombinationsIterator(this.ikcve_, this.arrayIndex_, this.combinationSize_, this.doc_);
        }
    }

    private final class IndexKeyComponentValueCombinationsIterator
    implements Iterator<Object[]> {
        private IndexKeyComponentValueExtractor ikcve_;
        private int valuesIteratorIdx_;
        private int maxSize_;
        private int i_;
        private int arrayIndex_;
        private List<Object> l_;
        private Object[] valueCombination_;
        private Object[] nextValueCombination_;
        private boolean hasNext_;

        public IndexKeyComponentValueCombinationsIterator(IndexKeyComponentValueExtractor ikcve, int arrayIndex, int combinationSize, Document doc) {
            this.ikcve_ = ikcve;
            this.arrayIndex_ = arrayIndex;
            this.nextValueCombination_ = new Object[combinationSize];
            this.ikcve_.extractValues(doc);
            this.maxSize_ = this.ikcve_.calcMaxValueListSize();
            this.valuesIteratorIdx_ = 0;
            this.initValueCombination();
            if (this.arrayIndex_ >= 0) {
                if (this.nextValueCombination_[this.arrayIndex_] instanceof IndexKeyComponentValueExtractor.MissingValue) {
                    this.l_ = new ArrayList<Object>();
                    this.i_ = 0;
                } else {
                    this.l_ = (List)this.nextValueCombination_[this.arrayIndex_];
                    this.i_ = 0;
                    this.nextValueCombination_[this.arrayIndex_] = this.l_.get(this.i_++);
                }
            }
            this.hasNext_ = true;
        }

        @Override
        public boolean hasNext() {
            return this.hasNext_;
        }

        @Override
        public Object[] next() {
            if (!this.hasNext_) {
                throw new NoSuchElementException();
            }
            this.valueCombination_ = new Object[this.nextValueCombination_.length];
            for (int i = 0; i < this.valueCombination_.length; ++i) {
                this.valueCombination_[i] = this.nextValueCombination_[i];
            }
            this.hasNext_ = this.calcNext();
            return this.valueCombination_;
        }

        private boolean initValueCombination() {
            if (this.valuesIteratorIdx_ >= this.maxSize_) {
                return false;
            }
            this.ikcve_.getIndexKeyComponentValuesCombination(this.nextValueCombination_, this.valuesIteratorIdx_++);
            return true;
        }

        private boolean calcNext() {
            if (this.arrayIndex_ >= 0) {
                if (this.i_ == this.l_.size()) {
                    if (!this.initValueCombination()) {
                        return false;
                    }
                    this.l_ = (List)this.nextValueCombination_[this.arrayIndex_];
                    this.i_ = 0;
                }
                this.nextValueCombination_[this.arrayIndex_] = this.l_.get(this.i_++);
            } else if (!this.initValueCombination()) {
                return false;
            }
            return true;
        }
    }
}

