/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.impl;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.mapr.db.exceptions.DBException;
import com.mapr.fs.proto.Dbserver;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.ojai.annotation.API;

@API.Internal
public class CommitContextHelper {
    private static final byte[] COMMIT_CONTEXT_SALT = new byte[]{33, 64, 41, 54, 36, 35};
    private static final String HashAlgorithm = "SHA-256";
    private static final int HashLength = 32;

    public static String EncodeCommitContext(Dbserver.CommitContext ctx) throws Exception {
        int i;
        byte[] ctxBA = ctx.toByteString().toByteArray();
        Deflater compresser = new Deflater();
        compresser.setInput(ctxBA);
        compresser.finish();
        StringBuilder ctxStringBuilder = new StringBuilder();
        while (!compresser.finished()) {
            byte[] ctxOP = new byte[ctxBA.length];
            int ctxOpLength = compresser.deflate(ctxOP);
            for (i = 0; i < ctxOpLength; ++i) {
                ctxStringBuilder.append(String.format("%02X", ctxOP[i] & 0xFF));
            }
        }
        compresser.end();
        MessageDigest md = MessageDigest.getInstance(HashAlgorithm);
        md.update(ctxStringBuilder.toString().getBytes());
        md.update(COMMIT_CONTEXT_SALT);
        byte[] hash = md.digest();
        for (i = 0; i < hash.length; ++i) {
            ctxStringBuilder.append(String.format("%02X", hash[i]));
        }
        return ctxStringBuilder.toString();
    }

    private static void VerifyCommitContext(String contextString) throws DBException {
        if (contextString.length() % 2 != 0) {
            throw new DBException("Invalid format of input context string");
        }
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance(HashAlgorithm);
        }
        catch (Exception e) {
            throw new DBException(e.getMessage());
        }
        md.update(contextString.getBytes(), 0, contextString.length() - 64);
        md.update(COMMIT_CONTEXT_SALT);
        byte[] computedHash = md.digest();
        byte[] actualHash = new byte[32];
        int i = contextString.length() - 64;
        int j = 0;
        while (i < contextString.length()) {
            String bStr = contextString.substring(i, i + 2);
            actualHash[j] = (byte)Integer.parseInt(bStr, 16);
            i += 2;
            ++j;
        }
        if (!Arrays.equals(computedHash, actualHash)) {
            throw new DBException("Invalid format of input context string");
        }
    }

    public static Dbserver.CommitContext DecodeCommitContext(String contextString) throws DBException {
        if (contextString == null) {
            return null;
        }
        CommitContextHelper.VerifyCommitContext(contextString);
        byte[] pcIP = new byte[contextString.length() / 2 - 32];
        for (int i = 0; i < contextString.length() - 64; i += 2) {
            String bStr = contextString.substring(i, i + 2);
            pcIP[i / 2] = (byte)Integer.parseInt(bStr, 16);
        }
        Inflater decompresser = new Inflater();
        decompresser.setInput(pcIP);
        byte[] ctxBA = null;
        byte[] ctxBAIter = new byte[pcIP.length * 5];
        int ctxBAInflatedLength = 0;
        while (decompresser.getRemaining() > 0) {
            try {
                int inflateIterLength = decompresser.inflate(ctxBAIter);
                ctxBA = ctxBA != null ? Arrays.copyOf(ctxBA, ctxBAInflatedLength + inflateIterLength) : new byte[inflateIterLength];
                for (int i = 0; i < inflateIterLength; ++i) {
                    ctxBA[ctxBAInflatedLength + i] = ctxBAIter[i];
                }
                ctxBAInflatedLength += inflateIterLength;
            }
            catch (DataFormatException e) {
                throw new DBException("Invalid format of input context string");
            }
        }
        decompresser.end();
        ByteString b = ByteString.copyFrom(ctxBA, (int)0, (int)ctxBAInflatedLength);
        Dbserver.CommitContext context = null;
        try {
            context = Dbserver.CommitContext.parseFrom((ByteString)b);
        }
        catch (InvalidProtocolBufferException e) {
            throw new DBException("Invalid format of input context string");
        }
        return context;
    }
}

