/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.tests.tableops;

import com.mapr.db.JsonTable;
import com.mapr.db.impl.MapRDBImpl;
import com.mapr.db.impl.MapRDBTableImpl;
import com.mapr.db.rowcol.DBDocumentImpl;
import com.mapr.db.tests.utils.DBTests;
import com.mapr.db.tests.utils.Datasets;
import com.mapr.tests.BaseTest;
import com.mapr.tests.annotations.StressTest;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import org.apache.hadoop.fs.Path;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.ojai.Document;
import org.ojai.DocumentStream;
import org.ojai.Value;
import org.ojai.store.QueryCondition;
import org.ojai.types.ODate;
import org.ojai.types.OTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={StressTest.class})
public class MapRDBSegmentScanTest
extends BaseTest
implements Datasets {
    private static final Logger _logger;
    private static final String TABLE_NAME = "testtable-MapRDBSegmentScanTest";
    private static final char[] mychars;
    private final Random random = new Random();
    private static JsonTable table;
    QueryCondition condition;
    List<Object> values;
    int numRecords = 2048;
    int maxRecDepth = 128;
    int maxRecBreadth = 32;
    int minkeySize = 128;
    int numDel = 256;
    String keyPrefix = "KEY";
    String[] keys = new String[this.numRecords];
    String[][] perLevel = new String[this.maxRecDepth][this.maxRecBreadth];
    String colPrefix = "hkey";

    @BeforeClass
    public static void startupBeforeClass() throws IOException {
        table = DBTests.createOrReplaceTable(TABLE_NAME);
    }

    @AfterClass
    public static void cleanupAfterClass() throws IOException, Exception {
        table.close();
        DBTests.deleteTables(TABLE_NAME);
    }

    public String getRandKey(int numChar) {
        char[] buf = new char[numChar];
        for (int idx = 0; idx < buf.length; ++idx) {
            buf[idx] = mychars[this.random.nextInt(mychars.length)];
        }
        return new String(buf);
    }

    private void setKeys() {
        String randString = this.getRandKey(this.minkeySize);
        String uuid = UUID.randomUUID().toString();
        for (int i = 0; i < this.numRecords; ++i) {
            this.keys[i] = this.keyPrefix + randString + uuid + i;
        }
    }

    private void setHierKeys() {
        String hierKey = null;
        for (int iter = 0; iter < this.maxRecDepth; ++iter) {
            int i;
            if (iter == 0) {
                for (i = 0; i < this.maxRecBreadth; ++i) {
                    this.perLevel[iter][i] = this.colPrefix + iter;
                }
                continue;
            }
            for (i = 0; i < this.maxRecBreadth; ++i) {
                for (int intIter = 0; intIter < iter; ++intIter) {
                    int suffix = intIter + 1;
                    hierKey = this.perLevel[intIter][i] + "." + this.colPrefix + suffix + i;
                }
                this.perLevel[iter][i] = hierKey;
            }
        }
        this.setKeys();
    }

    private void setCondition(int idx) {
        int i = idx == this.maxRecBreadth ? (int)(Math.random() * (double)this.maxRecBreadth) : idx;
        String hierKey = this.perLevel[this.maxRecDepth - 1][i];
        this.condition = MapRDBImpl.newCondition().and().exists("map.LIST").typeOf("map.LIST", Value.Type.ARRAY).is("map.int", QueryCondition.Op.EQUAL, 50000).close().build();
    }

    private void putRecords() throws IOException {
        Document putRec = null;
        for (int i = 0; i < this.numRecords; ++i) {
            putRec = this.getRecord();
            if (i == this.numRecords - 1) {
                putRec.set("office", "abc comp");
            }
            table.insertOrReplace(this.keys[i], putRec);
        }
        _logger.info("Inserted " + this.numRecords + " records.");
    }

    void testSegmentScan() throws IOException {
        DocumentStream rs = ((MapRDBTableImpl)table).segmentKeyScan();
        Iterator itrs = rs.iterator();
        _logger.info("Segment Scan start");
        int count = 0;
        String previouskey = null;
        String rowkey = null;
        while (itrs.hasNext()) {
            Document readRecord = (Document)itrs.next();
            previouskey = rowkey;
            rowkey = readRecord.getIdString();
            assert (count != 0 || rowkey == "");
            if (count > 1 && rowkey.compareTo(previouskey) <= 0) {
                _logger.error("start key(" + rowkey + ") of segment " + count + " is NOT larger than the start key(" + previouskey + ") of previous segment " + (count - 1));
            }
            _logger.info("segment " + count + " start key " + rowkey);
            ++count;
        }
        _logger.info("Segment scan completed - got " + count + " segments.");
        Assert.assertTrue((count > 0 ? 1 : 0) != 0);
    }

    Document getRecord() {
        DBDocumentImpl rec = new DBDocumentImpl();
        rec.setArray("Scores", new int[]{10, 20, 30, 40, 50, 60, 70}).setArray("Friends", new Object[]{"A", "B", "M", "Z", new Integer(10)}).set("map.boolean", false).set("map.string", "string").set("map.byte", (byte)100).set("map.short", (short)10000).set("map.int", 50000).set("map.long", 12345678999L).set("map.float", 10.1234f).set("map.double", 10.1234567891).setNull("NULL").set("map.a1.a2.a3", 10000);
        ByteBuffer bbuf = ByteBuffer.allocate(100);
        for (int i = 0; i < bbuf.capacity(); ++i) {
            bbuf.put((byte)i);
        }
        bbuf.rewind();
        rec.set("binary3", bbuf).set("Time", new OTime(10000000L)).set("Date", new ODate(432000000L)).set("boolean", false).set("string", "string").set("byte", (byte)100);
        this.values = new ArrayList<Object>();
        this.values.add("Field1");
        this.values.add(new Integer(500));
        this.values.add(new Double(5555.5555));
        rec.set("map.LIST", this.values);
        ArrayList<Object> values2 = new ArrayList<Object>();
        values2.add("Field1");
        values2.add(new Integer(500));
        values2.add(new Double(5555.5555));
        values2.add(new int[]{500, 1000, 1500, 2000});
        rec.set("map.LIST2", values2);
        for (int i = 0; i < this.maxRecBreadth; ++i) {
            rec.set(this.perLevel[this.maxRecDepth - 1][i], i * 1000);
        }
        return rec;
    }

    @Test
    public void stressTestMapRDB() throws IOException, InterruptedException {
        this.setHierKeys();
        this.setCondition(this.maxRecBreadth);
        this.putRecords();
        Path p = table.getPath();
        _logger.info("Table is " + p);
        table.close();
        Thread.sleep(50000L);
        table = MapRDBImpl.getTable((Path)p);
        this.testSegmentScan();
    }

    public static void main(String[] args) throws Exception {
        MapRDBSegmentScanTest t = new MapRDBSegmentScanTest();
        t.stressTestMapRDB();
    }

    static {
        char ch;
        _logger = LoggerFactory.getLogger(MapRDBSegmentScanTest.class);
        StringBuilder sb = new StringBuilder();
        for (ch = '0'; ch <= '9'; ch = (char)(ch + '\u0001')) {
            sb.append(ch);
        }
        for (ch = 'a'; ch <= 'z'; ch = (char)(ch + '\u0001')) {
            sb.append(ch);
        }
        mychars = sb.toString().toCharArray();
    }
}

