/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.tests.ojai;

import com.mapr.db.Table;
import com.mapr.db.exceptions.IllegalFieldnameException;
import com.mapr.db.impl.MapRDBImpl;
import com.mapr.db.tests.utils.DBTests;
import com.mapr.tests.annotations.ClusterTest;
import java.io.IOException;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;
import org.ojai.Document;
import org.ojai.store.DocumentMutation;

@Category(value={ClusterTest.class})
public class TestInvalidFieldNames {
    private static final String TABLE_NAME = "testtable-TestInvalidFieldNames";
    private static Table table;
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @BeforeClass
    public static void startupBeforeClass() throws IOException {
        table = DBTests.createOrReplaceTable(TABLE_NAME);
        table.setOption(Table.TableOption.BUFFERWRITE, false);
    }

    @AfterClass
    public static void cleanupAfterClass() throws IOException, Exception {
        if (table != null) {
            table.close();
            DBTests.deleteTables(TABLE_NAME);
        }
    }

    @Test
    public void test_insert_with_reserved_fieldname() throws IOException {
        Document d = MapRDBImpl.newDocument((String)"{\"a\": {\"$badfieldname\": 25 }}");
        this.thrown.expect(IllegalFieldnameException.class);
        table.insertOrReplace("doc1", d);
    }

    @Test
    public void test_update_with_reserved_fieldname() throws IOException {
        Document d = MapRDBImpl.newDocument((String)"{\"goodfieldname\": 25 }");
        table.insertOrReplace("doc1", d);
        DocumentMutation m = MapRDBImpl.newMutation().set("$badfieldname", 25);
        this.thrown.expect(IllegalFieldnameException.class);
        table.update("doc1", m);
    }
}

