/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.tests.rowcol;

import com.google.common.base.Charsets;
import com.google.common.io.Resources;
import com.mapr.db.impl.MapRDBImpl;
import com.mapr.db.rowcol.DBDocumentImpl;
import com.mapr.db.rowcol.KeyValue;
import com.mapr.db.rowcol.RowcolCodec;
import com.mapr.tests.BaseTest;
import com.mapr.tests.annotations.SimpleTest;
import java.io.IOException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.ojai.Document;
import org.ojai.FieldPath;
import org.ojai.Value;
import org.ojai.json.JsonOptions;
import org.ojai.types.ODate;
import org.ojai.types.OTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={SimpleTest.class})
public class EncoderDecoderTest
extends BaseTest {
    private static final Logger _logger = LoggerFactory.getLogger(EncoderDecoderTest.class);

    @Test
    public void testEncodeDecodeAllTypes() throws IOException {
        URL url = Resources.getResource((String)"com/mapr/db/tests/json/alltypes.json");
        String content = Resources.toString((URL)url, (Charset)Charsets.UTF_8);
        Document txtDocument = MapRDBImpl.newDocument((String)content);
    }

    @Test
    public void testSerializedIntValueSize() {
        DBDocumentImpl r = new DBDocumentImpl();
        r.set("a", 10);
        KeyValue kv = r.getKeyValue("a");
        Assert.assertEquals((long)r.getInt("a"), (long)10L);
        ByteBuffer buf = RowcolCodec.encode((Document)r);
        Assert.assertEquals((long)12L, (long)buf.remaining());
        r = new DBDocumentImpl();
        r.set("ABCDEFGHIJKLMNOPQRSTUVWXYZABCDEFGHIJKLMNOPQRSTUVWXYZ", -555555);
        kv = r.getKeyValue("ABCDEFGHIJKLMNOPQRSTUVWXYZABCDEFGHIJKLMNOPQRSTUVWXYZ");
        Assert.assertEquals((long)r.getInt("ABCDEFGHIJKLMNOPQRSTUVWXYZABCDEFGHIJKLMNOPQRSTUVWXYZ"), (long)-555555L);
        buf = RowcolCodec.encode((Document)r);
        Assert.assertEquals((long)63L, (long)buf.remaining());
    }

    @Test
    public void testSerializedBoolValueSize() {
        DBDocumentImpl r = new DBDocumentImpl();
        r.set("a", true);
        KeyValue kv = r.getKeyValue("a");
        Assert.assertEquals((Object)r.getBoolean("a"), (Object)true);
        ByteBuffer buf = RowcolCodec.encode((Document)r);
        Assert.assertEquals((long)8L, (long)buf.remaining());
        r = new DBDocumentImpl();
        r.set("ABCDEFGHIJKLMNOPQRSTUVWXYZABCDEFGHIJKLMNOPQRSTUVWXYZ", false);
        kv = r.getKeyValue("ABCDEFGHIJKLMNOPQRSTUVWXYZABCDEFGHIJKLMNOPQRSTUVWXYZ");
        Assert.assertEquals((Object)r.getBoolean("ABCDEFGHIJKLMNOPQRSTUVWXYZABCDEFGHIJKLMNOPQRSTUVWXYZ"), (Object)false);
        buf = RowcolCodec.encode((Document)r);
        Assert.assertEquals((long)59L, (long)buf.remaining());
    }

    @Test
    public void testSerializedBytetValueSize() {
        DBDocumentImpl r = new DBDocumentImpl();
        r.set("a", (byte)127);
        KeyValue kv = r.getKeyValue("a");
        Assert.assertEquals((long)r.getByte("a"), (long)127L);
        ByteBuffer buf = RowcolCodec.encode((Document)r);
        Assert.assertEquals((long)9L, (long)buf.remaining());
        r = new DBDocumentImpl();
        r.set("ABCDEFGHIJKLMNOPQRSTUVWXYZABCDEFGHIJKLMNOPQRSTUVWXYZ", (byte)-100);
        kv = r.getKeyValue("ABCDEFGHIJKLMNOPQRSTUVWXYZABCDEFGHIJKLMNOPQRSTUVWXYZ");
        Assert.assertEquals((long)-100L, (long)r.getByte("ABCDEFGHIJKLMNOPQRSTUVWXYZABCDEFGHIJKLMNOPQRSTUVWXYZ"));
        buf = RowcolCodec.encode((Document)r);
        Assert.assertEquals((long)60L, (long)buf.remaining());
    }

    @Test
    public void testSerializedShortValueSize() {
        DBDocumentImpl r = new DBDocumentImpl();
        r.set("a", (short)-5000);
        KeyValue kv = r.getKeyValue("a");
        Assert.assertEquals((long)r.getShort("a"), (long)-5000L);
        Assert.assertEquals((long)10L, (long)RowcolCodec.encode((Document)r).remaining());
        r = new DBDocumentImpl();
        r.set("ABCDEFGHIJKLMNOPQRSTUVWXYZABCDEFGHIJKLMNOPQRSTUVWXYZ", (short)Short.MAX_VALUE);
        kv = r.getKeyValue("ABCDEFGHIJKLMNOPQRSTUVWXYZABCDEFGHIJKLMNOPQRSTUVWXYZ");
        Assert.assertEquals((long)32767L, (long)r.getShort("ABCDEFGHIJKLMNOPQRSTUVWXYZABCDEFGHIJKLMNOPQRSTUVWXYZ"));
        Assert.assertEquals((long)61L, (long)RowcolCodec.encode((Document)r).remaining());
    }

    @Test
    public void testSerializedLongValueSize() {
        int valueSize = 8;
        long value1 = Long.MAX_VALUE;
        long value2 = Long.MIN_VALUE;
        DBDocumentImpl r = new DBDocumentImpl();
        r.set("a", value1);
        KeyValue kv = r.getKeyValue("a");
        Assert.assertEquals((long)r.getLong("a"), (long)value1);
        Assert.assertEquals((long)(4 + valueSize + 1 + 1 + 1 + 1), (long)RowcolCodec.encode((Document)r).remaining());
        r = new DBDocumentImpl();
        r.set("ABCDEFGHIJKLMNOPQRSTUVWXYZABCDEFGHIJKLMNOPQRSTUVWXYZ", value2);
        kv = r.getKeyValue("ABCDEFGHIJKLMNOPQRSTUVWXYZABCDEFGHIJKLMNOPQRSTUVWXYZ");
        Assert.assertEquals((long)value2, (long)r.getLong("ABCDEFGHIJKLMNOPQRSTUVWXYZABCDEFGHIJKLMNOPQRSTUVWXYZ"));
        Assert.assertEquals((long)(55 + valueSize + 1 + 1 + 1 + 1), (long)RowcolCodec.encode((Document)r).remaining());
    }

    @Test
    public void testSerializedFloatValueSize() {
        int valueSize = 4;
        float value1 = Float.MAX_VALUE;
        float value2 = Float.MIN_VALUE;
        DBDocumentImpl r = new DBDocumentImpl();
        r.set("a", value1);
        KeyValue kv = r.getKeyValue("a");
        Assert.assertEquals((double)r.getFloat("a"), (double)value1, (double)1.0E-6);
        Assert.assertEquals((long)(4 + valueSize + 1 + 1 + 1 + 1), (long)RowcolCodec.encode((Document)r).remaining());
        r = new DBDocumentImpl();
        r.set("ABCDEFGHIJKLMNOPQRSTUVWXYZABCDEFGHIJKLMNOPQRSTUVWXYZ", value2);
        kv = r.getKeyValue("ABCDEFGHIJKLMNOPQRSTUVWXYZABCDEFGHIJKLMNOPQRSTUVWXYZ");
        Assert.assertEquals((double)value2, (double)r.getFloat("ABCDEFGHIJKLMNOPQRSTUVWXYZABCDEFGHIJKLMNOPQRSTUVWXYZ"), (double)1.0E-6);
        Assert.assertEquals((long)(55 + valueSize + 1 + 1 + 1 + 1), (long)RowcolCodec.encode((Document)r).remaining());
    }

    @Test
    public void testSerializedDoubleValueSize() {
        int valueSize = 8;
        double value1 = Double.MAX_VALUE;
        double value2 = Double.MIN_VALUE;
        DBDocumentImpl r = new DBDocumentImpl();
        r.set("a", value1);
        KeyValue kv = r.getKeyValue("a");
        Assert.assertEquals((double)r.getDouble("a"), (double)value1, (double)1.0E-6);
        Assert.assertEquals((long)(4 + valueSize + 1 + 1 + 1 + 1), (long)RowcolCodec.encode((Document)r).remaining());
        r = new DBDocumentImpl();
        r.set("ABCDEFGHIJKLMNOPQRSTUVWXYZABCDEFGHIJKLMNOPQRSTUVWXYZ", value2);
        kv = r.getKeyValue("ABCDEFGHIJKLMNOPQRSTUVWXYZABCDEFGHIJKLMNOPQRSTUVWXYZ");
        Assert.assertEquals((double)value2, (double)r.getDouble("ABCDEFGHIJKLMNOPQRSTUVWXYZABCDEFGHIJKLMNOPQRSTUVWXYZ"), (double)1.0E-6);
        Assert.assertEquals((long)(55 + valueSize + 1 + 1 + 1 + 1), (long)RowcolCodec.encode((Document)r).remaining());
    }

    @Test
    public void testSerializedStringValueSize() {
        String value1 = "SmallSize";
        String value2 = "LARGESIZEDVALUEMORETHAN11BYTES";
        DBDocumentImpl r = new DBDocumentImpl();
        r.set("a", value1);
        KeyValue kv = r.getKeyValue("a");
        Assert.assertEquals((Object)r.getString("a"), (Object)value1);
        Assert.assertEquals((long)(4 + value1.length() + 1 + 1 + 1 + 1), (long)RowcolCodec.encode((Document)r).remaining());
        r = new DBDocumentImpl();
        r.set("ABCDEFGHIJKLMNOPQRSTUVWXYZABCDEFGHIJKLMNOPQRSTUVWXYZ", value2);
        kv = r.getKeyValue("ABCDEFGHIJKLMNOPQRSTUVWXYZABCDEFGHIJKLMNOPQRSTUVWXYZ");
        Assert.assertEquals((Object)value2, (Object)r.getString("ABCDEFGHIJKLMNOPQRSTUVWXYZABCDEFGHIJKLMNOPQRSTUVWXYZ"));
        Assert.assertEquals((long)(57 + value2.length() + 1 + 1 + 1 + 1), (long)RowcolCodec.encode((Document)r).remaining());
    }

    @Test
    public void simpleEncodeDecode() throws IOException {
        DBDocumentImpl r = new DBDocumentImpl();
        r.set("Name", "Anurag");
        r.set("Age", 10);
        ByteBuffer buf = RowcolCodec.encode((Document)r);
        Document readRec = RowcolCodec.decode((ByteBuffer)buf);
        Assert.assertEquals((Object)readRec.getString("Name"), (Object)"Anurag");
        Assert.assertEquals((long)readRec.getInt("Age"), (long)10L);
        ByteBuffer buf2 = RowcolCodec.encode((Document)readRec);
        Document readRec2 = RowcolCodec.decode((ByteBuffer)buf2);
        Assert.assertEquals((Object)readRec2.getString("Name"), (Object)"Anurag");
        Assert.assertEquals((long)readRec2.getInt("Age"), (long)10L);
    }

    @Test
    public void arrayEncodeTest() throws IOException {
        DBDocumentImpl r = new DBDocumentImpl();
        r.setArray("Array", new int[]{10, 20, 30, 40});
        r.setArray("Array2", new float[]{10.1f, 20.1f, 500.122f});
        ArrayList<Object> scores = new ArrayList<Object>();
        scores.add(100);
        scores.add("Anurag");
        scores.add(new int[]{5, 10, 20});
        r.set("Score", scores);
        r.set("newarray[0]", "ARRAYELEMENT1").set("newarray[1]", "ARRAYELEMENT2").set("newarray[0]", 10);
        r.set("twodimarray[0][0]", "ELEM[0][0]").set("twodimarray[0][1]", "ELEM[0][1]").set("twodimarray[1][0]", "ELEM[1][0]").set("twodimarray[1][1]", "ELEM[1][1]").set("twodimarray[2][0]", "ELEM[2][0]").set("twodimarray[2][1]", "ELEM[2][1]");
        ByteBuffer b = RowcolCodec.encode((Document)r);
        Document r2 = RowcolCodec.decode((ByteBuffer)b);
        Assert.assertEquals((long)r2.getInt("Array[0]"), (long)10L);
        Assert.assertEquals((long)r2.getInt("Array[2]"), (long)30L);
        Assert.assertEquals((long)r2.getInt("Array[3]"), (long)40L);
        Assert.assertEquals((double)10.1f, (double)r2.getFloat("Array2[0]"), (double)0.0);
        Assert.assertEquals((double)20.1f, (double)r2.getFloat("Array2[1]"), (double)0.0);
        int i = Float.floatToIntBits(500.122f);
        Assert.assertEquals((double)500.122f, (double)Float.intBitsToFloat(i), (double)0.0);
        Assert.assertEquals((double)500.122f, (double)r2.getFloat("Array2[2]"), (double)0.0);
        Assert.assertEquals((long)100L, (long)r2.getInt("Score[0]"));
        Assert.assertEquals((Object)"Anurag", (Object)r2.getString("Score[1]"));
        Assert.assertEquals((long)r2.getInt("Score[2][0]"), (long)5L);
        Assert.assertEquals((long)r2.getInt("Score[2][1]"), (long)10L);
        Assert.assertEquals((long)r2.getInt("newarray[0]"), (long)10L);
        Assert.assertEquals((Object)r2.getString("newarray[1]"), (Object)"ARRAYELEMENT2");
        Assert.assertEquals((Object)r2.getString("twodimarray[0][0]"), (Object)"ELEM[0][0]");
        Assert.assertEquals((Object)r2.getString("twodimarray[0][1]"), (Object)"ELEM[0][1]");
        Assert.assertEquals((Object)r2.getString("twodimarray[1][0]"), (Object)"ELEM[1][0]");
        Assert.assertEquals((Object)r2.getString("twodimarray[1][1]"), (Object)"ELEM[1][1]");
        Assert.assertEquals((Object)r2.getString("twodimarray[2][0]"), (Object)"ELEM[2][0]");
        Assert.assertEquals((Object)r2.getString("twodimarray[2][1]"), (Object)"ELEM[2][1]");
    }

    @Test
    public void encodeDecodeAllTypes() throws IOException {
        int i;
        Document rec2;
        Document rec = new DBDocumentImpl().set("map.boolean", false).set("map.string", "string").set("map.byte", (byte)100).set("map.short", (short)10000).set("map.int", 50000).set("map.long", 12345678999L).set("map.float", 10.1234f).set("map.double", 10.1234567891).setNull("map.NULL");
        byte[] bytes = new byte[5];
        for (int i2 = 0; i2 < bytes.length; ++i2) {
            bytes[i2] = (byte)i2;
        }
        rec.set("map.binary1", bytes);
        rec.set("map.binary2", bytes, 1, 3);
        ByteBuffer bbuf = ByteBuffer.allocate(100);
        for (int i3 = 0; i3 < bbuf.capacity(); ++i3) {
            bbuf.put((byte)i3);
        }
        bbuf.rewind();
        rec.set("map.binary3", bbuf);
        rec.set("map.Time", new OTime(10000000L));
        rec.set("map.Date", new ODate(432000000L));
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", "Anurag");
        map.put("Age", 20);
        ArrayList<Integer> scores = new ArrayList<Integer>();
        scores.add(100);
        scores.add(200);
        scores.add(300);
        scores.add(400);
        map.put("Score", scores);
        rec.set("map.map", map);
        ByteBuffer buf = RowcolCodec.encode((Document)rec);
        rec = rec2 = RowcolCodec.decode((ByteBuffer)buf);
        Assert.assertEquals((Object)rec.getValue("map").getType(), (Object)Value.Type.MAP);
        Assert.assertEquals((Object)rec.getBoolean("map.boolean"), (Object)false);
        Assert.assertEquals((Object)rec.getString("map.string"), (Object)"string");
        Assert.assertEquals((long)rec.getByte("map.byte"), (long)100L);
        Assert.assertEquals((long)rec.getShort("map.short"), (long)10000L);
        Assert.assertEquals((long)rec.getInt("map.int"), (long)50000L);
        Assert.assertEquals((long)rec.getLong("map.long"), (long)12345678999L);
        Assert.assertEquals((double)rec.getFloat("map.float"), (double)10.1234f, (double)0.0);
        Assert.assertEquals((double)rec.getDouble("map.double"), (double)10.1234567891, (double)0.0);
        Assert.assertEquals((Object)new OTime(10000000L), (Object)rec.getTime("map.Time"));
        Assert.assertEquals((Object)new ODate(432000000L).toString(), (Object)rec.getDate("map.Date").toString());
        Assert.assertEquals((Object)rec.getValue("map.NULL").getType(), (Object)Value.Type.NULL);
        Assert.assertEquals((long)rec.getInt("map.map.Score[0]"), (long)100L);
        Assert.assertEquals((long)rec.getInt("map.map.Score[1]"), (long)200L);
        Assert.assertEquals((long)rec.getInt("map.map.Score[2]"), (long)300L);
        Assert.assertEquals((long)rec.getInt("map.map.Score[3]"), (long)400L);
        ByteBuffer readBuf = rec.getBinary("map.binary1");
        for (i = 0; i < bytes.length; ++i) {
            Assert.assertEquals((long)readBuf.get(i), (long)bytes[i]);
        }
        readBuf = rec.getBinary("map.binary2");
        for (i = 0; i < 3; ++i) {
            Assert.assertEquals((long)readBuf.get(), (long)bytes[1 + i]);
        }
        readBuf = rec.getBinary("map.binary3");
        for (i = 0; i < bbuf.capacity(); ++i) {
            Assert.assertEquals((long)readBuf.get(i), (long)bbuf.get(i));
        }
        Map m = rec.getValue("map.map").getMap();
        Assert.assertEquals(map, (Object)m);
    }

    @Test
    public void encodeDecodeWithDeletes() throws IOException {
        int i;
        int i2;
        DBDocumentImpl rec = new DBDocumentImpl();
        rec.set("map.boolean", false);
        rec.set("map.string", "string");
        rec.set("map.byte", (byte)100);
        rec.set("map.short", (short)10000);
        rec.set("map.int", 50000);
        rec.set("map.long", 12345678999L);
        rec.set("map.float", 10.1234f);
        rec.set("map.double", 10.1234567891);
        rec.setNull("map.NULL");
        byte[] bytes = new byte[5];
        for (int i3 = 0; i3 < bytes.length; ++i3) {
            bytes[i3] = (byte)i3;
        }
        rec.set("map.binary1", bytes);
        rec.set("map.binary2", bytes, 1, 3);
        ByteBuffer bbuf = ByteBuffer.allocate(100);
        for (int i4 = 0; i4 < bbuf.capacity(); ++i4) {
            bbuf.put((byte)i4);
        }
        bbuf.rewind();
        rec.set("map.binary3", bbuf);
        rec.set("map.Time", new OTime(10000000L));
        rec.set("map.Date", new ODate(432000000L));
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", "Anurag");
        map.put("Age", 20);
        ArrayList<Integer> scores = new ArrayList<Integer>();
        scores.add(100);
        scores.add(200);
        scores.add(300);
        scores.add(400);
        map.put("Score", scores);
        rec.set("map.map", map);
        ByteBuffer buf = RowcolCodec.encode((Document)rec);
        Document rec2 = RowcolCodec.decode((ByteBuffer)buf);
        rec = rec2;
        Assert.assertEquals((Object)rec.getValue("map").getType(), (Object)Value.Type.MAP);
        Assert.assertEquals((Object)rec.getBoolean("map.boolean"), (Object)false);
        Assert.assertEquals((Object)rec.getString("map.string"), (Object)"string");
        Assert.assertEquals((long)rec.getByte("map.byte"), (long)100L);
        Assert.assertEquals((long)rec.getShort("map.short"), (long)10000L);
        Assert.assertEquals((long)rec.getInt("map.int"), (long)50000L);
        Assert.assertEquals((long)rec.getLong("map.long"), (long)12345678999L);
        Assert.assertEquals((double)rec.getFloat("map.float"), (double)10.1234f, (double)0.0);
        Assert.assertEquals((double)rec.getDouble("map.double"), (double)10.1234567891, (double)0.0);
        Assert.assertEquals((Object)new OTime(10000000L), (Object)rec.getTime("map.Time"));
        Assert.assertEquals((Object)new ODate(432000000L).toString(), (Object)rec.getDate("map.Date").toString());
        Assert.assertEquals((Object)rec.getValue("map.NULL").getType(), (Object)Value.Type.NULL);
        Assert.assertEquals((long)rec.getInt("map.map.Score[0]"), (long)100L);
        Assert.assertEquals((long)rec.getInt("map.map.Score[1]"), (long)200L);
        Assert.assertEquals((long)rec.getInt("map.map.Score[2]"), (long)300L);
        Assert.assertEquals((long)rec.getInt("map.map.Score[3]"), (long)400L);
        ByteBuffer readBuf = rec.getBinary("map.binary1");
        for (i2 = 0; i2 < bytes.length; ++i2) {
            Assert.assertEquals((long)readBuf.get(i2), (long)bytes[i2]);
        }
        readBuf.rewind();
        readBuf = rec.getBinary("map.binary2");
        for (i2 = 0; i2 < 3; ++i2) {
            Assert.assertEquals((long)readBuf.get(), (long)bytes[1 + i2]);
        }
        readBuf.rewind();
        readBuf = rec.getBinary("map.binary3");
        for (i2 = 0; i2 < bbuf.capacity(); ++i2) {
            Assert.assertEquals((long)readBuf.get(i2), (long)bbuf.get(i2));
        }
        readBuf.rewind();
        Map m = rec.getValue("map.map").getMap();
        Assert.assertEquals(map, (Object)m);
        rec.delete("map.string").delete("map.short").delete("map.double").delete("map.binary1").delete("map.map.Score[2]");
        buf = RowcolCodec.encode((Document)rec);
        rec2 = RowcolCodec.decode((ByteBuffer)buf);
        rec = rec2;
        Assert.assertEquals((Object)rec.getValue("map").getType(), (Object)Value.Type.MAP);
        Assert.assertEquals((Object)rec.getBoolean("map.boolean"), (Object)false);
        Assert.assertEquals((long)rec.getByte("map.byte"), (long)100L);
        Assert.assertEquals((long)rec.getInt("map.int"), (long)50000L);
        Assert.assertEquals((long)rec.getLong("map.long"), (long)12345678999L);
        Assert.assertEquals((double)rec.getFloat("map.float"), (double)10.1234f, (double)0.0);
        Assert.assertEquals((Object)new OTime(10000000L), (Object)rec.getTime("map.Time"));
        Assert.assertEquals((Object)new ODate(432000000L).toString(), (Object)rec.getDate("map.Date").toString());
        Assert.assertEquals((Object)rec.getValue("map.NULL").getType(), (Object)Value.Type.NULL);
        Assert.assertEquals((long)rec.getInt("map.map.Score[0]"), (long)100L);
        Assert.assertEquals((long)rec.getInt("map.map.Score[1]"), (long)200L);
        Assert.assertEquals((long)rec.getInt("map.map.Score[2]"), (long)400L);
        readBuf = rec.getBinary("map.binary2");
        for (i = 0; i < 3; ++i) {
            Assert.assertEquals((long)readBuf.get(), (long)bytes[1 + i]);
        }
        readBuf = rec.getBinary("map.binary3");
        for (i = 0; i < bbuf.capacity(); ++i) {
            Assert.assertEquals((long)readBuf.get(i), (long)bbuf.get(i));
        }
    }

    @Test
    public void encodeDecodeArrayTypes() throws IOException {
        DBDocumentImpl rec = new DBDocumentImpl();
        rec.setArray("BooleanArray", new boolean[]{false, true, true, false});
        rec.setArray("StringArray", new String[]{"FIRST", "SECOND", "THIRD", "FOURTH"});
        rec.setArray("LongArray", new long[]{500000L, -50000000L, 1234567890L, -6666666666L});
        rec.setArray("ByteArray", new byte[]{10, 20, 30, 40});
        ByteBuffer buf = RowcolCodec.encode((Document)rec);
        Document rec2 = RowcolCodec.decode((ByteBuffer)buf);
        rec = rec2;
        Assert.assertEquals((Object)rec.getBoolean("BooleanArray[0]"), (Object)false);
        Assert.assertEquals((Object)rec.getBoolean("BooleanArray[1]"), (Object)true);
        Assert.assertEquals((Object)rec.getBoolean("BooleanArray[2]"), (Object)true);
        Assert.assertEquals((Object)rec.getBoolean("BooleanArray[3]"), (Object)false);
        Map m = (Map)rec;
        for (String s : m.keySet()) {
            _logger.info("Key " + s);
        }
        Assert.assertEquals((long)rec.getByte("ByteArray[0]"), (long)10L);
        Assert.assertEquals((long)rec.getByte("ByteArray[1]"), (long)20L);
        Assert.assertEquals((long)rec.getByte("ByteArray[2]"), (long)30L);
        Assert.assertEquals((long)rec.getByte("ByteArray[3]"), (long)40L);
        Assert.assertEquals((long)rec.getLong("LongArray[0]"), (long)500000L);
        Assert.assertEquals((long)rec.getLong("LongArray[1]"), (long)-50000000L);
        Assert.assertEquals((long)rec.getLong("LongArray[2]"), (long)1234567890L);
        Assert.assertEquals((long)rec.getLong("LongArray[3]"), (long)-6666666666L);
        Assert.assertEquals((Object)rec.getString("StringArray[0]"), (Object)"FIRST");
        Assert.assertEquals((Object)rec.getString("StringArray[1]"), (Object)"SECOND");
        Assert.assertEquals((Object)rec.getString("StringArray[2]"), (Object)"THIRD");
        Assert.assertEquals((Object)rec.getString("StringArray[3]"), (Object)"FOURTH");
    }

    @Test
    public void encodeDecodeWideRecord() throws IOException {
        DBDocumentImpl rec = new DBDocumentImpl();
        for (int i = 0; i < 10000; ++i) {
            rec.set("f" + i, "a");
        }
        ByteBuffer buf = RowcolCodec.encode((Document)rec);
        Document rec2 = RowcolCodec.decode((ByteBuffer)buf);
        for (int i = 0; i < 10000; ++i) {
            Assert.assertEquals((Object)"a", (Object)rec2.getString("f" + i));
        }
    }

    @Test
    public void encodeDecodeWithProjection() throws IOException {
        DBDocumentImpl doc = new DBDocumentImpl();
        doc.set("root.string1", "value1").set("root.string2", "value2").set("root.map.int1", 4660).set("root.map.long2", 22136L).setArray("root.scalarArray1", new Object[]{"ra1", "ra2", "ra3"}).setArray("root.arrayOfArrays1", new Object[]{new Object[]{"aoa1", "aoa2", "aoa3"}, new Object[]{"aoa4", "aoa5", "aoa6 "}, new Object[]{"aoa7", "aoa8", "aoa9"}}).setArray("root.arrayOfMaps1", new Object[]{new DBDocumentImpl().set("mapVal1", "aomv11").set("mapVal2", "aomv12").set("mapVal3", "aomv13"), new DBDocumentImpl().set("mapVal1", "aomv21").set("mapVal2", "aomv22").set("mapVal3", "aomv23"), new DBDocumentImpl().set("mapVal1", "aomv31").set("mapVal2", "aomv32").set("mapVal3", "aomv33"), new DBDocumentImpl().set("mapVal1", "aomv41").set("mapVal2", "aomv42").set("mapVal3", "aomv43")}).setArray("root.arrayOfArraysOfMaps", new Object[]{new Object[]{new DBDocumentImpl().set("mapVal1", "aoaomv111").set("mapVal2", "aoaomv112"), new DBDocumentImpl().set("mapVal1", "aoaomv121").set("mapVal2", "aoaomv122"), new DBDocumentImpl().set("mapVal1", "aoaomv131").set("mapVal2", "aoaomv132")}, new Object[]{new DBDocumentImpl().set("mapVal1", "aoaomv211").set("mapVal2", "aoaomv212"), new DBDocumentImpl().set("mapVal1", "aoaomv221").set("mapVal2", "aoaomv222"), new DBDocumentImpl().set("mapVal1", "aoaomv231").set("mapVal2", "aoaomv232")}, new Object[]{new DBDocumentImpl().set("mapVal1", "aoaomv311").set("mapVal2", "aoaomv312"), new DBDocumentImpl().set("mapVal1", "aoaomv321").set("mapVal2", "aoaomv322"), new DBDocumentImpl().set("mapVal1", "aoaomv331").set("mapVal2", "aoaomv332")}});
        ByteBuffer buf = RowcolCodec.encode((Document)doc);
        DBDocumentImpl readDoc = null;
        HashMap<FieldPath, Integer> jsonPathMap = new HashMap<FieldPath, Integer>();
        HashMap<Integer, String> cfIdMap = new HashMap<Integer, String>();
        HashMap<Integer, ByteBuffer> bufMap = new HashMap<Integer, ByteBuffer>();
        jsonPathMap.put(FieldPath.EMPTY, 1);
        cfIdMap.put(1, "default");
        bufMap.put(1, buf);
        String[] projection = new String[]{"root.string1", "root.scalarArray1[]", "root.arrayOfArrays1[][1]", "root.arrayOfMaps1[].mapVal1", "root.arrayOfMaps1[].mapVal3", "root.arrayOfArraysOfMaps[][1].mapVal1"};
        System.out.print("Read Projection: " + projection);
        readDoc = RowcolCodec.decode(bufMap, jsonPathMap, cfIdMap, null, (boolean)true, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (String[])projection, null);
        JsonOptions printOptions = new JsonOptions().setPretty(true);
        System.out.print("Read Doc :" + readDoc.asJsonString(printOptions));
        Assert.assertEquals((Object)"value1", (Object)readDoc.getString("root.string1"));
        Assert.assertEquals((Object)"ra1", (Object)readDoc.getString("root.scalarArray1[0]"));
        Assert.assertEquals((Object)"ra2", (Object)readDoc.getString("root.scalarArray1[1]"));
        Assert.assertEquals((Object)"ra3", (Object)readDoc.getString("root.scalarArray1[2]"));
        Assert.assertEquals((Object)"aoa2", (Object)readDoc.getString("root.arrayOfArrays1[0][1]"));
        Assert.assertEquals((Object)"aoa5", (Object)readDoc.getString("root.arrayOfArrays1[1][1]"));
        Assert.assertEquals((Object)"aoa8", (Object)readDoc.getString("root.arrayOfArrays1[2][1]"));
        Assert.assertEquals((Object)"aomv11", (Object)readDoc.getString("root.arrayOfMaps1[0].mapVal1"));
        Assert.assertEquals((Object)"aomv13", (Object)readDoc.getString("root.arrayOfMaps1[0].mapVal3"));
        Assert.assertEquals((Object)"aomv21", (Object)readDoc.getString("root.arrayOfMaps1[1].mapVal1"));
        Assert.assertEquals((Object)"aomv23", (Object)readDoc.getString("root.arrayOfMaps1[1].mapVal3"));
        Assert.assertEquals((Object)"aomv31", (Object)readDoc.getString("root.arrayOfMaps1[2].mapVal1"));
        Assert.assertEquals((Object)"aomv33", (Object)readDoc.getString("root.arrayOfMaps1[2].mapVal3"));
        Assert.assertEquals((Object)"aomv41", (Object)readDoc.getString("root.arrayOfMaps1[3].mapVal1"));
        Assert.assertEquals((Object)"aomv43", (Object)readDoc.getString("root.arrayOfMaps1[3].mapVal3"));
        Assert.assertEquals((Object)"aoaomv121", (Object)readDoc.getString("root.arrayOfArraysOfMaps[0][1].mapVal1"));
        Assert.assertEquals((Object)"aoaomv221", (Object)readDoc.getString("root.arrayOfArraysOfMaps[1][1].mapVal1"));
        Assert.assertEquals((Object)"aoaomv321", (Object)readDoc.getString("root.arrayOfArraysOfMaps[2][1].mapVal1"));
        Assert.assertNull((Object)readDoc.getValue("root.string2"));
        Assert.assertNull((Object)readDoc.getValue("root.map"));
        Assert.assertNull((Object)readDoc.getValue("root.arrayOfArrays1[0][0]"));
        Assert.assertNull((Object)readDoc.getValue("root.arrayOfArrays1[1][0]"));
        Assert.assertNull((Object)readDoc.getValue("root.arrayOfArrays1[2][0]"));
        Assert.assertNull((Object)readDoc.getValue("root.arrayOfArrays1[0][2]"));
        Assert.assertNull((Object)readDoc.getValue("root.arrayOfArrays1[1][2]"));
        Assert.assertNull((Object)readDoc.getValue("root.arrayOfArrays1[2][2]"));
        Assert.assertNull((Object)readDoc.getValue("root.arrayOfMaps1[0].mapVal2"));
        Assert.assertNull((Object)readDoc.getValue("root.arrayOfMaps1[1].mapVal2"));
        Assert.assertNull((Object)readDoc.getValue("root.arrayOfMaps1[2].mapVal2"));
        Assert.assertNull((Object)readDoc.getValue("root.arrayOfMaps1[3].mapVal2"));
        Assert.assertNull((Object)readDoc.getString("root.arrayOfArraysOfMaps[0][0].mapVal1"));
        Assert.assertNull((Object)readDoc.getString("root.arrayOfArraysOfMaps[1][0].mapVal1"));
        Assert.assertNull((Object)readDoc.getString("root.arrayOfArraysOfMaps[2][0].mapVal1"));
        Assert.assertNull((Object)readDoc.getString("root.arrayOfArraysOfMaps[0][2].mapVal1"));
        Assert.assertNull((Object)readDoc.getString("root.arrayOfArraysOfMaps[1][2].mapVal1"));
        Assert.assertNull((Object)readDoc.getString("root.arrayOfArraysOfMaps[2][2].mapVal1"));
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                Assert.assertNull((Object)readDoc.getString("root.arrayOfArraysOfMaps[" + Integer.toString(i) + "][" + Integer.toString(j) + "].mapVal2"));
            }
        }
    }
}

