/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.kwps;

import com.mapr.kwps.KwpsFactory;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KwpsManager {
    private static final Logger log = LoggerFactory.getLogger(KwpsManager.class);
    private static final ConcurrentHashMap<String, KwpsFactory> knownKwpsFactories = new ConcurrentHashMap();

    public static KwpsFactory getKwpsFactory(String factoryName) {
        return knownKwpsFactories.get(factoryName);
    }

    public static KwpsFactory getDefaultFactory() {
        return knownKwpsFactories.get("v2");
    }

    static {
        ServiceLoader<KwpsFactory> kwpsFactorys = ServiceLoader.load(KwpsFactory.class);
        for (KwpsFactory kwpsFactory : kwpsFactorys) {
            knownKwpsFactories.putIfAbsent(kwpsFactory.getName(), kwpsFactory);
            log.info("Loaded KwpsFactory '{}' ({}).", (Object)kwpsFactory.getName(), (Object)kwpsFactory.getClass().getName());
        }
        if (knownKwpsFactories.size() == 0) {
            log.warn("No KwpsFactory implementation was found in the classpath.");
        }
    }
}

