/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.impl;

import com.mapr.db.impl.AefTransformer;
import com.mapr.utils.JavaAssert;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;

public class SqlTransformer {
    public final String engineName;
    public final String tableName;
    private int sequenceNumber;
    private final ArrayList<List<AefTransformer>> flattenLists = new ArrayList(6);

    public SqlTransformer(String engineName, String tableName) {
        this.engineName = engineName;
        this.tableName = tableName;
        this.sequenceNumber = 0;
    }

    private int nextInt() {
        return ++this.sequenceNumber;
    }

    public String makeUniqueId(String prefix) {
        return prefix + this.nextInt();
    }

    public void addToFlattenLayer(int flattenLayer, AefTransformer arrayTransformer) {
        if (this.flattenLists.size() <= flattenLayer) {
            this.flattenLists.ensureCapacity(flattenLayer);
            while (this.flattenLists.size() <= flattenLayer) {
                this.flattenLists.add(new LinkedList());
            }
        }
        List<AefTransformer> flattenList = this.flattenLists.get(flattenLayer);
        flattenList.add(arrayTransformer);
    }

    public Iterator<List<AefTransformer>> flattenLayerIterator() {
        return new ReverseIterator(this.flattenLists);
    }

    private static class ReverseIterator
    implements Iterator<List<AefTransformer>> {
        private final ArrayList<List<AefTransformer>> flattenLists;
        private int nextIndex;

        public ReverseIterator(ArrayList<List<AefTransformer>> flattenLists) {
            this.flattenLists = flattenLists;
            this.nextIndex = flattenLists.size() - 1;
        }

        @Override
        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        @Override
        public List<AefTransformer> next() {
            if (this.nextIndex < 0) {
                throw new NoSuchElementException();
            }
            List<AefTransformer> thisList = this.flattenLists.get(this.nextIndex--);
            if (!JavaAssert.isEnabled()) {
                return thisList;
            }
            return Collections.unmodifiableList(thisList);
        }
    }
}

