/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.tests.utils;

import com.mapr.db.Table;
import com.mapr.db.impl.MapRDBImpl;
import com.mapr.db.tests.utils.DBTests;
import com.mapr.db.util.MutationParser;
import com.mapr.tests.BaseTest;
import com.mapr.tests.annotations.ClusterTest;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.ojai.Document;
import org.ojai.exceptions.DecodingException;
import org.ojai.store.DocumentMutation;
import org.ojai.types.ODate;
import org.ojai.types.OTime;
import org.ojai.types.OTimestamp;

@Category(value={ClusterTest.class})
public class TestMutationParser
extends BaseTest {
    private static Table tab;
    private static final String TABLE_NAME = "testtable-testmutationparser";

    @BeforeClass
    public static void setUp() throws Exception {
        tab = DBTests.createOrReplaceTable(TABLE_NAME);
    }

    @Test
    public void testPutSubcommand() throws Exception {
        this.insertDocument("k1", this.getSampleDocument());
        String putSubcommand = "{\"$put\":[{\"a.b[0].boolean\":true},{\"a.c.d\":11},{\"a.x\":1}]}";
        this.applyMutation("k1", putSubcommand);
        Document returnedDoc = tab.findById("k1");
        Assert.assertTrue((boolean)returnedDoc.getBoolean("a.b[0].boolean"));
        Assert.assertEquals((double)11.0, (double)returnedDoc.getDouble("a.c.d"), (double)0.0);
    }

    @AfterClass
    public static void cleanUp() {
        tab.close();
    }

    private Document getSampleDocument() {
        Document doc = MapRDBImpl.newDocument().set("a.b[0].boolean", false).set("a.b[1].decimal", 123.456).set("a.c.d", 10.0).set("a.c.e", "Hello").set("m", "MapR wins");
        return doc;
    }

    private void insertDocument(String id, Document doc) {
        tab.insertOrReplace(id, doc);
        tab.flush();
    }

    private void applyMutation(String id, String mutationString) {
        MutationParser mParser = new MutationParser();
        DocumentMutation m = mParser.parseMutation(mutationString);
        tab.update("k1", m);
        tab.flush();
    }

    @Test
    public void testSetSubcommand() throws Exception {
        this.insertDocument("k1", this.getSampleDocument());
        String setSubcommand = "{\"$set\":[{\"a.b[0].boolean\":true},{\"a.c.d\":11},{\"a.x\":1}]}";
        this.applyMutation("k1", setSubcommand);
        Document returnedDoc = tab.findById("k1");
        Assert.assertTrue((boolean)returnedDoc.getBoolean("a.b[0].boolean"));
        Assert.assertEquals((double)11.0, (double)returnedDoc.getDouble("a.c.d"), (double)0.0);
    }

    @Test
    public void testOneSetSubcommandWithArray() throws Exception {
        this.insertDocument("k1", this.getSampleDocument());
        String oneSetMutationWithArray = "{\"$set\":{\"a.b\":[{\"$numberLong\":22456},{\"$dateDay\":\"1995-12-25\"}]}}";
        this.applyMutation("k1", oneSetMutationWithArray);
        Document returnedDoc = tab.findById("k1");
        Assert.assertEquals((long)22456L, (long)returnedDoc.getInt("a.b[0]"));
        Assert.assertEquals((Object)ODate.parse((String)"1995-12-25"), (Object)returnedDoc.getDate("a.b[1]"));
        Assert.assertEquals((Object)"Hello", (Object)returnedDoc.getString("a.c.e"));
    }

    @Test
    public void testOnePutSubcommand() throws Exception {
        this.insertDocument("k1", this.getSampleDocument());
        String onePutMutation = "{\"$put\":{\"a.c.d\":{\"k\":{\"$time\":\"11:17:22\"}}}}";
        this.applyMutation("k1", onePutMutation);
        Document returnedDoc = tab.findById("k1");
        Assert.assertFalse((boolean)returnedDoc.getBoolean("a.b[0].boolean"));
        Assert.assertEquals((Object)OTime.parse((String)"11:17:22"), (Object)returnedDoc.getTime("a.c.d.k"));
        Assert.assertEquals((Object)"Hello", (Object)returnedDoc.getString("a.c.e"));
    }

    @Test
    public void testDeleteSubcommand() throws Exception {
        this.insertDocument("k1", this.getSampleDocument());
        String deleteSubCommand = "{\"$delete\":[\"a.c.d\",\"a.b[1]\"]}";
        this.applyMutation("k1", deleteSubCommand);
        Document returnedDoc = tab.findById("k1");
        Assert.assertNull((Object)returnedDoc.getValue("a.c.d"));
        Assert.assertNull((Object)returnedDoc.getValue("a.b[1]"));
        Assert.assertFalse((boolean)returnedDoc.getBoolean("a.b[0].boolean"));
    }

    @Test
    public void testIncrementInMap() throws Exception {
        Document doc = MapRDBImpl.newDocument().set("a.b", "MapR").set("a.c.d", 10);
        tab.insertOrReplace("k1", doc);
        tab.flush();
        String incrementInMap = "{\"$increment\":{\"a.c.d\":{\"$numberLong\":-5}}}";
        this.applyMutation("k1", incrementInMap);
        Document returnedDoc = tab.findById("k1");
        Assert.assertEquals((long)5L, (long)returnedDoc.getInt("a.c.d"));
    }

    @Test
    public void testSimplePut() throws Exception {
        Document doc = MapRDBImpl.newDocument().set("a.b", "MapR").set("a.c.d", 10);
        tab.insertOrReplace("k1", doc);
        tab.flush();
        String putSimpleCommand = "{\"$put\":{\"a.c.d\":{\"$numberLong\":1234}}}";
        this.applyMutation("k1", putSimpleCommand);
        Document returnedDoc = tab.findById("k1");
        Assert.assertEquals((long)1234L, (long)returnedDoc.getLong("a.c.d"));
    }

    @Test
    public void testPutWithMap() throws Exception {
        Document doc = MapRDBImpl.newDocument().set("a.b", "MapR").set("a.c.d", 10);
        tab.insertOrReplace("k1", doc);
        tab.flush();
        String putWithMap = "{\"$put\":{\"a\":{\"c\":{\"$dateDay\":\"1997-11-24\"}}}}";
        this.applyMutation("k1", putWithMap);
        Document returnedDoc = tab.findById("k1");
        Assert.assertNull((Object)returnedDoc.getString("a.b"));
        Assert.assertEquals((Object)ODate.parse((String)"1997-11-24"), (Object)returnedDoc.getDate("a.c"));
    }

    @Test
    public void testMixedCommand() throws Exception {
        Document doc = MapRDBImpl.newDocument().set("a.b[0]", "sjc").set("a.c", 11.22).set("m", "MapR");
        tab.insertOrReplace("k1", doc);
        tab.flush();
        String singleDelete = "{\"$delete\":\"m\"}";
        this.applyMutation("k1", singleDelete);
        Document returnedDoc = tab.findById("k1");
        Assert.assertNull((Object)returnedDoc.getString("m"));
    }

    @Test
    public void testMergeSubcommand() throws Exception {
        this.insertDocument("k1", this.getSampleDocument());
        String mergeSubCommand = "{\"$merge\":{\"a.c\":{\"d\":11,\"y\":\"yo\"}}}";
        this.applyMutation("k1", mergeSubCommand);
        Document returnedDoc = tab.findById("k1");
        Assert.assertEquals((Object)"yo", (Object)returnedDoc.getString("a.c.y"));
    }

    @Test
    public void testMergeSubcommandOnScalar() throws Exception {
        this.insertDocument("k1", this.getSampleDocument());
        String mergeSubCommand = "{\"$merge\":{\"a.c\":5}}";
        try {
            this.applyMutation("k1", mergeSubCommand);
        }
        catch (DecodingException e) {
            return;
        }
        Assert.assertTrue((boolean)false);
    }

    @Test
    public void testIncrementSubcommand() throws Exception {
        Document doc = MapRDBImpl.newDocument().set("a.b[0].boolean", false).set("a.b[1].decimal", 123.456).set("a.c.d", 5).set("a.c.e", "Hello").set("m", "MapR wins");
        tab.insertOrReplace("k1", doc);
        tab.flush();
        String incrementSubCommand = "{\"$increment\":[\"p.q.r\",{\"a.c.d\":-5}]}";
        MutationParser mParser = new MutationParser();
        DocumentMutation m = mParser.parseMutation(incrementSubCommand);
        tab.update("k1", m);
        tab.flush();
        Document returnedDoc = tab.findById("k1");
        Assert.assertEquals((long)1L, (long)returnedDoc.getInt("p.q.r"));
        Assert.assertEquals((long)0L, (long)returnedDoc.getInt("a.c.d"));
    }

    @Test
    public void testDecrementSubcommand() throws Exception {
        Document doc = MapRDBImpl.newDocument().set("a.b[0].boolean", false).set("a.b[1].decimal", 123.456).set("a.c.d", 5).set("a.c.e", "Hello").set("m", "MapR wins");
        tab.insertOrReplace("k1", doc);
        tab.flush();
        String decrementSubCommand = "{\"$decrement\":[\"p.q.r\",{\"a.c.d\":-5}]}";
        MutationParser mParser = new MutationParser();
        DocumentMutation m = mParser.parseMutation(decrementSubCommand);
        tab.update("k1", m);
        tab.flush();
        Document returnedDoc = tab.findById("k1");
        Assert.assertEquals((long)-1L, (long)returnedDoc.getInt("p.q.r"));
        Assert.assertEquals((long)10L, (long)returnedDoc.getInt("a.c.d"));
    }

    @Test
    public void testAppendSubcommand() throws Exception {
        Document doc = MapRDBImpl.newDocument().set("a.b[0].boolean", false).set("a.b[1].decimal", 123.456).set("a.c.d", 5).set("a.c.e", "Hello").set("m", "MapR wins");
        tab.insertOrReplace("k1", doc);
        tab.flush();
        String appendSubCommand = "{\"$append\":[{\"a.b\":{\"appd\":1}},{\"a.c.e\":\" MapR\"}]}";
        MutationParser mParser = new MutationParser();
        DocumentMutation m = mParser.parseMutation(appendSubCommand);
        tab.update("k1", m);
        tab.flush();
        Document returnedDoc = tab.findById("k1");
        Assert.assertEquals((long)1L, (long)returnedDoc.getInt("a.b[2].appd"));
        Assert.assertEquals((Object)"Hello MapR", (Object)returnedDoc.getString("a.c.e"));
    }

    @Test
    public void testSimplePutWithDateTag() throws Exception {
        Document doc = MapRDBImpl.newDocument().set("a.b[0].boolean", false).set("a.b[1].decimal", 123.456).set("a.c.d", 5).set("a.c.e", "Hello").set("m", "MapR wins");
        tab.insertOrReplace("k1", doc);
        tab.flush();
        String putMutationWithTags = "{\"$put\":[{\"a.b[2]\":{\"$dateDay\":\"2010-10-10\"}},{\"a.c.d\":{\"$date\":\"2013-10-02T16:10:10\"}}]}";
        MutationParser mParser = new MutationParser();
        DocumentMutation m = mParser.parseMutation(putMutationWithTags);
        tab.update("k1", m);
        tab.flush();
        Document returnedDoc = tab.findById("k1");
        Assert.assertEquals((Object)ODate.parse((String)"2010-10-10"), (Object)returnedDoc.getDate("a.b[2]"));
        Assert.assertEquals((Object)OTimestamp.parse((String)"2013-10-02T16:10:10"), (Object)returnedDoc.getTimestamp("a.c.d"));
    }

    @Test
    public void testMultipleSubcommand() throws Exception {
        Document doc = MapRDBImpl.newDocument().set("a.b[0].boolean", false).set("a.b[1].decimal", 123.456).set("a.c.d", 5).set("a.c.e", "Hello").set("m", "MapR wins");
        tab.insertOrReplace("k1", doc);
        tab.flush();
        String multipleDecoratedSubCommand = "{\"$put\":[{\"a.b[0].boolean\":true},{\"a.c.d\":11}],\"$delete\":[\"m\"]}";
        MutationParser mParser = new MutationParser();
        DocumentMutation m = mParser.parseMutation(multipleDecoratedSubCommand);
        tab.update("k1", m);
        tab.flush();
        Document returnedDoc = tab.findById("k1");
        Assert.assertTrue((boolean)returnedDoc.getBoolean("a.b[0].boolean"));
        Assert.assertEquals((long)11L, (long)returnedDoc.getInt("a.c.d"));
        Assert.assertNull((Object)returnedDoc.getString("m"));
    }

    @Test
    public void testMergeWithTags() throws Exception {
        Document doc = MapRDBImpl.newDocument().set("a.b[0].boolean", false).set("a.b[1].decimal", 123.456).set("a.c.d", 5.5).set("a.c.e", "Hello").set("m", "MapR wins");
        tab.insertOrReplace("k1", doc);
        tab.flush();
        String mergeWithTags = "{\"$merge\":{\"a.c\":{\"d\":{\"$numberLong\":11},\"y\":\"yo\"}}}";
        MutationParser mParser = new MutationParser();
        DocumentMutation m = mParser.parseMutation(mergeWithTags);
        tab.update("k1", m);
        tab.flush();
        Document returnedDoc = tab.findById("k1");
        Assert.assertEquals((long)11L, (long)returnedDoc.getShort("a.c.d"));
    }

    @Test
    public void testMultipleMutationWithTags() throws Exception {
        Document doc = MapRDBImpl.newDocument().set("a.b[0].boolean", false).set("a.b[1].decimal", 123.456).set("a.c.d", 5.5).set("a.c.e", "Hello").set("m", "MapR wins");
        tab.insertOrReplace("k1", doc);
        tab.flush();
        String multipleMutationWithTags = "{\"$put\":[{\"a.b[0].boolean\":{\"$numberLong\":123}},{\"a.c.d\":{\"$time\":\"05:10:15.123\"}}],\"$increment\":[\"p.q.r\",\"a.b[1].decimal\"]}";
        MutationParser mParser = new MutationParser();
        DocumentMutation m = mParser.parseMutation(multipleMutationWithTags);
        tab.update("k1", m);
        tab.flush();
        Document returnedDoc = tab.findById("k1");
        Assert.assertEquals((long)123L, (long)returnedDoc.getShort("a.b[0].boolean"));
        Assert.assertEquals((Object)OTime.parse((String)"05:10:15.123"), (Object)returnedDoc.getTime("a.c.d"));
        Assert.assertEquals((long)1L, (long)returnedDoc.getShort("p.q.r"));
        Assert.assertEquals((double)124.456, (double)returnedDoc.getDouble("a.b[1].decimal"), (double)0.0);
    }

    @Test
    public void testNoSubCommand() throws Exception {
        Document doc = MapRDBImpl.newDocument().set("a", 11.11).set("b.c", "MapR");
        tab.insertOrReplace("k1", doc);
        tab.flush();
        String noSubCommand = "{\"a\":123,\"x\":\"San Jose\"}";
        MutationParser mparser = new MutationParser();
        DocumentMutation m = mparser.parseMutation(noSubCommand);
        tab.update("k1", m);
        tab.flush();
        Document returnedDoc = tab.findById("k1");
        Assert.assertEquals((long)123L, (long)returnedDoc.getInt("a"));
    }

    @Test
    public void testNoSubCommand3() throws Exception {
        Document doc = MapRDBImpl.newDocument().set("a", 11.11).set("b.c", "MapR");
        tab.insertOrReplace("k1", doc);
        tab.flush();
        String noSubCommand3 = "{\"a\":[123, 33],\"b\":{\"y\":\"San Jose\",\"z\":true,\"x1\":{\"aa\":{\"p\":\"bb\"}}}}";
        MutationParser mparser = new MutationParser();
        DocumentMutation m = mparser.parseMutation(noSubCommand3);
        tab.update("k1", m);
        tab.flush();
        Document returnedDoc = tab.findById("k1");
        Assert.assertEquals((long)33L, (long)returnedDoc.getInt("a[1]"));
        Assert.assertEquals((Object)"bb", (Object)returnedDoc.getString("b.x1.aa.p"));
        Assert.assertEquals((Object)"MapR", (Object)returnedDoc.getString("b.c"));
        Assert.assertTrue((boolean)returnedDoc.getBoolean("b.z"));
    }

    @Test
    public void testOneDecrementOpWithMap() throws Exception {
        Document doc = MapRDBImpl.newDocument().set("a[0]", 10).set("b", 2);
        tab.insertOrReplace("1", doc);
        tab.flush();
        String mutation = "{\"$decrement\":{\"a[0]\":3}}";
        MutationParser mparser = new MutationParser();
        DocumentMutation m = mparser.parseMutation(mutation);
        tab.update("1", m);
        tab.flush();
        Document r = tab.findById("1");
        Assert.assertEquals((double)7.0, (double)r.getDouble("a[0]"), (double)0.0);
    }

    @Test
    public void testEmptyMutation() throws Exception {
        Document doc = MapRDBImpl.newDocument().set("c", "xyz");
        tab.insertOrReplace("k5", doc);
        tab.flush();
        String emptyMutation = "{}";
        MutationParser mp = new MutationParser();
        DocumentMutation m = mp.parseMutation(emptyMutation);
        tab.update("k5", m);
        tab.flush();
        Document r = tab.findById("k5");
        Assert.assertEquals((Object)"xyz", (Object)r.getString("c"));
    }

    @Test
    public void testEmptySetMutation() throws Exception {
        String cmd = "{\"$put\":[{},{}]}";
        MutationParser mp = new MutationParser();
        DocumentMutation m = mp.parseMutation(cmd);
        Document doc = MapRDBImpl.newDocument().set("a", 1).set("b", true);
        tab.insertOrReplace("k1", doc);
        tab.flush();
        tab.update("k1", m);
        tab.flush();
        Document res = tab.findById("k1");
        Assert.assertEquals((double)1.0, (double)res.getDouble("a"), (double)0.0);
        Assert.assertTrue((boolean)res.getBoolean("b"));
        cmd = "{\"$put\":[{},{\"a\":{\"k\":\"mapr\"}},{}]}";
        MutationParser mp2 = new MutationParser();
        DocumentMutation m2 = mp2.parseMutation(cmd);
        tab.update("k1", m2);
        tab.flush();
        res = tab.findById("k1");
        Assert.assertEquals((Object)"mapr", (Object)res.getString("a.k"));
    }

    @Test
    public void testEmptyIncrement() throws Exception {
        String cmd = "{\"$increment\":[{},{}]}";
        MutationParser mp = new MutationParser();
        DocumentMutation m = mp.parseMutation(cmd);
        tab.update("emptyIncrement", m);
        tab.flush();
        Assert.assertNull((Object)tab.findById("emptyIncrement"));
        Document doc = MapRDBImpl.newDocument().set("a.b", 5);
        tab.insertOrReplace("emptyIncrement", doc);
        tab.flush();
        cmd = "{\"$increment\":[\"a.b\",{}]}";
        MutationParser mp2 = new MutationParser();
        DocumentMutation m2 = mp2.parseMutation(cmd);
        tab.update("emptyIncrement", m2);
        tab.flush();
        Document res = tab.findById("emptyIncrement");
        Assert.assertEquals((double)6.0, (double)res.getDouble("a.b"), (double)0.0);
    }

    @Test
    public void testEmptyAppend() {
        String cmd = "{\"$append\":[{}]}";
        MutationParser mp = new MutationParser();
        DocumentMutation m = mp.parseMutation(cmd);
        tab.update("emptyAppend", m);
        tab.flush();
        Assert.assertNull((Object)tab.findById("emptyAppend"));
        Document doc = MapRDBImpl.newDocument().set("a", "ab").set("c[1]", true);
        tab.insertOrReplace("emptyAppend", doc);
        tab.flush();
        cmd = "{\"$append\":[{},{\"a\":\"initio\"},{},{\"c\":[false]}]}";
        MutationParser mp2 = new MutationParser();
        DocumentMutation m2 = mp2.parseMutation(cmd);
        tab.update("emptyAppend", m2);
        tab.flush();
        Document res = tab.findById("emptyAppend");
        Assert.assertEquals((Object)"abinitio", (Object)res.getString("a"));
        Assert.assertTrue((boolean)res.getBoolean("c[1]"));
        Assert.assertFalse((boolean)res.getBoolean("c[2]"));
    }

    @Test
    public void testEmptyDecrement() throws Exception {
        String cmd = "{\"$decrement\":[{},{}]}";
        MutationParser mp = new MutationParser();
        DocumentMutation m = mp.parseMutation(cmd);
        tab.update("emptyDncrement", m);
        tab.flush();
        Assert.assertNull((Object)tab.findById("emptyDecrement"));
        Document doc = MapRDBImpl.newDocument().set("a.b", 5);
        tab.insertOrReplace("emptyDecrement", doc);
        tab.flush();
        cmd = "{\"$decrement\":[\"a.b\",{}]}";
        MutationParser mp2 = new MutationParser();
        DocumentMutation m2 = mp2.parseMutation(cmd);
        tab.update("emptyDecrement", m2);
        tab.flush();
        Document res = tab.findById("emptyDecrement");
        Assert.assertEquals((double)4.0, (double)res.getDouble("a.b"), (double)0.0);
    }

    @Test
    public void testSetWithMap() throws Exception {
        String cmd = "{\"$set\":{\"a\":{\"key14\":[{\"key0\":true}]}}}";
        MutationParser mp = new MutationParser();
        DocumentMutation m = mp.parseMutation(cmd);
        tab.update("k11", m);
        tab.flush();
        Document returnedDoc = tab.findById("k11");
        Assert.assertTrue((boolean)returnedDoc.getBoolean("a.key14[0].key0"));
    }

    @Test
    public void testSetWithMapContainingArrays() throws Exception {
        String cmd = "{\"$set\":{\"a\":{\"key14\":[{\"key0\":true},{\"key1\":false}]}}}";
        MutationParser mp = new MutationParser();
        DocumentMutation m = mp.parseMutation(cmd);
        tab.update("k5", m);
        tab.flush();
        Document returnedDoc = tab.findById("k5");
        Assert.assertTrue((boolean)returnedDoc.getBoolean("a.key14[0].key0"));
        Assert.assertFalse((boolean)returnedDoc.getBoolean("a.key14[1].key1"));
    }

    @Test
    public void testSetWithMultiMap() throws Exception {
        String cmd = "{\"$set\":{\"a\":{\"b\":{\"c\":[{\"$numberLong\":1111111},\"xyz\"]},\"d\":[true,false,[true,{\"k\":\"mapr\"}]]}}}";
        MutationParser mp = new MutationParser();
        DocumentMutation m = mp.parseMutation(cmd);
        tab.update("k6", m);
        tab.flush();
        Document returnedDoc = tab.findById("k6");
        Assert.assertEquals((Object)"mapr", (Object)returnedDoc.getString("a.d[2][1].k"));
        Assert.assertTrue((boolean)returnedDoc.getBoolean("a.d[2][0]"));
    }
}

