/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.tests.utils;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.mapr.baseutils.utils.AceHelper;
import com.mapr.db.JsonTable;
import com.mapr.db.MapRDB;
import com.mapr.db.MetaTable;
import com.mapr.db.TableDescriptor;
import com.mapr.db.exceptions.DBException;
import com.mapr.db.impl.AdminImpl;
import com.mapr.db.impl.MapRDBImpl;
import com.mapr.db.impl.MapRDBTableImpl;
import com.mapr.db.index.IndexDesc;
import com.mapr.db.scan.ScanStats;
import com.mapr.fs.FSTests;
import com.mapr.fs.proto.Dbserver;
import com.mapr.fs.tables.CFPermissions;
import com.mapr.fs.utils.ssh.RunCommand;
import com.mapr.fs.utils.ssh.TestCluster;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.Assert;
import org.ojai.Document;
import org.ojai.DocumentReader;
import org.ojai.DocumentStream;
import org.ojai.store.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBTests
extends FSTests {
    private static final Logger _logger = LoggerFactory.getLogger(DBTests.class);
    private static final long DEFAULT_WAIT_MILLIS = 60000L;
    private static final long DEFAULT_WAIT_FOR_SCHEMA_UPDATE_MILLIS = 12000L;
    private static final ObjectMapper objectMapper;
    private static final String USER_NAME;
    private static volatile AdminImpl admin_;
    private static boolean policyServiceMasterStatusSet;

    public static String getUserName() {
        return USER_NAME;
    }

    public static ObjectMapper mapper() {
        return objectMapper;
    }

    public static synchronized AdminImpl admin() throws IOException {
        if (admin_ == null) {
            admin_ = (AdminImpl)MapRDBImpl.newAdmin((Configuration)DBTests.getConf());
        }
        return admin_;
    }

    public static boolean tableExists(String table) throws IOException {
        Path tablePath = DBTests.getTablePath(table);
        return DBTests.maprfs().exists(tablePath);
    }

    public static String getFullPath(String tableName) {
        Path tablePath = DBTests.getTablePath(tableName);
        String fullPath = tablePath.toString();
        return fullPath;
    }

    public static JsonTable getTable(String table) throws IOException {
        Path tablePath = DBTests.getTablePath(table);
        return MapRDBImpl.getTable((Path)tablePath);
    }

    public static JsonTable createTable(String table) throws IOException {
        Path tablePath = DBTests.getTablePath(table);
        return DBTests.admin().createTable(tablePath);
    }

    public static JsonTable createOrReplaceTable(String table) throws IOException {
        Path tablePath = DBTests.getTablePath(table);
        if (DBTests.maprfs().exists(tablePath)) {
            _logger.info("Table {} exists, deleting.", (Object)tablePath);
            DBTests.maprfs().delete(tablePath);
        }
        _logger.info("Creating table {}.", (Object)tablePath);
        return DBTests.admin().createTable(tablePath);
    }

    public static JsonTable createOrReplaceTable(String tableName, boolean autoSplit) throws IOException {
        Path tablePath = DBTests.getTablePath(tableName);
        if (DBTests.maprfs().exists(tablePath)) {
            _logger.info("Table {} exists, deleting.", (Object)tablePath);
            DBTests.maprfs().delete(tablePath);
        }
        _logger.info("Creating table {}.", (Object)tablePath);
        TableDescriptor desc = MapRDBImpl.newTableDescriptor((Path)tablePath).setAutoSplit(autoSplit);
        return DBTests.admin().createTable(desc);
    }

    public static JsonTable createOrReplaceTable(String table, String[] splitKeys) throws IOException {
        Path tablePath = DBTests.getTablePath(table);
        if (DBTests.maprfs().exists(tablePath)) {
            _logger.info("Table {} exists, deleting.", (Object)tablePath);
            DBTests.maprfs().delete(tablePath);
        }
        _logger.info("Creating table {}.", (Object)tablePath);
        return DBTests.admin().createTable(MapRDBImpl.newTableDescriptor((Path)tablePath), splitKeys);
    }

    public static JsonTable createOrReplaceTable(String table, Map<String, String> cfPath, String[] splitKeys) throws IOException {
        Path tablePath = DBTests.getTablePath(table);
        if (DBTests.maprfs().exists(tablePath)) {
            _logger.info("Table {} exists, deleting.", (Object)tablePath);
            DBTests.maprfs().delete(tablePath);
        }
        _logger.info("Creating table {}.)", (Object)tablePath);
        TableDescriptor desc = MapRDBImpl.newTableDescriptor((Path)tablePath);
        int familyCount = 0;
        for (Map.Entry<String, String> cf : cfPath.entrySet()) {
            if (familyCount++ == 0 && !cf.getKey().equals("default")) {
                desc.addFamily(MapRDBImpl.newDefaultFamilyDescriptor());
                ++familyCount;
            }
            desc.addFamily(MapRDBImpl.newFamilyDescriptor((String)cf.getKey(), (String)cf.getValue()));
        }
        _logger.info("Creating table {}.", (Object)tablePath);
        return DBTests.admin().createTable(desc, splitKeys);
    }

    public static JsonTable createOrReplaceTable(String clusterPath, String table, Map<String, String> cfPathMap) throws IOException {
        String clusterPrefix = clusterPath.endsWith("/") ? clusterPath.substring(0, clusterPath.length() - 2) : clusterPath;
        clusterPrefix = DBTests.getTestRoot((String)clusterPrefix).toString();
        Path tablePath = new Path(clusterPrefix + table);
        if (DBTests.maprfs().exists(tablePath)) {
            _logger.info("Table {} exists, deleting.", (Object)tablePath);
            DBTests.maprfs().delete(tablePath);
        }
        TableDescriptor desc = MapRDBImpl.newTableDescriptor((Path)tablePath);
        int familyCount = 0;
        for (Map.Entry<String, String> cf : cfPathMap.entrySet()) {
            if (familyCount++ == 0 && !cf.getKey().equals("default")) {
                desc.addFamily(MapRDBImpl.newDefaultFamilyDescriptor());
                ++familyCount;
            }
            desc.addFamily(MapRDBImpl.newFamilyDescriptor((String)cf.getKey(), (String)cf.getValue()));
        }
        _logger.info("Creating table {}.", (Object)tablePath);
        return DBTests.admin().createTable(desc);
    }

    public static JsonTable createOrReplaceTable(String table, Map<String, String> cfPath) throws IOException {
        Path tablePath = DBTests.getTablePath(table);
        if (DBTests.maprfs().exists(tablePath)) {
            _logger.info("Table {} exists, deleting.", (Object)tablePath);
            DBTests.maprfs().delete(tablePath);
        }
        TableDescriptor desc = MapRDBImpl.newTableDescriptor((Path)tablePath);
        int familyCount = 0;
        for (Map.Entry<String, String> cf : cfPath.entrySet()) {
            if (familyCount++ == 0 && !cf.getKey().equals("default")) {
                desc.addFamily(MapRDBImpl.newDefaultFamilyDescriptor());
                ++familyCount;
            }
            desc.addFamily(MapRDBImpl.newFamilyDescriptor((String)cf.getKey(), (String)cf.getValue()));
        }
        _logger.info("Creating table {}.", (Object)tablePath);
        return DBTests.admin().createTable(desc);
    }

    public static void rmdir(Path path) throws IOException {
        if (DBTests.maprfs().exists(path)) {
            DBTests.maprfs().delete(path, true);
        }
    }

    public static void deleteTables(String ... tables) throws IOException {
        for (String table : tables) {
            Path tablePath = DBTests.getTablePath(table);
            if (!DBTests.maprfs().exists(tablePath)) continue;
            _logger.info("Deleting table {}.", (Object)tablePath);
            DBTests.maprfs().delete(tablePath);
        }
    }

    public static void justDeleteTables(String ... tables) throws IOException {
        for (String table : tables) {
            Path tablePath = DBTests.getTablePath(table);
            _logger.info("Deleting table {}.", (Object)tablePath);
            DBTests.maprfs().delete(tablePath);
        }
    }

    public static Path getTablePath(String table) {
        return new Path(DBTests.getTestRoot(), DBTests.fixTableName(table));
    }

    public static Path getTablePath(String clusterPath, String table) {
        String clusterPrefix = clusterPath.endsWith("/") ? clusterPath.substring(0, clusterPath.length() - 2) : clusterPath;
        return new Path(DBTests.getTestRoot((String)clusterPrefix), DBTests.fixTableName(table));
    }

    public static String getNameWithoutPath(String tableName) {
        int pos = tableName.lastIndexOf(47);
        if (pos < 0) {
            return tableName;
        }
        return tableName.substring(pos + 1);
    }

    private static String fixTableName(String table) {
        return table.startsWith("/") ? "." + table : table;
    }

    public static void setFieldAce(Path tablePath, String family, String fieldName, Dbserver.DBAccessType accessType, String ace) throws IOException {
        CFPermissions cfPermissions = new CFPermissions(family);
        String permission = (String)AceHelper.colPermissionMap.get(accessType);
        cfPermissions.addColPermission(fieldName, permission, ace);
        DBTests.mapradmin().setFamilyPermissions(tablePath, family, cfPermissions);
    }

    public static void setCFAce(Path tablePath, String family, Dbserver.DBAccessType accessType, String ace) throws IOException {
        CFPermissions cfPermissions = new CFPermissions(family);
        String permission = (String)AceHelper.cfPermissionMap.get(accessType);
        cfPermissions.addCFPermission(permission, ace);
        DBTests.mapradmin().setFamilyPermissions(tablePath, family, cfPermissions);
    }

    public static boolean cfExists(Path tablePath, String familyName) throws IOException {
        List cfAttrList = DBTests.maprfs().listColumnFamily(tablePath, false, true);
        for (Dbserver.ColumnFamilyAttr cfAttr : cfAttrList) {
            if (!cfAttr.getSchFamily().getName().equals(familyName)) continue;
            return true;
        }
        return false;
    }

    public static String ExecuteShellCmd(String cmd) throws Exception {
        StringBuffer output = new StringBuffer();
        try {
            String line;
            Process p = Runtime.getRuntime().exec(cmd);
            p.waitFor();
            BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((line = reader.readLine()) != null) {
                System.out.println(line + "\n");
                output.append(line + "\n");
            }
        }
        catch (Exception e) {
            _logger.error("Executing shell command " + cmd + " failed: " + e.getMessage());
            throw e;
        }
        return output.toString();
    }

    public static int ExecuteShellCmdAndGetReturnCode(String cmd) throws Exception {
        int exitStatus;
        StringBuffer output = new StringBuffer();
        try {
            String line;
            Process p = Runtime.getRuntime().exec(cmd);
            p.waitFor();
            exitStatus = p.exitValue();
            BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((line = reader.readLine()) != null) {
                System.out.println(line + "\n");
                output.append(line + "\n");
            }
        }
        catch (Exception e) {
            _logger.error("Executing shell command " + cmd + " failed: " + e.getMessage());
            throw e;
        }
        return exitStatus;
    }

    public static void EnableVolumeAuditing(String volume) throws Exception {
        String cmd = "maprcli volume audit -name " + volume + " -enabled true";
        _logger.info(cmd);
        String output = DBTests.ExecuteShellCmd(cmd);
        if (!output.isEmpty()) {
            _logger.info("Output: " + output);
        }
    }

    public static void DisableVolumeAuditing(String volume) throws Exception {
        String cmd = "maprcli volume audit -name " + volume + " -enabled false";
        _logger.info(cmd);
        String output = DBTests.ExecuteShellCmd(cmd);
        if (!output.isEmpty()) {
            _logger.info("Output: " + output);
        }
    }

    public static void EnableJSONTableAuditing(String tablePath) throws Exception {
        assert (tablePath != null && !tablePath.isEmpty());
        String[] tablePathDirs = tablePath.split("/");
        DBTests.EnableVolumeAuditing("mapr.cluster.root");
        DBTests.EnableVolumeAuditing("mapr.tmp");
        Object cmd = "maprcli audit cluster -enabled true";
        _logger.info((String)cmd);
        String output = DBTests.ExecuteShellCmd((String)cmd);
        if (!output.isEmpty()) {
            _logger.info("Output: " + output);
        }
        cmd = "maprcli audit data -enabled true";
        _logger.info((String)cmd);
        output = DBTests.ExecuteShellCmd((String)cmd);
        if (!output.isEmpty()) {
            _logger.info("Output: " + output);
        }
        Object volPath = "";
        for (int i = 0; i < tablePathDirs.length; ++i) {
            volPath = (String)volPath + tablePathDirs[i];
            if (i < tablePathDirs.length - 1) {
                volPath = (String)volPath + "/";
            }
            cmd = "hadoop mfs -setaudit on " + (String)volPath;
            _logger.info((String)cmd);
            output = DBTests.ExecuteShellCmd((String)cmd);
            if (output.isEmpty()) continue;
            _logger.info("Output: " + output);
        }
    }

    public static void DisableJSONTableAuditing(String tablePath) throws Exception {
        assert (tablePath != null && !tablePath.isEmpty());
        String[] tablePathDirs = tablePath.split("/");
        DBTests.DisableVolumeAuditing("mapr.cluster.root");
        DBTests.DisableVolumeAuditing("mapr.tmp");
        Object cmd = "maprcli audit cluster -enabled false";
        _logger.info((String)cmd);
        String output = DBTests.ExecuteShellCmd((String)cmd);
        if (!output.isEmpty()) {
            _logger.info("Output: " + output);
        }
        cmd = "maprcli audit data -enabled false";
        _logger.info((String)cmd);
        output = DBTests.ExecuteShellCmd((String)cmd);
        if (!output.isEmpty()) {
            _logger.info("Output: " + output);
        }
        Object volPath = "";
        for (int i = 0; i < tablePathDirs.length; ++i) {
            volPath = (String)volPath + tablePathDirs[i];
            if (i < tablePathDirs.length - 1) {
                volPath = (String)volPath + "/";
            }
            cmd = "hadoop mfs -setaudit off " + (String)volPath;
            _logger.info((String)cmd);
            output = DBTests.ExecuteShellCmd((String)cmd);
            if (output.isEmpty()) continue;
            _logger.info("Output: " + output);
        }
    }

    public static void updatePolicyServiceMasterStatus() throws Exception {
        String enablePolicyCreation = "maprcli config save -values {\"cldb.pbs.global.master\":\"1\"}";
        RunCommand enablePolicyCreationRC = TestCluster.runCommand((String)"maprcli config save -values {\"cldb.pbs.global.master\":\"1\"}");
        if (enablePolicyCreationRC.getExitCode() != 0) {
            _logger.error(enablePolicyCreationRC.getStdOut());
            Assert.fail((String)("Unable to Set the current cluster as Global Master: " + enablePolicyCreationRC.getStdOut()));
        }
        policyServiceMasterStatusSet = true;
    }

    private static boolean updatePolicyServiceMasterStatus(boolean makeMaster) throws Exception {
        String enablePolicyCreation = "maprcli config save -values {\"cldb.pbs.global.master\":\"1\"}";
        RunCommand enablePolicyCreationRC = TestCluster.runCommand((String)"maprcli config save -values {\"cldb.pbs.global.master\":\"1\"}");
        String policyMasterEnableOut = enablePolicyCreationRC.getStdOut();
        if (policyMasterEnableOut.length() > 0) {
            _logger.error(policyMasterEnableOut);
            return false;
        }
        return true;
    }

    public static boolean ensurePolicyServiceMasterStatus() throws Exception {
        String policyMasterStatus = "maprcli config load -keys \"cldb.pbs.global.master\" -json";
        RunCommand policyMasterStatusRC = TestCluster.runCommand((String)"maprcli config load -keys \"cldb.pbs.global.master\" -json");
        Document response = MapRDBImpl.newDocument((String)policyMasterStatusRC.getStdOut());
        if (response.getString("data[0].`cldb.pbs.global.master`").equals("0")) assert (DBTests.updatePolicyServiceMasterStatus(true));
        return true;
    }

    public static boolean createClusterSecurityPolicy(String policyName, boolean allowTagging, boolean allowEnforcement, String user) throws Exception {
        if (DBTests.ensurePolicyServiceMasterStatus()) {
            String createPolicyCmd = "maprcli security policy create -allowtagging " + Boolean.toString(allowTagging) + " -accesscontrol " + (allowEnforcement ? "Armed" : "Disarmed") + " -readdbace u:" + user + " -writedbace u:" + user + " -name " + policyName;
            RunCommand createPolicyRC = TestCluster.runCommand((String)createPolicyCmd);
            String policyCreateOut = createPolicyRC.getStdOut();
            if (policyCreateOut.length() != 0 && policyCreateOut.indexOf("Security policy " + policyName + " already exists") == -1) {
                System.err.println(policyCreateOut);
                _logger.error(policyCreateOut);
                return false;
            }
            return true;
        }
        System.err.println("ensurePolicyServiceMasterStatus failed");
        return false;
    }

    public static boolean modifyClusterSecurityPolicy(String policyName, boolean allowTagging, boolean accessControl) throws Exception {
        if (DBTests.ensurePolicyServiceMasterStatus()) {
            String modifyPolicyCmd = "maprcli security policy modify -name " + policyName + " -allowtagging " + allowTagging + " -accesscontrol " + accessControl + " -json";
            RunCommand modifyPolicyRC = TestCluster.runCommand((String)modifyPolicyCmd);
            String policyModifyOut = modifyPolicyRC.getStdOut();
            Document response = MapRDBImpl.newDocument((String)policyModifyOut);
            if (!response.getString("status").equals("OK") || !response.getString("messages[0]").equals("Successfully updated security policy '" + policyName + "'")) {
                _logger.error(policyModifyOut);
                return false;
            }
            return true;
        }
        _logger.error("ensurePolicyServiceMasterStatus failed");
        return false;
    }

    public static Map<String, Integer> getClusterPolicyIDList() throws Exception {
        HashMap<String, Integer> policyIdMap = new HashMap<String, Integer>();
        String listPolicyInfo = "maprcli security policy list -json";
        RunCommand listPolicyRC = TestCluster.runCommand((String)"maprcli security policy list -json");
        String listPolicyOut = listPolicyRC.getStdOut();
        Map policyDocMap = MapRDB.newDocument((String)listPolicyOut).asMap();
        assert (policyDocMap.get("data") instanceof List);
        List policyList = (List)policyDocMap.get("data");
        for (Object policyInfo : policyList) {
            assert (policyInfo instanceof Map);
            Map policyInfoMap = (Map)policyInfo;
            policyIdMap.put((String)policyInfoMap.get("policyname"), ((Double)policyInfoMap.get("policyid")).intValue());
        }
        return policyIdMap;
    }

    private static boolean isBucketFlushComplete() {
        String cmd = "/opt/mapr/server/mrconfig dbinfo mem";
        try {
            RunCommand rc = TestCluster.runCommand((String)"/opt/mapr/server/mrconfig dbinfo mem");
            String local = rc.getStdOut();
            if (local != null && (local = local.trim()).contains("pendingBucketFlushes 0") && local.contains("numActiveBuckets 0")) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static void waitForBucketFlush() throws IOException {
        DBTests.waitForBucketFlush(120000L);
    }

    public static void waitForBucketFlush(long waitMillis) throws IOException {
        long endWaitMillis = System.currentTimeMillis() + waitMillis;
        do {
            if (DBTests.isBucketFlushComplete()) {
                return;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (endWaitMillis >= System.currentTimeMillis());
        throw new IOException("waitForBucketFlush() did not succeed in the specified time: " + waitMillis);
    }

    public static void waitForRowCount(String tableName, long minRowCount) throws IOException {
        DBTests.waitForRowCount(DBTests.getTablePath(tableName), minRowCount);
    }

    public static void waitForRowCount(Path tablePath, long minRowCount) throws IOException {
        DBTests.waitForRowCount(tablePath, minRowCount, 60000L);
    }

    public static void waitForRowCount(Path tablePath, long minRowCount, long waitMillis) throws IOException {
        try (JsonTable table = MapRDBImpl.getTable((Path)tablePath);){
            table.flush();
            DBTests.waitForBucketFlush();
        }
        long endWaitMillis = System.currentTimeMillis() + waitMillis;
        do {
            long numRow;
            if ((numRow = DBTests.mapradmin().getNumRows(tablePath)) >= minRowCount) {
                return;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (endWaitMillis >= System.currentTimeMillis());
        throw new IOException("waitForRowCount() did not succeed in the specified time: " + waitMillis);
    }

    public static void waitForRowCount(String tableName, String indexFid, long minRowCount) throws IOException {
        DBTests.waitForRowCount(DBTests.getTablePath(tableName), indexFid, minRowCount);
    }

    public static void waitForRowCount(Path tablePath, String indexFid, long minRowCount) throws IOException {
        DBTests.waitForRowCount(tablePath, indexFid, minRowCount, 60000L);
    }

    public static void waitForRowCount(Path tablePath, String indexFid, long minRowCount, long waitMillis) throws IOException {
        try (JsonTable table = MapRDBImpl.getTable((Path)tablePath);){
            table.flush();
            DBTests.waitForBucketFlush();
        }
        long endWaitMillis = System.currentTimeMillis() + waitMillis;
        do {
            long numRow;
            if ((numRow = DBTests.mapradmin().getNumRows(tablePath, indexFid)) >= minRowCount) {
                return;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (endWaitMillis >= System.currentTimeMillis());
        throw new IOException("waitForRowCount() did not succeed in the specified time: " + waitMillis);
    }

    public static void setTableStatsSendInterval(long sendMinutes) throws Exception {
        if (sendMinutes < 1L || sendMinutes > 60L) {
            throw new IllegalArgumentException("send interval has to be between 1 and 60 minutes");
        }
        String cmd = "/opt/mapr/server/mrconfig set config enable.db.tablestats.sendinterval " + sendMinutes;
        RunCommand rc = TestCluster.runCommand((String)cmd);
        DBTests.checkResult(rc);
    }

    public static void waitForRowCountFromNC(Path tablePath, long minRowCount, long waitMillis) throws Exception {
        try (JsonTable table = MapRDBImpl.getTable((Path)tablePath);){
            table.flush();
            DBTests.waitForBucketFlush();
        }
        long endWaitMillis = System.currentTimeMillis() + waitMillis;
        do {
            JsonTable table;
            MetaTable metaTable;
            ScanStats stats;
            if ((stats = (metaTable = (table = MapRDBImpl.getTable((Path)tablePath)).getMetaTable()).getScanStats()).getEstimatedNumRows() >= minRowCount) {
                return;
            }
            table.close();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (endWaitMillis >= System.currentTimeMillis());
        throw new IOException("waitForRowCountFromNC() did not succeed in the specified time: " + waitMillis);
    }

    public static void waitForIndexFlush(String tableName) throws IOException {
        DBTests.waitForIndexFlush(DBTests.getTablePath(tableName));
    }

    public static void waitForIndexFlush(Path tablePath) throws IOException {
        DBTests.waitForIndexFlush(tablePath, 60000L);
    }

    public static void waitForIndexFlush(Path tablePath, long waitMillis) throws IOException {
        try (JsonTable table = MapRDBImpl.getTable((Path)tablePath);){
            table.flush();
        }
        long endWaitMillis = System.currentTimeMillis() + waitMillis;
        do {
            Dbserver.TableReplicaListResponse response;
            if (DBTests.getReplicaPending(response = DBTests.maprfs().listTableIndexes(tablePath, true, true, true)) <= 0L) {
                return;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (endWaitMillis >= System.currentTimeMillis());
        throw new IOException("waitForIndexFlush() did not succeed in the specified time: " + waitMillis);
    }

    public static void waitForSchemaUpdate() throws InterruptedException {
        Thread.sleep(12000L);
    }

    private static long getReplicaPending(Dbserver.TableReplicaListResponse response) {
        long replicationPending = 0L;
        for (Dbserver.TableReplicaStatus status : response.getReplicaStatusList()) {
            replicationPending += status.getBytesPending() + (long)status.getBucketsPending() + status.getPutsPending();
        }
        return replicationPending;
    }

    public static JsonTable createOrGetTable(String tableName) throws IOException {
        Path tablePath = DBTests.getTablePath(tableName);
        JsonTable table = !DBTests.maprfs().exists(tablePath) ? DBTests.admin().createTable(tablePath) : MapRDBImpl.getTable((Path)tablePath);
        return table;
    }

    public static void createIndex(String tableName, String indexName, String[] indexFields) throws Exception {
        DBTests.createIndex(tableName, indexName, indexFields, null);
    }

    public static void createIndex(String tableName, String indexName, String[] indexFields, String[] coveringFields) throws Exception {
        DBTests.createIndex(tableName, indexName, indexFields, coveringFields, false, 0);
    }

    @Deprecated
    public static void createIndex(String tableName, String indexName, String[] indexFields, String[] coveringFields, boolean isHashedIndex, int numHashPartitions) throws Exception {
        StringBuilder indexedFieldsDfn = new StringBuilder("'");
        for (String indexField : (String[])Preconditions.checkNotNull((Object)indexFields)) {
            indexedFieldsDfn.append(indexField).append(":1,");
        }
        indexedFieldsDfn.setCharAt(indexedFieldsDfn.length() - 1, '\'');
        StringBuilder coveringFieldsDfn = new StringBuilder();
        if (coveringFields != null && coveringFields.length > 0) {
            coveringFieldsDfn.append("'");
            for (String indexField : coveringFields) {
                coveringFieldsDfn.append(indexField).append(",");
            }
            coveringFieldsDfn.setCharAt(coveringFieldsDfn.length() - 1, '\'');
        }
        TestCluster.runCommand((String)("maprcli table index add -path " + DBTests.getTablePath((String)Preconditions.checkNotNull((Object)tableName)).toString() + " -index " + (String)Preconditions.checkNotNull((Object)indexName) + " -indexedfields " + indexedFieldsDfn.toString() + (coveringFields != null ? " -includedfields " + coveringFieldsDfn.toString() : (String)(isHashedIndex ? "-hashed true -numhashpartitions " + Integer.toString(numHashPartitions) : ""))));
        DBTests.waitForSchemaUpdate();
    }

    public static IndexDesc getIndex(JsonTable table, String indexName) throws DBException, IOException {
        Collection indexList = DBTests.admin().getTableIndexes(table.getPath(), true);
        for (IndexDesc idx : indexList) {
            if (!idx.getIndexName().equals(indexName)) continue;
            return idx;
        }
        return null;
    }

    public static void waitForReplicaSync(String tablePath, String replicaPath) throws Exception {
        StringBuilder listRepl = new StringBuilder("maprcli table replica list -json  -path " + tablePath + " -replica " + replicaPath);
        boolean replInSync = false;
        int retryCount = 5;
        Document outDoc = null;
        do {
            RunCommand cmdOut = TestCluster.runCommand((String)listRepl.toString());
            DBTests.handleCommandResponse(listRepl.toString(), cmdOut);
            outDoc = MapRDBImpl.newDocument((String)cmdOut.getStdOut());
            String state = outDoc.getString("data[0].replicaState");
            if (state != null && state.equals("REPLICA_STATE_REPLICATING")) {
                replInSync = true;
                continue;
            }
            System.out.println("Waiting for replica sync to complete..");
            Thread.sleep(1000L);
            --retryCount;
        } while (!replInSync && retryCount > 0);
        if (!replInSync) {
            String errString = outDoc.getString("data[0].errors.Msg");
            throw new IOException("waitForReplicaSync timed out for table: " + tablePath + ", replica: " + replicaPath + " error:" + errString);
        }
    }

    private static void handleCommandResponse(String cmd, RunCommand cmdOut) {
        if (cmdOut.getExitCode() != 0) {
            System.err.println("Command '" + cmd + "' failed:\n" + cmdOut.getStdErr());
        } else {
            System.out.println("Command output for " + cmd + ": \n" + cmdOut.getStdOut());
        }
    }

    public static MapRDBTableImpl createReplica(String tablePath, String replicaPath, boolean autosetup, String columns, boolean paused, boolean multimaster) throws Exception {
        StringBuilder replCmd = new StringBuilder("maprcli table replica ");
        if (autosetup) {
            replCmd.append("autosetup ");
        } else {
            replCmd.append("add ");
        }
        replCmd.append("-path " + tablePath + " -replica " + replicaPath + (String)(columns != null ? " -columns " + columns : "") + (autosetup ? " -multimaster " + multimaster : " -paused " + paused));
        RunCommand cmdOut = TestCluster.runCommand((String)replCmd.toString());
        DBTests.handleCommandResponse(replCmd.toString(), cmdOut);
        if (autosetup) {
            DBTests.waitForReplicaSync(tablePath, replicaPath);
        } else {
            StringBuilder upstreamCmd = new StringBuilder("maprcli table upstream add -path " + replicaPath + " -upstream " + tablePath);
            cmdOut = TestCluster.runCommand((String)upstreamCmd.toString());
            System.out.println(cmdOut.getOutput());
        }
        return (MapRDBTableImpl)MapRDBImpl.getTable((String)replicaPath);
    }

    public static void printDocumentEventsAsserts(Document document) {
        DBTests.printDocumentEventsAsserts(document, false);
    }

    public static void printDocumentEventsAsserts(Document document, boolean includeValues) {
        DocumentReader reader = document.asReader();
        System.err.println();
        DocumentReader.EventType evt = reader.next();
        System.err.println(String.format("    assertEquals(EventType.START_MAP, reader.next());  // beginning of the document\n", new Object[0]));
        System.err.println("    /*");
        System.err.println("     * The following field order is assumed because the RowCol");
        System.err.println("     * format encodes data in alphabetical order of field names.");
        System.err.println("     */");
        while ((evt = reader.next()) != null) {
            Object evtName;
            Object object = evtName = reader.inMap() ? reader.getFieldName() : "[" + reader.getArrayIndex() + "]";
            if (evtName == null) break;
            System.err.println(String.format("    assertEquals(EventType.%s, reader.next());  // %s", evt, evtName));
            if (reader.inMap()) {
                System.err.println(String.format("    assertEquals(\"%s\", reader.getFieldName());", reader.getFieldName()));
            } else {
                System.err.println(String.format("    assertEquals(%s, reader.getArrayIndex());", reader.getArrayIndex()));
            }
            if (!includeValues) continue;
            switch (evt) {
                case BOOLEAN: {
                    System.err.println(String.format("    assertEquals(%s, reader.getBoolean());", reader.getBoolean()));
                    break;
                }
                case BYTE: {
                    System.err.println(String.format("    assertEquals(%s, reader.getByte());", reader.getByte()));
                    break;
                }
                case SHORT: {
                    System.err.println(String.format("    assertEquals(%s, reader.getShort());", reader.getShort()));
                    break;
                }
                case INT: {
                    System.err.println(String.format("    assertEquals(%s, reader.getInt());", reader.getInt()));
                    break;
                }
                case LONG: {
                    System.err.println(String.format("    assertEquals(%s, reader.getLong());", reader.getLong()));
                    break;
                }
                case FLOAT: {
                    System.err.println(String.format("    assertEquals(%s, reader.getFloat(), 0);", Float.valueOf(reader.getFloat())));
                    break;
                }
                case DOUBLE: {
                    System.err.println(String.format("    assertEquals(%s, reader.getDouble(), 0);", reader.getDouble()));
                    break;
                }
                case STRING: {
                    System.err.println(String.format("    assertEquals(\"%s\", reader.getString());", reader.getString()));
                    break;
                }
                case DATE: {
                    System.err.println(String.format("    assertEquals(ODate.parse(\"%s\"), reader.getDate());", reader.getDate().toDateStr()));
                    break;
                }
                case TIME: {
                    System.err.println(String.format("    assertEquals(OTime.parse(\"%s\"), reader.getTime());", reader.getTime().toTimeStr()));
                    break;
                }
                case TIMESTAMP: {
                    System.err.println(String.format("    assertEquals(OTimestamp.parse(\"%s\"), reader.getTimestamp());", reader.getTimestamp().toUTCString()));
                    break;
                }
            }
        }
        System.err.println(String.format("\n    assertEquals(EventType.END_MAP, reader.next());  // end of the document", new Object[0]));
        System.err.println("\n    assertNull(reader.next());");
    }

    public static void createIndex(JsonTable tab, String indexName, boolean isHashed, int nHashPartitions, String[] indexedFields, SortOrder[] sortOrders, String[] nonIndexedFields) throws Exception {
        Preconditions.checkArgument((tab != null ? 1 : 0) != 0, (Object)"the table must be non-null");
        Preconditions.checkArgument((indexName != null && indexName.length() > 0 ? 1 : 0) != 0, (Object)"the index name must be a non-empty string");
        Preconditions.checkArgument((indexedFields != null && indexedFields.length > 0 ? 1 : 0) != 0, (Object)"the indexed fields must be a non-empty array of field names");
        StringBuilder sb = new StringBuilder("maprcli table index add -path ");
        sb.append(tab.getPath());
        sb.append(" -index ");
        sb.append(indexName);
        if (isHashed) {
            sb.append(" -hashed true ");
            Preconditions.checkArgument((nHashPartitions >= 0 ? 1 : 0) != 0, (Object)"the number of hash partitions must be non-negative");
            if (nHashPartitions > 0) {
                sb.append(" -numhashpartitions ");
                sb.append(nHashPartitions);
                sb.append(' ');
            }
        }
        if (indexedFields == null || indexedFields.length == 0) {
            throw new IllegalArgumentException("index must have at least one indexed field");
        }
        sb.append(" -indexedfields '");
        boolean isFirst = true;
        int fieldIndex = 0;
        for (String indexedField : indexedFields) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(',');
            }
            sb.append(indexedField);
            sb.append(':');
            SortOrder sortOrder = DBTests.getSortOrder(sortOrders, fieldIndex);
            switch (sortOrder) {
                case ASC: {
                    sb.append('1');
                    break;
                }
                case DESC: {
                    sb.append("-1");
                }
            }
            ++fieldIndex;
        }
        sb.append('\'');
        if (nonIndexedFields != null && nonIndexedFields.length > 0) {
            sb.append(" -includedfields '");
            isFirst = true;
            for (String nonIndexedField : nonIndexedFields) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    sb.append(',');
                }
                sb.append(nonIndexedField);
            }
            sb.append('\'');
        }
        String indexAdd = sb.toString();
        RunCommand rc = TestCluster.runCommand((String)indexAdd);
        DBTests.checkResult(rc);
        Path tablePath = tab.getPath();
        DBTests.waitForIndexFlush(tablePath);
    }

    private static void checkResult(String streamName, String output) {
        String local = output;
        if (local != null && (local = local.trim()).length() > 0) {
            System.err.println("error on " + streamName + ": " + local);
        }
    }

    public static List<Document> getAllDocumentsAndCloseStream(DocumentStream stream) {
        ArrayList documents = Lists.newArrayList();
        for (Document document : stream) {
            documents.add(document);
        }
        stream.close();
        return documents;
    }

    private static void checkResult(RunCommand runCommand) {
        DBTests.checkResult("stdout", runCommand.getStdOut());
        DBTests.checkResult("stderr", runCommand.getStdErr());
    }

    public static SortOrder getSortOrder(SortOrder[] sortOrders, int i) {
        if (sortOrders == null || sortOrders.length <= i) {
            return SortOrder.ASC;
        }
        SortOrder theOrder = sortOrders[i];
        if (theOrder == null) {
            return SortOrder.ASC;
        }
        return theOrder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document getSingleDocument(DocumentStream docStream) {
        try {
            Iterator docIter = docStream.iterator();
            if (!docIter.hasNext()) {
                throw new IllegalStateException("expected at least one document");
            }
            Document resultDoc = (Document)docIter.next();
            if (docIter.hasNext()) {
                throw new IllegalStateException("did not expect more than one document");
            }
            Document document = resultDoc;
            return document;
        }
        finally {
            docStream.close();
        }
    }

    static {
        System.setProperty("line.separator", "\n");
        objectMapper = new ObjectMapper();
        String userName = null;
        try {
            userName = UserGroupInformation.getLoginUser().getUserName();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        USER_NAME = userName;
        policyServiceMasterStatusSet = false;
    }
}

