/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.tests.tableops;

import com.google.common.collect.BiMap;
import com.google.common.collect.EnumBiMap;
import com.mapr.db.Table;
import com.mapr.db.TabletInfo;
import com.mapr.db.impl.BaseJsonTable;
import com.mapr.db.impl.ConditionImpl;
import com.mapr.db.impl.ConditionNode;
import com.mapr.db.impl.IdCodec;
import com.mapr.db.impl.MapRDBImpl;
import com.mapr.db.impl.MapRDBIndexImpl;
import com.mapr.db.impl.MapRDBTableImpl;
import com.mapr.db.impl.TabletInfoImpl;
import com.mapr.db.index.IndexDesc;
import com.mapr.db.index.IndexFieldDesc;
import com.mapr.db.indexrowkeyfmt.IndexRowKeyEncoder;
import com.mapr.db.rowcol.DBValueBuilderImpl;
import com.mapr.db.tests.aces.TestJSONAceSupportWithCluster;
import com.mapr.db.tests.utils.DBTests;
import com.mapr.fs.proto.Dbfilters;
import com.mapr.fs.utils.ssh.TestCluster;
import com.mapr.tests.BaseTest;
import com.mapr.tests.annotations.ClusterTest;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.hadoop.fs.Path;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.ojai.Document;
import org.ojai.DocumentConstants;
import org.ojai.FieldPath;
import org.ojai.store.QueryCondition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={ClusterTest.class})
public class TabletInfoTest
extends BaseTest {
    private static final Logger _logger = LoggerFactory.getLogger(TestJSONAceSupportWithCluster.class);
    private static final String EMPTY = "";
    private static final String AAAA = "aaaaa";
    private static final String BBBB = "bbbbb";
    private static final String CCCC = "ccccc";
    private static final String DDDD = "ddddd";
    private static final String EEEE = "eeeee";
    private static final String FFFF = "fffff";
    private static final String GGGG = "ggggg";
    private static final String HHHH = "hhhhh";
    private static final String IIII = "iiiii";
    private static final String JJJJ = "jjjjj";
    private static final String KKKK = "kkkkk";
    private static final String LLLL = "lllll";
    private static final String MMMM = "mmmmm";
    private static final String NNNN = "nnnnn";
    private static final String[] ALL_IDS = new String[]{"aaaaa", "", "ddddd", "eeeee", "bbbbb", "ccccc"};
    private static final String TABLE_NAME = "testtable-" + TabletInfoTest.class.getSimpleName();
    private static final String PRIMARY_TABLE_NAME = "testtable-" + TabletInfoTest.class.getSimpleName() + "-primary";
    private static final String SECONDARY_INDEX_NAME = "testtable-" + TabletInfoTest.class.getSimpleName() + "-secondary";
    private static BaseJsonTable table;
    private static BaseJsonTable primaryTable;
    private static BaseJsonTable secondaryIndexTable;
    private static List<IndexFieldDesc> partitionKeys;
    private static final int initAge = 16;
    static final BiMap<QueryCondition.Op, Dbfilters.CompareOpProto> opProtoMap;
    private static final int TABLET_FLUSH_INT = 10000;

    private static String getFormattedId(int id) {
        return String.format("id%08d", id);
    }

    private static String getFormattedInt(int age) {
        return String.format("%04d", age);
    }

    private static void populateTable(String tableName) {
        primaryTable = (BaseJsonTable)MapRDBImpl.getTable((Path)new Path(tableName));
        int numberOfEntries = 100;
        int increaseRangeSize = 80;
        for (int i = 0; i < 100; ++i) {
            String id = TabletInfoTest.getFormattedId(i);
            String firstName = String.format("Json%08d", i);
            String lastName = String.format("Smith%08d", i);
            String age = TabletInfoTest.getFormattedInt(16 + i);
            Document putRec = MapRDBImpl.newDocument().set("name.first", firstName).set("name.last", lastName).set("age", age);
            primaryTable.insertOrReplace(id, putRec);
        }
        _logger.info("Primary and Seconadry Index tables were populated");
    }

    @BeforeClass
    public static void setupTabletInfoTest() throws Exception {
        table = (BaseJsonTable)DBTests.createOrReplaceTable(TABLE_NAME, new String[]{AAAA, BBBB, CCCC, DDDD, EEEE});
        table.setOption(Table.TableOption.BUFFERWRITE, false);
        table.setOption(Table.TableOption.EXCLUDEID, true);
        primaryTable = (BaseJsonTable)DBTests.createOrReplaceTable(PRIMARY_TABLE_NAME);
        primaryTable.setOption(Table.TableOption.BUFFERWRITE, false);
        _logger.info("Primary table has been created");
        TestCluster.runCommand((String)("maprcli table index add -path " + primaryTable.getPath() + " -index " + SECONDARY_INDEX_NAME + " -indexedfields 'age:1'"));
        Collection tableIndexColl = DBTests.admin().getTableIndexes(primaryTable.getPath(), false);
        Assert.assertEquals((long)1L, (long)tableIndexColl.size());
        IndexDesc indexTableDesc = (IndexDesc)tableIndexColl.iterator().next();
        secondaryIndexTable = (BaseJsonTable)MapRDBImpl.getIndexTable((IndexDesc)indexTableDesc);
        partitionKeys = indexTableDesc.getIndexedFields();
        int size = partitionKeys.size();
        Assert.assertEquals((long)1L, (long)size);
    }

    @AfterClass
    public static void cleanupTabletTest() throws Exception {
        if (table != null) {
            table.close();
            DBTests.deleteTables(TABLE_NAME);
        }
    }

    @Test
    public void testGetTabletInfoForARow() throws IOException {
        TabletInfo tabletInfoCCCC = table.getTabletInfo(CCCC);
        List range = ((ConditionImpl)tabletInfoCCCC.getCondition()).getRowkeyRanges();
        Assert.assertEquals((Object)CCCC, (Object)IdCodec.decodeString((byte[])((ConditionNode.RowkeyRange)range.get(0)).getStartRow()));
        Assert.assertEquals((Object)DDDD, (Object)IdCodec.decodeString((byte[])((ConditionNode.RowkeyRange)range.get(0)).getStopRow()));
        TabletInfo tabletInfo1111 = table.getTabletInfo("1111");
        range = ((ConditionImpl)tabletInfo1111.getCondition()).getRowkeyRanges();
        Assert.assertEquals((Object)EMPTY, (Object)IdCodec.decodeString((byte[])((ConditionNode.RowkeyRange)range.get(0)).getStartRow()));
        Assert.assertEquals((Object)AAAA, (Object)IdCodec.decodeString((byte[])((ConditionNode.RowkeyRange)range.get(0)).getStopRow()));
        TabletInfo tabletInfoZZZZ = table.getTabletInfo("zzzz");
        range = ((ConditionImpl)tabletInfoZZZZ.getCondition()).getRowkeyRanges();
        Assert.assertEquals((Object)EEEE, (Object)IdCodec.decodeString((byte[])((ConditionNode.RowkeyRange)range.get(0)).getStartRow()));
        Assert.assertEquals((Object)EMPTY, (Object)IdCodec.decodeString((byte[])((ConditionNode.RowkeyRange)range.get(0)).getStopRow()));
    }

    @Test
    public void testGetAllTabletInfos() throws IOException {
        TabletInfo[] tabletInfos = table.getTabletInfos();
        Assert.assertEquals((long)6L, (long)tabletInfos.length);
        for (TabletInfo tabletInfo : tabletInfos) {
            _logger.info("TabletInfo: {}.", (Object)tabletInfo);
        }
        List range = ((ConditionImpl)tabletInfos[0].getCondition()).getRowkeyRanges();
        Assert.assertEquals((Object)EMPTY, (Object)IdCodec.decodeString((byte[])((ConditionNode.RowkeyRange)range.get(0)).getStartRow()));
        Assert.assertEquals((Object)AAAA, (Object)IdCodec.decodeString((byte[])((ConditionNode.RowkeyRange)range.get(0)).getStopRow()));
        range = ((ConditionImpl)tabletInfos[1].getCondition()).getRowkeyRanges();
        Assert.assertEquals((Object)AAAA, (Object)IdCodec.decodeString((byte[])((ConditionNode.RowkeyRange)range.get(0)).getStartRow()));
        Assert.assertEquals((Object)BBBB, (Object)IdCodec.decodeString((byte[])((ConditionNode.RowkeyRange)range.get(0)).getStopRow()));
        range = ((ConditionImpl)tabletInfos[2].getCondition()).getRowkeyRanges();
        Assert.assertEquals((Object)BBBB, (Object)IdCodec.decodeString((byte[])((ConditionNode.RowkeyRange)range.get(0)).getStartRow()));
        Assert.assertEquals((Object)CCCC, (Object)IdCodec.decodeString((byte[])((ConditionNode.RowkeyRange)range.get(0)).getStopRow()));
        range = ((ConditionImpl)tabletInfos[3].getCondition()).getRowkeyRanges();
        Assert.assertEquals((Object)CCCC, (Object)IdCodec.decodeString((byte[])((ConditionNode.RowkeyRange)range.get(0)).getStartRow()));
        Assert.assertEquals((Object)DDDD, (Object)IdCodec.decodeString((byte[])((ConditionNode.RowkeyRange)range.get(0)).getStopRow()));
        range = ((ConditionImpl)tabletInfos[4].getCondition()).getRowkeyRanges();
        Assert.assertEquals((Object)DDDD, (Object)IdCodec.decodeString((byte[])((ConditionNode.RowkeyRange)range.get(0)).getStartRow()));
        Assert.assertEquals((Object)EEEE, (Object)IdCodec.decodeString((byte[])((ConditionNode.RowkeyRange)range.get(0)).getStopRow()));
        range = ((ConditionImpl)tabletInfos[5].getCondition()).getRowkeyRanges();
        Assert.assertEquals((Object)EEEE, (Object)IdCodec.decodeString((byte[])((ConditionNode.RowkeyRange)range.get(0)).getStartRow()));
        Assert.assertEquals((Object)EMPTY, (Object)IdCodec.decodeString((byte[])((ConditionNode.RowkeyRange)range.get(0)).getStopRow()));
    }

    @Test
    public void testGetSelectedTabletInfos() throws IOException {
        ConditionImpl c = new ConditionImpl().and().is(DocumentConstants.ID_FIELD, QueryCondition.Op.GREATER_OR_EQUAL, "aaaab").is(DocumentConstants.ID_FIELD, QueryCondition.Op.LESS, "eeeec").close().build();
        TabletInfo[] tabletInfos = table.getTabletInfos((QueryCondition)c);
        Assert.assertEquals((long)4L, (long)tabletInfos.length);
        for (TabletInfo tabletInfo : tabletInfos) {
            _logger.info("TabletInfo: {}.", (Object)tabletInfo);
        }
        List range = ((ConditionImpl)tabletInfos[0].getCondition()).getRowkeyRanges();
        Assert.assertEquals((Object)"aaaab", (Object)IdCodec.decodeString((byte[])((ConditionNode.RowkeyRange)range.get(0)).getStartRow()));
        Assert.assertEquals((Object)BBBB, (Object)IdCodec.decodeString((byte[])((ConditionNode.RowkeyRange)range.get(0)).getStopRow()));
        range = ((ConditionImpl)tabletInfos[1].getCondition()).getRowkeyRanges();
        Assert.assertEquals((Object)BBBB, (Object)IdCodec.decodeString((byte[])((ConditionNode.RowkeyRange)range.get(0)).getStartRow()));
        Assert.assertEquals((Object)CCCC, (Object)IdCodec.decodeString((byte[])((ConditionNode.RowkeyRange)range.get(0)).getStopRow()));
        range = ((ConditionImpl)tabletInfos[2].getCondition()).getRowkeyRanges();
        Assert.assertEquals((Object)CCCC, (Object)IdCodec.decodeString((byte[])((ConditionNode.RowkeyRange)range.get(0)).getStartRow()));
        Assert.assertEquals((Object)DDDD, (Object)IdCodec.decodeString((byte[])((ConditionNode.RowkeyRange)range.get(0)).getStopRow()));
        range = ((ConditionImpl)tabletInfos[3].getCondition()).getRowkeyRanges();
        Assert.assertEquals((Object)DDDD, (Object)IdCodec.decodeString((byte[])((ConditionNode.RowkeyRange)range.get(0)).getStartRow()));
        Assert.assertEquals((Object)"eeeec", (Object)IdCodec.decodeString((byte[])((ConditionNode.RowkeyRange)range.get(0)).getStopRow()));
    }

    @Test
    public void testGetSelectedTabletInfosWithNoLastKey() throws IOException {
        ConditionImpl c = new ConditionImpl().is(DocumentConstants.ID_FIELD, QueryCondition.Op.GREATER_OR_EQUAL, "aaaxy").build();
        TabletInfo[] tabletInfos = table.getTabletInfos((QueryCondition)c);
        Assert.assertEquals((long)5L, (long)tabletInfos.length);
        for (TabletInfo tabletInfo : tabletInfos) {
            _logger.info("TabletInfo: {}.", (Object)tabletInfo);
        }
    }

    @Test
    public void testGetSelectedTabletInfosWithNoFirstKey() throws IOException {
        ConditionImpl c = new ConditionImpl().is(DocumentConstants.ID_FIELD, QueryCondition.Op.LESS_OR_EQUAL, "dddaa").build();
        TabletInfo[] tabletInfos = table.getTabletInfos((QueryCondition)c);
        Assert.assertEquals((long)4L, (long)tabletInfos.length);
        for (TabletInfo tabletInfo : tabletInfos) {
            _logger.info("TabletInfo: {}.", (Object)tabletInfo);
        }
    }

    @Test
    public void testGetSelectedTabletInfosOnTabletStartKeys() throws IOException {
        for (String id : ALL_IDS) {
            ConditionImpl c = new ConditionImpl().is(DocumentConstants.ID_FIELD, QueryCondition.Op.EQUAL, id).build();
            TabletInfo[] tabletInfos = table.getTabletInfos((QueryCondition)c);
            Assert.assertEquals((long)1L, (long)tabletInfos.length);
            TabletInfoImpl tabletInfo = (TabletInfoImpl)tabletInfos[0];
            _logger.info("TabletInfo: {}.", (Object)tabletInfo);
            Assert.assertTrue((boolean)tabletInfo.containsRow(IdCodec.encodeAsBytes((String)id)));
            Assert.assertArrayEquals((byte[])IdCodec.encodeAsBytes((String)id), (byte[])tabletInfo.getStartRow());
        }
    }

    @Test
    public void testGetSelectedTabletInfosForRangeWithinTablet() throws IOException {
        ConditionImpl c = new ConditionImpl().and().is(DocumentConstants.ID_FIELD, QueryCondition.Op.GREATER_OR_EQUAL, "AAAA").is(DocumentConstants.ID_FIELD, QueryCondition.Op.LESS, "BBBB").close().build();
        TabletInfo[] tabletInfos = table.getTabletInfos((QueryCondition)c);
        Assert.assertEquals((long)1L, (long)tabletInfos.length);
        TabletInfoImpl tabletInfo = (TabletInfoImpl)tabletInfos[0];
        Assert.assertArrayEquals((byte[])IdCodec.encodeAsBytes((String)"AAAA"), (byte[])tabletInfo.getStartRow());
        Assert.assertArrayEquals((byte[])IdCodec.encodeAsBytes((String)"BBBB"), (byte[])tabletInfo.getStopRow());
        _logger.info("TabletInfo: {}.", (Object)tabletInfo);
    }

    @Test
    public void testGetSelectedTabletInfosForRangeOnTabletBoundaries() throws IOException {
        ConditionImpl c = new ConditionImpl().and().is(DocumentConstants.ID_FIELD, QueryCondition.Op.GREATER_OR_EQUAL, AAAA).is(DocumentConstants.ID_FIELD, QueryCondition.Op.LESS, BBBB).close().build();
        TabletInfo[] tabletInfos = table.getTabletInfos((QueryCondition)c);
        Assert.assertEquals((long)1L, (long)tabletInfos.length);
        TabletInfoImpl tabletInfo = (TabletInfoImpl)tabletInfos[0];
        Assert.assertArrayEquals((byte[])IdCodec.encodeAsBytes((String)AAAA), (byte[])tabletInfo.getStartRow());
        Assert.assertArrayEquals((byte[])IdCodec.encodeAsBytes((String)BBBB), (byte[])tabletInfo.getStopRow());
        _logger.info("TabletInfo: {}.", (Object)tabletInfo);
    }

    @Test
    public void testGetSelectedTabletInfosForRangeOnTwoTabletBoundaries() throws IOException {
        ConditionImpl c = new ConditionImpl().and().is(DocumentConstants.ID_FIELD, QueryCondition.Op.GREATER_OR_EQUAL, AAAA).is(DocumentConstants.ID_FIELD, QueryCondition.Op.LESS, CCCC).close().build();
        TabletInfo[] tabletInfos = table.getTabletInfos((QueryCondition)c);
        Assert.assertEquals((long)2L, (long)tabletInfos.length);
        TabletInfoImpl tablet0Info = (TabletInfoImpl)tabletInfos[0];
        TabletInfoImpl tablet1Info = (TabletInfoImpl)tabletInfos[1];
        Assert.assertArrayEquals((byte[])IdCodec.encodeAsBytes((String)AAAA), (byte[])tablet0Info.getStartRow());
        Assert.assertArrayEquals((byte[])IdCodec.encodeAsBytes((String)BBBB), (byte[])tablet1Info.getStartRow());
        Assert.assertArrayEquals((byte[])IdCodec.encodeAsBytes((String)CCCC), (byte[])tablet1Info.getStopRow());
        _logger.info("TabletInfo: {}.", (Object)tablet0Info);
    }

    @Test
    public void testGetSelectedTabletInfosForRangeAcrossTabletBoundaries() throws IOException {
        ConditionImpl c = new ConditionImpl().and().is(DocumentConstants.ID_FIELD, QueryCondition.Op.GREATER_OR_EQUAL, "abbbb").is(DocumentConstants.ID_FIELD, QueryCondition.Op.LESS, "bcccc").close().build();
        TabletInfo[] tabletInfos = table.getTabletInfos((QueryCondition)c);
        Assert.assertEquals((long)2L, (long)tabletInfos.length);
        TabletInfoImpl tablet0Info = (TabletInfoImpl)tabletInfos[0];
        TabletInfoImpl tablet1Info = (TabletInfoImpl)tabletInfos[1];
        Assert.assertArrayEquals((byte[])IdCodec.encodeAsBytes((String)"abbbb"), (byte[])tablet0Info.getStartRow());
        Assert.assertArrayEquals((byte[])IdCodec.encodeAsBytes((String)BBBB), (byte[])tablet1Info.getStartRow());
        Assert.assertArrayEquals((byte[])IdCodec.encodeAsBytes((String)"bcccc"), (byte[])tablet1Info.getStopRow());
        _logger.info("TabletInfo: {}.", (Object)tablet0Info);
    }

    private byte[] getExpectedValue(QueryCondition.Op op, String fieldValue) {
        Assert.assertTrue((op == QueryCondition.Op.LESS || op == QueryCondition.Op.LESS_OR_EQUAL || op == QueryCondition.Op.GREATER || op == QueryCondition.Op.GREATER_OR_EQUAL ? 1 : 0) != 0);
        boolean[] descendingOrder = new boolean[]{false};
        IndexRowKeyEncoder encoder = new IndexRowKeyEncoder();
        encoder.init(0, descendingOrder);
        boolean indexedFieldIdx = false;
        List rrList = encoder.getRowKeyRange((Dbfilters.CompareOpProto)opProtoMap.get((Object)op), DBValueBuilderImpl.KeyValueBuilder.initFrom(fieldValue), 0);
        Assert.assertEquals((long)1L, (long)rrList.size());
        ConditionNode.RowkeyRange rr = (ConditionNode.RowkeyRange)rrList.get(0);
        return op == QueryCondition.Op.LESS || op == QueryCondition.Op.LESS_OR_EQUAL ? rr.getStopRow() : rr.getStartRow();
    }

    private void checkRangeBoundary(byte[] calculated, QueryCondition.Op op, String value) {
        byte[] expected = this.getExpectedValue(op, value);
        _logger.info("expctd = '" + Arrays.toString(expected) + "'");
        _logger.info("calctd = '" + Arrays.toString(calculated) + "'");
        Assert.assertArrayEquals((byte[])expected, (byte[])calculated);
    }

    private void checkRange(int rangeId, TabletInfoImpl tabletInfo, QueryCondition.Op startOp, String start, QueryCondition.Op stopOp, String stop) {
        _logger.info("Check Range " + rangeId);
        _logger.info("Start Row:");
        this.checkRangeBoundary(tabletInfo.getStartRow(), startOp, start);
        _logger.info("Stop Row:");
        this.checkRangeBoundary(tabletInfo.getStopRow(), stopOp, stop);
    }

    private void checkRange(ConditionNode.RowkeyRange observedRange, QueryCondition.Op startOp, String expectedStart, QueryCondition.Op stopOp, String expectedStop) {
        _logger.info("Check Range " + observedRange.toString());
        _logger.info("Start Row:");
        this.checkRangeBoundary(observedRange.getStartRow(), startOp, expectedStart);
        _logger.info("Stop Row:");
        this.checkRangeBoundary(observedRange.getStopRow(), stopOp, expectedStop);
    }

    @Test
    public void testSecondaryIndexTabletInfosRange0() throws IOException {
        _logger.info("Build condition.");
        String fieldPath1 = "age";
        FieldPath AGE_FIELD = FieldPath.parseFrom((String)"age");
        String start = TabletInfoTest.getFormattedInt(17);
        String stop = TabletInfoTest.getFormattedInt(19);
        ConditionImpl c = new ConditionImpl().and().is(AGE_FIELD, QueryCondition.Op.GREATER_OR_EQUAL, start).is(AGE_FIELD, QueryCondition.Op.LESS, stop).close().setPartitionKeys(0, partitionKeys).build();
        _logger.info("Get tablet infos.");
        TabletInfo[] tabletInfos = secondaryIndexTable.getTabletInfos((QueryCondition)c);
        Assert.assertEquals((long)1L, (long)tabletInfos.length);
        _logger.info("Secondary Index table has " + tabletInfos.length + " tablet infos");
        this.checkRange(0, (TabletInfoImpl)tabletInfos[0], QueryCondition.Op.GREATER_OR_EQUAL, start, QueryCondition.Op.LESS, stop);
        _logger.info("TabletInfo: {}.", (Object)((TabletInfoImpl)tabletInfos[0]));
    }

    @Test
    public void testSecondaryIndexTabletInfosRange1() throws IOException {
        _logger.info("Build condition.");
        String fieldPath1 = "age";
        FieldPath AGE_FIELD = FieldPath.parseFrom((String)"age");
        String[] start = new String[]{TabletInfoTest.getFormattedInt(17), TabletInfoTest.getFormattedInt(24)};
        String[] stop = new String[]{TabletInfoTest.getFormattedInt(19), TabletInfoTest.getFormattedInt(30)};
        QueryCondition.Op[] startOp = new QueryCondition.Op[]{QueryCondition.Op.GREATER_OR_EQUAL, QueryCondition.Op.GREATER};
        QueryCondition.Op[] stopOp = new QueryCondition.Op[]{QueryCondition.Op.LESS, QueryCondition.Op.LESS_OR_EQUAL};
        ConditionImpl c = new ConditionImpl().or().and().is(AGE_FIELD, startOp[0], start[0]).is(AGE_FIELD, stopOp[0], stop[0]).close().and().is(AGE_FIELD, startOp[1], start[1]).is(AGE_FIELD, stopOp[1], stop[1]).close().close().setPartitionKeys(0, partitionKeys).build();
        _logger.info("Get tablet infos.");
        TabletInfo[] tabletInfos = secondaryIndexTable.getTabletInfos((QueryCondition)c);
        Assert.assertEquals((long)2L, (long)tabletInfos.length);
        _logger.info("Secondary Index table has " + tabletInfos.length + " tablet infos");
        for (int i = 0; i < 2; ++i) {
            this.checkRange(i, (TabletInfoImpl)tabletInfos[i], startOp[i], start[i], stopOp[i], stop[i]);
            _logger.info("TabletInfo: {}.", (Object)((TabletInfoImpl)tabletInfos[i]));
        }
    }

    @Test
    public void testSecondaryIndexTabletInfosRange2() throws IOException {
        _logger.info("Build condition.");
        String fieldPath1 = "age";
        FieldPath AGE_FIELD = FieldPath.parseFrom((String)"age");
        String[] start = new String[]{TabletInfoTest.getFormattedInt(17), TabletInfoTest.getFormattedInt(24), TabletInfoTest.getFormattedInt(18), TabletInfoTest.getFormattedInt(29)};
        String[] stop = new String[]{TabletInfoTest.getFormattedInt(19), TabletInfoTest.getFormattedInt(30), TabletInfoTest.getFormattedInt(28), TabletInfoTest.getFormattedInt(35)};
        QueryCondition.Op[] startOp = new QueryCondition.Op[]{QueryCondition.Op.GREATER_OR_EQUAL, QueryCondition.Op.GREATER, QueryCondition.Op.GREATER_OR_EQUAL, QueryCondition.Op.GREATER};
        QueryCondition.Op[] stopOp = new QueryCondition.Op[]{QueryCondition.Op.LESS, QueryCondition.Op.LESS_OR_EQUAL, QueryCondition.Op.LESS, QueryCondition.Op.LESS_OR_EQUAL};
        ConditionImpl c = new ConditionImpl().and().or().and().is(AGE_FIELD, startOp[0], start[0]).is(AGE_FIELD, stopOp[0], stop[0]).close().and().is(AGE_FIELD, startOp[1], start[1]).is(AGE_FIELD, stopOp[1], stop[1]).close().close().or().and().is(AGE_FIELD, startOp[2], start[2]).is(AGE_FIELD, stopOp[2], stop[2]).close().and().is(AGE_FIELD, startOp[3], start[3]).is(AGE_FIELD, stopOp[3], stop[3]).close().close().close().setPartitionKeys(0, partitionKeys).build();
        _logger.info("Get tablet infos.");
        TabletInfo[] tabletInfos = secondaryIndexTable.getTabletInfos((QueryCondition)c);
        Assert.assertEquals((long)3L, (long)tabletInfos.length);
        _logger.info("Secondary Index table has " + tabletInfos.length + " tablet infos");
        int i = 0;
        this.checkRange(i, (TabletInfoImpl)tabletInfos[i], startOp[2], start[2], stopOp[0], stop[0]);
        _logger.info("TabletInfo: {}.", (Object)((TabletInfoImpl)tabletInfos[i]));
        this.checkRange(++i, (TabletInfoImpl)tabletInfos[i], startOp[1], start[1], stopOp[2], stop[2]);
        _logger.info("TabletInfo: {}.", (Object)((TabletInfoImpl)tabletInfos[i]));
        this.checkRange(++i, (TabletInfoImpl)tabletInfos[i], startOp[3], start[3], stopOp[1], stop[1]);
        _logger.info("TabletInfo: {}.", (Object)((TabletInfoImpl)tabletInfos[i]));
    }

    @Test
    public void testSecondaryIndexTabletInfosRange3() throws IOException {
        _logger.info("Build condition.");
        String fieldPath1 = "age";
        FieldPath AGE_FIELD = FieldPath.parseFrom((String)"age");
        String[] start = new String[]{TabletInfoTest.getFormattedInt(17), TabletInfoTest.getFormattedInt(24), TabletInfoTest.getFormattedInt(18), TabletInfoTest.getFormattedInt(29)};
        String[] stop = new String[]{TabletInfoTest.getFormattedInt(19), TabletInfoTest.getFormattedInt(30), TabletInfoTest.getFormattedInt(28), TabletInfoTest.getFormattedInt(35)};
        QueryCondition.Op[] startOp = new QueryCondition.Op[]{QueryCondition.Op.GREATER_OR_EQUAL, QueryCondition.Op.GREATER, QueryCondition.Op.GREATER_OR_EQUAL, QueryCondition.Op.GREATER};
        QueryCondition.Op[] stopOp = new QueryCondition.Op[]{QueryCondition.Op.LESS, QueryCondition.Op.LESS_OR_EQUAL, QueryCondition.Op.LESS, QueryCondition.Op.LESS_OR_EQUAL};
        ConditionImpl c = new ConditionImpl().or().or().and().is(AGE_FIELD, startOp[0], start[0]).is(AGE_FIELD, stopOp[0], stop[0]).close().and().is(AGE_FIELD, startOp[1], start[1]).is(AGE_FIELD, stopOp[1], stop[1]).close().close().or().and().is(AGE_FIELD, startOp[2], start[2]).is(AGE_FIELD, stopOp[2], stop[2]).close().and().is(AGE_FIELD, startOp[3], start[3]).is(AGE_FIELD, stopOp[3], stop[3]).close().close().close().setPartitionKeys(0, partitionKeys).build();
        _logger.info("Get tablet infos.");
        TabletInfo[] tabletInfos = secondaryIndexTable.getTabletInfos((QueryCondition)c);
        Assert.assertEquals((long)1L, (long)tabletInfos.length);
        _logger.info("Secondary Index table has " + tabletInfos.length + " tablet infos");
        int i = 0;
        this.checkRange(i, (TabletInfoImpl)tabletInfos[i], startOp[0], start[0], stopOp[3], stop[3]);
        _logger.info("TabletInfo: {}.", (Object)((TabletInfoImpl)tabletInfos[i]));
    }

    @Test
    public void testSecondaryIndexTabletInfosRange4() throws IOException {
        _logger.info("Build condition.");
        String fieldPath1 = "age";
        FieldPath AGE_FIELD = FieldPath.parseFrom((String)"age");
        String[] start = new String[]{TabletInfoTest.getFormattedInt(17), TabletInfoTest.getFormattedInt(24), TabletInfoTest.getFormattedInt(18), TabletInfoTest.getFormattedInt(29)};
        String[] stop = new String[]{TabletInfoTest.getFormattedInt(19), TabletInfoTest.getFormattedInt(30), TabletInfoTest.getFormattedInt(23), TabletInfoTest.getFormattedInt(35)};
        QueryCondition.Op[] startOp = new QueryCondition.Op[]{QueryCondition.Op.GREATER_OR_EQUAL, QueryCondition.Op.GREATER, QueryCondition.Op.GREATER_OR_EQUAL, QueryCondition.Op.GREATER};
        QueryCondition.Op[] stopOp = new QueryCondition.Op[]{QueryCondition.Op.LESS, QueryCondition.Op.LESS_OR_EQUAL, QueryCondition.Op.LESS, QueryCondition.Op.LESS_OR_EQUAL};
        ConditionImpl c = new ConditionImpl().or().or().and().is(AGE_FIELD, startOp[0], start[0]).is(AGE_FIELD, stopOp[0], stop[0]).close().and().is(AGE_FIELD, startOp[1], start[1]).is(AGE_FIELD, stopOp[1], stop[1]).close().close().or().and().is(AGE_FIELD, startOp[2], start[2]).is(AGE_FIELD, stopOp[2], stop[2]).close().and().is(AGE_FIELD, startOp[3], start[3]).is(AGE_FIELD, stopOp[3], stop[3]).close().close().close().setPartitionKeys(0, partitionKeys).build();
        _logger.info("Get tablet infos.");
        TabletInfo[] tabletInfos = secondaryIndexTable.getTabletInfos((QueryCondition)c);
        Assert.assertEquals((long)2L, (long)tabletInfos.length);
        _logger.info("Secondary Index table has " + tabletInfos.length + " tablet infos");
        int i = 0;
        this.checkRange(i, (TabletInfoImpl)tabletInfos[i], startOp[0], start[0], stopOp[2], stop[2]);
        _logger.info("TabletInfo: {}.", (Object)((TabletInfoImpl)tabletInfos[i]));
        this.checkRange(++i, (TabletInfoImpl)tabletInfos[i], startOp[1], start[1], stopOp[3], stop[3]);
        _logger.info("TabletInfo: {}.", (Object)((TabletInfoImpl)tabletInfos[i]));
    }

    private MapRDBIndexImpl testSecondaryIndexScanRangeSetupIndex(Table priTable, String indexName, String indexedFields) throws Exception {
        MapRDBTableImpl tab = (MapRDBTableImpl)priTable;
        TestCluster.runCommand((String)("maprcli table index add -path " + tab.getPath() + " -index " + indexName + " -indexedfields " + indexedFields));
        Collection tableIndexColl = DBTests.admin().getTableIndexes(tab.getPath(), false);
        Assert.assertEquals((long)1L, (long)tableIndexColl.size());
        IndexDesc indexTableDesc = (IndexDesc)tableIndexColl.iterator().next();
        secondaryIndexTable = (BaseJsonTable)MapRDBImpl.getIndexTable((IndexDesc)indexTableDesc);
        List i1PartitionKeys = indexTableDesc.getIndexedFields();
        int size = i1PartitionKeys.size();
        Assert.assertEquals((long)1L, (long)size);
        MapRDBIndexImpl indexImpl = (MapRDBIndexImpl)MapRDBImpl.getIndexTable((IndexDesc)indexTableDesc);
        return indexImpl;
    }

    @Test
    public void testSecondaryIndexScanRangeArrayElementIndex() throws Exception {
        String tName = "/testSecondaryIndexScanRangeArrayElementIndex-table";
        String iName = "i1";
        String indexedFields = "a[].b";
        MapRDBTableImpl t1 = (MapRDBTableImpl)DBTests.createOrGetTable(tName);
        MapRDBIndexImpl indexImpl = this.testSecondaryIndexScanRangeSetupIndex((Table)t1, iName, indexedFields);
        String formattedVal1 = TabletInfoTest.getFormattedInt(100);
        String formattedVal2 = TabletInfoTest.getFormattedInt(200);
        String formattedVal3 = TabletInfoTest.getFormattedInt(300);
        String formattedVal4 = TabletInfoTest.getFormattedInt(400);
        ConditionImpl qc = MapRDBImpl.newCondition().elementAnd("a[]").is("b", QueryCondition.Op.GREATER, formattedVal1).is("b", QueryCondition.Op.LESS, formattedVal2).close().build();
        List ranges = indexImpl.getRowkeyRanges((QueryCondition)qc);
        assert (ranges.size() == 1);
        this.checkRange((ConditionNode.RowkeyRange)ranges.get(0), QueryCondition.Op.GREATER, formattedVal1, QueryCondition.Op.LESS, formattedVal2);
        qc = MapRDBImpl.newCondition().or().elementAnd("a[]").is("b", QueryCondition.Op.GREATER, formattedVal1).is("b", QueryCondition.Op.LESS, formattedVal2).close().elementAnd("a[]").is("b", QueryCondition.Op.GREATER, formattedVal3).is("b", QueryCondition.Op.LESS, formattedVal4).close().close().build();
        ranges = indexImpl.getRowkeyRanges((QueryCondition)qc);
        assert (ranges.size() == 2);
        this.checkRange((ConditionNode.RowkeyRange)ranges.get(0), QueryCondition.Op.GREATER, formattedVal1, QueryCondition.Op.LESS, formattedVal2);
        this.checkRange((ConditionNode.RowkeyRange)ranges.get(1), QueryCondition.Op.GREATER, formattedVal3, QueryCondition.Op.LESS, formattedVal4);
    }

    public void testGetTabletInfoForOneTablet() throws Exception {
        TabletInfo[] tabletInfo;
        String[] keyPrefix = ALL_IDS;
        int numRowsPerSplit = 15;
        int startKey = 10;
        int endKey = startKey + numRowsPerSplit;
        Document d = MapRDBImpl.newDocument();
        d.set("a.b", "ab");
        for (int i = 0; i < keyPrefix.length; ++i) {
            int count = startKey;
            while (count < endKey) {
                table.insertOrReplace(keyPrefix[i] + Integer.toString(count++), d);
            }
        }
        table.flush();
        Thread.sleep(10000L);
        for (TabletInfo tablet : tabletInfo = table.getTabletInfos(IdCodec.encodeAsBytes((String)BBBB), IdCodec.encodeAsBytes((String)BBBB), true)) {
            TabletInfoImpl tabletInfoImpl = (TabletInfoImpl)tablet;
            Assert.assertTrue((tabletInfoImpl.getInternalEstimatedNumRows() == (long)numRowsPerSplit ? 1 : 0) != 0);
        }
        Assert.assertTrue((tabletInfo.length == 1 ? 1 : 0) != 0);
        List range = ((ConditionImpl)tabletInfo[0].getCondition()).getRowkeyRanges();
        Assert.assertEquals((Object)IdCodec.decodeString((byte[])((ConditionNode.RowkeyRange)range.get(0)).getStartRow()), (Object)BBBB);
        Assert.assertEquals((Object)IdCodec.decodeString((byte[])((ConditionNode.RowkeyRange)range.get(0)).getStopRow()), (Object)CCCC);
    }

    @Test
    public void testGetTabletInfosForKeyRange() throws Exception {
        TabletInfo[] tabletInfo;
        String[] keyPrefix = ALL_IDS;
        int numRowsPerSplit = 15;
        int startKey = 10;
        int endKey = startKey + numRowsPerSplit;
        Document d = MapRDBImpl.newDocument();
        d.set("a.b", "ab");
        for (int i = 0; i < keyPrefix.length; ++i) {
            int count = startKey;
            while (count < endKey) {
                table.insertOrReplace(keyPrefix[i] + Integer.toString(count++), d);
            }
        }
        table.flush();
        Thread.sleep(10000L);
        for (TabletInfo tablet : tabletInfo = table.getTabletInfos(IdCodec.encodeAsBytes((String)AAAA), IdCodec.encodeAsBytes((String)CCCC), true)) {
            TabletInfoImpl tabletInfoImpl = (TabletInfoImpl)tablet;
            Assert.assertEquals((long)numRowsPerSplit, (long)tabletInfoImpl.getInternalEstimatedNumRows());
        }
        Assert.assertTrue((tabletInfo.length == 3 ? 1 : 0) != 0);
        List range = ((ConditionImpl)tabletInfo[0].getCondition()).getRowkeyRanges();
        Assert.assertEquals((Object)IdCodec.decodeString((byte[])((ConditionNode.RowkeyRange)range.get(0)).getStartRow()), (Object)AAAA);
        Assert.assertEquals((Object)IdCodec.decodeString((byte[])((ConditionNode.RowkeyRange)range.get(0)).getStopRow()), (Object)BBBB);
        range = ((ConditionImpl)tabletInfo[1].getCondition()).getRowkeyRanges();
        Assert.assertEquals((Object)IdCodec.decodeString((byte[])((ConditionNode.RowkeyRange)range.get(0)).getStartRow()), (Object)BBBB);
        Assert.assertEquals((Object)IdCodec.decodeString((byte[])((ConditionNode.RowkeyRange)range.get(0)).getStopRow()), (Object)CCCC);
        range = ((ConditionImpl)tabletInfo[2].getCondition()).getRowkeyRanges();
        Assert.assertEquals((Object)IdCodec.decodeString((byte[])((ConditionNode.RowkeyRange)range.get(0)).getStartRow()), (Object)CCCC);
        Assert.assertEquals((Object)IdCodec.decodeString((byte[])((ConditionNode.RowkeyRange)range.get(0)).getStopRow()), (Object)DDDD);
    }

    @Test
    public void testGetTabletInfosForLargeTabletRange() throws Exception {
        TabletInfo[] tabletInfo;
        int numRowsPerSplit = 15;
        int startKey = 10;
        int endKey = startKey + numRowsPerSplit;
        Document d = MapRDBImpl.newDocument();
        d.set("a.b", "ab");
        String[] keyPrefix = new String[]{"aaaa", "bbbb", "cccc", "dddd", "eeee", "ffff", "gggg", "hhhh", "iiii", "jjjj", "kkkk", "llll", "mmmm", "nnnn"};
        String tName = "TabletInfoTest-testGetTabletInfosForLargeTabletRange";
        BaseJsonTable t = (BaseJsonTable)DBTests.createOrReplaceTable(tName, keyPrefix);
        for (int i = 0; i < keyPrefix.length; ++i) {
            int count = startKey;
            while (count < endKey) {
                t.insertOrReplace(keyPrefix[i] + Integer.toString(count++), d);
            }
        }
        t.flush();
        Thread.sleep(10000L);
        for (TabletInfo tablet : tabletInfo = t.getTabletInfos(IdCodec.encodeAsBytes((String)AAAA), IdCodec.encodeAsBytes((String)NNNN), true)) {
            TabletInfoImpl tabletInfoImpl = (TabletInfoImpl)tablet;
            Assert.assertEquals((long)numRowsPerSplit, (long)tabletInfoImpl.getInternalEstimatedNumRows());
        }
        Assert.assertTrue((tabletInfo.length == keyPrefix.length ? 1 : 0) != 0);
    }

    static {
        opProtoMap = EnumBiMap.create(QueryCondition.Op.class, Dbfilters.CompareOpProto.class);
        opProtoMap.put((Object)QueryCondition.Op.LESS, (Object)Dbfilters.CompareOpProto.LESS);
        opProtoMap.put((Object)QueryCondition.Op.LESS_OR_EQUAL, (Object)Dbfilters.CompareOpProto.LESS_OR_EQUAL);
        opProtoMap.put((Object)QueryCondition.Op.EQUAL, (Object)Dbfilters.CompareOpProto.EQUAL);
        opProtoMap.put((Object)QueryCondition.Op.NOT_EQUAL, (Object)Dbfilters.CompareOpProto.NOT_EQUAL);
        opProtoMap.put((Object)QueryCondition.Op.GREATER_OR_EQUAL, (Object)Dbfilters.CompareOpProto.GREATER_OR_EQUAL);
        opProtoMap.put((Object)QueryCondition.Op.GREATER, (Object)Dbfilters.CompareOpProto.GREATER);
        assert (opProtoMap.size() == QueryCondition.Op.values().length) : "Map is missing some of the QueryCondition.Op elements";
    }
}

