/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.tests.condition;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mapr.db.JsonTable;
import com.mapr.db.Table;
import com.mapr.db.impl.AefTransformer;
import com.mapr.db.impl.ConditionDescriptor;
import com.mapr.db.impl.ConditionImpl;
import com.mapr.db.impl.ConditionLeaf;
import com.mapr.db.impl.ConditionNode;
import com.mapr.db.impl.Constants;
import com.mapr.db.impl.IdCodec;
import com.mapr.db.impl.MapRDBImpl;
import com.mapr.db.impl.MapRDBIndexImpl;
import com.mapr.db.impl.MapRDBTableImpl;
import com.mapr.db.impl.index.IndexFieldDescImpl;
import com.mapr.db.index.IndexDesc;
import com.mapr.db.index.IndexFieldDesc;
import com.mapr.db.indexrowkeyfmt.IndexRowKeyEncoder;
import com.mapr.db.rowcol.DBValueBuilderImpl;
import com.mapr.db.rowcol.KeyValue;
import com.mapr.db.tests.utils.DBTests;
import com.mapr.db.util.ConditionParser;
import com.mapr.fs.jni.MapRConstants;
import com.mapr.fs.proto.Dbfilters;
import com.mapr.fs.utils.ssh.TestCluster;
import com.mapr.org.apache.hadoop.hbase.util.Bytes;
import com.mapr.tests.BaseTest;
import com.mapr.tests.annotations.FailingTest;
import com.mapr.tests.annotations.SimpleTest;
import com.mapr.utils.Regexes;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.math.MathContext;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.ojai.DocumentConstants;
import org.ojai.Value;
import org.ojai.store.QueryCondition;
import org.ojai.types.ODate;
import org.ojai.types.OInterval;
import org.ojai.types.OTime;
import org.ojai.types.OTimestamp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={SimpleTest.class})
public class TestCondition
extends BaseTest {
    private static final Logger _logger = LoggerFactory.getLogger(TestCondition.class);
    private static final List<ConditionNode.RowkeyRange> FULL_TABLE_RANGE = ImmutableList.of((Object)new ConditionNode.RowkeyRange(MapRConstants.EMPTY_BYTE_ARRAY, MapRConstants.EMPTY_BYTE_ARRAY));

    @Test
    public void testRowExist() {
        QueryCondition condition = Constants.ROW_EXISTS_CONDITION;
        this.serializeAndCompare(condition, "(_id != null)");
    }

    @Test
    public void testRowNotExist() {
        QueryCondition condition = Constants.ROW_NOT_EXISTS_CONDITION;
        this.serializeAndCompare(condition, "(_id = null)");
    }

    @Test
    public void testSimpleConditionsNonExistent() {
        ConditionImpl condition = MapRDBImpl.newCondition().notExists("nonExistantElem").build();
        this.serializeAndCompare((QueryCondition)condition, "(nonExistantElem = null)");
    }

    @Test
    public void testSimpleConditionsExistent() {
        ConditionImpl condition = MapRDBImpl.newCondition().exists("existantElem").build();
        this.serializeAndCompare((QueryCondition)condition, "(existantElem != null)");
    }

    @Test
    public void testSimpleConditionsNullType() {
        ConditionImpl condition = MapRDBImpl.newCondition().typeOf("nullElem", Value.Type.NULL).build();
        this.serializeAndCompare((QueryCondition)condition, "(TYPE_OF(nullElem) = NULL)");
    }

    @Test
    public void testSimpleConditionsBool() {
        QueryCondition condition = MapRDBImpl.newCondition().is("boolElem", QueryCondition.Op.EQUAL, false).build();
        this.serializeAndCompare(condition, "(boolElem = false)");
    }

    @Test
    public void testSimpleConditionsString() {
        ConditionImpl condition = MapRDBImpl.newCondition().is("stringElem", QueryCondition.Op.GREATER, "stupidity").build();
        this.serializeAndCompare((QueryCondition)condition, "(stringElem > \"stupidity\")");
    }

    @Test
    public void testSimpleConditionsInt() {
        ConditionImpl condition = MapRDBImpl.newCondition().is("intElem", QueryCondition.Op.NOT_EQUAL, 5).build();
        this.serializeAndCompare((QueryCondition)condition, "(intElem != {\"$numberInt\":5})");
    }

    @Test
    public void testSimpleConditionsLong() {
        ConditionImpl condition = MapRDBImpl.newCondition().is("longElem", QueryCondition.Op.LESS_OR_EQUAL, 527346237644235L).build();
        this.serializeAndCompare((QueryCondition)condition, "(longElem <= {\"$numberLong\":527346237644235})");
    }

    @Test
    public void testSimpleConditionsEmptyByteBuffer() {
        ByteBuffer bb = ByteBuffer.allocate(4).putInt(300);
        ConditionImpl condition = MapRDBImpl.newCondition().is("emptyByteBuffer", QueryCondition.Op.EQUAL, bb).build();
        this.serializeAndCompare((QueryCondition)condition, "(emptyByteBuffer = {\"$binary\":\"\"})");
    }

    @Test
    public void testSimpleConditionsFloat() {
        ConditionImpl condition = MapRDBImpl.newCondition().is("floatElem", QueryCondition.Op.LESS, 3.141592f).build();
        this.serializeAndCompare((QueryCondition)condition, "(floatElem < {\"$numberFloat\":3.141592})");
    }

    @Test
    public void testSimpleConditionsDouble() {
        ConditionImpl condition = MapRDBImpl.newCondition().is("doubleElem", QueryCondition.Op.GREATER_OR_EQUAL, Math.PI).build();
        this.serializeAndCompare((QueryCondition)condition, "(doubleElem >= 3.141592653589793)");
    }

    @Test
    @Ignore(value="BigDecimal type not supported")
    public void testSimpleConditionsDecimal() {
        ConditionImpl condition = MapRDBImpl.newCondition().is("deceimalElem", QueryCondition.Op.EQUAL, new BigDecimal("3.141592653589793238462643383279502884197169399375105820974944592307816406286208998628034825342117068", new MathContext(100))).build();
        this.serializeAndCompare((QueryCondition)condition, "(deceimalElem = {\"$decimal\":\"3.141592653589793238462643383279502884197169399375105820974944592307816406286208998628034825342117068\"})");
    }

    @Test
    public void testSimpleConditionsDate() {
        ConditionImpl condition = MapRDBImpl.newCondition().is("dateElem", QueryCondition.Op.NOT_EQUAL, ODate.parse((String)"1979-08-24")).build();
        this.serializeAndCompare((QueryCondition)condition, "(dateElem != {\"$dateDay\":\"1979-08-24\"})");
    }

    @Test
    public void testSimpleConditionsTime() {
        ConditionImpl condition = MapRDBImpl.newCondition().is("timeElem", QueryCondition.Op.LESS_OR_EQUAL, OTime.parse((String)"16:32:00")).build();
        this.serializeAndCompare((QueryCondition)condition, "(timeElem <= {\"$time\":\"16:32:00\"})");
    }

    @Test
    public void testSimpleConditionsTimestamp() {
        ConditionImpl condition = MapRDBImpl.newCondition().is("timestampElem", QueryCondition.Op.EQUAL, OTimestamp.parse((String)"1979-08-24T16:32:00.000+05:30")).build();
        this.serializeAndCompare((QueryCondition)condition, "(timestampElem = {\"$date\":\"1979-08-24T11:02:00.000Z\"})");
    }

    @Test
    @Ignore(value="Interval type not supported")
    public void testSimpleConditionsInterval() {
        ConditionImpl condition = MapRDBImpl.newCondition().is("intervalElem", QueryCondition.Op.GREATER, new OInterval(1239213L)).build();
        this.serializeAndCompare((QueryCondition)condition, "(intervalElem > {\"$interval\":1239213})");
    }

    @Test
    public void testSimpleConditionsBinary() {
        ConditionImpl condition = MapRDBImpl.newCondition().is("binaryElem", QueryCondition.Op.EQUAL, ByteBuffer.wrap(new byte[]{97, 100, 105, 116, 121, 97})).build();
        this.serializeAndCompare((QueryCondition)condition, "(binaryElem = {\"$binary\":\"aditya\"})");
    }

    @Test
    public void testSimpleConditionsMap() {
        ConditionImpl condition = MapRDBImpl.newCondition().equals("mapElem", (Map)ImmutableMap.of((Object)"name", (Object)"hulk", (Object)"weight", (Object)526, (Object)"id", (Object)627131273323L, (Object)"dob", (Object)OTimestamp.parse((String)"1979-10-12T05:23:00.122+07:00"))).build();
        this.serializeAndCompare((QueryCondition)condition, "(mapElem = {\"name\":\"hulk\",\"weight\":{\"$numberInt\":526},\"id\":{\"$numberLong\":627131273323},\"dob\":{\"$date\":\"1979-10-11T22:23:00.122Z\"}})");
    }

    @Test
    public void testSimpleConditionsEmptyMap() {
        ImmutableMap emptyMap = ImmutableMap.of();
        ConditionImpl condition = MapRDBImpl.newCondition().equals("emptyMapElem", (Map)emptyMap).build();
        this.serializeAndCompare((QueryCondition)condition, "(emptyMapElem = {})");
    }

    @Test
    public void testSimpleConditionsArray() {
        ConditionImpl condition = MapRDBImpl.newCondition().equals("listElem", (List)ImmutableList.of((Object)"January", (Object)4, (Object)OTimestamp.parse((String)"2015-03-14T20:12:21.000+00:00"), (Object)ODate.parse((String)"1969-12-31"), (Object)ODate.parse((String)"1970-01-01"), (Object)ODate.parse((String)"1950-01-26"), (Object)OTime.parse((String)"11:22:33"))).build();
        this.serializeAndCompare((QueryCondition)condition, "(listElem = [\"January\",{\"$numberInt\":4},{\"$date\":\"2015-03-14T20:12:21.000Z\"},{\"$dateDay\":\"1969-12-31\"},{\"$dateDay\":\"1970-01-01\"},{\"$dateDay\":\"1950-01-26\"},{\"$time\":\"11:22:33\"}])");
    }

    @Test
    public void testSimpleConditionsEmptyArray() {
        ConditionImpl condition = MapRDBImpl.newCondition().equals("emptyListElem", (List)ImmutableList.of()).build();
        this.serializeAndCompare((QueryCondition)condition, "(emptyListElem = [])");
    }

    @Test
    public void testSimpleConditionsWithLike() {
        QueryCondition condition = MapRDBImpl.newCondition().like("likeElem", "San%").build();
        this.serializeAndCompare(condition, "(likeElem MATCHES \"^\\\\QSan\\\\E.*$\")");
    }

    @Test
    public void testSimpleConditionsWithNotLike() {
        QueryCondition condition = MapRDBImpl.newCondition().notLike("likeElem", "%San__%").build();
        this.serializeAndCompare(condition, "(likeElem NOT_MATCHES \"^.*\\\\QSan\\\\E...*$\")");
    }

    @Test
    public void testSimpleConditionsRegexMatch() {
        ConditionImpl condition = MapRDBImpl.newCondition().matches("patternElem", ".*peace$").build();
        this.serializeAndCompare((QueryCondition)condition, "(patternElem MATCHES \".*peace$\")");
    }

    @Test
    public void testSimpleConditionsRegecNonMatch() {
        ConditionImpl condition = MapRDBImpl.newCondition().notMatches("antiPatternElem", ".*war.*").build();
        this.serializeAndCompare((QueryCondition)condition, "(antiPatternElem NOT_MATCHES \".*war.*\")");
    }

    @Test
    public void testSimpleConditionsRegexMatchId() {
        ConditionImpl condition = MapRDBImpl.newCondition().matches("_id", ".*peace$").build();
        this.serializeAndCompare((QueryCondition)condition, "(_id MATCHES \".*peace$\")");
    }

    @Test
    public void testSimpleConditionsRegecNonMatchId() {
        ConditionImpl condition = MapRDBImpl.newCondition().notMatches("_id", ".*war.*").build();
        this.serializeAndCompare((QueryCondition)condition, "(_id NOT_MATCHES \".*war.*\")");
    }

    @Test
    public void testSimpleConditionsIn() {
        ConditionImpl condition = MapRDBImpl.newCondition().in("oneInTheListElem", (List)ImmutableList.of((Object)42, (Object)"42", (Object)new ODate(42L), (Object)new OTime(42L), (Object)new OTimestamp(42L))).build();
        this.serializeAndCompare((QueryCondition)condition, "((oneInTheListElem = {\"$numberInt\":42}) or (oneInTheListElem = \"42\") or (oneInTheListElem = {\"$dateDay\":\"1969-12-31\"}) or (oneInTheListElem = {\"$time\":\"17:00:00.042\"}) or (oneInTheListElem = {\"$date\":\"1970-01-01T00:00:00.042Z\"}))");
    }

    @Test
    public void testSimpleConditionsNotIn() {
        ConditionImpl condition = MapRDBImpl.newCondition().notIn("noneInTheListElem", (List)ImmutableList.of((Object)"gold", (Object)"silver", (Object)"bronze")).build();
        this.serializeAndCompare((QueryCondition)condition, "((noneInTheListElem != \"gold\") and (noneInTheListElem != \"silver\") and (noneInTheListElem != \"bronze\"))");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConditionCompoundingWihoutBlock() {
        ConditionImpl condition = MapRDBImpl.newCondition().is("a", QueryCondition.Op.EQUAL, 6).matches("b", "wrong_condition_grouping").build();
    }

    @Test
    public void testConditionWithId() {
        ConditionImpl condition = MapRDBImpl.newCondition().is(DocumentConstants.ID_FIELD, QueryCondition.Op.GREATER_OR_EQUAL, "pqr").build();
        condition = condition.cloneOptimized();
        Assert.assertTrue((boolean)condition.isEmpty());
        this.checkAndGetRange((QueryCondition)condition, this.encode("pqr"), MapRConstants.EMPTY_BYTE_ARRAY);
        this.serializeAndCompare((QueryCondition)condition);
    }

    @Test
    public void testConditionWithIdEqual() {
        ConditionImpl condition = MapRDBImpl.newCondition().is(DocumentConstants.ID_FIELD, QueryCondition.Op.EQUAL, "pqr").build();
        condition = condition.cloneOptimized();
        Assert.assertTrue((boolean)condition.isEmpty());
        this.checkAndGetRange((QueryCondition)condition, this.encode("pqr"), this.encode("pqr\u0000"));
        this.serializeAndCompare((QueryCondition)condition);
    }

    @Test
    public void testConditionWithIdNotEqual() {
        ConditionImpl condition = MapRDBImpl.newCondition().is(DocumentConstants.ID_FIELD, QueryCondition.Op.NOT_EQUAL, "pqr").build();
        Assert.assertTrue((!(condition = condition.cloneOptimized()).isEmpty() ? 1 : 0) != 0);
        this.checkAndGetRange((QueryCondition)condition, MapRConstants.EMPTY_BYTE_ARRAY, MapRConstants.EMPTY_BYTE_ARRAY);
        this.serializeAndCompare((QueryCondition)condition, "(_id != \"pqr\")");
    }

    @Test
    public void testConditionWithIdOnMatchesPrefix() {
        ConditionImpl condition = MapRDBImpl.newCondition().matches(DocumentConstants.ID_FIELD, "^device.*").build();
        Assert.assertFalse((boolean)condition.isEmpty());
        this.checkAndGetRange((QueryCondition)condition, this.encode("device"), this.encode("devicf"));
        this.serializeAndCompare((QueryCondition)condition, "(_id MATCHES \"^device.*\")");
    }

    @Test
    public void testConditionWithIdOnMatchesContain() {
        ConditionImpl condition = MapRDBImpl.newCondition().matches(DocumentConstants.ID_FIELD, "device").build();
        Assert.assertFalse((boolean)condition.isEmpty());
        this.checkAndGetRange((QueryCondition)condition, MapRConstants.EMPTY_BYTE_ARRAY, MapRConstants.EMPTY_BYTE_ARRAY);
        this.serializeAndCompare((QueryCondition)condition, "(_id MATCHES \"device\")");
    }

    @Test
    public void testConditionWithIdOnLikePrefix() {
        QueryCondition condition = MapRDBImpl.newCondition().like(DocumentConstants.ID_FIELD, "device%").build();
        Assert.assertFalse((boolean)condition.isEmpty());
        this.checkAndGetRange(condition, this.encode("device"), this.encode("devicf"));
        this.serializeAndCompare(condition, "(_id MATCHES \"^\\\\Qdevice\\\\E.*$\")");
    }

    @Test
    public void testConditionWithIdOnLikeContain() {
        QueryCondition condition = MapRDBImpl.newCondition().like(DocumentConstants.ID_FIELD, "%device").build();
        Assert.assertFalse((boolean)condition.isEmpty());
        this.checkAndGetRange(condition, MapRConstants.EMPTY_BYTE_ARRAY, MapRConstants.EMPTY_BYTE_ARRAY);
        this.serializeAndCompare(condition, "(_id MATCHES \"^.*\\\\Qdevice\\\\E$\")");
    }

    @Test
    public void testConditionWithIdRange() {
        ConditionImpl condition = MapRDBImpl.newCondition().and().is(DocumentConstants.ID_FIELD, QueryCondition.Op.GREATER_OR_EQUAL, "pqr").is(DocumentConstants.ID_FIELD, QueryCondition.Op.LESS, "uvw").close().build();
        condition = condition.cloneOptimized();
        Assert.assertTrue((boolean)condition.isEmpty());
        this.checkAndGetRange((QueryCondition)condition, this.encode("pqr"), this.encode("uvw"));
        this.serializeAndCompare((QueryCondition)condition);
    }

    @Test
    public void testConditionWithIdDisjointRange() {
        ConditionImpl condition = MapRDBImpl.newCondition().or().is(DocumentConstants.ID_FIELD, QueryCondition.Op.LESS, "pqr").is(DocumentConstants.ID_FIELD, QueryCondition.Op.GREATER, "uvw").close().build();
        condition = condition.cloneOptimized();
        Assert.assertFalse((boolean)condition.isEmpty());
        this.checkAndGetRange((QueryCondition)condition, MapRConstants.EMPTY_BYTE_ARRAY, MapRConstants.EMPTY_BYTE_ARRAY);
        this.serializeAndCompare((QueryCondition)condition, "((_id < \"pqr\") or (_id > \"uvw\"))");
    }

    @Test
    public void testConditionWithIdReveseRange() {
        ConditionImpl condition = MapRDBImpl.newCondition().and().is(DocumentConstants.ID_FIELD, QueryCondition.Op.LESS, "pqr").is(DocumentConstants.ID_FIELD, QueryCondition.Op.GREATER, "uvw").close().build();
        condition = condition.cloneOptimized();
        this.checkAndGetRange((QueryCondition)condition, this.encodeStringBinary("uvw\\x00"), this.encode("pqr"));
        this.serializeAndCompare((QueryCondition)condition);
    }

    @Test
    public void testMultiLevelAndConditionsOnId() {
        ConditionImpl condition = MapRDBImpl.newCondition().and().and().is(DocumentConstants.ID_FIELD, QueryCondition.Op.GREATER, "abc").is(DocumentConstants.ID_FIELD, QueryCondition.Op.LESS, "pqr").close().is(DocumentConstants.ID_FIELD, QueryCondition.Op.GREATER_OR_EQUAL, "rst").is(DocumentConstants.ID_FIELD, QueryCondition.Op.LESS_OR_EQUAL, "xyz").close().build();
        ConditionImpl sameCondition = MapRDBImpl.newCondition().and().is(DocumentConstants.ID_FIELD, QueryCondition.Op.GREATER_OR_EQUAL, "rst").is(DocumentConstants.ID_FIELD, QueryCondition.Op.LESS, "pqr").is(DocumentConstants.ID_FIELD, QueryCondition.Op.LESS_OR_EQUAL, "xyz").is(DocumentConstants.ID_FIELD, QueryCondition.Op.GREATER, "abc").close().build();
        this.serializeAndCompare((QueryCondition)condition, (QueryCondition)sameCondition);
        condition = condition.cloneOptimized();
        this.checkAndGetRange((QueryCondition)condition, this.encode("rst"), this.encode("pqr"));
        this.serializeAndCompare((QueryCondition)condition);
    }

    @Test
    public void testOrOfAndsConditionsOnId() {
        ConditionImpl condition = MapRDBImpl.newCondition().or().and().is(DocumentConstants.ID_FIELD, QueryCondition.Op.GREATER, "abc").is(DocumentConstants.ID_FIELD, QueryCondition.Op.LESS, "pqr").close().and().is(DocumentConstants.ID_FIELD, QueryCondition.Op.GREATER_OR_EQUAL, "efg").is(DocumentConstants.ID_FIELD, QueryCondition.Op.LESS_OR_EQUAL, "xyz").close().close().build();
        condition = condition.cloneOptimized();
        Assert.assertFalse((boolean)condition.isEmpty());
        this.checkAndGetRange((QueryCondition)condition, this.encodeStringBinary("abc\\x00"), this.encodeStringBinary("xyz\\x00"));
        this.serializeAndCompare((QueryCondition)condition, "(((_id > \"abc\") and (_id < \"pqr\")) or ((_id >= \"efg\") and (_id <= \"xyz\")))");
    }

    @Test
    public void testMultiLevelCondition() {
        QueryCondition condition = this.newComplexCondition1();
        Assert.assertEquals((Object)"((c.u.r != null) and (TYPE_OF(c.u.r) = ARRAY) and (c.u.r[0].d = 10.5) and ((a.b[4] = {\"$numberInt\":4}) or (b.e.t = \"35\")))", (Object)condition.toString());
        this.serializeAndCompare(condition, "((c.u.r != null) and (TYPE_OF(c.u.r) = ARRAY) and (c.u.r[0].d = 10.5) and ((a.b[4] = {\"$numberInt\":4}) or (b.e.t = \"35\")))");
    }

    @Test
    public void testAddConditionToAnotherCondition() {
        QueryCondition inner = this.newComplexCondition1();
        ConditionImpl outer0 = MapRDBImpl.newCondition().condition(inner).build();
        this.serializeAndCompare((QueryCondition)outer0, "((c.u.r != null) and (TYPE_OF(c.u.r) = ARRAY) and (c.u.r[0].d = 10.5) and ((a.b[4] = {\"$numberInt\":4}) or (b.e.t = \"35\")))");
        Assert.assertFalse((boolean)outer0.isEmpty());
        Assert.assertEquals((Object)inner, (Object)outer0);
        ConditionImpl outer1 = MapRDBImpl.newCondition().and().is(DocumentConstants.ID_FIELD, QueryCondition.Op.GREATER_OR_EQUAL, "pqr").is(DocumentConstants.ID_FIELD, QueryCondition.Op.LESS, "uvw").condition(inner).close().build();
        outer1 = outer1.cloneOptimized();
        this.serializeAndCompare((QueryCondition)outer1, "((c.u.r != null) and (TYPE_OF(c.u.r) = ARRAY) and (c.u.r[0].d = 10.5) and ((a.b[4] = {\"$numberInt\":4}) or (b.e.t = \"35\")))");
        Assert.assertFalse((boolean)outer1.isEmpty());
        Assert.assertEquals((Object)inner, (Object)outer1);
        ConditionImpl outer2 = MapRDBImpl.newCondition().and().is(DocumentConstants.ID_FIELD, QueryCondition.Op.GREATER_OR_EQUAL, "pqr").is("some.other.field", QueryCondition.Op.EQUAL, 25.69).condition(inner).close().build();
        outer2 = outer2.cloneOptimized();
        ConditionImpl sameCondition2 = MapRDBImpl.newCondition().and().is(DocumentConstants.ID_FIELD, QueryCondition.Op.GREATER_OR_EQUAL, "pqr").is("some.other.field", QueryCondition.Op.EQUAL, 25.69).exists("c.u.r").typeOf("c.u.r", Value.Type.ARRAY).is("c.u.r[0].d", QueryCondition.Op.EQUAL, 10.5).or().is("a.b[4]", QueryCondition.Op.EQUAL, 4).is("b.e.t", QueryCondition.Op.EQUAL, "35").close().close().build();
        sameCondition2 = sameCondition2.cloneOptimized();
        this.serializeAndCompare((QueryCondition)outer2, (QueryCondition)sameCondition2);
        Assert.assertFalse((boolean)outer2.isEmpty());
        Assert.assertNotEquals((Object)inner, (Object)outer2);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddConditionToAnotherConditionFail() {
        QueryCondition inner = this.newComplexCondition1();
        MapRDBImpl.newCondition().is("abc", QueryCondition.Op.EQUAL, "pqr").condition(inner).build();
    }

    @Test
    public void testComplexMixCondition() {
        ConditionImpl condition = MapRDBImpl.newCondition().and().is(DocumentConstants.ID_FIELD, QueryCondition.Op.GREATER, "device001").is("price", QueryCondition.Op.GREATER_OR_EQUAL, 75).is(DocumentConstants.ID_FIELD, QueryCondition.Op.LESS, "user999").or().is(DocumentConstants.ID_FIELD, QueryCondition.Op.GREATER, "parts550").is("price", QueryCondition.Op.LESS_OR_EQUAL, 100).close().close().build();
        condition = condition.cloneOptimized();
        this.checkAndGetRange((QueryCondition)condition, this.encodeStringBinary("device001\\x00"), this.encode("user999"));
        this.serializeAndCompare((QueryCondition)condition, "((price >= {\"$numberInt\":75}) and ((_id > \"parts550\") or (price <= {\"$numberInt\":100})))");
    }

    @Test
    public void testAsJsonString() {
        ConditionImpl condition = MapRDBImpl.newCondition().and().is("price", QueryCondition.Op.GREATER, 75).is("length", QueryCondition.Op.GREATER_OR_EQUAL, 5).is("width", QueryCondition.Op.LESS, 7).is("height", QueryCondition.Op.LESS_OR_EQUAL, 1).is("weight", QueryCondition.Op.EQUAL, 2).is("depth", QueryCondition.Op.NOT_EQUAL, 4).is("w", QueryCondition.Op.GREATER, 8).or().is(DocumentConstants.ID_FIELD, QueryCondition.Op.GREATER, "parts550").is("usage", QueryCondition.Op.EQUAL, 100).is(DocumentConstants.ID_FIELD, QueryCondition.Op.LESS, "parts550").is("quanitiy", QueryCondition.Op.LESS_OR_EQUAL, 100).close().close().build();
        String conditionAsJsonString = condition.asJsonString();
        ConditionParser condParser = new ConditionParser();
        QueryCondition parsedCondition = condParser.parseCondition(conditionAsJsonString);
        this.serializeAndCompare((QueryCondition)condition, parsedCondition);
    }

    private byte[] encode(String in) {
        return IdCodec.encodeAsBytes((String)in);
    }

    private byte[] encodeStringBinary(String in) {
        return IdCodec.encodeStringBinary((String)in);
    }

    private void serializeAndCompare(QueryCondition condition) {
        this.serializeAndCompare(condition, "<EMPTY>");
    }

    private void serializeAndCompare(QueryCondition condition, QueryCondition sameCondition) {
        _logger.info("Serializing condition\n{}", (Object)((ConditionImpl)condition).asPrefix());
        ByteBuffer serialized = ((ConditionImpl)condition).getDescriptor().getSerialized();
        QueryCondition newCondition = ConditionImpl.parseFrom((ByteBuffer)serialized);
        Assert.assertEquals((Object)sameCondition, (Object)newCondition);
    }

    private void serializeAndCompare(QueryCondition condition, String infix) {
        _logger.info("Serializing condition\n{}", (Object)((ConditionImpl)condition).asPrefix());
        ByteBuffer serialized = ((ConditionImpl)condition).getDescriptor().getSerialized();
        QueryCondition newCondition = ConditionImpl.parseFrom((ByteBuffer)serialized);
        Assert.assertEquals((Object)condition, (Object)newCondition);
        Assert.assertEquals((Object)infix, (Object)((ConditionImpl)condition).asInfix());
    }

    private ConditionNode.RowkeyRange checkAndGetRange(QueryCondition condition, byte[] start, byte[] stop) {
        List rowkeyRanges = ((ConditionImpl)condition).getRowkeyRanges();
        Assert.assertEquals((long)1L, (long)rowkeyRanges.size());
        ConditionNode.RowkeyRange rowkeyRange = (ConditionNode.RowkeyRange)rowkeyRanges.get(0);
        _logger.info("{}", (Object)rowkeyRange);
        Assert.assertArrayEquals((byte[])start, (byte[])rowkeyRange.getStartRow());
        Assert.assertArrayEquals((byte[])stop, (byte[])rowkeyRange.getStopRow());
        return rowkeyRange;
    }

    private QueryCondition newComplexCondition1() {
        return MapRDBImpl.newCondition().and().exists("c.u.r").typeOf("c.u.r", Value.Type.ARRAY).is("c.u.r[0].d", QueryCondition.Op.EQUAL, 10.5).or().is("a.b[4]", QueryCondition.Op.EQUAL, 4).is("b.e.t", QueryCondition.Op.EQUAL, "35").close().close().build();
    }

    private void checkRangeCalculationResults(ConditionNode.RowkeyRange[] expectedRanges, List<ConditionNode.RowkeyRange> calculatedRanges) {
        this.checkRangeCalculationResults(Arrays.asList(expectedRanges), calculatedRanges);
    }

    private void checkRangeCalculationResults(List<ConditionNode.RowkeyRange> expectedRanges, List<ConditionNode.RowkeyRange> calculatedRanges) {
        StringWriter sw = new StringWriter();
        PrintWriter out = new PrintWriter(sw);
        out.println("");
        out.println("The ranges:");
        Assert.assertEquals((long)expectedRanges.size(), (long)calculatedRanges.size());
        boolean match = true;
        for (int i = 0; i < calculatedRanges.size(); ++i) {
            ConditionNode.RowkeyRange exp;
            ConditionNode.RowkeyRange calc = calculatedRanges.get(i);
            if (!calc.equals((Object)(exp = expectedRanges.get(i)))) {
                out.println("Failure for rowkey range " + i);
            }
            out.println("c" + i + " start: '" + Arrays.toString(calc.getStartRow()) + "', stop: '" + Arrays.toString(calc.getStopRow()) + "'");
            out.println("e" + i + " start: '" + Arrays.toString(exp.getStartRow()) + "', stop: '" + Arrays.toString(exp.getStopRow()) + "'");
            match = match && calc.equals((Object)exp);
        }
        out.println("Done!");
        out.close();
        _logger.debug(sw.toString());
        Assert.assertTrue((boolean)match);
    }

    private List<ConditionNode.RowkeyRange> getRowKeyRange(IndexRowKeyEncoder encoder, int numHashPartitions, Dbfilters.CompareOpProto op, KeyValue value) {
        List rrl = encoder.getRowKeyRange(op, value, 0);
        return numHashPartitions > 0 ? IndexRowKeyEncoder.getHashedRowKeyRanges((List)rrl, (int)numHashPartitions) : rrl;
    }

    private List<ConditionNode.RowkeyRange> getRowKeyRange(IndexRowKeyEncoder encoder, Dbfilters.CompareOpProto op, KeyValue value) {
        return this.getRowKeyRange(encoder, 0, op, value);
    }

    private List<ConditionNode.RowkeyRange> getRowKeyRange(IndexRowKeyEncoder encoder, Dbfilters.CompareOpProto op, KeyValue value, int fieldIndex) {
        return encoder.getRowKeyRange(op, value, fieldIndex);
    }

    @Test
    public void testSecIdxRangeCalculation() {
        String fieldPath1 = "x.a";
        String fieldPath2 = "x.b";
        ImmutableList partitionKeys = ImmutableList.of((Object)new IndexFieldDescImpl(fieldPath1, 1, IndexFieldDesc.Order.Asc, false, false, null), (Object)new IndexFieldDescImpl(fieldPath2, 2, IndexFieldDesc.Order.Desc, false, false, null));
        boolean[] descendingOrder = new boolean[]{false, true};
        IndexRowKeyEncoder encoder = new IndexRowKeyEncoder();
        encoder.init(0, descendingOrder);
        List<ConditionNode.RowkeyRange> expectedRangeList = this.getRowKeyRange(encoder, Dbfilters.CompareOpProto.GREATER_OR_EQUAL, DBValueBuilderImpl.KeyValueBuilder.initFrom("rst"));
        Assert.assertEquals((long)1L, (long)expectedRangeList.size());
        ConditionNode.RowkeyRange[] expectedRanges = expectedRangeList.toArray(new ConditionNode.RowkeyRange[expectedRangeList.size()]);
        ConditionImpl condition = MapRDBImpl.newCondition().is(fieldPath1, QueryCondition.Op.GREATER_OR_EQUAL, "rst");
        condition.setPartitionKeys(encoder.getVersion(), (List)partitionKeys).build();
        List calculatedRanges = condition.getRowkeyRanges();
        this.checkRangeCalculationResults(expectedRanges, (List<ConditionNode.RowkeyRange>)calculatedRanges);
        expectedRangeList = this.getRowKeyRange(encoder, Dbfilters.CompareOpProto.LESS_OR_EQUAL, DBValueBuilderImpl.KeyValueBuilder.initFrom("rst"));
        Assert.assertEquals((long)1L, (long)expectedRangeList.size());
        expectedRanges = expectedRangeList.toArray(new ConditionNode.RowkeyRange[expectedRangeList.size()]);
        condition = MapRDBImpl.newCondition().is(fieldPath1, QueryCondition.Op.LESS_OR_EQUAL, "rst");
        condition.setPartitionKeys(encoder.getVersion(), (List)partitionKeys).build();
        calculatedRanges = condition.getRowkeyRanges();
        this.checkRangeCalculationResults(expectedRanges, (List<ConditionNode.RowkeyRange>)calculatedRanges);
        expectedRangeList = this.getRowKeyRange(encoder, Dbfilters.CompareOpProto.GREATER, DBValueBuilderImpl.KeyValueBuilder.initFrom("rst"));
        Assert.assertEquals((long)1L, (long)expectedRangeList.size());
        expectedRanges = expectedRangeList.toArray(new ConditionNode.RowkeyRange[expectedRangeList.size()]);
        condition = MapRDBImpl.newCondition().is(fieldPath1, QueryCondition.Op.GREATER, "rst");
        condition.setPartitionKeys(encoder.getVersion(), (List)partitionKeys).build();
        calculatedRanges = condition.getRowkeyRanges();
        this.checkRangeCalculationResults(expectedRanges, (List<ConditionNode.RowkeyRange>)calculatedRanges);
        expectedRangeList = this.getRowKeyRange(encoder, Dbfilters.CompareOpProto.LESS, DBValueBuilderImpl.KeyValueBuilder.initFrom("rst"));
        Assert.assertEquals((long)1L, (long)expectedRangeList.size());
        expectedRanges = expectedRangeList.toArray(new ConditionNode.RowkeyRange[expectedRangeList.size()]);
        condition = MapRDBImpl.newCondition().is(fieldPath1, QueryCondition.Op.LESS, "rst");
        condition.setPartitionKeys(encoder.getVersion(), (List)partitionKeys).build();
        calculatedRanges = condition.getRowkeyRanges();
        this.checkRangeCalculationResults(expectedRanges, (List<ConditionNode.RowkeyRange>)calculatedRanges);
        ArrayList<ConditionNode.RowkeyRange> rangeList = new ArrayList<ConditionNode.RowkeyRange>(this.getRowKeyRange(encoder, Dbfilters.CompareOpProto.GREATER, DBValueBuilderImpl.KeyValueBuilder.initFrom("abc")));
        Assert.assertEquals((long)1L, (long)rangeList.size());
        rangeList.addAll(this.getRowKeyRange(encoder, Dbfilters.CompareOpProto.LESS, DBValueBuilderImpl.KeyValueBuilder.initFrom("rst")));
        Assert.assertEquals((long)2L, (long)rangeList.size());
        ConditionNode.RowkeyRange[] ranges = rangeList.toArray(new ConditionNode.RowkeyRange[rangeList.size()]);
        expectedRanges = new ConditionNode.RowkeyRange[]{new ConditionNode.RowkeyRange(ranges[0].getStartRow(), ranges[1].getStopRow())};
        condition = MapRDBImpl.newCondition().and().is(fieldPath1, QueryCondition.Op.GREATER, "abc").is(fieldPath1, QueryCondition.Op.LESS, "rst").close();
        condition.setPartitionKeys(encoder.getVersion(), (List)partitionKeys).build();
        calculatedRanges = condition.getRowkeyRanges();
        this.checkRangeCalculationResults(expectedRanges, (List<ConditionNode.RowkeyRange>)calculatedRanges);
        rangeList = new ArrayList<ConditionNode.RowkeyRange>(this.getRowKeyRange(encoder, Dbfilters.CompareOpProto.GREATER, DBValueBuilderImpl.KeyValueBuilder.initFrom("abc")));
        Assert.assertEquals((long)1L, (long)rangeList.size());
        rangeList.addAll(this.getRowKeyRange(encoder, Dbfilters.CompareOpProto.LESS, DBValueBuilderImpl.KeyValueBuilder.initFrom("rst")));
        Assert.assertEquals((long)2L, (long)rangeList.size());
        ranges = rangeList.toArray(new ConditionNode.RowkeyRange[rangeList.size()]);
        expectedRanges = new ConditionNode.RowkeyRange[]{new ConditionNode.RowkeyRange(ranges[1].getStartRow(), ranges[0].getStopRow())};
        condition = MapRDBImpl.newCondition().or().is(fieldPath1, QueryCondition.Op.GREATER, "abc").is(fieldPath1, QueryCondition.Op.LESS, "rst").close();
        condition.setPartitionKeys(encoder.getVersion(), (List)partitionKeys).build();
        calculatedRanges = condition.getRowkeyRanges();
        this.checkRangeCalculationResults(expectedRanges, (List<ConditionNode.RowkeyRange>)calculatedRanges);
        expectedRanges = new ConditionNode.RowkeyRange[1];
        ConditionNode.EMPTY_TABLE_RANGE.toArray(expectedRanges);
        condition = MapRDBImpl.newCondition().and().is(fieldPath1, QueryCondition.Op.LESS, "abc").is(fieldPath1, QueryCondition.Op.GREATER, "rst").close();
        condition.setPartitionKeys(encoder.getVersion(), (List)partitionKeys).build();
        calculatedRanges = condition.getRowkeyRanges();
        this.checkRangeCalculationResults(expectedRanges, (List<ConditionNode.RowkeyRange>)calculatedRanges);
        expectedRangeList = new ArrayList<ConditionNode.RowkeyRange>(this.getRowKeyRange(encoder, Dbfilters.CompareOpProto.LESS, DBValueBuilderImpl.KeyValueBuilder.initFrom("abc")));
        Assert.assertEquals((long)1L, (long)expectedRangeList.size());
        expectedRangeList.addAll(this.getRowKeyRange(encoder, Dbfilters.CompareOpProto.GREATER, DBValueBuilderImpl.KeyValueBuilder.initFrom("rst")));
        Assert.assertEquals((long)2L, (long)expectedRangeList.size());
        expectedRanges = expectedRangeList.toArray(new ConditionNode.RowkeyRange[expectedRangeList.size()]);
        condition = MapRDBImpl.newCondition().or().is(fieldPath1, QueryCondition.Op.LESS, "abc").is(fieldPath1, QueryCondition.Op.GREATER, "rst").close();
        condition.setPartitionKeys(encoder.getVersion(), (List)partitionKeys).build();
        calculatedRanges = condition.getRowkeyRanges();
        this.checkRangeCalculationResults(expectedRanges, (List<ConditionNode.RowkeyRange>)calculatedRanges);
        rangeList = new ArrayList<ConditionNode.RowkeyRange>(this.getRowKeyRange(encoder, Dbfilters.CompareOpProto.GREATER, DBValueBuilderImpl.KeyValueBuilder.initFrom("pqr")));
        Assert.assertEquals((long)1L, (long)rangeList.size());
        rangeList.addAll(this.getRowKeyRange(encoder, Dbfilters.CompareOpProto.LESS, DBValueBuilderImpl.KeyValueBuilder.initFrom("rst")));
        Assert.assertEquals((long)2L, (long)rangeList.size());
        ranges = rangeList.toArray(new ConditionNode.RowkeyRange[rangeList.size()]);
        expectedRanges = new ConditionNode.RowkeyRange[]{new ConditionNode.RowkeyRange(ranges[0].getStartRow(), ranges[1].getStopRow())};
        condition = MapRDBImpl.newCondition().and().and().is(fieldPath1, QueryCondition.Op.GREATER, "abc").is(fieldPath1, QueryCondition.Op.LESS, "rst").close().is(fieldPath1, QueryCondition.Op.GREATER, "pqr").is(fieldPath1, QueryCondition.Op.LESS, "xyz").close();
        condition.setPartitionKeys(encoder.getVersion(), (List)partitionKeys).build();
        calculatedRanges = condition.getRowkeyRanges();
        this.checkRangeCalculationResults(expectedRanges, (List<ConditionNode.RowkeyRange>)calculatedRanges);
        expectedRanges = new ConditionNode.RowkeyRange[1];
        ConditionNode.EMPTY_TABLE_RANGE.toArray(expectedRanges);
        condition = MapRDBImpl.newCondition().and().and().is(fieldPath1, QueryCondition.Op.GREATER, "abc").is(fieldPath1, QueryCondition.Op.LESS, "rst").close().is(fieldPath1, QueryCondition.Op.GREATER_OR_EQUAL, "rst").is(fieldPath1, QueryCondition.Op.LESS, "xyz").close();
        condition.setPartitionKeys(encoder.getVersion(), (List)partitionKeys).build();
        calculatedRanges = condition.getRowkeyRanges();
        this.checkRangeCalculationResults(expectedRanges, (List<ConditionNode.RowkeyRange>)calculatedRanges);
        rangeList = new ArrayList<ConditionNode.RowkeyRange>(this.getRowKeyRange(encoder, Dbfilters.CompareOpProto.GREATER, DBValueBuilderImpl.KeyValueBuilder.initFrom("pqs")));
        Assert.assertEquals((long)1L, (long)rangeList.size());
        rangeList.addAll(this.getRowKeyRange(encoder, Dbfilters.CompareOpProto.LESS, DBValueBuilderImpl.KeyValueBuilder.initFrom("rss")));
        Assert.assertEquals((long)2L, (long)rangeList.size());
        ranges = rangeList.toArray(new ConditionNode.RowkeyRange[rangeList.size()]);
        expectedRanges = new ConditionNode.RowkeyRange[]{new ConditionNode.RowkeyRange(ranges[0].getStartRow(), ranges[1].getStopRow())};
        condition = MapRDBImpl.newCondition().and().and().and().is(fieldPath1, QueryCondition.Op.GREATER, "abc").is(fieldPath1, QueryCondition.Op.LESS, "rst").close().is(fieldPath1, QueryCondition.Op.GREATER, "pqr").is(fieldPath1, QueryCondition.Op.LESS, "xyz").close().and().and().is(fieldPath1, QueryCondition.Op.GREATER, "bcd").is(fieldPath1, QueryCondition.Op.LESS, "rss").close().is(fieldPath1, QueryCondition.Op.GREATER, "pqs").is(fieldPath1, QueryCondition.Op.LESS, "xyz").close().close();
        condition.setPartitionKeys(encoder.getVersion(), (List)partitionKeys).build();
        calculatedRanges = condition.getRowkeyRanges();
        this.checkRangeCalculationResults(expectedRanges, (List<ConditionNode.RowkeyRange>)calculatedRanges);
        rangeList = new ArrayList<ConditionNode.RowkeyRange>(this.getRowKeyRange(encoder, Dbfilters.CompareOpProto.GREATER, DBValueBuilderImpl.KeyValueBuilder.initFrom("pqr")));
        rangeList.addAll(this.getRowKeyRange(encoder, Dbfilters.CompareOpProto.LESS, DBValueBuilderImpl.KeyValueBuilder.initFrom("rst")));
        ranges = rangeList.toArray(new ConditionNode.RowkeyRange[rangeList.size()]);
        expectedRanges = new ConditionNode.RowkeyRange[]{new ConditionNode.RowkeyRange(ranges[0].getStartRow(), ranges[1].getStopRow())};
        condition = MapRDBImpl.newCondition().or().and().and().is(fieldPath1, QueryCondition.Op.GREATER, "abc").is(fieldPath1, QueryCondition.Op.LESS, "rst").close().is(fieldPath1, QueryCondition.Op.GREATER, "pqr").is(fieldPath1, QueryCondition.Op.LESS, "xyz").close().and().and().is(fieldPath1, QueryCondition.Op.GREATER, "bcd").is(fieldPath1, QueryCondition.Op.LESS, "rss").close().is(fieldPath1, QueryCondition.Op.GREATER, "pqs").is(fieldPath1, QueryCondition.Op.LESS, "xyz").close().close();
        condition.setPartitionKeys(encoder.getVersion(), (List)partitionKeys).build();
        calculatedRanges = condition.getRowkeyRanges();
        this.checkRangeCalculationResults(expectedRanges, (List<ConditionNode.RowkeyRange>)calculatedRanges);
    }

    @Test
    public void testSecIdxRangeCalculation2() {
        String[] fieldPath = new String[]{"x.a", "x.b"};
        boolean[] descendingOrder = new boolean[]{true, true};
        IndexFieldDesc.Order[] order = new IndexFieldDesc.Order[]{descendingOrder[0] ? IndexFieldDesc.Order.Desc : IndexFieldDesc.Order.Asc, descendingOrder[1] ? IndexFieldDesc.Order.Desc : IndexFieldDesc.Order.Asc};
        ImmutableList partitionKeys = ImmutableList.of((Object)new IndexFieldDescImpl(fieldPath[0], 1, order[0], false, false, null), (Object)new IndexFieldDescImpl(fieldPath[1], 2, order[1], false, false, null));
        IndexRowKeyEncoder encoder = new IndexRowKeyEncoder();
        encoder.init(0, descendingOrder);
        List<ConditionNode.RowkeyRange> expectedRanges = this.getRowKeyRange(encoder, Dbfilters.CompareOpProto.EQUAL, DBValueBuilderImpl.KeyValueBuilder.initFrom("5"));
        Assert.assertEquals((long)1L, (long)expectedRanges.size());
        ConditionImpl condition = MapRDBImpl.newCondition().is(fieldPath[0], QueryCondition.Op.EQUAL, "5");
        condition.setPartitionKeys(encoder.getVersion(), (List)partitionKeys).build();
        List calculatedRanges = condition.getRowkeyRanges();
        this.checkRangeCalculationResults(expectedRanges, (List<ConditionNode.RowkeyRange>)calculatedRanges);
    }

    @Test
    public void testSecIdxRangeCalculation3() {
        String[] fieldPath = new String[]{"x.a", "x.b"};
        boolean[] descendingOrder = new boolean[]{true, false};
        IndexFieldDesc.Order[] order = new IndexFieldDesc.Order[]{descendingOrder[0] ? IndexFieldDesc.Order.Desc : IndexFieldDesc.Order.Asc, descendingOrder[1] ? IndexFieldDesc.Order.Desc : IndexFieldDesc.Order.Asc};
        ImmutableList partitionKeys = ImmutableList.of((Object)new IndexFieldDescImpl(fieldPath[0], 1, order[0], false, false, null), (Object)new IndexFieldDescImpl(fieldPath[1], 2, order[1], false, false, null));
        IndexRowKeyEncoder encoder = new IndexRowKeyEncoder();
        encoder.init(0, descendingOrder);
        ArrayList<ConditionNode.RowkeyRange> expectedRanges = new ArrayList<ConditionNode.RowkeyRange>(encoder.getRowKeyRange(Dbfilters.CompareOpProto.GREATER, DBValueBuilderImpl.KeyValueBuilder.initFrom("abc"), 0));
        Assert.assertEquals((long)1L, (long)expectedRanges.size());
        ConditionImpl condition = MapRDBImpl.newCondition().and().is(fieldPath[0], QueryCondition.Op.GREATER, "abc").is(fieldPath[1], QueryCondition.Op.LESS, "rst").close();
        condition.setPartitionKeys(encoder.getVersion(), (List)partitionKeys).build();
        List calculatedRanges = condition.getRowkeyRanges();
        this.checkRangeCalculationResults(expectedRanges, (List<ConditionNode.RowkeyRange>)calculatedRanges);
    }

    @Test
    public void testSecIdxRangeCalculation4() {
        String[] fieldPath = new String[]{"x.a", "x.b"};
        boolean[] descendingOrder = new boolean[]{false, true};
        IndexFieldDesc.Order[] order = new IndexFieldDesc.Order[]{descendingOrder[0] ? IndexFieldDesc.Order.Desc : IndexFieldDesc.Order.Asc, descendingOrder[1] ? IndexFieldDesc.Order.Desc : IndexFieldDesc.Order.Asc};
        ImmutableList partitionKeys = ImmutableList.of((Object)new IndexFieldDescImpl(fieldPath[0], 2, order[0], false, false, null), (Object)new IndexFieldDescImpl(fieldPath[1], 2, order[1], false, false, null));
        IndexRowKeyEncoder encoder = new IndexRowKeyEncoder();
        encoder.init(0, descendingOrder);
        ArrayList rangeList = new ArrayList(encoder.getRowKeyRange(Dbfilters.CompareOpProto.EQUAL, DBValueBuilderImpl.KeyValueBuilder.initFrom("abc"), 0));
        Assert.assertEquals((long)1L, (long)rangeList.size());
        rangeList.addAll(encoder.getRowKeyRange(Dbfilters.CompareOpProto.EQUAL, DBValueBuilderImpl.KeyValueBuilder.initFrom("rst"), 1));
        Assert.assertEquals((long)2L, (long)rangeList.size());
        ConditionNode.RowkeyRange[] expectedRanges = new ConditionNode.RowkeyRange[]{new ConditionNode.RowkeyRange(Bytes.concatenate((byte[])((ConditionNode.RowkeyRange)rangeList.get(0)).getStartRow(), (byte[])((ConditionNode.RowkeyRange)rangeList.get(1)).getStartRow()), Bytes.concatenate((byte[])((ConditionNode.RowkeyRange)rangeList.get(0)).getStartRow(), (byte[])((ConditionNode.RowkeyRange)rangeList.get(1)).getStopRow()))};
        ConditionImpl condition = MapRDBImpl.newCondition().and().is(fieldPath[0], QueryCondition.Op.EQUAL, "abc").is(fieldPath[1], QueryCondition.Op.EQUAL, "rst").close();
        condition.setPartitionKeys(encoder.getVersion(), (List)partitionKeys).build();
        List calculatedRanges = condition.getRowkeyRanges();
        this.checkRangeCalculationResults(expectedRanges, (List<ConditionNode.RowkeyRange>)calculatedRanges);
    }

    @Test
    public void testSecIdxRangeCalculation5() {
        String[] fieldPath = new String[]{"x.a", "x.b"};
        boolean[] descendingOrder = new boolean[]{true, true};
        IndexFieldDesc.Order[] order = new IndexFieldDesc.Order[]{descendingOrder[0] ? IndexFieldDesc.Order.Desc : IndexFieldDesc.Order.Asc, descendingOrder[1] ? IndexFieldDesc.Order.Desc : IndexFieldDesc.Order.Asc};
        ImmutableList partitionKeys = ImmutableList.of((Object)new IndexFieldDescImpl(fieldPath[0], 2, order[0], false, false, null), (Object)new IndexFieldDescImpl(fieldPath[1], 2, order[1], false, false, null));
        IndexRowKeyEncoder encoder = new IndexRowKeyEncoder();
        encoder.init(0, descendingOrder);
        ArrayList<ConditionNode.RowkeyRange> expectedRanges = new ArrayList<ConditionNode.RowkeyRange>(encoder.getRowKeyRange(Dbfilters.CompareOpProto.EQUAL, DBValueBuilderImpl.KeyValueBuilder.initFrom("xyz"), 0));
        Assert.assertEquals((long)1L, (long)expectedRanges.size());
        expectedRanges.addAll(encoder.getRowKeyRange(Dbfilters.CompareOpProto.EQUAL, DBValueBuilderImpl.KeyValueBuilder.initFrom("abc"), 0));
        Assert.assertEquals((long)2L, (long)expectedRanges.size());
        ConditionImpl condition = MapRDBImpl.newCondition().or().is(fieldPath[0], QueryCondition.Op.EQUAL, "xyz").and().is(fieldPath[0], QueryCondition.Op.EQUAL, "abc").is(fieldPath[1], QueryCondition.Op.EQUAL, "rst").close().close();
        condition.setPartitionKeys(encoder.getVersion(), (List)partitionKeys).build();
        List calculatedRanges = condition.getRowkeyRanges();
        this.checkRangeCalculationResults(expectedRanges, (List<ConditionNode.RowkeyRange>)calculatedRanges);
    }

    @Test
    public void testSecIdxRangeCalculation6() {
        String[] fieldPath = new String[]{"x.a", "x.b"};
        boolean[] descendingOrder = new boolean[]{true, true};
        IndexFieldDesc.Order[] order = new IndexFieldDesc.Order[]{descendingOrder[0] ? IndexFieldDesc.Order.Desc : IndexFieldDesc.Order.Asc, descendingOrder[1] ? IndexFieldDesc.Order.Desc : IndexFieldDesc.Order.Asc};
        ImmutableList partitionKeys = ImmutableList.of((Object)new IndexFieldDescImpl(fieldPath[0], 1, order[0], false, false, null), (Object)new IndexFieldDescImpl(fieldPath[1], 2, order[1], false, false, null));
        IndexRowKeyEncoder encoder = new IndexRowKeyEncoder();
        encoder.init(0, descendingOrder);
        ArrayList rangeList = new ArrayList(encoder.getRowKeyRange(Dbfilters.CompareOpProto.EQUAL, DBValueBuilderImpl.KeyValueBuilder.initFrom("xyz"), 0));
        Assert.assertEquals((long)1L, (long)rangeList.size());
        rangeList.addAll(encoder.getRowKeyRange(Dbfilters.CompareOpProto.EQUAL, DBValueBuilderImpl.KeyValueBuilder.initFrom("abc"), 0));
        Assert.assertEquals((long)2L, (long)rangeList.size());
        rangeList.addAll(encoder.getRowKeyRange(Dbfilters.CompareOpProto.LESS, DBValueBuilderImpl.KeyValueBuilder.initFrom("rs"), 1));
        Assert.assertEquals((long)3L, (long)rangeList.size());
        ConditionNode.RowkeyRange[] expectedRanges = new ConditionNode.RowkeyRange[]{new ConditionNode.RowkeyRange(Bytes.concatenate((byte[])((ConditionNode.RowkeyRange)rangeList.get(0)).getStartRow(), (byte[])((ConditionNode.RowkeyRange)rangeList.get(2)).getStartRow()), Bytes.concatenate((byte[])((ConditionNode.RowkeyRange)rangeList.get(0)).getStartRow(), (byte[])((ConditionNode.RowkeyRange)rangeList.get(2)).getStopRow())), new ConditionNode.RowkeyRange(Bytes.concatenate((byte[])((ConditionNode.RowkeyRange)rangeList.get(1)).getStartRow(), (byte[])((ConditionNode.RowkeyRange)rangeList.get(2)).getStartRow()), Bytes.concatenate((byte[])((ConditionNode.RowkeyRange)rangeList.get(1)).getStartRow(), (byte[])((ConditionNode.RowkeyRange)rangeList.get(2)).getStopRow()))};
        ConditionImpl condition = MapRDBImpl.newCondition().and().or().is(fieldPath[0], QueryCondition.Op.EQUAL, "xyz").and().is(fieldPath[0], QueryCondition.Op.EQUAL, "abc").is(fieldPath[1], QueryCondition.Op.GREATER, "jh").close().close().is(fieldPath[1], QueryCondition.Op.LESS, "rs").close();
        condition.setPartitionKeys(encoder.getVersion(), (List)partitionKeys).build();
        List calculatedRanges = condition.getRowkeyRanges();
        this.checkRangeCalculationResults(expectedRanges, (List<ConditionNode.RowkeyRange>)calculatedRanges);
    }

    @Test
    public void testSecIdxRangeCalculation7() {
        String[] fieldPath = new String[]{"x.a", "x.b", "x.c"};
        boolean[] descendingOrder = new boolean[]{true, true, true};
        IndexFieldDesc.Order[] order = new IndexFieldDesc.Order[]{descendingOrder[0] ? IndexFieldDesc.Order.Desc : IndexFieldDesc.Order.Asc, descendingOrder[1] ? IndexFieldDesc.Order.Desc : IndexFieldDesc.Order.Asc, descendingOrder[2] ? IndexFieldDesc.Order.Desc : IndexFieldDesc.Order.Asc};
        ImmutableList partitionKeys = ImmutableList.of((Object)new IndexFieldDescImpl(fieldPath[0], 2, order[0], false, false, null), (Object)new IndexFieldDescImpl(fieldPath[1], 2, order[1], false, false, null), (Object)new IndexFieldDescImpl(fieldPath[2], 2, order[2], false, false, null));
        IndexRowKeyEncoder encoder = new IndexRowKeyEncoder();
        encoder.init(0, descendingOrder);
        ArrayList<ConditionNode.RowkeyRange> expectedRanges = new ArrayList<ConditionNode.RowkeyRange>(encoder.getRowKeyRange(Dbfilters.CompareOpProto.EQUAL, DBValueBuilderImpl.KeyValueBuilder.initFrom("xyz"), 0));
        Assert.assertEquals((long)1L, (long)expectedRanges.size());
        expectedRanges.addAll(encoder.getRowKeyRange(Dbfilters.CompareOpProto.EQUAL, DBValueBuilderImpl.KeyValueBuilder.initFrom("abc"), 0));
        Assert.assertEquals((long)2L, (long)expectedRanges.size());
        ConditionImpl condition = MapRDBImpl.newCondition().and().or().is(fieldPath[0], QueryCondition.Op.EQUAL, "xyz").and().is(fieldPath[0], QueryCondition.Op.EQUAL, "abc").is(fieldPath[1], QueryCondition.Op.GREATER, "jh").close().close().is(fieldPath[2], QueryCondition.Op.LESS, "rs").close();
        condition.setPartitionKeys(encoder.getVersion(), (List)partitionKeys).build();
        List calculatedRanges = condition.getRowkeyRanges();
        this.checkRangeCalculationResults(expectedRanges, (List<ConditionNode.RowkeyRange>)calculatedRanges);
    }

    @Test
    public void testSecIdxRangeCalculation8() {
        String[] fieldPath = new String[]{"x.a", "x.b", "x.c"};
        boolean[] descendingOrder = new boolean[]{true, false, true};
        IndexFieldDesc.Order[] order = new IndexFieldDesc.Order[]{descendingOrder[0] ? IndexFieldDesc.Order.Desc : IndexFieldDesc.Order.Asc, descendingOrder[1] ? IndexFieldDesc.Order.Desc : IndexFieldDesc.Order.Asc, descendingOrder[2] ? IndexFieldDesc.Order.Desc : IndexFieldDesc.Order.Asc};
        ImmutableList partitionKeys = ImmutableList.of((Object)new IndexFieldDescImpl(fieldPath[0], 2, order[0], false, false, null), (Object)new IndexFieldDescImpl(fieldPath[1], 2, order[1], false, false, null), (Object)new IndexFieldDescImpl(fieldPath[2], 0, order[2], false, false, null));
        IndexRowKeyEncoder encoder = new IndexRowKeyEncoder();
        encoder.init(0, descendingOrder);
        ArrayList rangeList = new ArrayList(encoder.getRowKeyRange(Dbfilters.CompareOpProto.EQUAL, DBValueBuilderImpl.KeyValueBuilder.initFrom("abc"), 0));
        Assert.assertEquals((long)1L, (long)rangeList.size());
        rangeList.addAll(encoder.getRowKeyRange(Dbfilters.CompareOpProto.EQUAL, DBValueBuilderImpl.KeyValueBuilder.initFrom("rst"), 1));
        Assert.assertEquals((long)2L, (long)rangeList.size());
        rangeList.addAll(encoder.getRowKeyRange(Dbfilters.CompareOpProto.EQUAL, DBValueBuilderImpl.KeyValueBuilder.initFrom("klm"), 2));
        Assert.assertEquals((long)3L, (long)rangeList.size());
        ConditionNode.RowkeyRange[] expectedRanges = new ConditionNode.RowkeyRange[]{new ConditionNode.RowkeyRange(Bytes.concatenate((byte[])Bytes.concatenate((byte[])((ConditionNode.RowkeyRange)rangeList.get(0)).getStartRow(), (byte[])((ConditionNode.RowkeyRange)rangeList.get(1)).getStartRow()), (byte[])((ConditionNode.RowkeyRange)rangeList.get(2)).getStartRow()), Bytes.concatenate((byte[])Bytes.concatenate((byte[])((ConditionNode.RowkeyRange)rangeList.get(0)).getStartRow(), (byte[])((ConditionNode.RowkeyRange)rangeList.get(1)).getStartRow()), (byte[])((ConditionNode.RowkeyRange)rangeList.get(2)).getStopRow()))};
        ConditionImpl condition = MapRDBImpl.newCondition().and().is(fieldPath[0], QueryCondition.Op.EQUAL, "abc").is(fieldPath[1], QueryCondition.Op.EQUAL, "rst").is(fieldPath[2], QueryCondition.Op.EQUAL, "klm").close();
        condition.setPartitionKeys(encoder.getVersion(), (List)partitionKeys).build();
        List calculatedRanges = condition.getRowkeyRanges();
        this.checkRangeCalculationResults(expectedRanges, (List<ConditionNode.RowkeyRange>)calculatedRanges);
    }

    @Test
    public void testSecIdxRangeCalculation9() {
        String[] fieldPath = new String[]{"x.a", "x.b", "x.c"};
        boolean[] descendingOrder = new boolean[]{false, true, false};
        IndexFieldDesc.Order[] order = new IndexFieldDesc.Order[]{descendingOrder[0] ? IndexFieldDesc.Order.Desc : IndexFieldDesc.Order.Asc, descendingOrder[1] ? IndexFieldDesc.Order.Desc : IndexFieldDesc.Order.Asc, descendingOrder[2] ? IndexFieldDesc.Order.Desc : IndexFieldDesc.Order.Asc};
        ImmutableList partitionKeys = ImmutableList.of((Object)new IndexFieldDescImpl(fieldPath[0], 0, order[0], false, false, null), (Object)new IndexFieldDescImpl(fieldPath[1], 0, order[1], false, false, null), (Object)new IndexFieldDescImpl(fieldPath[2], 0, order[2], false, false, null));
        IndexRowKeyEncoder encoder = new IndexRowKeyEncoder();
        encoder.init(0, descendingOrder);
        ArrayList<ConditionNode.RowkeyRange> expectedRanges = new ArrayList<ConditionNode.RowkeyRange>(encoder.getRowKeyRange(Dbfilters.CompareOpProto.GREATER, DBValueBuilderImpl.KeyValueBuilder.initFrom("abc"), 0));
        Assert.assertEquals((long)1L, (long)expectedRanges.size());
        ConditionImpl condition = MapRDBImpl.newCondition().and().is(fieldPath[0], QueryCondition.Op.GREATER, "abc").is(fieldPath[1], QueryCondition.Op.LESS_OR_EQUAL, "rst").is(fieldPath[2], QueryCondition.Op.LESS, "klm").close();
        condition.setPartitionKeys(encoder.getVersion(), (List)partitionKeys).build();
        List calculatedRanges = condition.getRowkeyRanges();
        this.checkRangeCalculationResults(expectedRanges, (List<ConditionNode.RowkeyRange>)calculatedRanges);
    }

    @Test
    public void testSecIdxRangeCalculation10() {
        String[] fieldPath = new String[]{"x.a", "x.b", "x.c"};
        boolean[] descendingOrder = new boolean[]{false, true, false};
        IndexFieldDesc.Order[] order = new IndexFieldDesc.Order[]{descendingOrder[0] ? IndexFieldDesc.Order.Desc : IndexFieldDesc.Order.Asc, descendingOrder[1] ? IndexFieldDesc.Order.Desc : IndexFieldDesc.Order.Asc, descendingOrder[2] ? IndexFieldDesc.Order.Desc : IndexFieldDesc.Order.Asc};
        ImmutableList partitionKeys = ImmutableList.of((Object)new IndexFieldDescImpl(fieldPath[0], 0, order[0], false, false, null), (Object)new IndexFieldDescImpl(fieldPath[1], 0, order[1], false, false, null), (Object)new IndexFieldDescImpl(fieldPath[2], 0, order[2], false, false, null));
        IndexRowKeyEncoder encoder = new IndexRowKeyEncoder();
        encoder.init(0, descendingOrder);
        ArrayList<ConditionNode.RowkeyRange> expectedRanges = new ArrayList<ConditionNode.RowkeyRange>(encoder.getRowKeyRange(Dbfilters.CompareOpProto.LESS_OR_EQUAL, DBValueBuilderImpl.KeyValueBuilder.initFrom("abc"), 0));
        Assert.assertEquals((long)1L, (long)expectedRanges.size());
        QueryCondition condition = MapRDBImpl.newCondition().and().is(fieldPath[0], QueryCondition.Op.LESS_OR_EQUAL, "abc").like(fieldPath[0], "%text%").close();
        ((ConditionImpl)condition).setPartitionKeys(encoder.getVersion(), (List)partitionKeys).build();
        List calculatedRanges = ((ConditionImpl)condition).getRowkeyRanges();
        this.checkRangeCalculationResults(expectedRanges, (List<ConditionNode.RowkeyRange>)calculatedRanges);
    }

    @Test
    public void testSecIdxRangeCalculation11() {
        String[] fieldPath = new String[]{"x.a", "x.b", "x.c"};
        boolean[] descendingOrder = new boolean[]{false, true, false};
        IndexFieldDesc.Order[] order = new IndexFieldDesc.Order[]{descendingOrder[0] ? IndexFieldDesc.Order.Desc : IndexFieldDesc.Order.Asc, descendingOrder[1] ? IndexFieldDesc.Order.Desc : IndexFieldDesc.Order.Asc, descendingOrder[2] ? IndexFieldDesc.Order.Desc : IndexFieldDesc.Order.Asc};
        ImmutableList partitionKeys = ImmutableList.of((Object)new IndexFieldDescImpl(fieldPath[0], 0, order[0], false, false, null), (Object)new IndexFieldDescImpl(fieldPath[1], 0, order[1], false, false, null), (Object)new IndexFieldDescImpl(fieldPath[2], 0, order[2], false, false, null));
        IndexRowKeyEncoder encoder = new IndexRowKeyEncoder();
        encoder.init(0, descendingOrder);
        ArrayList rangeList = new ArrayList(encoder.getRowKeyRange(Dbfilters.CompareOpProto.EQUAL, DBValueBuilderImpl.KeyValueBuilder.initFrom("abc"), 0));
        Assert.assertEquals((long)1L, (long)rangeList.size());
        rangeList.addAll(encoder.getRowKeyRange(Dbfilters.CompareOpProto.EQUAL, DBValueBuilderImpl.KeyValueBuilder.initFrom("rst"), 1));
        Assert.assertEquals((long)2L, (long)rangeList.size());
        rangeList.addAll(encoder.getRowKeyRange(Dbfilters.CompareOpProto.EQUAL, DBValueBuilderImpl.KeyValueBuilder.initFrom("klm"), 2));
        Assert.assertEquals((long)3L, (long)rangeList.size());
        ConditionNode.RowkeyRange[] expectedRanges = new ConditionNode.RowkeyRange[]{new ConditionNode.RowkeyRange(Bytes.concatenate((byte[])Bytes.concatenate((byte[])((ConditionNode.RowkeyRange)rangeList.get(0)).getStartRow(), (byte[])((ConditionNode.RowkeyRange)rangeList.get(1)).getStartRow()), (byte[])((ConditionNode.RowkeyRange)rangeList.get(2)).getStartRow()), Bytes.concatenate((byte[])Bytes.concatenate((byte[])((ConditionNode.RowkeyRange)rangeList.get(0)).getStartRow(), (byte[])((ConditionNode.RowkeyRange)rangeList.get(1)).getStartRow()), (byte[])((ConditionNode.RowkeyRange)rangeList.get(2)).getStopRow()))};
        ConditionImpl condition = MapRDBImpl.newCondition().and().is(fieldPath[0], QueryCondition.Op.LESS_OR_EQUAL, "abc").is(fieldPath[0], QueryCondition.Op.GREATER_OR_EQUAL, "abc").is(fieldPath[1], QueryCondition.Op.LESS_OR_EQUAL, "rst").is(fieldPath[1], QueryCondition.Op.GREATER_OR_EQUAL, "rst").is(fieldPath[2], QueryCondition.Op.EQUAL, "klm").close();
        condition.setPartitionKeys(encoder.getVersion(), (List)partitionKeys).build();
        List calculatedRanges = condition.getRowkeyRanges();
        this.checkRangeCalculationResults(expectedRanges, (List<ConditionNode.RowkeyRange>)calculatedRanges);
    }

    @Test
    public void testSecIdxRangeCalculation12() {
        String[] fieldPath = new String[]{"x.a", "x.b", "x.c"};
        boolean[] descendingOrder = new boolean[]{false, true, false};
        IndexFieldDesc.Order[] order = new IndexFieldDesc.Order[]{descendingOrder[0] ? IndexFieldDesc.Order.Desc : IndexFieldDesc.Order.Asc, descendingOrder[1] ? IndexFieldDesc.Order.Desc : IndexFieldDesc.Order.Asc, descendingOrder[2] ? IndexFieldDesc.Order.Desc : IndexFieldDesc.Order.Asc};
        ImmutableList partitionKeys = ImmutableList.of((Object)new IndexFieldDescImpl(fieldPath[0], 0, order[0], false, false, null), (Object)new IndexFieldDescImpl(fieldPath[1], 0, order[1], false, false, null), (Object)new IndexFieldDescImpl(fieldPath[2], 0, order[2], false, false, null));
        IndexRowKeyEncoder encoder = new IndexRowKeyEncoder();
        encoder.init(0, descendingOrder);
        ArrayList rangeList = new ArrayList(encoder.getRowKeyRange(Dbfilters.CompareOpProto.EQUAL, DBValueBuilderImpl.KeyValueBuilder.initFrom("abc"), 0));
        Assert.assertEquals((long)1L, (long)rangeList.size());
        rangeList.addAll(encoder.getRowKeyRange(Dbfilters.CompareOpProto.GREATER, DBValueBuilderImpl.KeyValueBuilder.initFrom("rst"), 1));
        Assert.assertEquals((long)2L, (long)rangeList.size());
        ConditionNode.RowkeyRange[] expectedRanges = new ConditionNode.RowkeyRange[]{new ConditionNode.RowkeyRange(Bytes.concatenate((byte[])((ConditionNode.RowkeyRange)rangeList.get(0)).getStartRow(), (byte[])((ConditionNode.RowkeyRange)rangeList.get(1)).getStartRow()), Bytes.concatenate((byte[])((ConditionNode.RowkeyRange)rangeList.get(0)).getStartRow(), (byte[])((ConditionNode.RowkeyRange)rangeList.get(1)).getStopRow()))};
        ConditionImpl condition = MapRDBImpl.newCondition().and().is(fieldPath[0], QueryCondition.Op.LESS_OR_EQUAL, "abc").is(fieldPath[0], QueryCondition.Op.GREATER_OR_EQUAL, "abc").is(fieldPath[1], QueryCondition.Op.GREATER, "rst").is(fieldPath[2], QueryCondition.Op.GREATER, "klm").close();
        condition.setPartitionKeys(encoder.getVersion(), (List)partitionKeys).build();
        List calculatedRanges = condition.getRowkeyRanges();
        this.checkRangeCalculationResults(expectedRanges, (List<ConditionNode.RowkeyRange>)calculatedRanges);
    }

    @Test
    public void testSecIdxRangeCalculation13() {
        String[] fieldPath = new String[]{"x.a", "x.b", "x.c"};
        boolean[] descendingOrder = new boolean[]{false, true, false};
        IndexFieldDesc.Order[] order = new IndexFieldDesc.Order[]{descendingOrder[0] ? IndexFieldDesc.Order.Desc : IndexFieldDesc.Order.Asc, descendingOrder[1] ? IndexFieldDesc.Order.Desc : IndexFieldDesc.Order.Asc, descendingOrder[2] ? IndexFieldDesc.Order.Desc : IndexFieldDesc.Order.Asc};
        ImmutableList partitionKeys = ImmutableList.of((Object)new IndexFieldDescImpl(fieldPath[0], 0, order[0], false, false, null), (Object)new IndexFieldDescImpl(fieldPath[1], 0, order[1], false, false, null), (Object)new IndexFieldDescImpl(fieldPath[2], 0, order[2], false, false, null));
        IndexRowKeyEncoder encoder = new IndexRowKeyEncoder();
        encoder.init(0, descendingOrder);
        ArrayList rangeList = new ArrayList(encoder.getRowKeyRange(Dbfilters.CompareOpProto.EQUAL, DBValueBuilderImpl.KeyValueBuilder.initFrom("abc"), 0));
        Assert.assertEquals((long)1L, (long)rangeList.size());
        rangeList.addAll(encoder.getRowKeyRange(Dbfilters.CompareOpProto.EQUAL, DBValueBuilderImpl.KeyValueBuilder.initFrom("rst"), 1));
        Assert.assertEquals((long)2L, (long)rangeList.size());
        rangeList.addAll(encoder.getRowKeyRange(Dbfilters.CompareOpProto.EQUAL, DBValueBuilderImpl.KeyValueBuilder.initFrom("klm"), 2));
        Assert.assertEquals((long)3L, (long)rangeList.size());
        rangeList.addAll(encoder.getRowKeyRange(Dbfilters.CompareOpProto.GREATER, DBValueBuilderImpl.KeyValueBuilder.initFrom("xyz"), 0));
        Assert.assertEquals((long)4L, (long)rangeList.size());
        ConditionNode.RowkeyRange[] expectedRanges = new ConditionNode.RowkeyRange[]{new ConditionNode.RowkeyRange(Bytes.concatenate((byte[])Bytes.concatenate((byte[])((ConditionNode.RowkeyRange)rangeList.get(0)).getStartRow(), (byte[])((ConditionNode.RowkeyRange)rangeList.get(1)).getStartRow()), (byte[])((ConditionNode.RowkeyRange)rangeList.get(2)).getStartRow()), Bytes.concatenate((byte[])Bytes.concatenate((byte[])((ConditionNode.RowkeyRange)rangeList.get(0)).getStartRow(), (byte[])((ConditionNode.RowkeyRange)rangeList.get(1)).getStartRow()), (byte[])((ConditionNode.RowkeyRange)rangeList.get(2)).getStopRow())), new ConditionNode.RowkeyRange(((ConditionNode.RowkeyRange)rangeList.get(3)).getStartRow(), ((ConditionNode.RowkeyRange)rangeList.get(3)).getStopRow())};
        ConditionImpl condition = MapRDBImpl.newCondition().and().or().and().is(fieldPath[0], QueryCondition.Op.LESS_OR_EQUAL, "abc").is(fieldPath[0], QueryCondition.Op.GREATER_OR_EQUAL, "abc").close().is(fieldPath[0], QueryCondition.Op.GREATER, "xyz").close().is(fieldPath[1], QueryCondition.Op.LESS_OR_EQUAL, "rst").is(fieldPath[1], QueryCondition.Op.GREATER_OR_EQUAL, "rst").is(fieldPath[2], QueryCondition.Op.EQUAL, "klm").close();
        condition.setPartitionKeys(encoder.getVersion(), (List)partitionKeys).build();
        List calculatedRanges = condition.getRowkeyRanges();
        this.checkRangeCalculationResults(expectedRanges, (List<ConditionNode.RowkeyRange>)calculatedRanges);
    }

    @Test
    public void testSecIdxRangeCalculation14() {
        String[] fieldPath = new String[]{"x.a", "x.b", "x.c"};
        boolean[] descendingOrder = new boolean[]{false, true, false};
        IndexFieldDesc.Order[] order = new IndexFieldDesc.Order[]{descendingOrder[0] ? IndexFieldDesc.Order.Desc : IndexFieldDesc.Order.Asc, descendingOrder[1] ? IndexFieldDesc.Order.Desc : IndexFieldDesc.Order.Asc, descendingOrder[2] ? IndexFieldDesc.Order.Desc : IndexFieldDesc.Order.Asc};
        ImmutableList partitionKeys = ImmutableList.of((Object)new IndexFieldDescImpl(fieldPath[0], 0, order[0], false, false, null), (Object)new IndexFieldDescImpl(fieldPath[1], 0, order[1], false, false, null), (Object)new IndexFieldDescImpl(fieldPath[2], 0, order[2], false, false, null));
        IndexRowKeyEncoder encoder = new IndexRowKeyEncoder();
        encoder.init(0, descendingOrder);
        ConditionNode.RowkeyRange[] expectedRanges = new ConditionNode.RowkeyRange[1];
        ConditionNode.EMPTY_TABLE_RANGE.toArray(expectedRanges);
        ConditionImpl condition = MapRDBImpl.newCondition().and().is(fieldPath[0], QueryCondition.Op.EQUAL, "abc").is(fieldPath[0], QueryCondition.Op.EQUAL, "xyz").is(fieldPath[1], QueryCondition.Op.LESS_OR_EQUAL, "rst").is(fieldPath[1], QueryCondition.Op.GREATER_OR_EQUAL, "rst").is(fieldPath[2], QueryCondition.Op.EQUAL, "klm").close();
        condition.setPartitionKeys(encoder.getVersion(), (List)partitionKeys).build();
        List calculatedRanges = condition.getRowkeyRanges();
        this.checkRangeCalculationResults(expectedRanges, (List<ConditionNode.RowkeyRange>)calculatedRanges);
    }

    @Test
    public void testSecIdxRangeCalculation15() {
        String[] fieldPath = new String[]{"x.a", "x.b", "x.c"};
        boolean[] descendingOrder = new boolean[]{false, true, false};
        IndexFieldDesc.Order[] order = new IndexFieldDesc.Order[]{descendingOrder[0] ? IndexFieldDesc.Order.Desc : IndexFieldDesc.Order.Asc, descendingOrder[1] ? IndexFieldDesc.Order.Desc : IndexFieldDesc.Order.Asc, descendingOrder[2] ? IndexFieldDesc.Order.Desc : IndexFieldDesc.Order.Asc};
        ImmutableList partitionKeys = ImmutableList.of((Object)new IndexFieldDescImpl(fieldPath[0], 0, order[0], false, false, null), (Object)new IndexFieldDescImpl(fieldPath[1], 0, order[1], false, false, null), (Object)new IndexFieldDescImpl(fieldPath[2], 0, order[2], false, false, null));
        IndexRowKeyEncoder encoder = new IndexRowKeyEncoder();
        encoder.init(0, descendingOrder);
        ArrayList rangeList = new ArrayList(encoder.getRowKeyRange(Dbfilters.CompareOpProto.EQUAL, DBValueBuilderImpl.KeyValueBuilder.initFrom("abc"), 0));
        Assert.assertEquals((long)1L, (long)rangeList.size());
        rangeList.addAll(encoder.getRowKeyRange(Dbfilters.CompareOpProto.EQUAL, DBValueBuilderImpl.KeyValueBuilder.initFrom("klm"), 1));
        Assert.assertEquals((long)2L, (long)rangeList.size());
        rangeList.addAll(encoder.getRowKeyRange(Dbfilters.CompareOpProto.EQUAL, DBValueBuilderImpl.KeyValueBuilder.initFrom("xyz"), 1));
        Assert.assertEquals((long)3L, (long)rangeList.size());
        ConditionNode.RowkeyRange[] expectedRanges = new ConditionNode.RowkeyRange[]{new ConditionNode.RowkeyRange(Bytes.concatenate((byte[])((ConditionNode.RowkeyRange)rangeList.get(0)).getStartRow(), (byte[])((ConditionNode.RowkeyRange)rangeList.get(2)).getStartRow()), Bytes.concatenate((byte[])((ConditionNode.RowkeyRange)rangeList.get(0)).getStartRow(), (byte[])((ConditionNode.RowkeyRange)rangeList.get(2)).getStopRow())), new ConditionNode.RowkeyRange(Bytes.concatenate((byte[])((ConditionNode.RowkeyRange)rangeList.get(0)).getStartRow(), (byte[])((ConditionNode.RowkeyRange)rangeList.get(1)).getStartRow()), Bytes.concatenate((byte[])((ConditionNode.RowkeyRange)rangeList.get(0)).getStartRow(), (byte[])((ConditionNode.RowkeyRange)rangeList.get(1)).getStopRow()))};
        ConditionImpl condition = MapRDBImpl.newCondition().and().is(fieldPath[0], QueryCondition.Op.EQUAL, "abc").or().is(fieldPath[1], QueryCondition.Op.EQUAL, "klm").is(fieldPath[1], QueryCondition.Op.EQUAL, "xyz").close().close();
        condition.setPartitionKeys(encoder.getVersion(), (List)partitionKeys).build();
        List calculatedRanges = condition.getRowkeyRanges();
        this.checkRangeCalculationResults(expectedRanges, (List<ConditionNode.RowkeyRange>)calculatedRanges);
    }

    @Test
    public void testSecIdxRangeCalculation16() {
        String[] fieldPath = new String[]{"x.a", "x.b", "x.c"};
        boolean[] descendingOrder = new boolean[]{false, true, false};
        IndexFieldDesc.Order[] order = new IndexFieldDesc.Order[]{descendingOrder[0] ? IndexFieldDesc.Order.Desc : IndexFieldDesc.Order.Asc, descendingOrder[1] ? IndexFieldDesc.Order.Desc : IndexFieldDesc.Order.Asc, descendingOrder[2] ? IndexFieldDesc.Order.Desc : IndexFieldDesc.Order.Asc};
        ImmutableList partitionKeys = ImmutableList.of((Object)new IndexFieldDescImpl(fieldPath[0], 0, order[0], false, false, null), (Object)new IndexFieldDescImpl(fieldPath[1], 0, order[1], false, false, null), (Object)new IndexFieldDescImpl(fieldPath[2], 0, order[2], false, false, null));
        IndexRowKeyEncoder encoder = new IndexRowKeyEncoder();
        encoder.init(0, descendingOrder);
        ArrayList rangeList = new ArrayList(encoder.getRowKeyRange(Dbfilters.CompareOpProto.EQUAL, DBValueBuilderImpl.KeyValueBuilder.initFrom("abc"), 0));
        Assert.assertEquals((long)1L, (long)rangeList.size());
        rangeList.addAll(encoder.getRowKeyRange(Dbfilters.CompareOpProto.EQUAL, DBValueBuilderImpl.KeyValueBuilder.initFrom("klm"), 1));
        Assert.assertEquals((long)2L, (long)rangeList.size());
        rangeList.addAll(encoder.getRowKeyRange(Dbfilters.CompareOpProto.EQUAL, DBValueBuilderImpl.KeyValueBuilder.initFrom("rst"), 2));
        Assert.assertEquals((long)3L, (long)rangeList.size());
        rangeList.addAll(encoder.getRowKeyRange(Dbfilters.CompareOpProto.EQUAL, DBValueBuilderImpl.KeyValueBuilder.initFrom("xyz"), 2));
        Assert.assertEquals((long)4L, (long)rangeList.size());
        rangeList.addAll(encoder.getRowKeyRange(Dbfilters.CompareOpProto.GREATER, DBValueBuilderImpl.KeyValueBuilder.initFrom("ya"), 2));
        Assert.assertEquals((long)5L, (long)rangeList.size());
        rangeList.addAll(encoder.getRowKeyRange(Dbfilters.CompareOpProto.LESS, DBValueBuilderImpl.KeyValueBuilder.initFrom("yy"), 2));
        Assert.assertEquals((long)6L, (long)rangeList.size());
        ConditionNode.RowkeyRange[] expectedRanges = new ConditionNode.RowkeyRange[]{new ConditionNode.RowkeyRange(Bytes.concatenate((byte[])Bytes.concatenate((byte[])((ConditionNode.RowkeyRange)rangeList.get(0)).getStartRow(), (byte[])((ConditionNode.RowkeyRange)rangeList.get(1)).getStartRow()), (byte[])((ConditionNode.RowkeyRange)rangeList.get(2)).getStartRow()), Bytes.concatenate((byte[])Bytes.concatenate((byte[])((ConditionNode.RowkeyRange)rangeList.get(0)).getStartRow(), (byte[])((ConditionNode.RowkeyRange)rangeList.get(1)).getStartRow()), (byte[])((ConditionNode.RowkeyRange)rangeList.get(2)).getStopRow())), new ConditionNode.RowkeyRange(Bytes.concatenate((byte[])Bytes.concatenate((byte[])((ConditionNode.RowkeyRange)rangeList.get(0)).getStartRow(), (byte[])((ConditionNode.RowkeyRange)rangeList.get(1)).getStartRow()), (byte[])((ConditionNode.RowkeyRange)rangeList.get(3)).getStartRow()), Bytes.concatenate((byte[])Bytes.concatenate((byte[])((ConditionNode.RowkeyRange)rangeList.get(0)).getStartRow(), (byte[])((ConditionNode.RowkeyRange)rangeList.get(1)).getStartRow()), (byte[])((ConditionNode.RowkeyRange)rangeList.get(3)).getStopRow())), new ConditionNode.RowkeyRange(Bytes.concatenate((byte[])Bytes.concatenate((byte[])((ConditionNode.RowkeyRange)rangeList.get(0)).getStartRow(), (byte[])((ConditionNode.RowkeyRange)rangeList.get(1)).getStartRow()), (byte[])((ConditionNode.RowkeyRange)rangeList.get(4)).getStartRow()), Bytes.concatenate((byte[])Bytes.concatenate((byte[])((ConditionNode.RowkeyRange)rangeList.get(0)).getStartRow(), (byte[])((ConditionNode.RowkeyRange)rangeList.get(1)).getStartRow()), (byte[])((ConditionNode.RowkeyRange)rangeList.get(5)).getStopRow()))};
        ConditionImpl condition = MapRDBImpl.newCondition().and().is(fieldPath[0], QueryCondition.Op.EQUAL, "abc").is(fieldPath[1], QueryCondition.Op.EQUAL, "klm").or().is(fieldPath[2], QueryCondition.Op.EQUAL, "rst").is(fieldPath[2], QueryCondition.Op.EQUAL, "xyz").and().is(fieldPath[2], QueryCondition.Op.GREATER, "ya").is(fieldPath[2], QueryCondition.Op.LESS, "yy").close().close().close();
        condition.setPartitionKeys(encoder.getVersion(), (List)partitionKeys).build();
        List calculatedRanges = condition.getRowkeyRanges();
        this.checkRangeCalculationResults(expectedRanges, (List<ConditionNode.RowkeyRange>)calculatedRanges);
    }

    @Test
    public void testSecIdxRangeCalculation17_matches1() {
        SeondaryIndexTestHelper helper = new SeondaryIndexTestHelper();
        ArrayList rangeList = new ArrayList(helper.encoder.getRowKeyRange(Dbfilters.CompareOpProto.EQUAL, DBValueBuilderImpl.KeyValueBuilder.initFrom("abc"), 0));
        Assert.assertEquals((long)1L, (long)rangeList.size());
        String strRegex = "^rst.*";
        byte[] regexPrefix = Regexes.getRegexPrefix((String)strRegex).getBytes();
        rangeList.addAll(helper.encoder.getRowKeyRangeForPrefixMatch(regexPrefix, 1));
        Assert.assertEquals((long)2L, (long)rangeList.size());
        ConditionNode.RowkeyRange[] expectedRanges = new ConditionNode.RowkeyRange[]{new ConditionNode.RowkeyRange(Bytes.concatenate((byte[])((ConditionNode.RowkeyRange)rangeList.get(0)).getStartRow(), (byte[])((ConditionNode.RowkeyRange)rangeList.get(1)).getStartRow()), Bytes.concatenate((byte[])((ConditionNode.RowkeyRange)rangeList.get(0)).getStartRow(), (byte[])((ConditionNode.RowkeyRange)rangeList.get(1)).getStopRow()))};
        ConditionImpl condition = MapRDBImpl.newCondition().and().is(helper.fieldPath[0], QueryCondition.Op.EQUAL, "abc").matches(helper.fieldPath[1], "^rst.*").close();
        condition.setPartitionKeys(helper.encoder.getVersion(), helper.partitionKeys).build();
        List calculatedRanges = condition.getRowkeyRanges();
        this.checkRangeCalculationResults(expectedRanges, (List<ConditionNode.RowkeyRange>)calculatedRanges);
    }

    @Test
    public void testSecIdxRangeCalculation17_matches2() {
        SeondaryIndexTestHelper helper = new SeondaryIndexTestHelper();
        byte[] regexPrefix = Regexes.getRegexPrefix((String)"^abc$").getBytes();
        ArrayList<ConditionNode.RowkeyRange> expectedRanges = new ArrayList<ConditionNode.RowkeyRange>(helper.encoder.getRowKeyRangeForPrefixMatch(regexPrefix, 0));
        Assert.assertEquals((long)1L, (long)expectedRanges.size());
        ConditionImpl condition = MapRDBImpl.newCondition().and().matches(helper.fieldPath[0], "^abc$").matches(helper.fieldPath[1], "^rst.*").close();
        condition.setPartitionKeys(helper.encoder.getVersion(), helper.partitionKeys).build();
        List calculatedRanges = condition.getRowkeyRanges();
        this.checkRangeCalculationResults(expectedRanges, (List<ConditionNode.RowkeyRange>)calculatedRanges);
    }

    @Test
    public void testSecIdxRangeCalculation17_matches3() {
        SeondaryIndexTestHelper helper = new SeondaryIndexTestHelper();
        byte[] regexPrefix = Regexes.getRegexPrefix((String)"abc").getBytes();
        ArrayList<ConditionNode.RowkeyRange> expectedRanges = new ArrayList<ConditionNode.RowkeyRange>(helper.encoder.getRowKeyRangeForPrefixMatch(regexPrefix, 0));
        Assert.assertEquals((long)1L, (long)expectedRanges.size());
        ConditionImpl condition = MapRDBImpl.newCondition().and().matches(helper.fieldPath[0], "abc").matches(helper.fieldPath[1], "^rst.*").matches(helper.fieldPath[2], "^klm.*").close();
        condition.setPartitionKeys(helper.encoder.getVersion(), helper.partitionKeys).build();
        List calculatedRanges = condition.getRowkeyRanges();
        this.checkRangeCalculationResults(expectedRanges, (List<ConditionNode.RowkeyRange>)calculatedRanges);
    }

    @Test
    public void testSecIdxRangeCalculation17_matches4() {
        SeondaryIndexTestHelper helper = new SeondaryIndexTestHelper();
        byte[] regexPrefix = Regexes.getRegexPrefix((String)"^abc.*").getBytes();
        ArrayList<ConditionNode.RowkeyRange> expectedRanges = new ArrayList<ConditionNode.RowkeyRange>(helper.encoder.getRowKeyRangeForPrefixMatch(regexPrefix, 0));
        Assert.assertEquals((long)1L, (long)expectedRanges.size());
        ConditionImpl condition = MapRDBImpl.newCondition().and().matches(helper.fieldPath[0], "^abc.*").matches(helper.fieldPath[1], "^rst.*").matches(helper.fieldPath[2], "^klm.*").close();
        condition.setPartitionKeys(helper.encoder.getVersion(), helper.partitionKeys).build();
        List calculatedRanges = condition.getRowkeyRanges();
        this.checkRangeCalculationResults(expectedRanges, (List<ConditionNode.RowkeyRange>)calculatedRanges);
    }

    @Test
    public void testSecIdxRangeCalculation18_like() {
        SeondaryIndexTestHelper helper = new SeondaryIndexTestHelper();
        String strRegex = "^\\Qabc\\E.*$";
        byte[] regexPrefix = Regexes.getRegexPrefix((String)strRegex).getBytes();
        List expectedRanges = helper.encoder.getRowKeyRangeForPrefixMatch(regexPrefix, 0);
        ConditionNode.RowkeyRange expectedRange = (ConditionNode.RowkeyRange)expectedRanges.get(0);
        QueryCondition condition = MapRDBImpl.newCondition().like(helper.fieldPath[0], "abc%");
        ((ConditionImpl)condition).setPartitionKeys(helper.encoder.getVersion(), helper.partitionKeys).build();
        List calculatedRanges = ((ConditionImpl)condition).getRowkeyRanges();
        this.checkRangeCalculationResults(expectedRanges, (List<ConditionNode.RowkeyRange>)calculatedRanges);
    }

    @Test
    public void testHashSecIdxRangeCalculation1() {
        String[] fieldPath = new String[]{"x.a", "x.b"};
        boolean[] descendingOrder = new boolean[]{false, false};
        IndexFieldDesc.Order[] order = new IndexFieldDesc.Order[]{descendingOrder[0] ? IndexFieldDesc.Order.Desc : IndexFieldDesc.Order.Asc, descendingOrder[1] ? IndexFieldDesc.Order.Desc : IndexFieldDesc.Order.Asc};
        ImmutableList partitionKeys = ImmutableList.of((Object)new IndexFieldDescImpl(fieldPath[0], 1, order[0], false, false, null), (Object)new IndexFieldDescImpl(fieldPath[1], 2, order[1], false, false, null));
        boolean nullFirst = false;
        boolean isHashedIndex = true;
        int numHashPartitions = 2;
        IndexRowKeyEncoder encoder = new IndexRowKeyEncoder();
        encoder.init(0, descendingOrder, nullFirst, isHashedIndex, numHashPartitions);
        ArrayList<ConditionNode.RowkeyRange> expectedRanges = new ArrayList<ConditionNode.RowkeyRange>(Arrays.asList(new ConditionNode.RowkeyRange(MapRConstants.EMPTY_BYTE_ARRAY, MapRConstants.EMPTY_BYTE_ARRAY)));
        ConditionImpl condition = MapRDBImpl.newCondition().and().is(fieldPath[0], QueryCondition.Op.NOT_EQUAL, "xyz").is(fieldPath[1], QueryCondition.Op.LESS_OR_EQUAL, "rst").close();
        condition.setPartitionKeys(encoder.getVersion(), (List)partitionKeys, isHashedIndex, numHashPartitions, nullFirst).build();
        List calculatedRanges = condition.getRowkeyRanges();
        this.checkRangeCalculationResults(expectedRanges, (List<ConditionNode.RowkeyRange>)calculatedRanges);
    }

    @Test
    public void testConditionWithDateTime() {
        ConditionImpl cond1 = MapRDBImpl.newCondition().is("a", QueryCondition.Op.GREATER, ODate.parse((String)"2015-12-11")).build();
        ConditionImpl cond2 = MapRDBImpl.newCondition().condition((QueryCondition)cond1).build();
        Assert.assertEquals((Object)cond1, (Object)cond2);
    }

    @Test
    public void testConditionWithDateTime2() {
        ConditionImpl c1 = MapRDBImpl.newCondition().is("a.b", QueryCondition.Op.GREATER, OTimestamp.parse((String)"2013-08-22T15:11:22Z")).build();
        ConditionImpl c2 = MapRDBImpl.newCondition().and().is("k", QueryCondition.Op.EQUAL, "xyz").is("a.b", QueryCondition.Op.GREATER, OTimestamp.parse((String)"2013-08-22T15:11:22Z")).close().build();
        ConditionImpl c3 = MapRDBImpl.newCondition().and().is("k", QueryCondition.Op.EQUAL, "xyz").condition((QueryCondition)c1).close().build();
        Assert.assertEquals((Object)c2, (Object)c3);
    }

    private static void checkAef(QueryCondition qc) {
        ConditionImpl condImpl = (ConditionImpl)qc;
        ConditionNode cNode = condImpl.getRoot();
        if (AefTransformer.showTransform()) {
            System.err.println();
            System.err.println("QueryCondition: " + qc);
        }
        if (cNode == null) {
            return;
        }
        AefTransformer interAef = cNode.createAefTransformer(null);
        StringBuilder sb = null;
        if (AefTransformer.showTransform()) {
            sb = new StringBuilder();
            interAef.prettyPrint(sb, 0);
            System.err.print("INTERMEDIATE AEFT:\n" + sb);
        }
        AefTransformer serverAef = interAef.toServer();
        if (AefTransformer.showTransform()) {
            sb.setLength(0);
            serverAef.prettyPrint(sb, 0);
            System.err.println("SERVER AEFT:\n" + sb);
        }
        ConditionDescriptor cd = serverAef.getDescriptor(Constants.DEFAULT_FAMILY_MAP, null, null, -1);
        Assert.assertNotNull((Object)cd);
        QueryCondition deserCond = ConditionImpl.parseFrom((ByteBuffer)cd.getSerialized());
        Assert.assertEquals((Object)qc, (Object)deserCond);
    }

    @Test
    public void testElementAnd() {
        ConditionImpl qc1 = MapRDBImpl.newCondition().elementAnd("foo[]").close().build();
        TestCondition.checkAef((QueryCondition)qc1);
        this.serializeAndCompare((QueryCondition)qc1, "<EMPTY>");
        ConditionImpl qc2 = MapRDBImpl.newCondition().elementAnd("foo[]").is("a", QueryCondition.Op.EQUAL, 17).close().build();
        TestCondition.checkAef((QueryCondition)qc2);
        this.serializeAndCompare((QueryCondition)qc2, "elementAnd(\"foo[]\", (a = {\"$numberInt\":17}))");
        ConditionImpl qc3 = MapRDBImpl.newCondition().elementAnd("a[]").is("b", QueryCondition.Op.EQUAL, "ab").is("c", QueryCondition.Op.EQUAL, "ac").close().build();
        TestCondition.checkAef((QueryCondition)qc3);
        this.serializeAndCompare((QueryCondition)qc3, "elementAnd(\"a[]\", (b = \"ab\") and (c = \"ac\"))");
        ConditionImpl qc4 = MapRDBImpl.newCondition().and().is("a", QueryCondition.Op.EQUAL, 17).elementAnd("foo[]").is("x.y", QueryCondition.Op.GREATER, "bar").is("z", QueryCondition.Op.EQUAL, 42).close().close().build();
        TestCondition.checkAef((QueryCondition)qc4);
        this.serializeAndCompare((QueryCondition)qc4, "((a = {\"$numberInt\":17}) and elementAnd(\"foo[]\", (x.y > \"bar\") and (z = {\"$numberInt\":42})))");
        ConditionImpl qc5 = MapRDBImpl.newCondition().elementAnd("a[][]").is("$", QueryCondition.Op.LESS, 75).is("$", QueryCondition.Op.GREATER, 130).close().build();
        TestCondition.checkAef((QueryCondition)qc5);
        ConditionImpl qc6 = MapRDBImpl.newCondition().is("a[][]", QueryCondition.Op.EQUAL, 100).build();
        TestCondition.checkAef((QueryCondition)qc6);
        ConditionImpl maprdb670 = MapRDBImpl.newCondition().and().is("a[][]", QueryCondition.Op.LESS, 75).is("a[][]", QueryCondition.Op.GREATER, 130).close().build();
        TestCondition.checkAef((QueryCondition)maprdb670);
        ConditionImpl qc8 = MapRDBImpl.newCondition().and().is("a[][]", QueryCondition.Op.LESS, 75).is("a[]", QueryCondition.Op.GREATER, 130).close().build();
        TestCondition.checkAef((QueryCondition)qc8);
        ConditionImpl qc9 = MapRDBImpl.newCondition().or().is("a[].b", QueryCondition.Op.LESS, 75).is("a[].c", QueryCondition.Op.GREATER, 100).close().build();
        TestCondition.checkAef((QueryCondition)qc9);
        ConditionImpl qc10 = MapRDBImpl.newCondition().or().is("a[].b", QueryCondition.Op.LESS, 75).is("y", QueryCondition.Op.GREATER, 100).close().build();
        TestCondition.checkAef((QueryCondition)qc10);
        ConditionImpl qc11 = MapRDBImpl.newCondition().and().is("a[].b", QueryCondition.Op.LESS, 75).is("c[].d", QueryCondition.Op.GREATER, 100).is("y", QueryCondition.Op.GREATER, "foo").is("a[][].f", QueryCondition.Op.LESS, 19).is("c[].g", QueryCondition.Op.LESS, 75).close().build();
        TestCondition.checkAef((QueryCondition)qc11);
        ConditionImpl maprdb669 = MapRDBImpl.newCondition().elementAnd("a[][]").is("$", QueryCondition.Op.LESS, 75).is("$", QueryCondition.Op.GREATER, 130).close().build();
        TestCondition.checkAef((QueryCondition)maprdb669);
        ConditionImpl maprdb668 = MapRDBImpl.newCondition().elementAnd("a[]").or().is("b", QueryCondition.Op.EQUAL, "ab").is("c", QueryCondition.Op.EQUAL, "ac").close().is("d", QueryCondition.Op.EQUAL, "ad").close().build();
        TestCondition.checkAef((QueryCondition)maprdb668);
    }

    private MapRDBIndexImpl testSecondaryIndexConditionSetupIndex(Table priTable, String indexName, String indexedFields) throws Exception {
        MapRDBTableImpl tab = (MapRDBTableImpl)priTable;
        TestCluster.runCommand((String)("maprcli table index add -path " + tab.getPath() + " -index " + indexName + " -indexedfields " + indexedFields));
        Collection tableIndexColl = DBTests.admin().getTableIndexes(tab.getPath(), false);
        Assert.assertEquals((long)1L, (long)tableIndexColl.size());
        IndexDesc indexTableDesc = (IndexDesc)tableIndexColl.iterator().next();
        MapRDBIndexImpl indexImpl = (MapRDBIndexImpl)MapRDBImpl.getIndexTable((IndexDesc)indexTableDesc);
        return indexImpl;
    }

    private IndexRowKeyEncoder testSecondaryIndexConditionSetupEncoder(boolean[] descendingOrder, String[] indexedFields) {
        ImmutableList partitionKeys = ImmutableList.of((Object)new IndexFieldDescImpl(indexedFields[0], 1, descendingOrder[0] ? IndexFieldDesc.Order.Desc : IndexFieldDesc.Order.Asc, false, false, null), (Object)new IndexFieldDescImpl(indexedFields[1], 2, descendingOrder[1] ? IndexFieldDesc.Order.Desc : IndexFieldDesc.Order.Asc, false, false, null));
        IndexRowKeyEncoder encoder = new IndexRowKeyEncoder();
        encoder.init(0, descendingOrder);
        return encoder;
    }

    private static KeyValue getRowColEncodedValue(int val) {
        return DBValueBuilderImpl.KeyValueBuilder.initFrom(val);
    }

    private static ConditionNode.RowkeyRange getMergedRange(ConditionNode.RowkeyRange range1, ConditionNode.RowkeyRange range2) {
        return new ConditionNode.RowkeyRange(range1.getStartRow(), range2.getStopRow());
    }

    private static ConditionNode.RowkeyRange getConcatenatedRange(ConditionNode.RowkeyRange range1, ConditionNode.RowkeyRange range2) {
        return new ConditionNode.RowkeyRange(Bytes.concatenate((byte[])range1.getStartRow(), (byte[])range2.getStartRow()), Bytes.concatenate((byte[])range1.getStartRow(), (byte[])range2.getStopRow()));
    }

    @Test
    @Category(value={FailingTest.class})
    public void testSecondaryIndexScanRangeArrayElementAndIndex() throws Exception {
        String tName = "testSecondaryIndexScanRangeArrayElementAndIndex-table";
        String iName = "testSecondaryIndexScanRangeArrayElementAndIndex-index";
        String indexedFieldString = "a[].b,a[].c";
        boolean[] descendingOrder = new boolean[]{false, false};
        IndexRowKeyEncoder encoder = this.testSecondaryIndexConditionSetupEncoder(descendingOrder, indexedFieldString.split(","));
        JsonTable priTable = DBTests.createOrGetTable(tName);
        MapRDBIndexImpl index = this.testSecondaryIndexConditionSetupIndex((Table)priTable, iName, indexedFieldString);
        ConditionImpl qc = MapRDBImpl.newCondition().elementAnd("a[]").is("b", QueryCondition.Op.GREATER, 100).is("b", QueryCondition.Op.LESS, 200).close().build();
        List calculatedRanges = index.getRowkeyRanges((QueryCondition)qc);
        Assert.assertEquals((long)1L, (long)calculatedRanges.size());
        List<ConditionNode.RowkeyRange> expectedLowerBound = this.getRowKeyRange(encoder, Dbfilters.CompareOpProto.GREATER, TestCondition.getRowColEncodedValue(100));
        List<ConditionNode.RowkeyRange> expectedUpperBound = this.getRowKeyRange(encoder, Dbfilters.CompareOpProto.LESS, TestCondition.getRowColEncodedValue(200));
        Assert.assertEquals((long)1L, (long)expectedLowerBound.size());
        Assert.assertEquals((long)1L, (long)expectedUpperBound.size());
        ConditionNode.RowkeyRange expectedRange = TestCondition.getMergedRange(expectedLowerBound.get(0), expectedUpperBound.get(0));
        assert (expectedRange.equals(calculatedRanges.get(0)));
        qc = MapRDBImpl.newCondition().elementAnd("a[]").is("c", QueryCondition.Op.GREATER_OR_EQUAL, 200).is("c", QueryCondition.Op.LESS, 300).close().build();
        calculatedRanges = index.getRowkeyRanges((QueryCondition)qc);
        Assert.assertEquals((long)1L, (long)calculatedRanges.size());
        calculatedRanges.equals(FULL_TABLE_RANGE);
        qc = MapRDBImpl.newCondition().elementAnd("a[]").is("b", QueryCondition.Op.EQUAL, 200).is("c", QueryCondition.Op.EQUAL, 300).close().build();
        calculatedRanges = index.getRowkeyRanges((QueryCondition)qc);
        Assert.assertEquals((long)1L, (long)calculatedRanges.size());
        List<ConditionNode.RowkeyRange> firstFieldRange = this.getRowKeyRange(encoder, Dbfilters.CompareOpProto.EQUAL, TestCondition.getRowColEncodedValue(200), 0);
        List<ConditionNode.RowkeyRange> secondFieldRange = this.getRowKeyRange(encoder, Dbfilters.CompareOpProto.EQUAL, TestCondition.getRowColEncodedValue(300), 1);
        Assert.assertEquals((long)1L, (long)firstFieldRange.size());
        Assert.assertEquals((long)1L, (long)secondFieldRange.size());
        expectedRange = TestCondition.getConcatenatedRange(firstFieldRange.get(0), secondFieldRange.get(0));
        assert (((ConditionNode.RowkeyRange)calculatedRanges.get(0)).equals((Object)expectedRange));
        qc = MapRDBImpl.newCondition().elementAnd("a[]").is("b", QueryCondition.Op.EQUAL, 200).is("c", QueryCondition.Op.LESS, 300).close().build();
        calculatedRanges = index.getRowkeyRanges((QueryCondition)qc);
        Assert.assertEquals((long)1L, (long)calculatedRanges.size());
        firstFieldRange = this.getRowKeyRange(encoder, Dbfilters.CompareOpProto.EQUAL, TestCondition.getRowColEncodedValue(200), 0);
        secondFieldRange = this.getRowKeyRange(encoder, Dbfilters.CompareOpProto.LESS, TestCondition.getRowColEncodedValue(300), 1);
        Assert.assertEquals((long)1L, (long)firstFieldRange.size());
        Assert.assertEquals((long)1L, (long)secondFieldRange.size());
        expectedRange = TestCondition.getConcatenatedRange(firstFieldRange.get(0), secondFieldRange.get(0));
        assert (((ConditionNode.RowkeyRange)calculatedRanges.get(0)).equals((Object)expectedRange));
        qc = MapRDBImpl.newCondition().or().elementAnd("a[]").is("b", QueryCondition.Op.GREATER, 100).is("b", QueryCondition.Op.LESS, 200).close().elementAnd("a[]").is("b", QueryCondition.Op.GREATER_OR_EQUAL, 300).is("b", QueryCondition.Op.LESS_OR_EQUAL, 400).close().close().build();
        calculatedRanges = index.getRowkeyRanges((QueryCondition)qc);
        Assert.assertEquals((long)2L, (long)calculatedRanges.size());
        List<ConditionNode.RowkeyRange> expectedLowerBound1 = this.getRowKeyRange(encoder, Dbfilters.CompareOpProto.GREATER, TestCondition.getRowColEncodedValue(100));
        List<ConditionNode.RowkeyRange> expectedUpperBound1 = this.getRowKeyRange(encoder, Dbfilters.CompareOpProto.LESS, TestCondition.getRowColEncodedValue(200));
        Assert.assertEquals((long)1L, (long)expectedLowerBound1.size());
        Assert.assertEquals((long)1L, (long)expectedUpperBound1.size());
        List<ConditionNode.RowkeyRange> expectedLowerBound2 = this.getRowKeyRange(encoder, Dbfilters.CompareOpProto.GREATER_OR_EQUAL, TestCondition.getRowColEncodedValue(300));
        List<ConditionNode.RowkeyRange> expectedUpperBound2 = this.getRowKeyRange(encoder, Dbfilters.CompareOpProto.LESS_OR_EQUAL, TestCondition.getRowColEncodedValue(400));
        Assert.assertEquals((long)1L, (long)expectedLowerBound2.size());
        Assert.assertEquals((long)1L, (long)expectedUpperBound2.size());
        ConditionNode.RowkeyRange expectedRange1 = TestCondition.getMergedRange(expectedLowerBound1.get(0), expectedUpperBound1.get(0));
        ConditionNode.RowkeyRange expectedRange2 = TestCondition.getMergedRange(expectedLowerBound2.get(0), expectedUpperBound2.get(0));
        assert (expectedRange1.equals(calculatedRanges.get(0)));
        assert (expectedRange2.equals(calculatedRanges.get(1)));
    }

    @Test
    public void testCondition_recursiveMapSort_MapArrayMap() throws Exception {
        String cmd = "{\"$eq\":{\"l0_a30_mapList[].l0_a0_mapMapKey\":{\"key0\":[{\"key9\":{\"$numberShort\":9},\"key10\":{\"$numberShort\":10},\"key5\":{\"$numberLong\":5}}]}}}";
        String strExpectedValue = "{\"key0\":[{\"key10\":10,\"key5\":5,\"key9\":9}]}";
        ConditionParser cp = new ConditionParser();
        ConditionImpl condImpl = (ConditionImpl)cp.parseCondition(cmd);
        ConditionLeaf cNode = (ConditionLeaf)condImpl.getRoot();
        TreeMap resMap = new TreeMap();
        ConditionLeaf.recursiveMapSort((Object)cNode.getValue(), resMap);
        String strAfter = DBValueBuilderImpl.KeyValueBuilder.initFromObject(resMap).toString();
        Assert.assertEquals((Object)strExpectedValue, (Object)strAfter);
    }

    @Test
    public void testCondition_recursiveMapSort_ArrayArrayMap() throws Exception {
        String cmd = "{\"$eq\":{\"l0_a30_mapList[].l0_a0_mapMapKey\":[[{\"key9\":{\"$numberShort\":9},\"key10\":{\"$numberShort\":10},\"key5\":{\"$numberLong\":5}}]]}}";
        String strExpectedValue = "[[{\"key10\":10,\"key5\":5,\"key9\":9}]]";
        ConditionParser cp = new ConditionParser();
        ConditionImpl condImpl = (ConditionImpl)cp.parseCondition(cmd);
        ConditionLeaf cNode = (ConditionLeaf)condImpl.getRoot();
        ArrayList resList = new ArrayList();
        ConditionLeaf.recursiveMapSort((Object)cNode.getValue(), resList);
        String strAfter = DBValueBuilderImpl.KeyValueBuilder.initFromObject(resList).toString();
        Assert.assertEquals((Object)strExpectedValue, (Object)strAfter);
    }

    @Test
    public void testCondition_recursiveMapSort_ArrayMap() throws Exception {
        String cmd = "{\"$eq\":{\"l0_a30_mapList[].l0_a0_mapMapKey\":[{\"key9\":{\"$numberShort\":9},\"key5\":{\"$numberShort\":5}},{\"key10\":{\"$numberLong\":10}}]}}";
        String strExpectedValue = "[{\"key5\":5,\"key9\":9}, {\"key10\":10}]";
        ConditionParser cp = new ConditionParser();
        ConditionImpl condImpl = (ConditionImpl)cp.parseCondition(cmd);
        ConditionLeaf cNode = (ConditionLeaf)condImpl.getRoot();
        ArrayList resList = new ArrayList();
        ConditionLeaf.recursiveMapSort((Object)cNode.getValue(), resList);
        String strAfter = DBValueBuilderImpl.KeyValueBuilder.initFromObject(resList).toString();
        Assert.assertEquals((Object)strExpectedValue, (Object)strAfter);
    }

    class SeondaryIndexTestHelper {
        String[] fieldPath = new String[]{"x.a", "x.b", "x.c"};
        boolean[] descendingOrder = new boolean[]{false, true, false};
        IndexFieldDesc.Order[] order = new IndexFieldDesc.Order[]{this.descendingOrder[0] ? IndexFieldDesc.Order.Desc : IndexFieldDesc.Order.Asc, this.descendingOrder[1] ? IndexFieldDesc.Order.Desc : IndexFieldDesc.Order.Asc, this.descendingOrder[2] ? IndexFieldDesc.Order.Desc : IndexFieldDesc.Order.Asc};
        ImmutableList<IndexFieldDesc> partitionKeys = ImmutableList.of((Object)new IndexFieldDescImpl(this.fieldPath[0], 0, this.order[0], false, false, null), (Object)new IndexFieldDescImpl(this.fieldPath[1], 0, this.order[1], false, false, null), (Object)new IndexFieldDescImpl(this.fieldPath[2], 0, this.order[2], false, false, null));
        IndexRowKeyEncoder encoder = new IndexRowKeyEncoder();

        SeondaryIndexTestHelper() {
            this.encoder.init(0, this.descendingOrder);
        }
    }
}

