/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.indexrowkeyfmt;

import com.mapr.db.indexrowkeyfmt.IndexRowKeyDecoder;
import com.mapr.db.indexrowkeyfmt.IndexRowKeyEncoder;
import com.mapr.db.indexrowkeyfmt.NumericComponent;
import com.mapr.utils.ByteReader;
import java.util.Arrays;
import java.util.Random;
import org.junit.Assert;

class Nmbr
implements Comparable<Nmbr> {
    private static final int FLOAT_EXPONENT_BIAS = 127;
    private static final int FLOAT_EXPONENT_MASK = 2139095040;
    private static final int FLOAT_MANTISSA_SIZE = 23;
    private static final int FLOAT_MANTISSA_MASK = 0x7FFFFF;
    private static final int DOUBLE_EXPONENT_BIAS = 1023;
    private static final long DOUBLE_EXPONENT_MASK = 0x7FF0000000000000L;
    private static final int DOUBLE_MANTISSA_SIZE = 52;
    private static final long DOUBLE_MANTISSA_MASK = 0xFFFFFFFFFFFFFL;
    private static final int NMBR_TYPE_DOUBLE = 0;
    private static final int NMBR_TYPE_FLOAT = 1;
    private static final int NMBR_TYPE_INT64 = 2;
    private static final int NMBR_TYPE_INT32 = 3;
    private static final int NMBR_TYPE_INT16 = 4;
    private static final int NMBR_TYPE_INT8 = 5;
    private static final int NMBR_TYPE_COUNT = 6;
    private static final String prk_ = "E";
    private static final Random random_ = new Random(7L);
    private double d;
    private float f;
    private long i64;
    private int i32;
    private short i16;
    private byte i8;
    private final IndexRowKeyEncoder enc_ = new IndexRowKeyEncoder();
    private final IndexRowKeyDecoder dec_ = new IndexRowKeyDecoder();
    private NumericComponent decodedNumericComponent_ = null;
    private int type_ = 1;
    private boolean isNegative_ = false;
    private boolean isInfinity_ = false;
    private boolean isNaN_ = false;
    private boolean isZero_ = true;
    private short exponent_ = 0;
    private long mantissa_ = 0L;
    private byte[] encodedStr_ = new byte[32];
    private int encodedStrSize_ = 0;

    private short findMostSignificantBit32(int u) {
        assert (u != 0);
        return (short)(31 - Integer.numberOfLeadingZeros(u));
    }

    private short findMostSignificantBit64(long u) {
        assert (u != 0L);
        return (short)(63 - Long.numberOfLeadingZeros(u));
    }

    public byte[] getEncoding() {
        return Arrays.copyOfRange(this.encodedStr_, 0, this.encodedStrSize_ - this.dec_.getPrimaryTableRowKey().length - 1);
    }

    public void generateLongEM(boolean minus, short exponent, long mantissa) {
        this.isNegative_ = minus;
        this.isInfinity_ = false;
        this.isNaN_ = false;
        this.isZero_ = false;
        this.exponent_ = exponent;
        this.mantissa_ = mantissa;
        this.i64 = (Long.MIN_VALUE | mantissa >>> 1) >>> 63 - exponent;
        if (this.isNegative_) {
            this.i64 = -this.i64;
        }
        this.type_ = 2;
    }

    public void generate() {
        int randomInt = random_.nextInt();
        if (randomInt < 0) {
            randomInt *= -1;
        }
        this.type_ = randomInt % 6;
        switch (this.type_) {
            case 0: {
                this.d = random_.nextDouble();
                long ui64 = Double.doubleToRawLongBits(this.d);
                boolean bl = this.isNegative_ = (ui64 & Long.MIN_VALUE) != 0L;
                if ((ui64 & 0x7FF0000000000000L) == 0x7FF0000000000000L) {
                    this.isInfinity_ = (ui64 & 0xFFFFFFFFFFFFFL) == 0L;
                    this.isNaN_ = !this.isInfinity_;
                } else {
                    this.isInfinity_ = false;
                    this.isNaN_ = false;
                }
                boolean bl2 = this.isZero_ = this.d == 0.0;
                if (this.d == 0.0) break;
                this.exponent_ = (short)((ui64 & 0x7FF0000000000000L) >> 52);
                this.exponent_ = (short)(this.exponent_ - 1023);
                this.mantissa_ = ui64;
                this.mantissa_ <<= 12;
                break;
            }
            case 1: {
                this.f = random_.nextFloat();
                int ui32 = Float.floatToRawIntBits(this.f);
                boolean bl = this.isNegative_ = (ui32 & Integer.MIN_VALUE) != 0;
                if ((ui32 & 0x7F800000) == 2139095040) {
                    this.isInfinity_ = (ui32 & 0x7FFFFF) == 0;
                    this.isNaN_ = !this.isInfinity_;
                } else {
                    this.isInfinity_ = false;
                    this.isNaN_ = false;
                }
                boolean bl3 = this.isZero_ = this.f == 0.0f;
                if (this.f == 0.0f) break;
                this.exponent_ = (short)((ui32 & 0x7F800000) >> 23);
                this.exponent_ = (short)(this.exponent_ - 127);
                this.mantissa_ = ui32;
                this.mantissa_ <<= 41;
                break;
            }
            case 2: {
                this.i64 = random_.nextLong();
                this.isNegative_ = this.i64 < 0L;
                this.isInfinity_ = false;
                this.isNaN_ = false;
                this.isZero_ = this.i64 == 0L;
                long aux = this.i64;
                if (this.isNegative_) {
                    aux = -aux;
                }
                if (aux == 0L) break;
                this.exponent_ = this.findMostSignificantBit64(aux);
                this.mantissa_ = this.exponent_ != 0 ? aux << 64 - this.exponent_ : 0L;
                break;
            }
            case 3: {
                this.i32 = random_.nextInt();
                this.isNegative_ = this.i32 < 0;
                this.isInfinity_ = false;
                this.isNaN_ = false;
                this.isZero_ = this.i32 == 0;
                long aux = this.i32;
                if (this.isNegative_) {
                    aux = -aux;
                }
                if (aux == 0L) break;
                this.exponent_ = this.findMostSignificantBit64(aux);
                this.mantissa_ = this.exponent_ != 0 ? aux << 64 - this.exponent_ : 0L;
                break;
            }
            case 4: {
                this.i16 = (short)random_.nextInt();
                this.isNegative_ = this.i16 < 0;
                this.isInfinity_ = false;
                this.isNaN_ = false;
                this.isZero_ = this.i16 == 0;
                long aux = this.i16;
                if (this.isNegative_) {
                    aux = -aux;
                }
                if (aux == 0L) break;
                this.exponent_ = this.findMostSignificantBit64(aux);
                this.mantissa_ = this.exponent_ != 0 ? aux << 64 - this.exponent_ : 0L;
                break;
            }
            case 5: {
                this.i8 = (byte)random_.nextInt();
                this.isNegative_ = this.i8 < 0;
                this.isInfinity_ = false;
                this.isNaN_ = false;
                this.isZero_ = this.i8 == 0;
                long aux = this.i8;
                if (this.isNegative_) {
                    aux = -aux;
                }
                if (aux == 0L) break;
                this.exponent_ = this.findMostSignificantBit64(aux);
                this.mantissa_ = this.exponent_ != 0 ? aux << 64 - this.exponent_ : 0L;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    public void init(boolean[] descendingOrder) {
        this.enc_.init(0, descendingOrder, false, false, 0);
        this.dec_.init(0, descendingOrder);
    }

    public void encode() {
        this.enc_.resetComponents();
        switch (this.type_) {
            case 0: {
                this.enc_.setComponent(0, this.d);
                break;
            }
            case 1: {
                this.enc_.setComponent(0, this.f);
                break;
            }
            case 2: {
                this.enc_.setComponent(0, this.i64);
                break;
            }
            case 3: {
                this.enc_.setComponent(0, this.i32);
                break;
            }
            case 4: {
                this.enc_.setComponent(0, this.i16);
                break;
            }
            case 5: {
                this.enc_.setComponent(0, this.i8);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        this.enc_.setPrimaryKey(prk_);
        this.encodedStrSize_ = this.enc_.getRowKey(this.encodedStr_);
        this.encodedStr_ = Arrays.copyOfRange(this.encodedStr_, 0, this.encodedStrSize_);
    }

    public void decode() {
        int result = this.dec_.setRowKey(ByteReader.wrap((byte[])this.encodedStr_));
        this.decodedNumericComponent_ = result != 0 ? null : (NumericComponent)this.dec_.getComponent(0);
    }

    public void checkDecodingCorrectness() {
        boolean bothNotNaNs;
        Assert.assertTrue((this.decodedNumericComponent_ != null ? 1 : 0) != 0);
        short decodedExponent = this.decodedNumericComponent_.getExponent();
        long decodedMantissa = this.decodedNumericComponent_.getMantissa();
        boolean haveTheSameSign = this.isNegative_ == this.decodedNumericComponent_.getIsNegative();
        boolean bothZeros = this.isZero_ && this.decodedNumericComponent_.getIsZero();
        boolean bothNotZeros = !this.isZero_ && !this.decodedNumericComponent_.getIsZero();
        boolean bothInfinities = this.isInfinity_ && this.decodedNumericComponent_.getIsInfinity();
        boolean bothNotInfinities = !this.isInfinity_ && !this.decodedNumericComponent_.getIsInfinity();
        boolean bothNaNs = this.isNaN_ && this.decodedNumericComponent_.getIsNaN();
        boolean bl = bothNotNaNs = !this.isNaN_ && !this.decodedNumericComponent_.getIsNaN();
        boolean exponentsMatch = bothNaNs ? (this.exponent_ == 128 || this.exponent_ == 1024) && decodedExponent == 0 && decodedMantissa != 0L : this.exponent_ == decodedExponent;
        boolean mantissasMatch = this.mantissa_ == decodedMantissa;
        Assert.assertTrue((boolean)haveTheSameSign);
        if (bothZeros) {
            Assert.assertTrue((boolean)bothNotInfinities);
            Assert.assertTrue((boolean)bothNotNaNs);
            Assert.assertTrue((boolean)exponentsMatch);
            Assert.assertTrue((boolean)mantissasMatch);
            return;
        }
        Assert.assertTrue((boolean)bothNotZeros);
        if (bothInfinities) {
            Assert.assertTrue((boolean)bothNotNaNs);
            Assert.assertTrue((boolean)exponentsMatch);
            Assert.assertTrue((boolean)mantissasMatch);
            return;
        }
        Assert.assertTrue((boolean)bothNotInfinities);
        if (bothNaNs) {
            Assert.assertTrue((boolean)exponentsMatch);
            Assert.assertTrue((boolean)mantissasMatch);
            return;
        }
        Assert.assertTrue((boolean)bothNotNaNs);
        Assert.assertTrue((boolean)bothNotInfinities);
        Assert.assertTrue((boolean)bothNotNaNs);
        Assert.assertTrue((boolean)exponentsMatch);
        Assert.assertTrue((boolean)mantissasMatch);
    }

    public String getTypeStr() {
        switch (this.type_) {
            case 0: {
                return "d";
            }
            case 1: {
                return "f";
            }
            case 2: {
                return "i64";
            }
            case 3: {
                return "i32";
            }
            case 4: {
                return "i16";
            }
            case 5: {
                return "i8";
            }
        }
        assert (false);
        return "";
    }

    private int compareUnsigned(long x, long y) {
        if (x < 0L && y >= 0L) {
            return 1;
        }
        if (x >= 0L && y < 0L) {
            return -1;
        }
        return x == y ? 0 : (x > y ? 1 : -1);
    }

    @Override
    public int compareTo(Nmbr rhs) {
        if (this.isNaN_) {
            if (rhs.isNaN_) {
                if (this.isNegative_) {
                    if (rhs.isNegative_) {
                        return this.mantissa_ == rhs.mantissa_ ? 0 : (this.compareUnsigned(this.mantissa_, rhs.mantissa_) > 0 ? -1 : 1);
                    }
                    return -1;
                }
                if (rhs.isNegative_) {
                    return 1;
                }
                return this.mantissa_ == rhs.mantissa_ ? 0 : (this.compareUnsigned(this.mantissa_, rhs.mantissa_) < 0 ? -1 : 1);
            }
            return 1;
        }
        if (rhs.isNaN_) {
            return -1;
        }
        if (this.isNegative_) {
            if (rhs.isNegative_) {
                if (this.exponent_ < rhs.exponent_) {
                    return 1;
                }
                if (this.exponent_ > rhs.exponent_) {
                    return -1;
                }
                return this.mantissa_ == rhs.mantissa_ ? 0 : (this.compareUnsigned(this.mantissa_, rhs.mantissa_) > 0 ? -1 : 1);
            }
            return -1;
        }
        if (this.isZero_) {
            return rhs.isZero_ ? 0 : (rhs.isNegative_ ? 1 : -1);
        }
        if (rhs.isNegative_ || rhs.isZero_) {
            return 1;
        }
        if (this.exponent_ < rhs.exponent_) {
            return -1;
        }
        if (this.exponent_ > rhs.exponent_) {
            return 1;
        }
        return this.mantissa_ == rhs.mantissa_ ? 0 : (this.compareUnsigned(this.mantissa_, rhs.mantissa_) < 0 ? -1 : 1);
    }

    public void print() {
        System.out.printf("Infinity = %s, Nan = %s(%s, %d, %016x)[%s] / '", this.isInfinity_ ? "true" : "false", this.isNaN_ ? "true" : "false", this.isNegative_ ? "-" : "+", this.exponent_, this.mantissa_, this.getTypeStr());
        for (int i = 0; i < this.encodedStrSize_; ++i) {
            System.out.printf("%02x", this.encodedStr_[i]);
        }
        System.out.printf("'\n", new Object[0]);
    }
}

