/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.tests.objectinstrumentation;

import com.google.common.collect.Lists;
import com.mapr.db.Table;
import com.mapr.db.impl.MapRDBImpl;
import com.mapr.db.tests.utils.DBTests;
import com.mapr.db.tests.utils.DataUtil;
import com.mapr.tests.annotations.ClusterTest;
import com.mapr.tests.annotations.IsolatedTest;
import com.mapr.tests.objectinstrumentation.ObjectInstrumentationTest;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Map;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.ojai.Document;

@Category(value={ClusterTest.class, IsolatedTest.class})
public class ObjectAllocationTestOnDBOperations
extends ObjectInstrumentationTest {
    private static final String TABLE_NAME = "testtable-ObjectAllocationTestOnDBOperations";
    private static final int NUM_RECORDS = 10000;
    private static final int FIELD_COUNT = 10;
    private static final int FIELD_SIZE = 10;
    private static final String ERR_MORE_OBJECTS = "This test is approximate and the reference value could change. If you notice a failure, please compare the allocation report found under './target/test-logs/allocation_report.log' with the benchmark report available under './src/test/resources/allocation_report.log'";
    private static final String ERR_LESS_OBJECTS = "If your change has caused this failure, it could mean one of the two things. 1. You have remarkably improved the object allocation; in which case congratulations!!! Please fix the failure by adjusting the reference value to the new lower threshold. 2. The alternate explanation could be that you broke the feature and something is not warking as they should. Please compare the allocation report found  under './target/test-logs/allocation_report.log' with the last benchmark report which is available under './src/test/resources/allocation_report.log'";
    private static Table table;

    @BeforeClass
    public static void startupBeforeClass() throws IOException {
        table = DBTests.createOrReplaceTable(TABLE_NAME);
        table.setOption(Table.TableOption.BUFFERWRITE, true);
    }

    @AfterClass
    public static void cleanupAfterClass() throws IOException, Exception {
        if (table != null) {
            table.close();
            DBTests.deleteTables(TABLE_NAME);
        }
    }

    public ObjectAllocationTestOnDBOperations() {
        this.setTypes(new ObjectInstrumentationTest.InstrumentationType[]{ObjectInstrumentationTest.InstrumentationType.ALL});
        this.setHistogramThreshold(10000);
    }

    @Test
    @Ignore(value="http://bugs.corp.maprtech.com/show_bug.cgi?id=27310")
    public void testObjectAllocationOnRecordInsert() throws IOException {
        int i;
        ArrayList rowkeys = Lists.newArrayListWithCapacity((int)10000);
        ArrayList values = Lists.newArrayListWithCapacity((int)10000);
        for (i = 0; i < 10000; ++i) {
            rowkeys.add(DataUtil.buildKey(i));
            values.add(DataUtil.buildValues(10, 10));
        }
        this.startSampling();
        for (i = 0; i < 10000; ++i) {
            Document record = MapRDBImpl.newDocument();
            for (Map.Entry entry : ((Map)values.get(i)).entrySet()) {
                record.set((String)entry.getKey(), (ByteBuffer)entry.getValue());
            }
            table.insertOrReplace((String)rowkeys.get(i), record);
        }
        table.flush();
        this.stopSampling();
        Assert.assertTrue((String)ERR_MORE_OBJECTS, (this.totalObjectCount.longValue() <= 1400000L ? 1 : 0) != 0);
        Assert.assertTrue((String)ERR_LESS_OBJECTS, (this.totalObjectCount.longValue() >= 1200000L ? 1 : 0) != 0);
    }
}

