/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.tests.utils;

import com.mapr.db.util.SqlHelper;
import com.mapr.org.apache.hadoop.hbase.util.Bytes;
import com.mapr.tests.BaseTest;
import com.mapr.tests.annotations.SimpleTest;
import java.nio.ByteBuffer;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.ojai.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={SimpleTest.class})
public class TestSqlHelper
extends BaseTest {
    private static final Logger _logger = LoggerFactory.getLogger(TestSqlHelper.class);

    @Test
    public void testEncodeDecodeBinary() {
        byte[][] testCases = new byte[][]{new byte[0], {0}, {0, 0, 0, 0, 0, 0, 0, 0, 0}, new byte[50]};
        new Random().nextBytes(testCases[3]);
        _logger.debug("Random byte sequence '{}'", (Object)Bytes.toStringBinary((byte[])testCases[3]));
        for (byte[] testCase : testCases) {
            ByteBuffer originalBuffer = ByteBuffer.wrap(testCase);
            String str = SqlHelper.encodeBinaryAsString((ByteBuffer)originalBuffer);
            Value value = SqlHelper.decodeStringAsValue((String)str);
            Assert.assertEquals((Object)originalBuffer, (Object)value.getBinary());
        }
    }

    @Test
    public void testDecodeString() {
        String userString1 = "$ojai_binary$user_string";
        Value value = SqlHelper.decodeStringAsValue((String)"$ojai_binary$user_string");
        Assert.assertEquals((Object)Value.Type.STRING, (Object)value.getType());
        Assert.assertEquals((Object)"$ojai_binary$user_string", (Object)value.getString());
        String userString2 = "user_string";
        Value value2 = SqlHelper.decodeStringAsValue((String)"user_string");
        Assert.assertEquals((Object)Value.Type.STRING, (Object)value2.getType());
        Assert.assertEquals((Object)"user_string", (Object)value2.getString());
    }
}

