/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.impl;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LikeToRegexConvertor {
    private static final Logger logger = LoggerFactory.getLogger(LikeToRegexConvertor.class);
    private static final Pattern SQL_LIKE_REGEX = Pattern.compile("([%_])|(\\[[^]]*\\])|([^%_\\[]+)");
    private static final String SQL_LIKE_ESCAPE_REGEX_STR = "(%s.?)|([%%_])|(\\[[^]]*\\])|([^%%_\\[%s]+)";
    private static final String JAVA_REGEX_SPECIALS = ".()[]{}<>|^-+=*?!$\\";
    private final String likeString_;
    private final String escapeChar_;
    private String regexString_ = null;
    private String prefixString_ = null;

    public LikeToRegexConvertor(String likeString, Character escapeChar) {
        this.likeString_ = likeString;
        this.escapeChar_ = escapeChar == null ? null : (JAVA_REGEX_SPECIALS.indexOf(escapeChar.charValue()) == -1 ? String.valueOf(escapeChar) : "\\" + escapeChar);
    }

    public LikeToRegexConvertor parse() {
        if (this.regexString_ != null) {
            return this;
        }
        Matcher matcher = null;
        StringBuilder prefixSB = new StringBuilder();
        StringBuilder regexSB = new StringBuilder("^");
        matcher = this.escapeChar_ == null ? SQL_LIKE_REGEX.matcher(this.likeString_) : Pattern.compile(String.format(SQL_LIKE_ESCAPE_REGEX_STR, this.escapeChar_, this.escapeChar_)).matcher(this.likeString_);
        String fragment = null;
        boolean literalsSoFar = true;
        block8: while (matcher.find()) {
            if (this.escapeChar_ != null && matcher.group(1) != null) {
                fragment = matcher.group(1);
                if (fragment.length() != 2) {
                    throw new IllegalArgumentException("Invalid fragment '" + fragment + "' at index " + matcher.start() + " in the LIKE operand '" + this.likeString_ + "'");
                }
                String escapedChar = fragment.substring(1);
                if (literalsSoFar) {
                    prefixSB.append(escapedChar);
                }
                regexSB.append(Pattern.quote(escapedChar));
                continue;
            }
            switch (fragment = matcher.group()) {
                case "_": {
                    literalsSoFar = false;
                    regexSB.append(".");
                    continue block8;
                }
                case "%": {
                    literalsSoFar = false;
                    regexSB.append(".*");
                    continue block8;
                }
            }
            if (fragment.startsWith("[") && fragment.endsWith("]")) {
                literalsSoFar = false;
                regexSB.append(fragment);
                continue;
            }
            if (literalsSoFar) {
                prefixSB.append(fragment);
            }
            regexSB.append(Pattern.quote(fragment));
        }
        this.prefixString_ = prefixSB.toString();
        this.regexString_ = regexSB.append('$').toString();
        logger.debug("Converted LIKE string '{}' to REGEX string '{}'.", (Object)this.likeString_, (Object)this.regexString_);
        return this;
    }

    public String getRegexString() {
        return this.regexString_;
    }

    public String getPrefixString() {
        return this.prefixString_;
    }

    public String getLikeString() {
        return this.likeString_;
    }
}

