/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.tests.rowcol;

import com.mapr.db.rowcol.BigDecimalSizeDescriptor;
import com.mapr.db.rowcol.ByteWriter;
import com.mapr.db.tests.condition.TestCondition;
import com.mapr.tests.BaseTest;
import com.mapr.tests.annotations.SimpleTest;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={SimpleTest.class})
public class BigDecimalSizeDescriptorTest
extends BaseTest {
    private static final Logger _logger = LoggerFactory.getLogger(TestCondition.class);

    @Test
    public void testBigDecimal() {
        BigDecimal d = new BigDecimal("12345.123456789");
        ByteWriter w = new ByteWriter();
        BigDecimalSizeDescriptor.serialize((BigDecimal)d, (ByteWriter)w);
        ByteBuffer bbuf = w.getByteBuffer();
        BigDecimal newDecimal = BigDecimalSizeDescriptor.deSerialize((ByteBuffer)bbuf);
        Assert.assertEquals((Object)d, (Object)newDecimal);
    }

    @Test
    public void testVeryBigDecimal() {
        BigDecimal d = new BigDecimal("1234512345121231231973248.32947598712123124123456789");
        ByteWriter w = new ByteWriter();
        BigDecimalSizeDescriptor.serialize((BigDecimal)d, (ByteWriter)w);
        ByteBuffer bbuf = w.getByteBuffer();
        BigDecimal newDecimal = BigDecimalSizeDescriptor.deSerialize((ByteBuffer)bbuf);
        Assert.assertEquals((Object)d, (Object)newDecimal);
    }
}

