/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.tests.condition;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mapr.db.JsonTable;
import com.mapr.db.Table;
import com.mapr.db.impl.ConditionImpl;
import com.mapr.db.impl.IdCodec;
import com.mapr.db.impl.MapRDBImpl;
import com.mapr.db.tests.utils.DBTests;
import com.mapr.db.tests.utils.Datasets;
import com.mapr.db.util.ByteBufs;
import com.mapr.tests.BaseTest;
import com.mapr.tests.annotations.ClusterTest;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.ojai.Document;
import org.ojai.DocumentConstants;
import org.ojai.DocumentStream;
import org.ojai.FieldPath;
import org.ojai.Value;
import org.ojai.store.QueryCondition;
import org.ojai.util.Documents;
import org.ojai.util.Values;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={ClusterTest.class})
public class TestConditionWithCluster
extends BaseTest
implements Datasets {
    private static final Logger _logger = LoggerFactory.getLogger(TestConditionWithCluster.class);
    private static final String TABLE_NAME = "testtable-TestConditionWithCluster";
    static Table table;

    @BeforeClass
    public static void setUpBeforeClass() throws IOException {
        int i;
        table = DBTests.createOrReplaceTable(TABLE_NAME);
        for (i = 0; i < ENGINEERS.length - 1; ++i) {
            table.insertOrReplace(IDS[i], ENGINEERS[i]);
        }
        table.insertOrReplace(ByteBufs.wrap((byte[])IDS[i].getBytes()), ENGINEERS[i]);
        table.flush();
        _logger.info("{} documents inserted.", (Object)ENGINEERS.length);
    }

    @AfterClass
    public static void cleanupAfterClass() throws Exception {
        if (table != null) {
            table.close();
            DBTests.deleteTables(TABLE_NAME);
        }
    }

    @Test
    public void testGetWithPositiveCondition() throws Exception {
        ConditionImpl condition = MapRDBImpl.newCondition().and().equals("name", NAMES[0]).typeOf("address.phones", Value.Type.ARRAY).exists("address.phones[1]").is("address.phones[1]", QueryCondition.Op.EQUAL, 5556667777L).close().build();
        _logger.info("Executing get() with " + condition.toString());
        Document result = table.findById(IDS[0], (QueryCondition)condition);
        Assert.assertNotNull((Object)result);
        _logger.info("Using matching condition, returned document: " + result);
    }

    @Test
    public void testGetWithConditionWhenRowExistOrNotExist() throws Exception {
        ConditionImpl condition = MapRDBImpl.newCondition().exists(DocumentConstants.ID_FIELD).build();
        _logger.info("Executing get() with " + condition.toString());
        Document result = table.findById(IDS[7], (QueryCondition)condition);
        Assert.assertNotNull((Object)result);
        _logger.info("Using positive condition with existing row, returned document: " + result);
        condition = MapRDBImpl.newCondition().notExists(DocumentConstants.ID_FIELD).build();
        _logger.info("Executing get() with " + condition.toString());
        result = table.findById(IDS[7], (QueryCondition)condition);
        Assert.assertNull((Object)result);
        _logger.info("Using negetive condition with existing row, returned document: " + result);
        condition = MapRDBImpl.newCondition().exists(DocumentConstants.ID_FIELD).build();
        _logger.info("Executing get() with " + condition.toString());
        result = table.findById(IDS[9], (QueryCondition)condition);
        Assert.assertNull((Object)result);
        _logger.info("Using negetive condition with existing row, returned document: " + result);
        condition = MapRDBImpl.newCondition().notExists(DocumentConstants.ID_FIELD).build();
        _logger.info("Executing get() with " + condition.toString());
        result = table.findById(IDS[9], (QueryCondition)condition);
        Assert.assertNull((Object)result);
        _logger.info("Using positive condition with existing row, returned document: " + result);
    }

    @Test
    public void testGetWithPositiveMatchesCondition() throws Exception {
        ConditionImpl condition = MapRDBImpl.newCondition().and().equals("name", NAMES[0]).matches("address.street", ".*Pennsylvania Avenue.*").close().build();
        _logger.info("Exeuting get() with " + condition.toString());
        Document result = table.findById(IDS[0], (QueryCondition)condition);
        Assert.assertNotNull((Object)result);
        _logger.info("Using matching condition, returned document: " + result);
    }

    @Test
    public void testGetWithSumOfProductCondition() throws Exception {
        ConditionImpl condition = MapRDBImpl.newCondition().or().and().is("name.first", QueryCondition.Op.EQUAL, "Michael").is("name.last", QueryCondition.Op.EQUAL, "Corleone").close().is("age", QueryCondition.Op.GREATER, 100).close().build();
        _logger.info("Exeuting get() with " + condition.toString());
        Document result = table.findById(IDS[0], (QueryCondition)condition);
        Assert.assertNotNull((Object)result);
        _logger.info("Using matching condition, returned document: " + result);
    }

    @Test
    public void testGetWithNegativeCondition() throws Exception {
        ConditionImpl condition = MapRDBImpl.newCondition().and().is("name.first", QueryCondition.Op.EQUAL, "Michael").is("name.last", QueryCondition.Op.EQUAL, "Corleone").close().build();
        _logger.info("Exeuting get() with " + condition.toString());
        Document result = table.findById(IDS[0], (QueryCondition)condition);
        Assert.assertNull((Object)result);
        _logger.info("Using non-matching condition, returned document: " + result);
    }

    @Test
    public void testScanWithPositiveCondition() throws Exception {
        ConditionImpl condition = MapRDBImpl.newCondition().and().is(DocumentConstants.ID_FIELD, QueryCondition.Op.GREATER, "dev0").is(DocumentConstants.ID_FIELD, QueryCondition.Op.LESS, "dev4").is("age", QueryCondition.Op.LESS_OR_EQUAL, 23).close().build();
        _logger.info("Exeuting scan() with " + condition.toString());
        DocumentStream stream = table.find((QueryCondition)condition);
        Assert.assertNotNull((Object)stream);
        int documentCount = 0;
        for (Document document : stream) {
            ++documentCount;
            double age = Values.asDouble((Value)document.getValue("age"));
            Assert.assertTrue((age <= 23.0 ? 1 : 0) != 0);
            _logger.info("Returned document: id='" + IdCodec.asString((Value)document.getId()) + "', age=" + age);
        }
        Assert.assertEquals((long)2L, (long)documentCount);
    }

    @Test
    public void testScanWithEmptyByteBuffer() throws Exception {
        ConditionImpl condition = MapRDBImpl.newCondition().is("image", QueryCondition.Op.EQUAL, ByteBuffer.allocate(0)).build();
        _logger.info("Exeuting scan() with " + condition.toString());
        DocumentStream stream = table.find((QueryCondition)condition);
        Assert.assertNotNull((Object)stream);
        int documentCount = 0;
        for (Document document : stream) {
            ++documentCount;
            String firstName = document.getString("name.first");
            Assert.assertEquals((Object)"Aditya", (Object)firstName);
            _logger.info("Returned document: " + document);
        }
        Assert.assertEquals((long)1L, (long)documentCount);
    }

    @Test
    public void testScanWithRowkeyMatchesCondition() throws Exception {
        String regex = "dev.*";
        ConditionImpl condition = MapRDBImpl.newCondition().matches(DocumentConstants.ID_FIELD, regex).build();
        _logger.info("Exeuting scan() with " + condition.toString());
        DocumentStream stream = table.find((QueryCondition)condition);
        Assert.assertNotNull((Object)stream);
        int documentCount = 0;
        for (Document document : stream) {
            ++documentCount;
            String id = IdCodec.asString((Value)document.getId());
            Assert.assertTrue((boolean)id.matches(regex));
            _logger.info("Returned document: id='" + id + "', name='" + document.getMap("name") + "', age=" + document.getValue("age"));
        }
        Assert.assertEquals((long)5L, (long)documentCount);
    }

    @Test
    public void testScanWithRowkeyLikeCondition() throws Exception {
        String like = "%ev%";
        QueryCondition condition = MapRDBImpl.newCondition().like(DocumentConstants.ID_FIELD, like).build();
        _logger.info("Exeuting scan() with " + condition.toString());
        DocumentStream stream = table.find(condition);
        Assert.assertNotNull((Object)stream);
        int documentCount = 0;
        for (Document document : stream) {
            ++documentCount;
            String id = IdCodec.asString((Value)document.getId());
            _logger.info("Returned document: id='" + id + "', name='" + document.getMap("name") + "', age=" + document.getValue("age"));
        }
        Assert.assertEquals((long)5L, (long)documentCount);
    }

    @Test
    public void testScanWithInCondition() throws Exception {
        ConditionImpl condition = MapRDBImpl.newCondition().in("age", (List)ImmutableList.of((Object)1001.82, (Object)Float.valueOf(17.5f), (Object)23, (Object)25.56, (Object)95)).build();
        _logger.info("Exeuting scan() with " + condition.toString());
        DocumentStream stream = table.find((QueryCondition)condition);
        Assert.assertNotNull((Object)stream);
        int documentCount = 0;
        for (Document document : stream) {
            ++documentCount;
            _logger.info("Returned document: id='" + IdCodec.asString((Value)document.getId()) + "', name='" + document.getMap("name") + "', age=" + document.getValue("age"));
        }
        Assert.assertEquals((long)3L, (long)documentCount);
    }

    @Test
    public void testScanWithNotInCondition() throws Exception {
        ConditionImpl condition = MapRDBImpl.newCondition().notIn("age", (List)ImmutableList.of((Object)23, (Object)71L, (Object)91, (Object)54.7)).build();
        _logger.info("Exeuting scan() with " + condition.toString());
        DocumentStream stream = table.find((QueryCondition)condition);
        Assert.assertNotNull((Object)stream);
        int documentCount = 0;
        for (Document document : stream) {
            ++documentCount;
            _logger.info("Returned document: id='" + IdCodec.asString((Value)document.getId()) + "', name='" + document.getMap("name") + "', age=" + document.getValue("age"));
        }
        Assert.assertEquals((long)5L, (long)documentCount);
    }

    @Test
    public void testScanWithSizeOfConditionWithArray() throws Exception {
        QueryCondition condition = MapRDBImpl.newCondition().sizeOf("address.phones", QueryCondition.Op.GREATER, 2L).build();
        _logger.info("Exeuting scan() with " + condition.toString());
        DocumentStream stream = table.find(condition);
        Assert.assertNotNull((Object)stream);
        int documentCount = 0;
        for (Document document : stream) {
            ++documentCount;
            _logger.info("Returned document: " + document);
        }
        Assert.assertEquals((long)1L, (long)documentCount);
    }

    @Test
    public void testScanWithSizeOfConditionWithMap() throws Exception {
        QueryCondition condition = MapRDBImpl.newCondition().sizeOf(FieldPath.EMPTY, QueryCondition.Op.GREATER_OR_EQUAL, 4L).build();
        _logger.info("Exeuting scan() with " + condition.toString());
        DocumentStream stream = table.find(condition);
        Assert.assertNotNull((Object)stream);
        int documentCount = 0;
        for (Document document : stream) {
            ++documentCount;
            _logger.info("Returned document: " + document);
        }
        Assert.assertEquals((long)4L, (long)documentCount);
    }

    @Test
    public void testScanWithSizeOfConditionWithString() throws Exception {
        QueryCondition condition = MapRDBImpl.newCondition().sizeOf("name.second", QueryCondition.Op.GREATER_OR_EQUAL, 8L).build();
        _logger.info("Exeuting scan() with " + condition.toString());
        DocumentStream stream = table.find(condition);
        Assert.assertNotNull((Object)stream);
        int documentCount = 0;
        for (Document document : stream) {
            ++documentCount;
            _logger.info("Returned document: " + document);
        }
        Assert.assertEquals((long)3L, (long)documentCount);
    }

    @Test
    public void testScanWithSizeOfConditionWithNullValues() throws Exception {
        QueryCondition condition = MapRDBImpl.newCondition().sizeOf("image", QueryCondition.Op.LESS_OR_EQUAL, 9L).build();
        _logger.info("Exeuting scan() with " + condition.toString());
        DocumentStream stream = table.find(condition);
        Assert.assertNotNull((Object)stream);
        int documentCount = 0;
        for (Document document : stream) {
            ++documentCount;
            _logger.info("Returned document: " + document);
        }
        Assert.assertEquals((long)2L, (long)documentCount);
    }

    @Test
    public void testScanWithSizeOfConditionWithId() throws Exception {
        QueryCondition condition = MapRDBImpl.newCondition().sizeOf(DocumentConstants.ID_FIELD, QueryCondition.Op.GREATER_OR_EQUAL, 19L).build();
        _logger.info("Exeuting scan() with " + condition.toString());
        DocumentStream stream = table.find(condition);
        Assert.assertNotNull((Object)stream);
        int documentCount = 0;
        for (Document document : stream) {
            ++documentCount;
            _logger.info("Returned document: " + document);
        }
        Assert.assertEquals((long)2L, (long)documentCount);
    }

    @Test
    public void testScanWithSizeOfConditionWithBinary() throws Exception {
        QueryCondition condition = MapRDBImpl.newCondition().and().sizeOf("image", QueryCondition.Op.LESS_OR_EQUAL, 9L).sizeOf("image", QueryCondition.Op.GREATER, 6L).close().build();
        _logger.info("Exeuting scan() with " + condition.toString());
        DocumentStream stream = table.find(condition);
        Assert.assertNotNull((Object)stream);
        int documentCount = 0;
        for (Document document : stream) {
            ++documentCount;
            _logger.info("Returned document: " + document);
        }
        Assert.assertEquals((long)1L, (long)documentCount);
    }

    @Test
    public void testScanWithTypeOfConditionWithId() throws Exception {
        ConditionImpl condition = MapRDBImpl.newCondition().typeOf(DocumentConstants.ID_FIELD, Value.Type.BINARY).build();
        _logger.info("Exeuting scan() with " + condition.toString());
        DocumentStream stream = table.find((QueryCondition)condition);
        Assert.assertNotNull((Object)stream);
        int documentCount = 0;
        for (Document document : stream) {
            ++documentCount;
            _logger.info("Returned document: " + document);
        }
        Assert.assertEquals((long)1L, (long)documentCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFilterSingleCondition() throws Exception {
        String tableName = "testtable-TestConditionWithCluster-testSingleCondition";
        String[] prefixes = new String[]{"a", "b", "c", "d", "e"};
        try (JsonTable t = DBTests.createOrReplaceTable(tableName);){
            for (int i = 0; i < 10; ++i) {
                String key = prefixes[i % 5] + "-" + Integer.toString(i);
                Document d = MapRDBImpl.newDocument();
                d.set("first", key + "-first");
                t.insertOrReplace(key, d);
            }
            t.flush();
            ConditionImpl c1 = MapRDBImpl.newCondition().is(DocumentConstants.ID_FIELD, QueryCondition.Op.GREATER_OR_EQUAL, "e").build();
            Iterator it1 = t.find((QueryCondition)c1).iterator();
            ConditionImpl c2 = MapRDBImpl.newCondition().and().is(DocumentConstants.ID_FIELD, QueryCondition.Op.GREATER_OR_EQUAL, "e").close().build();
            Iterator it2 = t.find((QueryCondition)c2).iterator();
            while (it1.hasNext() && it2.hasNext()) {
                Document d1 = (Document)it1.next();
                Document d2 = (Document)it2.next();
                Assert.assertTrue((boolean)Documents.equals((Document)d1, (Document)d2));
            }
            Assert.assertTrue((!it1.hasNext() && !it2.hasNext() ? 1 : 0) != 0);
        }
        catch (Throwable throwable) {
            DBTests.deleteTables(tableName);
            throw throwable;
        }
        DBTests.deleteTables(tableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFilterWithMultiFamilies() throws Exception {
        String tableName = "testtable-TestConditionWithCluster-multiFamilies";
        try (JsonTable multiCFTable = DBTests.createOrReplaceTable(tableName, (Map<String, String>)ImmutableMap.of((Object)"f1", (Object)"a.b.c", (Object)"f2", (Object)"p.q.r", (Object)"f3", (Object)"a.b.e")).setOption(Table.TableOption.BUFFERWRITE, false);){
            Document developer = MapRDBImpl.newDocument();
            developer.set("a.b.c.d", NAMES[0]);
            developer.set("a.b.e", ADDRESSES[0]);
            developer.set("p.q.r.s", 105);
            multiCFTable.insertOrReplace(IDS[0], developer);
            developer.set("p.q.r.s", 104);
            multiCFTable.insertOrReplace(IDS[1], developer);
            ConditionImpl condition = MapRDBImpl.newCondition().and().equals("a.b.e", ADDRESSES[0]).is("p.q.r.s", QueryCondition.Op.EQUAL, 105).close().build();
            DocumentStream stream = multiCFTable.find((QueryCondition)condition);
            Assert.assertNotNull((Object)stream);
            int documentCount = 0;
            for (Document document : stream) {
                ++documentCount;
                Assert.assertEquals((Object)IDS[0], (Object)IdCodec.asString((Value)document.getId()));
            }
            stream.close();
            Assert.assertEquals((long)1L, (long)documentCount);
            Document row = multiCFTable.findById(IDS[0], (QueryCondition)condition);
            Assert.assertNotNull((Object)row);
            row = multiCFTable.findById(IDS[1], (QueryCondition)condition);
            Assert.assertNull((Object)row);
        }
        catch (Throwable throwable) {
            DBTests.deleteTables(tableName);
            throw throwable;
        }
        DBTests.deleteTables(tableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test_bug_28378_array_field_on_a_column_family() throws Exception {
        String tableName = "testtable-TestConditionWithCluster-array-field-on-a-column-family";
        try (JsonTable table = DBTests.createOrReplaceTable(tableName, (Map<String, String>)ImmutableMap.of((Object)"versions", (Object)"versions")).setOption(Table.TableOption.BUFFERWRITE, false);){
            table.insertOrReplace(MapRDBImpl.newDocument((String)"{\"_id\":\"1500a821-f9d3-46de-a603-e6e6b0db5822\",\"versions\":[{\"data\":{\"firstName\":\"first\",\"lastName\":\"last\"}}]}"));
            table.insertOrReplace(MapRDBImpl.newDocument((String)"{\"_id\":\"2500a821-f9d3-46de-a603-e6e6b0db5822\",\"versions\":[{\"data\":{\"firstName\":\"first\",\"lastName\":\"middle\"}}, null]}"));
            List<Document> docs = DBTests.getAllDocumentsAndCloseStream(table.find((QueryCondition)MapRDBImpl.newCondition().exists("versions").build()));
            Assert.assertEquals((long)2L, (long)docs.size());
            docs = DBTests.getAllDocumentsAndCloseStream(table.find((QueryCondition)MapRDBImpl.newCondition().exists("versions[0]").build()));
            Assert.assertEquals((long)2L, (long)docs.size());
            docs = DBTests.getAllDocumentsAndCloseStream(table.find((QueryCondition)MapRDBImpl.newCondition().exists("versions[1]").build()));
            Assert.assertEquals((long)1L, (long)docs.size());
            docs = DBTests.getAllDocumentsAndCloseStream(table.find((QueryCondition)MapRDBImpl.newCondition().is("versions[0].data.firstName", QueryCondition.Op.EQUAL, "first").build()));
            Assert.assertEquals((long)2L, (long)docs.size());
            docs = DBTests.getAllDocumentsAndCloseStream(table.find((QueryCondition)MapRDBImpl.newCondition().is("versions[0].data.lastName", QueryCondition.Op.EQUAL, "middle").build()));
            Assert.assertEquals((long)1L, (long)docs.size());
        }
        catch (Throwable throwable) {
            DBTests.deleteTables(tableName);
            throw throwable;
        }
        DBTests.deleteTables(tableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFindWithTypeOfNull() throws Exception {
        String tableName = "testtable-TestConditionWithCluster-testFindWithTypeOfNull";
        try (JsonTable table = DBTests.createOrReplaceTable(tableName);){
            table.insertOrReplace(MapRDBImpl.newDocument((String)"{\"_id\":\"1500a821-f9d3-46de-a603-e6e6b0db5822\",\"data\":{\"firstName\":\"first\",\"lastName\":null}}"));
            table.insertOrReplace(MapRDBImpl.newDocument((String)"{\"_id\":\"2500a821-f9d3-46de-a603-e6e6b0db5822\",\"data\":{\"firstName\":\"first\",\"lastName\":\"middle\"}}"));
            table.flush();
            List<Document> docs = DBTests.getAllDocumentsAndCloseStream(table.find((QueryCondition)MapRDBImpl.newCondition().typeOf("data.lastName", Value.Type.NULL).build()));
            Assert.assertEquals((long)1L, (long)docs.size());
        }
        catch (Throwable throwable) {
            DBTests.deleteTables(tableName);
            throw throwable;
        }
        DBTests.deleteTables(tableName);
    }
}

