/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.kwps;

import com.google.common.collect.ImmutableSet;
import com.mapr.kwps.KwpsCommon;
import java.util.Set;

public class KafkaTopic {
    public static final String GROUP_METADATA_TOPIC_NAME = "__consumer_offsets";
    public static final String TRANSACTION_STATE_TOPIC_NAME = "__transaction_state";
    public static final String LEGAL_CHARS = "[a-zA-Z0-9._-]";
    private static final Set<String> INTERNAL_TOPICS = ImmutableSet.of((Object)"__consumer_offsets", (Object)"__transaction_state");
    private static final int MAX_NAME_LENGTH = 249;

    public static String validate(String topic) {
        if (topic.isEmpty()) {
            throw KwpsCommon.newKafkaException("org.apache.kafka.common.errors.InvalidTopicException", "Topic name is illegal, it can't be empty");
        }
        if (topic.equals(".") || topic.equals("..")) {
            throw KwpsCommon.newKafkaException("org.apache.kafka.common.errors.InvalidTopicException", "Topic name cannot be \".\" or \"..\"");
        }
        if (topic.length() > 249) {
            throw KwpsCommon.newKafkaException("org.apache.kafka.common.errors.InvalidTopicException", "Topic name is illegal, it can't be longer than 249 characters, topic name: " + topic);
        }
        if (!KafkaTopic.containsValidPattern(topic)) {
            throw KwpsCommon.newKafkaException("org.apache.kafka.common.errors.InvalidTopicException", "Topic name \"" + topic + "\" is illegal, it contains a character other than ASCII alphanumerics, '.', '_' and '-'");
        }
        return topic;
    }

    public static boolean isInternal(String topic) {
        return INTERNAL_TOPICS.contains(topic);
    }

    public static boolean hasCollisionChars(String topic) {
        return topic.contains("_") || topic.contains(".");
    }

    public static boolean hasCollision(String topicA, String topicB) {
        return topicA.replace('.', '_').equals(topicB.replace('.', '_'));
    }

    static boolean containsValidPattern(String topic) {
        for (int i = 0; i < topic.length(); ++i) {
            boolean validChar;
            char c = topic.charAt(i);
            boolean bl = validChar = c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c == '.' || c == '_' || c == '-';
            if (validChar) continue;
            return false;
        }
        return true;
    }

    public static void main(String[] args) {
        KafkaTopic.validate("abcd#");
    }
}

