/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.rowcol;

import com.mapr.db.rowcol.ByteWriter;
import com.mapr.db.rowcol.KeyValue;
import com.mapr.db.rowcol.KeyValueWithTS;
import com.mapr.db.rowcol.SerializationContext;
import com.mapr.db.rowcol.TimeAndUniq;
import java.nio.ByteBuffer;

public class TimeDescriptor {
    public static final int CreateTimeIndex = 0;
    public static final int UpdateTimeIndex = 1;
    public static final int DeleteTimeIndex = 2;
    public static final int TimeIndexCount = 3;
    public static final int CreateTimeShift = 0;
    public static final int CreateTimeMask = 3;
    public static final int UpdateTimeShift = 2;
    public static final int UpdateTimeMask = 12;
    public static final int DeleteTimeShift = 4;
    public static final int DeleteTimeMask = 48;
    static final short CreateTimeSizeShift = 0;
    static final short CreateTimeUniqSizeShift = 3;
    static final short UpdateTimeSizeShift = 5;
    static final short UpdateTimeUniqSizeShift = 8;
    static final short DeleteTimeSizeShift = 10;
    static final short DeleteTimeUniqSizeShift = 13;
    static final short CreateTimeSizeMask = 7;
    static final short CreateTimeUniqSizeMask = 24;
    static final short UpdateTimeSizeMask = 224;
    static final short UpdateTimeUniqSizeMask = 768;
    static final short DeleteTimeSizeMask = 7168;
    static final short DeleteTimeUniqSizeMask = 24576;

    public static void reset(KeyValue kv) {
        kv.timeDescriptor = 0;
    }

    public static void setCreateTimeValid(KeyValue kv) {
        kv.timeDescriptor = (byte)(kv.timeDescriptor | TimeDescriptor.setCreateTimeValidHelper());
    }

    public static int setCreateTimeValidHelper() {
        return TimeStampState.VALID_WITH_REFTIME.ordinal() << 0;
    }

    public static boolean isCreateTimeValid(byte timeDescriptor) {
        return (timeDescriptor & 3) >> 0 != 0;
    }

    public static boolean isCreateTimeValid(KeyValue kv) {
        return TimeDescriptor.isCreateTimeValid(kv.timeDescriptor);
    }

    public static void setDeleteTimeValid(KeyValue kv) {
        kv.timeDescriptor = (byte)(kv.timeDescriptor | TimeDescriptor.setDeleteTimeValid());
    }

    public static int setDeleteTimeValid() {
        return TimeStampState.VALID_WITH_REFTIME.ordinal() << 4;
    }

    public static boolean isDeleteTimeValid(KeyValue kv) {
        return TimeDescriptor.isDeleteTimeValid(kv.timeDescriptor);
    }

    public static boolean isDeleteTimeValid(byte timeDescriptor) {
        return (timeDescriptor & 0x30) >> 4 != 0;
    }

    public static void setUpdateTimeValid(KeyValue kv) {
        kv.timeDescriptor = (byte)(kv.timeDescriptor | TimeDescriptor.setUpdateTimeValid());
    }

    public static int setUpdateTimeValid() {
        return TimeStampState.VALID_WITH_REFTIME.ordinal() << 2;
    }

    public static boolean isUpdateTimeValid(KeyValue kv) {
        return TimeDescriptor.isUpdateTimeValid(kv.timeDescriptor);
    }

    public static boolean isUpdateTimeValid(byte timeDescriptor) {
        return (timeDescriptor & 0xC) >> 2 != 0;
    }

    public static byte resetCreateTime(byte timeDescriptor) {
        return (byte)(timeDescriptor & 0xFFFFFFFC);
    }

    public static void resetCreateTime(KeyValue kv) {
        kv.timeDescriptor = TimeDescriptor.resetCreateTime(kv.timeDescriptor);
    }

    public static void resetUpdateTime(KeyValue kv) {
        kv.timeDescriptor = TimeDescriptor.resetUpdateTime(kv.timeDescriptor);
    }

    public static byte resetUpdateTime(byte timeDescriptor) {
        return (byte)(timeDescriptor & 0xFFFFFFF3);
    }

    public static byte resetDeleteTime(byte timeDescriptor) {
        return (byte)(timeDescriptor & 0xFFFFFFCF);
    }

    public static void serialize(KeyValue kv, ByteWriter w, SerializationContext ctx) {
        assert ((kv.timeDescriptor & 3) >> 0 <= TimeStampState.VALID_WITH_REFTIME.ordinal());
        assert ((kv.timeDescriptor & 0xC) >> 2 <= TimeStampState.VALID_WITH_REFTIME.ordinal());
        assert ((kv.timeDescriptor & 0x30) >> 4 <= TimeStampState.VALID_WITH_REFTIME.ordinal());
        w.put(kv.timeDescriptor);
    }

    public static void serialize(KeyValue kv, ByteWriter w) {
        TimeDescriptor.serialize(kv, w, null);
    }

    public static byte getTimeDescriptor(ByteBuffer r) {
        return r.get();
    }

    public static boolean isExternal(TimeStampState t, byte desc) {
        t = TimeStampState.intToTimeStampState((desc & 3) >> 0);
        switch (t) {
            case VALID_WITH_EXTERNAL_TIME: {
                return true;
            }
        }
        return false;
    }

    public static byte deserialize(KeyValue v, ByteBuffer r, SerializationContext ctx) {
        return TimeDescriptor.deserialize(v, r, ctx, false);
    }

    public static void timeDescriptorToStates(byte timeDescriptor, TimeStampState[] timeStates) {
        timeStates[0] = TimeDescriptor.getCreateTimeState(timeDescriptor);
        timeStates[1] = TimeDescriptor.getUpdateTimeState(timeDescriptor);
        timeStates[2] = TimeDescriptor.getDeleteTimeState(timeDescriptor);
    }

    public static byte deserialize(KeyValue v, ByteBuffer r, SerializationContext ctx, boolean keepRootTime) {
        KeyValueWithTS kv = null;
        byte timeDescriptor = TimeDescriptor.getTimeDescriptor(r);
        ctx.setTimeDescriptor(timeDescriptor);
        boolean decodeTimestamp = ctx.getDecodeTimestamp();
        if (keepRootTime) {
            timeDescriptor = TimeDescriptor.deserializeWithTimes(timeDescriptor, ctx.baseCudTimes, r, ctx);
            if (decodeTimestamp) {
                TimeDescriptor.timeDescriptorToStates(timeDescriptor, ctx.baseCudTimeStates);
            }
        } else {
            timeDescriptor = TimeDescriptor.deserializeWithTimes(timeDescriptor, ctx.cudTimes, r, ctx);
            if (decodeTimestamp) {
                TimeDescriptor.timeDescriptorToStates(timeDescriptor, ctx.cudTimeStates);
            }
        }
        if (decodeTimestamp && v != null) {
            kv = (KeyValueWithTS)v;
            if (kv.times == null) {
                kv.times = new TimeAndUniq[3];
            }
            for (int i = 0; i < 3; ++i) {
                long kvtime = keepRootTime ? ctx.baseCudTimes[i].time() : ctx.cudTimes[i].time();
                int kvuniq = keepRootTime ? ctx.baseCudTimes[i].uniq() : ctx.cudTimes[i].uniq();
                kv.times[i] = new TimeAndUniq(kvtime, kvuniq);
            }
        }
        if (v != null) {
            v.timeDescriptor = timeDescriptor;
        }
        return timeDescriptor;
    }

    public static TimeStampState getCreateTimeState(byte timeDescriptor) {
        return TimeStampState.intToTimeStampState((timeDescriptor & 3) >> 0);
    }

    public static TimeStampState getUpdateTimeState(byte timeDescriptor) {
        return TimeStampState.intToTimeStampState((timeDescriptor & 0xC) >> 2);
    }

    public static TimeStampState getDeleteTimeState(byte timeDescriptor) {
        return TimeStampState.intToTimeStampState((timeDescriptor & 0x30) >> 4);
    }

    public static boolean IsValid(TimeStampState s) {
        return s == TimeStampState.VALID_WITH_REFTIME || s == TimeStampState.VALID_WITH_EXTERNAL_TIME;
    }

    private static byte deserializeWithTimes(byte timeDescriptor, TimeAndUniq[] times, ByteBuffer r, SerializationContext ctx) {
        boolean createTimeExternal = false;
        boolean updateTimeExternal = false;
        boolean deleteTimeExternal = false;
        TimeStampState t = TimeStampState.intToTimeStampState((timeDescriptor & 3) >> 0);
        boolean decodeTS = ctx.getDecodeTimestamp();
        switch (t) {
            case NOT_VALID: {
                break;
            }
            case VALID_WITH_REFTIME: {
                if (!decodeTS) break;
                times[0].setTime(ctx.getBaseTime());
                break;
            }
            case VALID_WITH_EXTERNAL_TIME: {
                createTimeExternal = true;
            }
        }
        t = TimeStampState.intToTimeStampState((timeDescriptor & 0xC) >> 2);
        switch (t) {
            case NOT_VALID: {
                break;
            }
            case VALID_WITH_REFTIME: {
                if (!decodeTS) break;
                times[1].setTime(ctx.getBaseTime());
                break;
            }
            case VALID_WITH_EXTERNAL_TIME: {
                updateTimeExternal = true;
            }
        }
        t = TimeStampState.intToTimeStampState((timeDescriptor & 0x30) >> 4);
        switch (t) {
            case NOT_VALID: {
                break;
            }
            case VALID_WITH_REFTIME: {
                if (!decodeTS) break;
                times[2].setTime(ctx.getBaseTime());
                break;
            }
            case VALID_WITH_EXTERNAL_TIME: {
                deleteTimeExternal = true;
            }
        }
        if (TimeDescriptor.isCreateTimeValid(timeDescriptor)) {
            timeDescriptor = TimeDescriptor.resetCreateTime(timeDescriptor);
            timeDescriptor = (byte)(timeDescriptor | TimeDescriptor.setCreateTimeValidHelper());
        }
        if (TimeDescriptor.isUpdateTimeValid(timeDescriptor)) {
            timeDescriptor = TimeDescriptor.resetUpdateTime(timeDescriptor);
            timeDescriptor = (byte)(timeDescriptor | TimeDescriptor.setUpdateTimeValid());
        }
        if (ctx.preserveDeleteTime()) {
            if (TimeDescriptor.isDeleteTimeValid(timeDescriptor)) {
                timeDescriptor = TimeDescriptor.resetDeleteTime(timeDescriptor);
                timeDescriptor = (byte)(timeDescriptor | TimeDescriptor.setDeleteTimeValid());
            }
        } else {
            timeDescriptor = TimeDescriptor.resetDeleteTime(timeDescriptor);
        }
        if (createTimeExternal || updateTimeExternal || deleteTimeExternal) {
            short sizeByte = r.getShort();
            TimeAndUniq time = null;
            if (createTimeExternal) {
                if (decodeTS) {
                    time = times[0];
                }
                TimeDescriptor.readCreateTimeAndUniq(r, sizeByte, time, ctx);
            }
            if (updateTimeExternal) {
                if (decodeTS) {
                    time = times[1];
                }
                TimeDescriptor.readUpdateTimeAndUniq(r, sizeByte, time, ctx);
            }
            if (deleteTimeExternal) {
                if (decodeTS) {
                    time = times[2];
                }
                TimeDescriptor.readDeleteTimeAndUniq(r, sizeByte, time, ctx);
            }
        }
        return timeDescriptor;
    }

    static void readCreateTimeAndUniq(ByteBuffer r, short sizeInfo, TimeAndUniq time, SerializationContext ctx) {
        short timeSizeInfo = (short)((sizeInfo & 7) >> 0);
        short uniqSizeInfo = (short)((sizeInfo & 0x18) >> 3);
        TimeDescriptor.readTimeAndUniq(r, timeSizeInfo, uniqSizeInfo, time, ctx);
    }

    static void readUpdateTimeAndUniq(ByteBuffer r, short sizeInfo, TimeAndUniq time, SerializationContext ctx) {
        short timeSizeInfo = (short)((sizeInfo & 0xE0) >> 5);
        short uniqSizeInfo = (short)((sizeInfo & 0x300) >> 8);
        TimeDescriptor.readTimeAndUniq(r, timeSizeInfo, uniqSizeInfo, time, ctx);
    }

    static void readDeleteTimeAndUniq(ByteBuffer r, short sizeInfo, TimeAndUniq time, SerializationContext ctx) {
        short timeSizeInfo = (short)((sizeInfo & 0x1C00) >> 10);
        short uniqSizeInfo = (short)((sizeInfo & 0x6000) >> 13);
        TimeDescriptor.readTimeAndUniq(r, timeSizeInfo, uniqSizeInfo, time, ctx);
    }

    static void readTimeAndUniq(ByteBuffer r, short timeSizeInfo, short uniqSizeInfo, TimeAndUniq time, SerializationContext ctx) {
        assert (timeSizeInfo >= 0 && timeSizeInfo <= 7);
        boolean decodeTS = ctx.getDecodeTimestamp();
        long diff = 0L;
        switch (timeSizeInfo) {
            case 0: {
                if (!decodeTS) break;
                time.setTime(ctx.getBaseTime().time());
                break;
            }
            case 1: {
                diff = r.get();
                if (!decodeTS) break;
                time.setTime(ctx.getBaseTime().time() + (0xFFL & diff));
                assert (time.time() > ctx.getBaseTime().time());
                break;
            }
            case 2: {
                diff = r.getShort();
                if (!decodeTS) break;
                time.setTime(ctx.getBaseTime().time() + (0xFFFFL & diff));
                assert (time.time() > ctx.getBaseTime().time());
                break;
            }
            case 3: {
                diff = r.getInt();
                if (!decodeTS) break;
                time.setTime(ctx.getBaseTime().time() + (0xFFFFFFFFFFFFFFFFL & diff));
                assert (time.time() > ctx.getBaseTime().time());
                break;
            }
            case 4: {
                byte[] b = new byte[6];
                r.get(b);
                if (!decodeTS) break;
                long t = 0L;
                for (int i = 0; i < b.length; ++i) {
                    t |= (long)(b[i] & 0xFF) << 8 * i;
                }
                time.setTime(t);
                break;
            }
            case 5: {
                diff = r.getInt();
                if (!decodeTS) break;
                time.setTime(ctx.getBaseTime().time() - (0xFFFFFFFFFFFFFFFFL & diff));
                assert (time.time() < ctx.getBaseTime().time());
                break;
            }
            case 6: {
                diff = r.getShort();
                if (!decodeTS) break;
                time.setTime(ctx.getBaseTime().time() - (0xFFFFL & diff));
                assert (time.time() < ctx.getBaseTime().time());
                break;
            }
            case 7: {
                diff = r.get();
                if (!decodeTS) break;
                time.setTime(ctx.getBaseTime().time() - (0xFFL & diff));
                assert (time.time() < ctx.getBaseTime().time());
                break;
            }
        }
        int uniq = 0;
        switch (uniqSizeInfo) {
            case 0: {
                break;
            }
            case 1: {
                uniq = r.get();
                break;
            }
            case 2: {
                uniq = r.getShort();
                break;
            }
            case 3: {
                uniq = r.getInt();
            }
        }
        if (decodeTS) {
            time.setUniq(uniq);
        }
    }

    public static String toStringWithTimestamp(KeyValue v) {
        KeyValueWithTS kv = (KeyValueWithTS)v;
        StringBuilder b = new StringBuilder();
        b.append("[");
        for (int i = 0; i < 3; ++i) {
            TimeAndUniq t = kv.times[i];
            String s = String.format("%d.%d", t.time(), t.uniq());
            b.append(s);
            if (i == 2) continue;
            b.append(", ");
        }
        b.append("]");
        return b.toString();
    }

    static enum TimeStampType {
        TIMESTAMP_TIME_CREATETIME,
        TIMESTAMP_TIME_UPDATETIME,
        TIMESTAMP_TIME_DELETETIME;

    }

    public static enum TimeStampState {
        NOT_VALID(0),
        VALID_WITH_REFTIME(1),
        VALID_WITH_EXTERNAL_TIME(2),
        NOT_SET(3);

        private int value;

        private TimeStampState(int val) {
            this.value = val;
        }

        static final TimeStampState intToTimeStampState(int val) {
            if (val == 0) {
                return NOT_VALID;
            }
            if (val == 1) {
                return VALID_WITH_REFTIME;
            }
            if (val == 2) {
                return VALID_WITH_EXTERNAL_TIME;
            }
            return NOT_SET;
        }
    }
}

