/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.rowcol;

import com.mapr.db.rowcol.ByteWriter;
import com.mapr.db.rowcol.DBDocumentImpl;
import com.mapr.db.rowcol.SerializationContext;
import java.nio.ByteBuffer;

public class RootTimeDescriptor {
    static final byte TimeStampShift = 0;
    static final byte TimeStampMask = 1;
    static final byte UniqSizeShift = 1;
    static final byte UniqSizeMask = 6;
    static final byte HasDeletesShift = 3;
    static final byte HasDeletesMask = 8;
    static final byte VersionShift = 4;
    static final byte VersionMask = -16;

    public static void serialize(DBDocumentImpl rec, ByteWriter w, SerializationContext ctx) {
        rec.rootTimeDescriptor = 0;
        if (ctx.storeRowTS()) {
            rec.rootTimeDescriptor = 1;
            w.put(rec.rootTimeDescriptor);
            long time = System.currentTimeMillis();
            byte[] dummyBuf = new byte[6];
            for (int i = 0; i < 6; ++i) {
                dummyBuf[i] = (byte)(time >> 8 * i & 0xFFL);
            }
            w.put(dummyBuf);
        } else {
            if (rec.hasDeletes()) {
                rec.rootTimeDescriptor = (byte)(rec.rootTimeDescriptor | 8);
            }
            w.put(rec.rootTimeDescriptor);
        }
    }

    public static void deserialize(ByteBuffer input, SerializationContext ctx) {
        byte buf = input.get();
        long time = 0L;
        int uniq = 0;
        byte[] dummyBuf = new byte[6];
        if ((buf & 1) >> 0 > 0) {
            input.get(dummyBuf);
            for (int i = 0; i < dummyBuf.length; ++i) {
                time |= (long)(dummyBuf[i] & 0xFF) << 8 * i;
            }
        }
        byte uniqSize = (byte)((buf & 6) >> 1);
        switch (uniqSize) {
            case 0: {
                break;
            }
            case 1: {
                uniq = input.get();
                break;
            }
            case 2: {
                uniq = input.getShort();
                break;
            }
            case 3: {
                uniq = input.getInt();
            }
        }
        ctx.setBaseTime(time, uniq);
    }

    public static void rewriteHasDeleteFlag(DBDocumentImpl rec, ByteWriter w, SerializationContext ctx) {
        rec.rootTimeDescriptor = rec.hasDeletes() ? (byte)(rec.rootTimeDescriptor | 8) : (byte)(rec.rootTimeDescriptor & 0xFFFFFFF7);
        w.putByteAtOffset(0, rec.rootTimeDescriptor);
    }

    static enum JsonRowColVersion {
        JSONROWCOLVERSION0;

    }
}

